/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.config;

import java.util.Map;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.webflow.execution.FlowExecutionListener;
import org.springframework.webflow.execution.factory.ConditionalFlowExecutionListenerLoader;
import org.springframework.webflow.execution.factory.FlowExecutionListenerCriteriaFactory;
import org.springframework.webflow.execution.factory.FlowExecutionListenerLoader;

class FlowExecutionListenerLoaderFactoryBean
implements FactoryBean,
InitializingBean {
    private Map listenersWithCriteria;
    private ConditionalFlowExecutionListenerLoader listenerLoader;
    private FlowExecutionListenerCriteriaFactory listenerCriteriaFactory = new FlowExecutionListenerCriteriaFactory();

    FlowExecutionListenerLoaderFactoryBean() {
    }

    public void setListeners(Map listenersWithCriteria) {
        this.listenersWithCriteria = listenersWithCriteria;
    }

    public void afterPropertiesSet() {
        this.listenerLoader = new ConditionalFlowExecutionListenerLoader();
        for (Map.Entry entry : this.listenersWithCriteria.entrySet()) {
            FlowExecutionListener listener = (FlowExecutionListener)entry.getKey();
            String criteria = (String)entry.getValue();
            this.listenerLoader.addListener(listener, this.listenerCriteriaFactory.getListenerCriteria(criteria));
        }
    }

    public Object getObject() throws Exception {
        return this.listenerLoader;
    }

    public Class getObjectType() {
        return FlowExecutionListenerLoader.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

