/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.addressmatching;

import com.supermap.analyst.addressmatching.InternalGeoRegion;
import com.supermap.analyst.addressmatching.InternalHandle;
import com.supermap.analyst.addressmatching.InternalHandleDisposable;
import com.supermap.analyst.addressmatching.InternalResource;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetVector;
import com.supermap.data.GeoRegion;
import java.util.ArrayList;

public class AddressMatchParameter {
    private ArrayList<Dataset> _$6;
    private int _$5;
    private String _$4;
    private GeoRegion _$3;
    private boolean _$2;
    private boolean _$1;

    public AddressMatchParameter() {
        this._$3 = null;
        this._$2 = false;
        this._$1 = false;
        this._$6 = new ArrayList();
        this._$5 = 0;
    }

    public AddressMatchParameter(AddressMatchParameter addressMatchParameter) {
        if (addressMatchParameter == null) {
            String string = InternalResource.loadString("addressMatchParameter", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        this._$6 = new ArrayList();
        int n = addressMatchParameter._$6.size();
        for (int i = 0; i < n; ++i) {
            this._$6.add(addressMatchParameter._$6.get(i));
        }
        this._$5 = addressMatchParameter._$5;
        this._$4 = addressMatchParameter._$4;
        this._$2 = addressMatchParameter._$2;
        this._$1 = addressMatchParameter._$1;
        GeoRegion geoRegion = addressMatchParameter.getSearchRegion().clone();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geoRegion, false);
        this._$3 = geoRegion;
    }

    public DatasetVector[] getSearchDatasets() {
        int n = this._$6.size();
        DatasetVector[] datasetVectorArray = new DatasetVector[n];
        for (int i = 0; i < n; ++i) {
            datasetVectorArray[i] = (DatasetVector)this._$6.get(i);
        }
        return datasetVectorArray;
    }

    public int getResultCount() {
        return this._$5;
    }

    public void setResultCount(int n) {
        if (n < 0) {
            String string = InternalResource.loadString("value", "Global_ShouldGreaterThanZero", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        this._$5 = n;
    }

    public String getSearchAddress() {
        return this._$4;
    }

    public void setSearchAddress(String string) {
        if (string == null || string.trim().length() == 0) {
            String string2 = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "addressmatching_resources");
            throw new IllegalArgumentException(string2);
        }
        this._$4 = string;
    }

    public GeoRegion getSearchRegion() {
        return this._$3;
    }

    public void setSearchRegion(GeoRegion geoRegion) {
        if (geoRegion != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion) == 0L) {
                String string = InternalResource.loadString("geoRegion", "Global_ArgumentObjectHasBeenDisposed", "addressmatching_resources");
                throw new IllegalArgumentException(string);
            }
            GeoRegion geoRegion2 = geoRegion.clone();
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geoRegion2, false);
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion2);
            if (this._$3 != null) {
                InternalGeoRegion.changeHandle(this._$3, l);
            } else {
                this._$3 = geoRegion2;
            }
        } else {
            if (this._$3 != null) {
                this._$3.dispose();
            }
            this._$3 = null;
        }
    }

    public boolean isLocationReturn() {
        return this._$2;
    }

    public void setLocationReturn(boolean bl) {
        this._$2 = bl;
    }

    public boolean isAddressSegmented() {
        return this._$1;
    }

    public void setAddressSegmented(boolean bl) {
        this._$1 = bl;
    }

    public int addSearchDataset(DatasetVector datasetVector) {
        if (datasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector) == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        this._$6.add((Dataset)datasetVector);
        return this._$6.size() - 1;
    }

    public boolean setSearchDataset(int n, DatasetVector datasetVector) {
        if (n >= this._$6.size() || n < 0) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "addressmatching_resources");
            throw new ArrayIndexOutOfBoundsException(string);
        }
        if (datasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector) == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        this._$6.set(n, (Dataset)datasetVector);
        return this._$6.get(n).equals(datasetVector);
    }

    public boolean removeSearchDataset(int n) {
        if (n >= this._$6.size() || n < 0) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "addressmatching_resources");
            throw new ArrayIndexOutOfBoundsException(string);
        }
        int n2 = this._$6.size();
        this._$6.remove(n);
        return this._$6.size() == n2 - 1;
    }

    public void clearSearchDataset() {
        this._$6.clear();
    }

    protected void finalize() {
        if (this._$3 != null) {
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)this._$3, true);
            this._$3.dispose();
        }
    }
}

