/*
 * Decompiled with CFR 0.152.
 */
package com.supermap;

import Aladdin.Hasp;
import com.supermap.License;
import com.supermap.LicenseConnectMode;
import com.supermap.LicenseFeatureInfo;
import com.supermap.LicenseVerifyFailedEvent;
import com.supermap.LicenseVerifyFailedListener;
import com.supermap.ProductType;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class LicenseHaspInstance {
    private static int g_fault_tolerant_count = 1;
    static final String vendorCode = "JrNeGqM4xOWYWW2sd+Yf0q72MnQwMbX2/OS2HdnY9jrwtEt+VKmr5fRvV6P0qDgv8OoF9FYVmmeYsxqXd0niNfALXlGoaDjhSfsrtEzUICDsfJc3VIinxpWcQye+bZ0izZT7ZCXzYvZeEKHrteLtt9cFzNlUljbYp8EKjri1e9UeqJn5Qqcy8sceclr0pJjg4pXbGnRJB8fCF+R76sU/mWJ+hSdWmgUV10yy01tjYUex8wWmyiE0xmknqZ5RuLzQn8dsLwgS1ul+6RFl+CbNpyxHVxgGTzffBbSZwRDimdb9dM3LiChXIklEowTcRRiYGtR0sg+l2B+kQnJJ3eL23Anx4fnsGls2p1ZJYuEyh7XHlrJB4OF5VqsKcIH3iJaWVuwY2dqq32mYXT3rN4MVbbrjTa14yvvUM+a7OdmNsYnkgjhlc/DT3fQSPhR0M2CcDeQMeuw2MzvvTkhp6nwvu/GjO86KKFOAm6jD97h4Bl9FYRlNF9T/bl1XKCi/gNcq8mOjpmjKWiQsvnaMZXxfDZcvmmwshjjkVYsTJKWY4OwwcouYcm4uZEsOlFUlWvMWRTUYAeFoprR5QYIo8YZY/wIDTn+Xnk+mguApfF9mLbyvmX5tmnEEzvnuQFqBJRTWzMLnOp36F/1m4ImQbA/VwRQFRZwrVnYeV1+ERz07DTL87y11frp4pB138QGjM7Eeng7nx1ErPnG77HV6Kg87CRLz5sI1fiOJ6+QqUqaHC9IsbCrIRLm/UJv6QR6HcQFwIFaZQ5IFLvwO6l5rd4VAPIAcY+PsQe4YPFRfD201Tp/1Qk6+7mAh7bq3kagccWnXOZZ5XtrtpCg6N0Ebo5QRbw4SZY+8KVvg93xmrPbAtbW7/nI1WxINzi8HtRNhnq8lxirf4dIkTpiGDNHylTwPAbpc6FEzu2Dlm7FnORxXX8s=";
    private static final String REPLACE_CODE = "@_@";
    private static final String SCOPE = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><haspscope>@_@</haspscope>";
    private static final String HL_Block = "<hasp type=\"HASP-HL\" >@_@</hasp>";
    private static final String HOST_Block = "<license_manager hostname=\"@_@\" />";
    private static final String IP_Block = "<license_manager ip=\"@_@\" />";
    private static final String KeyID_Block = "<hasp id=\"@_@\" />";
    static int SuperMap_License_Error_Hasp_Load_Library_Error = 4001;
    static transient Vector<LicenseVerifyFailedListener> m_licenseVerifyFailedListeners;
    private static LicenseConnectMode g_connectMode;
    private static String g_connectParamString;
    private static boolean g_configLoaded;
    private Hasp m_hasp;
    private int m_featureID;

    static {
        g_connectMode = LicenseConnectMode.DEFAULT;
        g_connectParamString = "";
    }

    public LicenseHaspInstance() {
        if (!g_configLoaded && g_connectMode == LicenseConnectMode.DEFAULT && g_connectParamString.equals("")) {
            LicenseHaspInstance.FindAndReadConfig();
        }
    }

    public void dispose() {
        this.disconnect();
    }

    public int connect(ProductType product) {
        int productValue = product.getUGCValue();
        return this.connect(productValue);
    }

    public int connect(int featureID) {
        this.disconnect();
        int resultCode = SuperMap_License_Error_Hasp_Load_Library_Error;
        this.m_featureID = featureID;
        int i = 0;
        while (i < g_fault_tolerant_count) {
            this.m_hasp = new Hasp(featureID);
            if (this.m_hasp == null) {
                return resultCode;
            }
            this.internalLogin();
            resultCode = this.m_hasp.getLastError();
            if (resultCode == 0) break;
            ++i;
        }
        return resultCode;
    }

    public static String getLicenseConnectServer() {
        return g_connectParamString;
    }

    public static void setLicenseConnectServer(String value) {
        g_connectParamString = value;
    }

    public static LicenseConnectMode getLicenseConnectMode() {
        return g_connectMode;
    }

    public static void setLicenseConnectMode(LicenseConnectMode value) {
        g_connectMode = value;
    }

    public static void setLicenseConnectTolerantCount(int count) {
        g_fault_tolerant_count = count;
    }

    public static int getLicenseConnectTolerantCount() {
        return g_fault_tolerant_count;
    }

    private void internalLogin() {
        switch (g_connectMode.getUGCValue()) {
            case 0: {
                this.m_hasp.login(vendorCode);
                break;
            }
            case 1: {
                String server = "";
                if (g_connectParamString.isEmpty()) {
                    server = HL_Block.replace(REPLACE_CODE, server);
                } else if (g_connectParamString.trim().matches("\\d+\\.\\d+\\.\\d+\\.\\d+")) {
                    String ip = IP_Block.replace(REPLACE_CODE, g_connectParamString.trim());
                    server = HL_Block.replace(REPLACE_CODE, ip);
                } else {
                    String host = HOST_Block.replace(REPLACE_CODE, g_connectParamString.trim());
                    server = HL_Block.replace(REPLACE_CODE, host);
                }
                this.m_hasp.loginScope(SCOPE.replace(REPLACE_CODE, server), vendorCode);
                break;
            }
            case 3: {
                String server = HOST_Block.replace(REPLACE_CODE, "localhost");
                this.m_hasp.loginScope(SCOPE.replace(REPLACE_CODE, server), vendorCode);
                break;
            }
            case 4: {
                String server = HOST_Block.replace(REPLACE_CODE, "~localhost");
                this.m_hasp.loginScope(SCOPE.replace(REPLACE_CODE, server), vendorCode);
                break;
            }
            case 5: {
                String server = HOST_Block.replace(REPLACE_CODE, g_connectParamString.trim());
                this.m_hasp.loginScope(SCOPE.replace(REPLACE_CODE, server), vendorCode);
                break;
            }
            case 6: {
                String server = IP_Block.replace(REPLACE_CODE, g_connectParamString.trim());
                this.m_hasp.loginScope(SCOPE.replace(REPLACE_CODE, server), vendorCode);
                break;
            }
            case 7: {
                String server = KeyID_Block.replace(REPLACE_CODE, g_connectParamString.trim());
                this.m_hasp.loginScope(SCOPE.replace(REPLACE_CODE, server), vendorCode);
                break;
            }
        }
    }

    public int verify() {
        if (this.m_hasp == null) {
            return SuperMap_License_Error_Hasp_Load_Library_Error;
        }
        int resultCode = -1;
        byte[] data = new byte[16];
        if (this.m_hasp != null) {
            this.m_hasp.encrypt(data);
            resultCode = this.m_hasp.getLastError();
        }
        if (resultCode != 0 && (resultCode = this.connect(this.m_featureID)) == 0) {
            int i = 0;
            while (i < g_fault_tolerant_count) {
                this.m_hasp.encrypt(data);
                if (this.m_hasp.getLastError() == 0) break;
                ++i;
            }
        }
        return resultCode;
    }

    public void disconnect() {
        if (this.m_hasp != null) {
            this.m_hasp.logout();
        }
    }

    public String getUser() {
        return this.readRONames(true);
    }

    public String getCompany() {
        return this.readRONames(false);
    }

    private String readRONames(Boolean isUser) {
        int offset = 0;
        byte[] data = new byte[256];
        String name = "";
        if (this.m_hasp != null && this.verify() == 0) {
            this.m_hasp.read(65525L, offset, data);
            int status = this.m_hasp.getLastError();
            if (status == 0) {
                String unicode = "";
                try {
                    unicode = new String(data, "UTF-8");
                }
                catch (UnsupportedEncodingException e1) {
                    e1.printStackTrace();
                }
                unicode = unicode.trim();
                int pos = unicode.indexOf("|");
                if (pos >= 0) {
                    name = isUser != false ? unicode.substring(0, pos) : unicode.substring(pos + 1, unicode.length());
                }
            }
        }
        return name;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        return buffer.toString();
    }

    public static synchronized void addLicenseVerifyFailedListener(LicenseVerifyFailedListener l) {
        if (m_licenseVerifyFailedListeners == null) {
            m_licenseVerifyFailedListeners = new Vector();
        }
        if (!m_licenseVerifyFailedListeners.contains(l)) {
            m_licenseVerifyFailedListeners.add(l);
        }
    }

    public static synchronized void removeLicenseVerifyFailedListener(LicenseVerifyFailedListener l) {
        if (m_licenseVerifyFailedListeners != null && m_licenseVerifyFailedListeners.contains(l)) {
            m_licenseVerifyFailedListeners.remove(l);
        }
    }

    protected static void fireLicenseVerifyFailed(LicenseVerifyFailedEvent event) {
        if (m_licenseVerifyFailedListeners != null) {
            Vector<LicenseVerifyFailedListener> listeners = m_licenseVerifyFailedListeners;
            int count = listeners.size();
            int i = 0;
            while (i < count) {
                listeners.elementAt(i).licenseVerifyFailed(event);
                ++i;
            }
        }
    }

    public LicenseFeatureInfo getFeatureInfo() {
        LicenseFeatureInfo result = null;
        if (this.m_hasp == null) {
            return result;
        }
        if (this.verify() == 0) {
            String format = "<haspformat root=\"hasp_info\">    <feature>       <attribute name=\"id\" />       <attribute name=\"name\" />       <attribute name=\"locked\" />       <attribute name=\"expired\" />       <attribute name=\"disabled\" />       <attribute name=\"usable\" />       <attribute name=\"vmenabled\" />           <element name=\"license\" />       <element name=\"concurrency\" />         <hasp>          <attribute name=\"id\" />          <attribute name=\"type\" />        </hasp>    </feature></haspformat>";
            String info = this.m_hasp.getSessionInfo(format);
            int status = this.m_hasp.getLastError();
            if (status == 0) {
                StringReader sr = new StringReader(info);
                InputSource is = new InputSource(sr);
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = null;
                try {
                    builder = factory.newDocumentBuilder();
                }
                catch (ParserConfigurationException e) {
                    e.printStackTrace();
                }
                Document doc = null;
                try {
                    doc = builder.parse(is);
                }
                catch (SAXException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                Element root = doc.getDocumentElement();
                Element featureNode = LicenseHaspInstance.getFirstElementByName(root, "feature");
                String temp = featureNode.getAttribute("id");
                long id = LicenseHaspInstance.parseLong(temp);
                String name = featureNode.getAttribute("name");
                temp = featureNode.getAttribute("vmenabled");
                boolean vmenable = LicenseHaspInstance.parseBoolean(temp);
                temp = featureNode.getAttribute("locked");
                boolean locked = LicenseHaspInstance.parseBoolean(temp);
                Element licenseNode = LicenseHaspInstance.getFirstElementByName(featureNode, "license");
                Element element = LicenseHaspInstance.getFirstElementByName(licenseNode, "license_type");
                temp = element.getFirstChild().getNodeValue();
                boolean istrial = locked ? false : temp.equals("trial");
                Calendar cl = Calendar.getInstance();
                cl.clear();
                element = LicenseHaspInstance.getFirstElementByName(licenseNode, "time_start");
                if (element != null) {
                    temp = element.getFirstChild().getNodeValue();
                    int num = LicenseHaspInstance.parseInt(temp);
                    cl.add(13, num);
                }
                if (cl.get(1) == 1970) {
                    cl.set(1, 9999);
                }
                Date startTime = cl.getTime();
                element = LicenseHaspInstance.getFirstElementByName(licenseNode, "total_time");
                if (element != null) {
                    temp = element.getFirstChild().getNodeValue();
                    int num = LicenseHaspInstance.parseInt(temp);
                    cl.add(13, num);
                }
                if (cl.get(1) == 1970) {
                    cl.set(1, 9999);
                }
                Date endTime = cl.getTime();
                Element conElement = LicenseHaspInstance.getFirstElementByName(featureNode, "concurrency");
                element = LicenseHaspInstance.getFirstElementByName(conElement, "seats");
                temp = element.getFirstChild().getNodeValue();
                int maxlogin = 0;
                maxlogin = temp.equals("unlimited") ? 65535 : LicenseHaspInstance.parseInt(temp);
                element = LicenseHaspInstance.getFirstElementByName(conElement, "export");
                String mode = temp = element.getFirstChild().getNodeValue();
                Element haspElement = LicenseHaspInstance.getFirstElementByName(featureNode, "hasp");
                temp = haspElement.getAttribute("id");
                long keyid = LicenseHaspInstance.parseLong(temp);
                temp = haspElement.getAttribute("type");
                String keytype = "";
                if (temp.contains("HL")) {
                    keytype = "Hardware Key";
                } else if (temp.contains("SL")) {
                    keytype = "Soft License";
                }
                result = new LicenseFeatureInfo(id, name, mode, istrial, vmenable, maxlogin, startTime, endTime, keyid, keytype);
            }
        }
        return result;
    }

    private static Element getFirstElementByName(Element element, String tagName) {
        return (Element)LicenseHaspInstance.getFirstElement(element.getElementsByTagName(tagName));
    }

    private static Node getFirstElement(NodeList nodeList) {
        if (nodeList == null || nodeList.getLength() < 1) {
            return null;
        }
        return nodeList.item(0);
    }

    private static int parseInt(String value) {
        int result = Integer.MIN_VALUE;
        try {
            result = Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    private static long parseLong(String value) {
        long result = Long.MIN_VALUE;
        try {
            result = Long.parseLong(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    private static boolean parseBoolean(String value) {
        return Boolean.parseBoolean(value);
    }

    static void FindAndReadConfig() {
        g_configLoaded = true;
        ArrayList<String> findPathes = new ArrayList<String>();
        findPathes.add(License.getUGOBasePath());
        findPathes.add(License.PROGRAM_PATH);
        findPathes.add(License.OPT_PATH);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toUpperCase().equals(License.CONNECTION_CONFIG_FILE_NAME);
            }
        };
        String configFile = null;
        File dir = null;
        for (String string : findPathes) {
            File[] files;
            if (string == null || string.isEmpty() || !(dir = new File(string)).exists() || (files = dir.listFiles(filter)).length <= 0) continue;
            configFile = files[0].getAbsolutePath();
            break;
        }
        if (configFile != null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = null;
            try {
                builder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            Document doc = null;
            try {
                doc = builder.parse(new File(configFile));
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Element root = doc.getDocumentElement();
            Element tempNode = License.getFirstElementByName(root, "ConnectMode");
            String temp = tempNode.getFirstChild().getNodeValue();
            temp = temp.trim().toUpperCase();
            if (temp.equals("")) {
                return;
            }
            if (temp.equals("HLONLY")) {
                g_connectMode = LicenseConnectMode.HL_ONLY;
            } else if (temp.equals("LOCALONLY")) {
                g_connectMode = LicenseConnectMode.LOCAL_ONLY;
            } else if (temp.equals("REMOTEONLY")) {
                g_connectMode = LicenseConnectMode.REMOTE_ONLY;
            } else if (temp.equals("SPECIFIEDHOSTNAME")) {
                g_connectMode = LicenseConnectMode.SPECIFIED_HOSTNAME;
            } else if (temp.equals("SPECIFIEDIP")) {
                g_connectMode = LicenseConnectMode.SPECIFIED_IP;
            } else if (temp.equals("SPECIFIEDKEYID")) {
                g_connectMode = LicenseConnectMode.SPECIFIED_KEYID;
            }
            tempNode = License.getFirstElementByName(root, "ConnectServer");
            temp = tempNode.getFirstChild().getNodeValue();
            g_connectParamString = temp.trim();
        }
    }
}

