/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.services.persondir.support.jdbc;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.collections.map.ListOrderedMap;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.support.JdbcUtils;

public class ColumnMapParameterizedRowMapper
implements ParameterizedRowMapper<Map<String, Object>> {
    private final boolean ignoreNull;

    public ColumnMapParameterizedRowMapper() {
        this(false);
    }

    public ColumnMapParameterizedRowMapper(boolean ignoreNull) {
        this.ignoreNull = ignoreNull;
    }

    public final Map<String, Object> mapRow(ResultSet rs, int rowNum) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        Map<String, Object> mapOfColValues = this.createColumnMap(columnCount);
        for (int i = 1; i <= columnCount; ++i) {
            String columnName = JdbcUtils.lookupColumnName((ResultSetMetaData)rsmd, (int)i);
            Object obj = this.getColumnValue(rs, i);
            if (this.ignoreNull && obj == null) continue;
            String key = this.getColumnKey(columnName);
            mapOfColValues.put(key, obj);
        }
        return mapOfColValues;
    }

    protected Map<String, Object> createColumnMap(int columnCount) {
        return ListOrderedMap.decorate((Map)new CaseInsensitiveMap(columnCount > 0 ? columnCount : 1));
    }

    protected String getColumnKey(String columnName) {
        return columnName;
    }

    protected Object getColumnValue(ResultSet rs, int index) throws SQLException {
        return JdbcUtils.getResultSetValue((ResultSet)rs, (int)index);
    }
}

