/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser;

import java.io.IOException;
import java.io.Reader;
import java.text.Collator;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Locale;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.analysis.LowerCaseTokenizer;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.document.DateField;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.CharStream;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.queryParser.QueryParserTokenManager;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.MockDirectoryWrapper;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.Version;

public abstract class QueryParserTestBase
extends LuceneTestCase {
    public static Analyzer qpAnalyzer = new QPTestAnalyzer();
    private int originalMaxClauses;

    public void setUp() throws Exception {
        super.setUp();
        this.originalMaxClauses = BooleanQuery.getMaxClauseCount();
    }

    public abstract QueryParser getParser(Analyzer var1) throws Exception;

    public Query getQuery(String query, Analyzer a) throws Exception {
        return this.getParser(a).parse(query);
    }

    public void assertQueryEquals(String query, Analyzer a, String result) throws Exception {
        Query q = this.getQuery(query, a);
        String s = q.toString("field");
        if (!s.equals(result)) {
            QueryParserTestBase.fail((String)("Query /" + query + "/ yielded /" + s + "/, expecting /" + result + "/"));
        }
    }

    public void assertQueryEquals(QueryParser qp, String field, String query, String result) throws Exception {
        Query q = qp.parse(query);
        String s = q.toString(field);
        if (!s.equals(result)) {
            QueryParserTestBase.fail((String)("Query /" + query + "/ yielded /" + s + "/, expecting /" + result + "/"));
        }
    }

    public void assertEscapedQueryEquals(String query, Analyzer a, String result) throws Exception {
        String escapedQuery = QueryParser.escape((String)query);
        if (!escapedQuery.equals(result)) {
            QueryParserTestBase.fail((String)("Query /" + query + "/ yielded /" + escapedQuery + "/, expecting /" + result + "/"));
        }
    }

    public void assertWildcardQueryEquals(String query, boolean lowercase, String result, boolean allowLeadingWildcard) throws Exception {
        QueryParser qp = this.getParser(null);
        qp.setLowercaseExpandedTerms(lowercase);
        qp.setAllowLeadingWildcard(allowLeadingWildcard);
        Query q = qp.parse(query);
        String s = q.toString("field");
        if (!s.equals(result)) {
            QueryParserTestBase.fail((String)("WildcardQuery /" + query + "/ yielded /" + s + "/, expecting /" + result + "/"));
        }
    }

    public void assertWildcardQueryEquals(String query, boolean lowercase, String result) throws Exception {
        this.assertWildcardQueryEquals(query, lowercase, result, false);
    }

    public void assertWildcardQueryEquals(String query, String result) throws Exception {
        QueryParser qp = this.getParser(null);
        Query q = qp.parse(query);
        String s = q.toString("field");
        if (!s.equals(result)) {
            QueryParserTestBase.fail((String)("WildcardQuery /" + query + "/ yielded /" + s + "/, expecting /" + result + "/"));
        }
    }

    public Query getQueryDOA(String query, Analyzer a) throws Exception {
        if (a == null) {
            a = new MockAnalyzer(random, 2, true);
        }
        QueryParser qp = new QueryParser(TEST_VERSION_CURRENT, "field", a);
        qp.setDefaultOperator(QueryParser.AND_OPERATOR);
        return qp.parse(query);
    }

    public void assertQueryEqualsDOA(String query, Analyzer a, String result) throws Exception {
        Query q = this.getQueryDOA(query, a);
        String s = q.toString("field");
        if (!s.equals(result)) {
            QueryParserTestBase.fail((String)("Query /" + query + "/ yielded /" + s + "/, expecting /" + result + "/"));
        }
    }

    public void testCJK() throws Exception {
        this.assertQueryEquals("term\u3000term\u3000term", null, "term term term");
        this.assertQueryEquals("\u7528\u8a9e\u3000\u7528\u8a9e\u3000\u7528\u8a9e", null, "\u7528\u8a9e \u7528\u8a9e \u7528\u8a9e");
    }

    public void testCJKTerm() throws Exception {
        StandardAnalyzer analyzer = new StandardAnalyzer(TEST_VERSION_CURRENT);
        BooleanQuery expected = new BooleanQuery();
        expected.add((Query)new TermQuery(new Term("field", "\u4e2d")), BooleanClause.Occur.SHOULD);
        expected.add((Query)new TermQuery(new Term("field", "\u56fd")), BooleanClause.Occur.SHOULD);
        QueryParserTestBase.assertEquals((Object)expected, (Object)this.getQuery("\u4e2d\u56fd", (Analyzer)analyzer));
    }

    public void testCJKBoostedTerm() throws Exception {
        StandardAnalyzer analyzer = new StandardAnalyzer(TEST_VERSION_CURRENT);
        BooleanQuery expected = new BooleanQuery();
        expected.setBoost(0.5f);
        expected.add((Query)new TermQuery(new Term("field", "\u4e2d")), BooleanClause.Occur.SHOULD);
        expected.add((Query)new TermQuery(new Term("field", "\u56fd")), BooleanClause.Occur.SHOULD);
        QueryParserTestBase.assertEquals((Object)expected, (Object)this.getQuery("\u4e2d\u56fd^0.5", (Analyzer)analyzer));
    }

    public void testCJKPhrase() throws Exception {
        StandardAnalyzer analyzer = new StandardAnalyzer(TEST_VERSION_CURRENT);
        PhraseQuery expected = new PhraseQuery();
        expected.add(new Term("field", "\u4e2d"));
        expected.add(new Term("field", "\u56fd"));
        QueryParserTestBase.assertEquals((Object)expected, (Object)this.getQuery("\"\u4e2d\u56fd\"", (Analyzer)analyzer));
    }

    public void testCJKBoostedPhrase() throws Exception {
        StandardAnalyzer analyzer = new StandardAnalyzer(TEST_VERSION_CURRENT);
        PhraseQuery expected = new PhraseQuery();
        expected.setBoost(0.5f);
        expected.add(new Term("field", "\u4e2d"));
        expected.add(new Term("field", "\u56fd"));
        QueryParserTestBase.assertEquals((Object)expected, (Object)this.getQuery("\"\u4e2d\u56fd\"^0.5", (Analyzer)analyzer));
    }

    public void testCJKSloppyPhrase() throws Exception {
        StandardAnalyzer analyzer = new StandardAnalyzer(TEST_VERSION_CURRENT);
        PhraseQuery expected = new PhraseQuery();
        expected.setSlop(3);
        expected.add(new Term("field", "\u4e2d"));
        expected.add(new Term("field", "\u56fd"));
        QueryParserTestBase.assertEquals((Object)expected, (Object)this.getQuery("\"\u4e2d\u56fd\"~3", (Analyzer)analyzer));
    }

    public void testAutoGeneratePhraseQueriesOn() throws Exception {
        StandardAnalyzer analyzer = new StandardAnalyzer(TEST_VERSION_CURRENT);
        PhraseQuery expected = new PhraseQuery();
        expected.add(new Term("field", "\u4e2d"));
        expected.add(new Term("field", "\u56fd"));
        QueryParser parser = new QueryParser(TEST_VERSION_CURRENT, "field", (Analyzer)analyzer);
        parser.setAutoGeneratePhraseQueries(true);
        QueryParserTestBase.assertEquals((Object)expected, (Object)parser.parse("\u4e2d\u56fd"));
    }

    public void testSimple() throws Exception {
        this.assertQueryEquals("term term term", null, "term term term");
        this.assertQueryEquals("t\u00fcrm term term", new MockAnalyzer(random), "t\u00fcrm term term");
        this.assertQueryEquals("\u00fcmlaut", new MockAnalyzer(random), "\u00fcmlaut");
        this.assertQueryEquals("\"\"", (Analyzer)new KeywordAnalyzer(), "");
        this.assertQueryEquals("foo:\"\"", (Analyzer)new KeywordAnalyzer(), "foo:");
        this.assertQueryEquals("a AND b", null, "+a +b");
        this.assertQueryEquals("(a AND b)", null, "+a +b");
        this.assertQueryEquals("c OR (a AND b)", null, "c (+a +b)");
        this.assertQueryEquals("a AND NOT b", null, "+a -b");
        this.assertQueryEquals("a AND -b", null, "+a -b");
        this.assertQueryEquals("a AND !b", null, "+a -b");
        this.assertQueryEquals("a && b", null, "+a +b");
        this.assertQueryEquals("a && ! b", null, "+a -b");
        this.assertQueryEquals("a OR b", null, "a b");
        this.assertQueryEquals("a || b", null, "a b");
        this.assertQueryEquals("a OR !b", null, "a -b");
        this.assertQueryEquals("a OR ! b", null, "a -b");
        this.assertQueryEquals("a OR -b", null, "a -b");
        this.assertQueryEquals("+term -term term", null, "+term -term term");
        this.assertQueryEquals("foo:term AND field:anotherTerm", null, "+foo:term +anotherterm");
        this.assertQueryEquals("term AND \"phrase phrase\"", null, "+term +\"phrase phrase\"");
        this.assertQueryEquals("\"hello there\"", null, "\"hello there\"");
        QueryParserTestBase.assertTrue((boolean)(this.getQuery("a AND b", null) instanceof BooleanQuery));
        QueryParserTestBase.assertTrue((boolean)(this.getQuery("hello", null) instanceof TermQuery));
        QueryParserTestBase.assertTrue((boolean)(this.getQuery("\"hello there\"", null) instanceof PhraseQuery));
        this.assertQueryEquals("germ term^2.0", null, "germ term^2.0");
        this.assertQueryEquals("(term)^2.0", null, "term^2.0");
        this.assertQueryEquals("(germ term)^2.0", null, "(germ term)^2.0");
        this.assertQueryEquals("term^2.0", null, "term^2.0");
        this.assertQueryEquals("term^2", null, "term^2.0");
        this.assertQueryEquals("\"germ term\"^2.0", null, "\"germ term\"^2.0");
        this.assertQueryEquals("\"term germ\"^2", null, "\"term germ\"^2.0");
        this.assertQueryEquals("(foo OR bar) AND (baz OR boo)", null, "+(foo bar) +(baz boo)");
        this.assertQueryEquals("((a OR b) AND NOT c) OR d", null, "(+(a b) -c) d");
        this.assertQueryEquals("+(apple \"steve jobs\") -(foo bar baz)", null, "+(apple \"steve jobs\") -(foo bar baz)");
        this.assertQueryEquals("+title:(dog OR cat) -author:\"bob dole\"", null, "+(title:dog title:cat) -author:\"bob dole\"");
        QueryParser qp = new QueryParser(TEST_VERSION_CURRENT, "field", (Analyzer)new MockAnalyzer(random));
        QueryParserTestBase.assertEquals((Object)QueryParser.OR_OPERATOR, (Object)qp.getDefaultOperator());
        qp.setDefaultOperator(QueryParser.AND_OPERATOR);
        QueryParserTestBase.assertEquals((Object)QueryParser.AND_OPERATOR, (Object)qp.getDefaultOperator());
        qp.setDefaultOperator(QueryParser.OR_OPERATOR);
        QueryParserTestBase.assertEquals((Object)QueryParser.OR_OPERATOR, (Object)qp.getDefaultOperator());
    }

    public void testPunct() throws Exception {
        MockAnalyzer a = new MockAnalyzer(random, 0, false);
        this.assertQueryEquals("a&b", a, "a&b");
        this.assertQueryEquals("a&&b", a, "a&&b");
        this.assertQueryEquals(".NET", a, ".NET");
    }

    public void testSlop() throws Exception {
        this.assertQueryEquals("\"term germ\"~2", null, "\"term germ\"~2");
        this.assertQueryEquals("\"term germ\"~2 flork", null, "\"term germ\"~2 flork");
        this.assertQueryEquals("\"term\"~2", null, "term");
        this.assertQueryEquals("\" \"~2 germ", null, "germ");
        this.assertQueryEquals("\"term germ\"~2^2", null, "\"term germ\"~2^2.0");
    }

    public void testNumber() throws Exception {
        this.assertQueryEquals("3", null, "");
        this.assertQueryEquals("term 1.0 1 2", null, "term");
        this.assertQueryEquals("term term1 term2", null, "term term term");
        MockAnalyzer a = new MockAnalyzer(random, 0, true);
        this.assertQueryEquals("3", a, "3");
        this.assertQueryEquals("term 1.0 1 2", a, "term 1.0 1 2");
        this.assertQueryEquals("term term1 term2", a, "term term1 term2");
    }

    public void testWildcard() throws Exception {
        this.assertQueryEquals("term*", null, "term*");
        this.assertQueryEquals("term*^2", null, "term*^2.0");
        this.assertQueryEquals("term~", null, "term~0.5");
        this.assertQueryEquals("term~0.7", null, "term~0.7");
        this.assertQueryEquals("term~^2", null, "term~0.5^2.0");
        this.assertQueryEquals("term^2~", null, "term~0.5^2.0");
        this.assertQueryEquals("term*germ", null, "term*germ");
        this.assertQueryEquals("term*germ^3", null, "term*germ^3.0");
        QueryParserTestBase.assertTrue((boolean)(this.getQuery("term*", null) instanceof PrefixQuery));
        QueryParserTestBase.assertTrue((boolean)(this.getQuery("term*^2", null) instanceof PrefixQuery));
        QueryParserTestBase.assertTrue((boolean)(this.getQuery("term~", null) instanceof FuzzyQuery));
        QueryParserTestBase.assertTrue((boolean)(this.getQuery("term~0.7", null) instanceof FuzzyQuery));
        FuzzyQuery fq = (FuzzyQuery)this.getQuery("term~0.7", null);
        QueryParserTestBase.assertEquals((double)0.7f, (double)fq.getMinSimilarity(), (double)0.1f);
        QueryParserTestBase.assertEquals((long)0L, (long)fq.getPrefixLength());
        fq = (FuzzyQuery)this.getQuery("term~", null);
        QueryParserTestBase.assertEquals((double)0.5, (double)fq.getMinSimilarity(), (double)0.1f);
        QueryParserTestBase.assertEquals((long)0L, (long)fq.getPrefixLength());
        this.assertParseException("term~1.1");
        QueryParserTestBase.assertTrue((boolean)(this.getQuery("term*germ", null) instanceof WildcardQuery));
        this.assertWildcardQueryEquals("Term*", true, "term*");
        this.assertWildcardQueryEquals("term*", true, "term*");
        this.assertWildcardQueryEquals("Term*", true, "term*");
        this.assertWildcardQueryEquals("TERM*", true, "term*");
        this.assertWildcardQueryEquals("term*", false, "term*");
        this.assertWildcardQueryEquals("Term*", false, "Term*");
        this.assertWildcardQueryEquals("TERM*", false, "TERM*");
        this.assertWildcardQueryEquals("Te?m", "te?m");
        this.assertWildcardQueryEquals("te?m", true, "te?m");
        this.assertWildcardQueryEquals("Te?m", true, "te?m");
        this.assertWildcardQueryEquals("TE?M", true, "te?m");
        this.assertWildcardQueryEquals("Te?m*gerM", true, "te?m*germ");
        this.assertWildcardQueryEquals("te?m", false, "te?m");
        this.assertWildcardQueryEquals("Te?m", false, "Te?m");
        this.assertWildcardQueryEquals("TE?M", false, "TE?M");
        this.assertWildcardQueryEquals("Te?m*gerM", false, "Te?m*gerM");
        this.assertWildcardQueryEquals("Term~", "term~0.5");
        this.assertWildcardQueryEquals("Term~", true, "term~0.5");
        this.assertWildcardQueryEquals("Term~", false, "Term~0.5");
        this.assertWildcardQueryEquals("[A TO C]", "[a TO c]");
        this.assertWildcardQueryEquals("[A TO C]", true, "[a TO c]");
        this.assertWildcardQueryEquals("[A TO C]", false, "[A TO C]");
        try {
            this.assertWildcardQueryEquals("*Term", true, "*term");
            QueryParserTestBase.fail();
        }
        catch (ParseException pe) {
            // empty catch block
        }
        try {
            this.assertWildcardQueryEquals("?Term", true, "?term");
            QueryParserTestBase.fail();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.assertWildcardQueryEquals("*Term", true, "*term", true);
        this.assertWildcardQueryEquals("?Term", true, "?term", true);
    }

    public void testLeadingWildcardType() throws Exception {
        QueryParser qp = this.getParser(null);
        qp.setAllowLeadingWildcard(true);
        QueryParserTestBase.assertEquals(WildcardQuery.class, qp.parse("t*erm*").getClass());
        QueryParserTestBase.assertEquals(WildcardQuery.class, qp.parse("?term*").getClass());
        QueryParserTestBase.assertEquals(WildcardQuery.class, qp.parse("*term*").getClass());
    }

    public void testQPA() throws Exception {
        this.assertQueryEquals("term term^3.0 term", qpAnalyzer, "term term^3.0 term");
        this.assertQueryEquals("term stop^3.0 term", qpAnalyzer, "term term");
        this.assertQueryEquals("term term term", qpAnalyzer, "term term term");
        this.assertQueryEquals("term +stop term", qpAnalyzer, "term term");
        this.assertQueryEquals("term -stop term", qpAnalyzer, "term term");
        this.assertQueryEquals("drop AND (stop) AND roll", qpAnalyzer, "+drop +roll");
        this.assertQueryEquals("term +(stop) term", qpAnalyzer, "term term");
        this.assertQueryEquals("term -(stop) term", qpAnalyzer, "term term");
        this.assertQueryEquals("drop AND stop AND roll", qpAnalyzer, "+drop +roll");
        this.assertQueryEquals("term phrase term", qpAnalyzer, "term (phrase1 phrase2) term");
        this.assertQueryEquals("term AND NOT phrase term", qpAnalyzer, "+term -(phrase1 phrase2) term");
        this.assertQueryEquals("stop^3", qpAnalyzer, "");
        this.assertQueryEquals("stop", qpAnalyzer, "");
        this.assertQueryEquals("(stop)^3", qpAnalyzer, "");
        this.assertQueryEquals("((stop))^3", qpAnalyzer, "");
        this.assertQueryEquals("(stop^3)", qpAnalyzer, "");
        this.assertQueryEquals("((stop)^3)", qpAnalyzer, "");
        this.assertQueryEquals("(stop)", qpAnalyzer, "");
        this.assertQueryEquals("((stop))", qpAnalyzer, "");
        QueryParserTestBase.assertTrue((boolean)(this.getQuery("term term term", qpAnalyzer) instanceof BooleanQuery));
        QueryParserTestBase.assertTrue((boolean)(this.getQuery("term +stop", qpAnalyzer) instanceof TermQuery));
    }

    public void testRange() throws Exception {
        this.assertQueryEquals("[ a TO z]", null, "[a TO z]");
        QueryParserTestBase.assertEquals((Object)MultiTermQuery.CONSTANT_SCORE_AUTO_REWRITE_DEFAULT, (Object)((TermRangeQuery)this.getQuery("[ a TO z]", null)).getRewriteMethod());
        QueryParser qp = new QueryParser(TEST_VERSION_CURRENT, "field", (Analyzer)new MockAnalyzer(random, 2, true));
        qp.setMultiTermRewriteMethod(MultiTermQuery.SCORING_BOOLEAN_QUERY_REWRITE);
        QueryParserTestBase.assertEquals((Object)MultiTermQuery.SCORING_BOOLEAN_QUERY_REWRITE, (Object)((TermRangeQuery)qp.parse("[ a TO z]")).getRewriteMethod());
        this.assertQueryEquals("[ a TO z ]", null, "[a TO z]");
        this.assertQueryEquals("{ a TO z}", null, "{a TO z}");
        this.assertQueryEquals("{ a TO z }", null, "{a TO z}");
        this.assertQueryEquals("{ a TO z }^2.0", null, "{a TO z}^2.0");
        this.assertQueryEquals("[ a TO z] OR bar", null, "[a TO z] bar");
        this.assertQueryEquals("[ a TO z] AND bar", null, "+[a TO z] +bar");
        this.assertQueryEquals("( bar blar { a TO z}) ", null, "bar blar {a TO z}");
        this.assertQueryEquals("gack ( bar blar { a TO z}) ", null, "gack (bar blar {a TO z})");
        this.assertQueryEquals("[* TO Z]", null, "[* TO z]");
        this.assertQueryEquals("[A TO *]", null, "[a TO *]");
        this.assertQueryEquals("[* TO *]", null, "[* TO *]");
        this.assertQueryEquals("[\\* TO \"*\"]", null, "[\\* TO \\*]");
    }

    public void testFarsiRangeCollating() throws Exception {
        MockDirectoryWrapper ramDir = QueryParserTestBase.newDirectory();
        IndexWriter iw = new IndexWriter((Directory)ramDir, QueryParserTestBase.newIndexWriterConfig(TEST_VERSION_CURRENT, (Analyzer)new WhitespaceAnalyzer(TEST_VERSION_CURRENT)));
        Document doc = new Document();
        doc.add((Fieldable)QueryParserTestBase.newField("content", "\u0633\u0627\u0628", Field.Store.YES, Field.Index.NOT_ANALYZED));
        iw.addDocument(doc);
        iw.close();
        IndexSearcher is = new IndexSearcher((Directory)ramDir, true);
        QueryParser qp = new QueryParser(TEST_VERSION_CURRENT, "content", (Analyzer)new WhitespaceAnalyzer(TEST_VERSION_CURRENT));
        Collator c = Collator.getInstance(new Locale("ar"));
        qp.setRangeCollator(c);
        qp.setMultiTermRewriteMethod(MultiTermQuery.CONSTANT_SCORE_FILTER_REWRITE);
        ScoreDoc[] result = is.search((Query)qp.parse((String)"[ \u062f TO \u0698 ]"), null, (int)1000).scoreDocs;
        QueryParserTestBase.assertEquals((String)"The index Term should not be included.", (long)0L, (long)result.length);
        result = is.search((Query)qp.parse((String)"[ \u0633 TO \u0638 ]"), null, (int)1000).scoreDocs;
        QueryParserTestBase.assertEquals((String)"The index Term should be included.", (long)1L, (long)result.length);
        qp.setMultiTermRewriteMethod(MultiTermQuery.SCORING_BOOLEAN_QUERY_REWRITE);
        result = is.search((Query)qp.parse((String)"[ \u062f TO \u0698 ]"), null, (int)1000).scoreDocs;
        QueryParserTestBase.assertEquals((String)"The index Term should not be included.", (long)0L, (long)result.length);
        result = is.search((Query)qp.parse((String)"[ \u0633 TO \u0638 ]"), null, (int)1000).scoreDocs;
        QueryParserTestBase.assertEquals((String)"The index Term should be included.", (long)1L, (long)result.length);
        is.close();
        ramDir.close();
    }

    private String escapeDateString(String s) {
        if (s.indexOf(" ") > -1) {
            return "\"" + s + "\"";
        }
        return s;
    }

    private String getLegacyDate(String s) throws Exception {
        DateFormat df = DateFormat.getDateInstance(3);
        return DateField.dateToString((Date)df.parse(s));
    }

    private String getDate(String s, DateTools.Resolution resolution) throws Exception {
        DateFormat df = DateFormat.getDateInstance(3);
        return this.getDate(df.parse(s), resolution);
    }

    private String getDate(Date d, DateTools.Resolution resolution) throws Exception {
        if (resolution == null) {
            return DateField.dateToString((Date)d);
        }
        return DateTools.dateToString((Date)d, (DateTools.Resolution)resolution);
    }

    private String getLocalizedDate(int year, int month, int day) {
        DateFormat df = DateFormat.getDateInstance(3);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.clear();
        calendar.set(year, month, day);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return df.format(calendar.getTime());
    }

    public void testLegacyDateRange() throws Exception {
        String startDate = this.getLocalizedDate(2002, 1, 1);
        String endDate = this.getLocalizedDate(2002, 1, 4);
        GregorianCalendar endDateExpected = new GregorianCalendar();
        endDateExpected.clear();
        endDateExpected.set(2002, 1, 4, 23, 59, 59);
        endDateExpected.set(14, 999);
        this.assertQueryEquals("[ " + this.escapeDateString(startDate) + " TO " + this.escapeDateString(endDate) + "]", null, "[" + this.getLegacyDate(startDate) + " TO " + DateField.dateToString((Date)endDateExpected.getTime()) + "]");
        this.assertQueryEquals("{  " + this.escapeDateString(startDate) + "    " + this.escapeDateString(endDate) + "   }", null, "{" + this.getLegacyDate(startDate) + " TO " + this.getLegacyDate(endDate) + "}");
    }

    public void testDateRange() throws Exception {
        String startDate = this.getLocalizedDate(2002, 1, 1);
        String endDate = this.getLocalizedDate(2002, 1, 4);
        GregorianCalendar endDateExpected = new GregorianCalendar();
        endDateExpected.clear();
        endDateExpected.set(2002, 1, 4, 23, 59, 59);
        endDateExpected.set(14, 999);
        String defaultField = "default";
        String monthField = "month";
        String hourField = "hour";
        QueryParser qp = new QueryParser(TEST_VERSION_CURRENT, "field", (Analyzer)new MockAnalyzer(random, 2, true));
        this.assertDateRangeQueryEquals(qp, "default", startDate, endDate, endDateExpected.getTime(), null);
        qp.setDateResolution("month", DateTools.Resolution.MONTH);
        this.assertDateRangeQueryEquals(qp, "default", startDate, endDate, endDateExpected.getTime(), null);
        qp.setDateResolution(DateTools.Resolution.MILLISECOND);
        qp.setDateResolution("hour", DateTools.Resolution.HOUR);
        this.assertDateRangeQueryEquals(qp, "default", startDate, endDate, endDateExpected.getTime(), DateTools.Resolution.MILLISECOND);
        this.assertDateRangeQueryEquals(qp, "month", startDate, endDate, endDateExpected.getTime(), DateTools.Resolution.MONTH);
        this.assertDateRangeQueryEquals(qp, "hour", startDate, endDate, endDateExpected.getTime(), DateTools.Resolution.HOUR);
    }

    public void assertDateRangeQueryEquals(QueryParser qp, String field, String startDate, String endDate, Date endDateInclusive, DateTools.Resolution resolution) throws Exception {
        this.assertQueryEquals(qp, field, field + ":[" + this.escapeDateString(startDate) + " TO " + this.escapeDateString(endDate) + "]", "[" + this.getDate(startDate, resolution) + " TO " + this.getDate(endDateInclusive, resolution) + "]");
        this.assertQueryEquals(qp, field, field + ":{" + this.escapeDateString(startDate) + " TO " + this.escapeDateString(endDate) + "}", "{" + this.getDate(startDate, resolution) + " TO " + this.getDate(endDate, resolution) + "}");
    }

    public void testEscaped() throws Exception {
        MockAnalyzer a = new MockAnalyzer(random, 0, false);
        this.assertQueryEquals("\\a", a, "a");
        this.assertQueryEquals("a\\-b:c", a, "a-b:c");
        this.assertQueryEquals("a\\+b:c", a, "a+b:c");
        this.assertQueryEquals("a\\:b:c", a, "a:b:c");
        this.assertQueryEquals("a\\\\b:c", a, "a\\b:c");
        this.assertQueryEquals("a:b\\-c", a, "a:b-c");
        this.assertQueryEquals("a:b\\+c", a, "a:b+c");
        this.assertQueryEquals("a:b\\:c", a, "a:b:c");
        this.assertQueryEquals("a:b\\\\c", a, "a:b\\c");
        this.assertQueryEquals("a:b\\-c*", a, "a:b-c*");
        this.assertQueryEquals("a:b\\+c*", a, "a:b+c*");
        this.assertQueryEquals("a:b\\:c*", a, "a:b:c*");
        this.assertQueryEquals("a:b\\\\c*", a, "a:b\\c*");
        this.assertQueryEquals("a:b\\-?c", a, "a:b-?c");
        this.assertQueryEquals("a:b\\+?c", a, "a:b+?c");
        this.assertQueryEquals("a:b\\:?c", a, "a:b:?c");
        this.assertQueryEquals("a:b\\\\?c", a, "a:b\\?c");
        this.assertQueryEquals("a:b\\-c~", a, "a:b-c~0.5");
        this.assertQueryEquals("a:b\\+c~", a, "a:b+c~0.5");
        this.assertQueryEquals("a:b\\:c~", a, "a:b:c~0.5");
        this.assertQueryEquals("a:b\\\\c~", a, "a:b\\c~0.5");
        this.assertQueryEquals("[ a\\- TO a\\+ ]", null, "[a- TO a+]");
        this.assertQueryEquals("[ a\\: TO a\\~ ]", null, "[a: TO a~]");
        this.assertQueryEquals("[ a\\\\ TO a\\* ]", null, "[a\\ TO a*]");
        this.assertQueryEquals("[\"c\\:\\\\temp\\\\\\~foo0.txt\" TO \"c\\:\\\\temp\\\\\\~foo9.txt\"]", a, "[c:\\temp\\~foo0.txt TO c:\\temp\\~foo9.txt]");
        this.assertQueryEquals("a\\\\\\+b", a, "a\\+b");
        this.assertQueryEquals("a \\\"b c\\\" d", a, "a \"b c\" d");
        this.assertQueryEquals("\"a \\\"b c\\\" d\"", a, "\"a \"b c\" d\"");
        this.assertQueryEquals("\"a \\+b c d\"", a, "\"a +b c d\"");
        this.assertQueryEquals("c\\:\\\\temp\\\\\\~foo.txt", a, "c:\\temp\\~foo.txt");
        this.assertParseException("XY\\");
        this.assertQueryEquals("a\\u0062c", a, "abc");
        this.assertQueryEquals("XY\\u005a", a, "XYZ");
        this.assertQueryEquals("XY\\u005A", a, "XYZ");
        this.assertQueryEquals("\"a \\\\\\u0028\\u0062\\\" c\"", a, "\"a \\(b\" c\"");
        this.assertParseException("XY\\u005G");
        this.assertParseException("XY\\u005");
        this.assertQueryEquals("(item:\\\\ item:ABCD\\\\)", a, "item:\\ item:ABCD\\");
        this.assertParseException("(item:\\\\ item:ABCD\\\\))");
        this.assertQueryEquals("\\*", a, "*");
        this.assertQueryEquals("\\\\", a, "\\");
        this.assertParseException("\\");
        this.assertQueryEquals("(\"a\\\\\") or (\"b\")", a, "a\\ or b");
    }

    public void testQueryStringEscaping() throws Exception {
        MockAnalyzer a = new MockAnalyzer(random, 0, false);
        this.assertEscapedQueryEquals("a-b:c", a, "a\\-b\\:c");
        this.assertEscapedQueryEquals("a+b:c", a, "a\\+b\\:c");
        this.assertEscapedQueryEquals("a:b:c", a, "a\\:b\\:c");
        this.assertEscapedQueryEquals("a\\b:c", a, "a\\\\b\\:c");
        this.assertEscapedQueryEquals("a:b-c", a, "a\\:b\\-c");
        this.assertEscapedQueryEquals("a:b+c", a, "a\\:b\\+c");
        this.assertEscapedQueryEquals("a:b:c", a, "a\\:b\\:c");
        this.assertEscapedQueryEquals("a:b\\c", a, "a\\:b\\\\c");
        this.assertEscapedQueryEquals("a:b-c*", a, "a\\:b\\-c\\*");
        this.assertEscapedQueryEquals("a:b+c*", a, "a\\:b\\+c\\*");
        this.assertEscapedQueryEquals("a:b:c*", a, "a\\:b\\:c\\*");
        this.assertEscapedQueryEquals("a:b\\\\c*", a, "a\\:b\\\\\\\\c\\*");
        this.assertEscapedQueryEquals("a:b-?c", a, "a\\:b\\-\\?c");
        this.assertEscapedQueryEquals("a:b+?c", a, "a\\:b\\+\\?c");
        this.assertEscapedQueryEquals("a:b:?c", a, "a\\:b\\:\\?c");
        this.assertEscapedQueryEquals("a:b?c", a, "a\\:b\\?c");
        this.assertEscapedQueryEquals("a:b-c~", a, "a\\:b\\-c\\~");
        this.assertEscapedQueryEquals("a:b+c~", a, "a\\:b\\+c\\~");
        this.assertEscapedQueryEquals("a:b:c~", a, "a\\:b\\:c\\~");
        this.assertEscapedQueryEquals("a:b\\c~", a, "a\\:b\\\\c\\~");
        this.assertEscapedQueryEquals("[ a - TO a+ ]", null, "\\[ a \\- TO a\\+ \\]");
        this.assertEscapedQueryEquals("[ a : TO a~ ]", null, "\\[ a \\: TO a\\~ \\]");
        this.assertEscapedQueryEquals("[ a\\ TO a* ]", null, "\\[ a\\\\ TO a\\* \\]");
        this.assertEscapedQueryEquals("|| abc ||", a, "\\|\\| abc \\|\\|");
        this.assertEscapedQueryEquals("&& abc &&", a, "\\&\\& abc \\&\\&");
    }

    public void testTabNewlineCarriageReturn() throws Exception {
        this.assertQueryEqualsDOA("+weltbank +worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("+weltbank\n+worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \n+worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \n +worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("+weltbank\r+worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \r+worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \r +worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("+weltbank\r\n+worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \r\n+worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \r\n +worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \r \n +worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("+weltbank\t+worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \t+worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \t +worlbank", null, "+weltbank +worlbank");
    }

    public void testSimpleDAO() throws Exception {
        this.assertQueryEqualsDOA("term term term", null, "+term +term +term");
        this.assertQueryEqualsDOA("term +term term", null, "+term +term +term");
        this.assertQueryEqualsDOA("term term +term", null, "+term +term +term");
        this.assertQueryEqualsDOA("term +term +term", null, "+term +term +term");
        this.assertQueryEqualsDOA("-term term term", null, "-term +term +term");
    }

    public void testBoost() throws Exception {
        HashSet<String> stopWords = new HashSet<String>(1);
        stopWords.add("on");
        StandardAnalyzer oneStopAnalyzer = new StandardAnalyzer(TEST_VERSION_CURRENT, stopWords);
        QueryParser qp = new QueryParser(TEST_VERSION_CURRENT, "field", (Analyzer)oneStopAnalyzer);
        Query q = qp.parse("on^1.0");
        QueryParserTestBase.assertNotNull((Object)q);
        q = qp.parse("\"hello\"^2.0");
        QueryParserTestBase.assertNotNull((Object)q);
        QueryParserTestBase.assertEquals((double)q.getBoost(), (double)2.0, (double)0.5);
        q = qp.parse("hello^2.0");
        QueryParserTestBase.assertNotNull((Object)q);
        QueryParserTestBase.assertEquals((double)q.getBoost(), (double)2.0, (double)0.5);
        q = qp.parse("\"on\"^1.0");
        QueryParserTestBase.assertNotNull((Object)q);
        QueryParser qp2 = new QueryParser(TEST_VERSION_CURRENT, "field", (Analyzer)new StandardAnalyzer(TEST_VERSION_CURRENT));
        q = qp2.parse("the^3");
        QueryParserTestBase.assertNotNull((Object)q);
        QueryParserTestBase.assertEquals((Object)"", (Object)q.toString());
        QueryParserTestBase.assertEquals((double)1.0, (double)q.getBoost(), (double)0.01f);
    }

    public void assertParseException(String queryString) throws Exception {
        try {
            this.getQuery(queryString, null);
        }
        catch (ParseException expected) {
            return;
        }
        QueryParserTestBase.fail((String)"ParseException expected, not thrown");
    }

    public void testException() throws Exception {
        this.assertParseException("\"some phrase");
        this.assertParseException("(foo bar");
        this.assertParseException("foo bar))");
        this.assertParseException("field:term:with:colon some more terms");
        this.assertParseException("(sub query)^5.0^2.0 plus more");
        this.assertParseException("secret AND illegal) AND access:confidential");
    }

    public void testCustomQueryParserWildcard() {
        try {
            new QPTestParser("contents", new MockAnalyzer(random, 0, false)).parse("a?t");
            QueryParserTestBase.fail((String)"Wildcard queries should not be allowed");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void testCustomQueryParserFuzzy() throws Exception {
        try {
            new QPTestParser("contents", new MockAnalyzer(random, 0, false)).parse("xunit~");
            QueryParserTestBase.fail((String)"Fuzzy queries should not be allowed");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void testBooleanQuery() throws Exception {
        BooleanQuery.setMaxClauseCount((int)2);
        try {
            QueryParser qp = new QueryParser(TEST_VERSION_CURRENT, "field", (Analyzer)new MockAnalyzer(random, 0, false));
            qp.parse("one two three");
            QueryParserTestBase.fail((String)"ParseException expected due to too many boolean clauses");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void testPrecedence() throws Exception {
        QueryParser qp = new QueryParser(TEST_VERSION_CURRENT, "field", (Analyzer)new MockAnalyzer(random, 0, false));
        Query query1 = qp.parse("A AND B OR C AND D");
        Query query2 = qp.parse("+A +B +C +D");
        QueryParserTestBase.assertEquals((Object)query1, (Object)query2);
    }

    public void testLocalDateFormat() throws IOException, ParseException {
        MockDirectoryWrapper ramDir = QueryParserTestBase.newDirectory();
        IndexWriter iw = new IndexWriter((Directory)ramDir, QueryParserTestBase.newIndexWriterConfig(TEST_VERSION_CURRENT, (Analyzer)new WhitespaceAnalyzer(TEST_VERSION_CURRENT)));
        this.addDateDoc("a", 2005, 12, 2, 10, 15, 33, iw);
        this.addDateDoc("b", 2005, 12, 4, 22, 15, 0, iw);
        iw.close();
        IndexSearcher is = new IndexSearcher((Directory)ramDir, true);
        this.assertHits(1, "[12/1/2005 TO 12/3/2005]", is);
        this.assertHits(2, "[12/1/2005 TO 12/4/2005]", is);
        this.assertHits(1, "[12/3/2005 TO 12/4/2005]", is);
        this.assertHits(1, "{12/1/2005 TO 12/3/2005}", is);
        this.assertHits(1, "{12/1/2005 TO 12/4/2005}", is);
        this.assertHits(0, "{12/3/2005 TO 12/4/2005}", is);
        is.close();
        ramDir.close();
    }

    public void testStarParsing() throws Exception {
        final int[] type = new int[1];
        QueryParser qp = new QueryParser(TEST_VERSION_CURRENT, "field", new MockAnalyzer(random, 0, false)){

            protected Query getWildcardQuery(String field, String termStr) throws ParseException {
                type[0] = 1;
                return new TermQuery(new Term(field, termStr));
            }

            protected Query getPrefixQuery(String field, String termStr) throws ParseException {
                type[0] = 2;
                return new TermQuery(new Term(field, termStr));
            }

            protected Query getFieldQuery(String field, String queryText, boolean quoted) throws ParseException {
                type[0] = 3;
                return super.getFieldQuery(field, queryText, quoted);
            }
        };
        TermQuery tq = (TermQuery)qp.parse("foo:zoo*");
        QueryParserTestBase.assertEquals((Object)"zoo", (Object)tq.getTerm().text());
        QueryParserTestBase.assertEquals((long)2L, (long)type[0]);
        tq = (TermQuery)qp.parse("foo:zoo*^2");
        QueryParserTestBase.assertEquals((Object)"zoo", (Object)tq.getTerm().text());
        QueryParserTestBase.assertEquals((long)2L, (long)type[0]);
        QueryParserTestBase.assertEquals((double)tq.getBoost(), (double)2.0, (double)0.0);
        tq = (TermQuery)qp.parse("foo:*");
        QueryParserTestBase.assertEquals((Object)"*", (Object)tq.getTerm().text());
        QueryParserTestBase.assertEquals((long)1L, (long)type[0]);
        tq = (TermQuery)qp.parse("foo:*^2");
        QueryParserTestBase.assertEquals((Object)"*", (Object)tq.getTerm().text());
        QueryParserTestBase.assertEquals((long)1L, (long)type[0]);
        QueryParserTestBase.assertEquals((double)tq.getBoost(), (double)2.0, (double)0.0);
        tq = (TermQuery)qp.parse("*:foo");
        QueryParserTestBase.assertEquals((Object)"*", (Object)tq.getTerm().field());
        QueryParserTestBase.assertEquals((Object)"foo", (Object)tq.getTerm().text());
        QueryParserTestBase.assertEquals((long)3L, (long)type[0]);
        tq = (TermQuery)qp.parse("*:*");
        QueryParserTestBase.assertEquals((Object)"*", (Object)tq.getTerm().field());
        QueryParserTestBase.assertEquals((Object)"*", (Object)tq.getTerm().text());
        QueryParserTestBase.assertEquals((long)1L, (long)type[0]);
        tq = (TermQuery)qp.parse("(*:*)");
        QueryParserTestBase.assertEquals((Object)"*", (Object)tq.getTerm().field());
        QueryParserTestBase.assertEquals((Object)"*", (Object)tq.getTerm().text());
        QueryParserTestBase.assertEquals((long)1L, (long)type[0]);
    }

    public void testStopwords() throws Exception {
        QueryParser qp = new QueryParser(TEST_VERSION_CURRENT, "a", (Analyzer)new StopAnalyzer(TEST_VERSION_CURRENT, StopFilter.makeStopSet((Version)TEST_VERSION_CURRENT, (String[])new String[]{"the", "foo"})));
        Query result = qp.parse("a:the OR a:foo");
        QueryParserTestBase.assertNotNull((String)"result is null and it shouldn't be", (Object)result);
        QueryParserTestBase.assertTrue((String)"result is not a BooleanQuery", (boolean)(result instanceof BooleanQuery));
        QueryParserTestBase.assertTrue((String)(((BooleanQuery)result).clauses().size() + " does not equal: " + 0), (((BooleanQuery)result).clauses().size() == 0 ? 1 : 0) != 0);
        result = qp.parse("a:woo OR a:the");
        QueryParserTestBase.assertNotNull((String)"result is null and it shouldn't be", (Object)result);
        QueryParserTestBase.assertTrue((String)"result is not a TermQuery", (boolean)(result instanceof TermQuery));
        result = qp.parse("(fieldX:xxxxx OR fieldy:xxxxxxxx)^2 AND (fieldx:the OR fieldy:foo)");
        QueryParserTestBase.assertNotNull((String)"result is null and it shouldn't be", (Object)result);
        QueryParserTestBase.assertTrue((String)"result is not a BooleanQuery", (boolean)(result instanceof BooleanQuery));
        if (VERBOSE) {
            System.out.println("Result: " + result);
        }
        QueryParserTestBase.assertTrue((String)(((BooleanQuery)result).clauses().size() + " does not equal: " + 2), (((BooleanQuery)result).clauses().size() == 2 ? 1 : 0) != 0);
    }

    public void testPositionIncrement() throws Exception {
        QueryParser qp = new QueryParser(TEST_VERSION_CURRENT, "a", (Analyzer)new StopAnalyzer(TEST_VERSION_CURRENT, StopFilter.makeStopSet((Version)TEST_VERSION_CURRENT, (String[])new String[]{"the", "in", "are", "this"})));
        qp.setEnablePositionIncrements(true);
        String qtxt = "\"the words in poisitions pos02578 are stopped in this phrasequery\"";
        int[] expectedPositions = new int[]{1, 3, 4, 6, 9};
        PhraseQuery pq = (PhraseQuery)qp.parse(qtxt);
        Term[] t = pq.getTerms();
        int[] pos = pq.getPositions();
        for (int i = 0; i < t.length; ++i) {
            QueryParserTestBase.assertEquals((String)("term " + i + " = " + t[i] + " has wrong term-position!"), (long)expectedPositions[i], (long)pos[i]);
        }
    }

    public void testMatchAllDocs() throws Exception {
        QueryParser qp = new QueryParser(TEST_VERSION_CURRENT, "field", (Analyzer)new MockAnalyzer(random, 0, false));
        QueryParserTestBase.assertEquals((Object)new MatchAllDocsQuery(), (Object)qp.parse("*:*"));
        QueryParserTestBase.assertEquals((Object)new MatchAllDocsQuery(), (Object)qp.parse("(*:*)"));
        BooleanQuery bq = (BooleanQuery)qp.parse("+*:* -*:*");
        QueryParserTestBase.assertTrue((boolean)(bq.getClauses()[0].getQuery() instanceof MatchAllDocsQuery));
        QueryParserTestBase.assertTrue((boolean)(bq.getClauses()[1].getQuery() instanceof MatchAllDocsQuery));
    }

    private void assertHits(int expected, String query, IndexSearcher is) throws ParseException, IOException {
        QueryParser qp = new QueryParser(TEST_VERSION_CURRENT, "date", (Analyzer)new MockAnalyzer(random, 0, false));
        qp.setLocale(Locale.ENGLISH);
        Query q = qp.parse(query);
        ScoreDoc[] hits = is.search((Query)q, null, (int)1000).scoreDocs;
        QueryParserTestBase.assertEquals((long)expected, (long)hits.length);
    }

    private void addDateDoc(String content, int year, int month, int day, int hour, int minute, int second, IndexWriter iw) throws IOException {
        Document d = new Document();
        d.add((Fieldable)QueryParserTestBase.newField("f", content, Field.Store.YES, Field.Index.ANALYZED));
        Calendar cal = Calendar.getInstance(Locale.ENGLISH);
        cal.set(year, month - 1, day, hour, minute, second);
        d.add((Fieldable)QueryParserTestBase.newField("date", DateField.dateToString((Date)cal.getTime()), Field.Store.YES, Field.Index.NOT_ANALYZED));
        iw.addDocument(d);
    }

    public void tearDown() throws Exception {
        BooleanQuery.setMaxClauseCount((int)this.originalMaxClauses);
        super.tearDown();
    }

    public void testPositionIncrements() throws Exception {
        MockDirectoryWrapper dir = QueryParserTestBase.newDirectory();
        StandardAnalyzer a = new StandardAnalyzer(TEST_VERSION_CURRENT);
        IndexWriter w = new IndexWriter((Directory)dir, QueryParserTestBase.newIndexWriterConfig(TEST_VERSION_CURRENT, (Analyzer)a));
        Document doc = new Document();
        doc.add((Fieldable)QueryParserTestBase.newField("f", "the wizard of ozzy", Field.Store.NO, Field.Index.ANALYZED));
        w.addDocument(doc);
        IndexReader r = IndexReader.open((IndexWriter)w, (boolean)true);
        w.close();
        IndexSearcher s = QueryParserTestBase.newSearcher(r);
        QueryParser qp = new QueryParser(TEST_VERSION_CURRENT, "f", (Analyzer)a);
        Query q = qp.parse("\"wizard of ozzy\"");
        QueryParserTestBase.assertEquals((long)1L, (long)s.search((Query)q, (int)1).totalHits);
        s.close();
        r.close();
        dir.close();
    }

    public void testProtectedCtors() throws Exception {
        try {
            QueryParser.class.getConstructor(CharStream.class);
            QueryParserTestBase.fail((String)"please switch public QueryParser(CharStream) to be protected");
        }
        catch (NoSuchMethodException nsme) {
            // empty catch block
        }
        try {
            QueryParser.class.getConstructor(QueryParserTokenManager.class);
            QueryParserTestBase.fail((String)"please switch public QueryParser(QueryParserTokenManager) to be protected");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public static class QPTestParser
    extends QueryParser {
        public QPTestParser(String f, Analyzer a) {
            super(LuceneTestCase.TEST_VERSION_CURRENT, f, a);
        }

        protected Query getFuzzyQuery(String field, String termStr, float minSimilarity) throws ParseException {
            throw new ParseException("Fuzzy queries not allowed");
        }

        protected Query getWildcardQuery(String field, String termStr) throws ParseException {
            throw new ParseException("Wildcard queries not allowed");
        }
    }

    public static final class QPTestAnalyzer
    extends Analyzer {
        public final TokenStream tokenStream(String fieldName, Reader reader) {
            return new QPTestFilter((TokenStream)new LowerCaseTokenizer(LuceneTestCase.TEST_VERSION_CURRENT, reader));
        }
    }

    public static final class QPTestFilter
    extends TokenFilter {
        CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
        boolean inPhrase = false;
        int savedStart = 0;
        int savedEnd = 0;

        public QPTestFilter(TokenStream in) {
            super(in);
        }

        public boolean incrementToken() throws IOException {
            if (this.inPhrase) {
                this.inPhrase = false;
                this.clearAttributes();
                this.termAtt.append("phrase2");
                this.offsetAtt.setOffset(this.savedStart, this.savedEnd);
                return true;
            }
            while (this.input.incrementToken()) {
                if (this.termAtt.toString().equals("phrase")) {
                    this.inPhrase = true;
                    this.savedStart = this.offsetAtt.startOffset();
                    this.savedEnd = this.offsetAtt.endOffset();
                    this.termAtt.setEmpty().append("phrase1");
                    this.offsetAtt.setOffset(this.savedStart, this.savedEnd);
                    return true;
                }
                if (this.termAtt.toString().equals("stop")) continue;
                return true;
            }
            return false;
        }
    }
}

