/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * Copyright (c) 2013, Red Hat Inc. or third-party contributors as
 * indicated by the @author tags or express copyright attribution
 * statements applied by the authors.  All third-party contributions are
 * distributed under license by Red Hat Inc.
 *
 * This copyrighted material is made available to anyone wishing to use, modify,
 * copy, or redistribute it subject to the terms and conditions of the GNU
 * Lesser General Public License, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this distribution; if not, write to:
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301  USA
 */
package org.hibernate.persister.collection;

/**
 * The names of all the collection properties.
 *
 * @author josh
 */
public final class CollectionPropertyNames {
	private CollectionPropertyNames() {
	}

	public static final String COLLECTION_SIZE = "size";
	public static final String COLLECTION_ELEMENTS = "elements";
	public static final String COLLECTION_INDICES = "indices";
	public static final String COLLECTION_MAX_INDEX = "maxIndex";
	public static final String COLLECTION_MIN_INDEX = "minIndex";
	public static final String COLLECTION_MAX_ELEMENT = "maxElement";
	public static final String COLLECTION_MIN_ELEMENT = "minElement";
	public static final String COLLECTION_INDEX = "index";
}
