/*
 * Decompiled with CFR 0.152.
 */
package org.smslib;

import java.io.IOException;
import java.util.Collection;
import org.smslib.GatewayException;
import org.smslib.InboundMessage;
import org.smslib.OutboundMessage;
import org.smslib.Phonebook;
import org.smslib.Service;
import org.smslib.StatusReportMessage;
import org.smslib.TimeoutException;
import org.smslib.USSDRequest;
import org.smslib.helper.Logger;
import org.smslib.notify.GatewayStatusNotification;
import org.smslib.notify.OutboundMessageNotification;
import org.smslib.threading.AServiceThread;

public abstract class AGateway {
    private String gatewayId;
    private int attributes;
    private boolean inbound;
    private boolean outbound;
    private Protocols protocol;
    private Statistics statistics;
    private String from;
    private int deliveryErrorCode;
    protected GatewayStatuses status;
    protected int restartCount;
    private QueueManager queueManager;

    public AGateway(String id) {
        this.gatewayId = id;
        this.inbound = false;
        this.outbound = false;
        this.attributes = 0;
        this.protocol = Protocols.PDU;
        this.from = "";
        this.statistics = new Statistics();
        this.from = "";
        this.deliveryErrorCode = -1;
        this.status = GatewayStatuses.STOPPED;
        this.restartCount = 0;
    }

    public void setAttributes(int myAttributes) {
        this.attributes = myAttributes;
    }

    public int getAttributes() {
        return this.attributes;
    }

    public AGateway getMyself() {
        return this;
    }

    public boolean isInbound() {
        return this.inbound;
    }

    public void setInbound(boolean value) {
        if ((this.attributes & 2) != 0) {
            this.inbound = value;
        }
    }

    public boolean isOutbound() {
        return this.outbound;
    }

    public void setOutbound(boolean value) {
        if ((this.attributes & 1) != 0) {
            this.outbound = value;
        }
    }

    public void setProtocol(Protocols myProtocoll) {
        this.protocol = myProtocoll;
    }

    public Protocols getProtocol() {
        return this.protocol;
    }

    public String getGatewayId() {
        return this.gatewayId;
    }

    public GatewayStatuses getStatus() {
        return this.status;
    }

    public void setStatus(GatewayStatuses myStatus) {
        Service.getInstance().getNotifyQueueManager().getNotifyQueue().add(new GatewayStatusNotification(this.getMyself(), this.getStatus(), myStatus));
        this.status = myStatus;
    }

    public int getInboundMessageCount() {
        return this.statistics.inbound;
    }

    public void incInboundMessageCount() {
        ++this.statistics.inbound;
    }

    public int getOutboundMessageCount() {
        return this.statistics.outbound;
    }

    public void incOutboundMessageCount() {
        ++this.statistics.outbound;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String myFrom) {
        this.from = myFrom;
    }

    public void startGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.setStatus(GatewayStatuses.STARTING);
        this.queueManager = new QueueManager("QueueManager [" + this.gatewayId + "]", this.getQueueSchedulingInterval());
        ++this.restartCount;
        this.setStatus(GatewayStatuses.STARTED);
    }

    public void stopGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.setStatus(GatewayStatuses.STOPPING);
        if (this.queueManager != null) {
            this.queueManager.cancel();
            this.queueManager = null;
        }
        this.setStatus(GatewayStatuses.STOPPED);
    }

    public void readMessages(Collection<InboundMessage> msgList, InboundMessage.MessageClasses msgClass) throws TimeoutException, GatewayException, IOException, InterruptedException {
        throw new GatewayException("Feature not supported.");
    }

    public InboundMessage readMessage(String memLoc, int memIndex) throws TimeoutException, GatewayException, IOException, InterruptedException {
        throw new GatewayException("Feature not supported.");
    }

    public boolean sendMessage(OutboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        throw new GatewayException("Feature not supported.");
    }

    public int sendMessages(Collection<OutboundMessage> msgList) throws TimeoutException, GatewayException, IOException, InterruptedException {
        int cnt = 0;
        for (OutboundMessage msg : msgList) {
            if (!this.sendMessage(msg)) continue;
            ++cnt;
        }
        return cnt;
    }

    public boolean deleteMessage(InboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        throw new GatewayException("Feature not supported.");
    }

    public float queryBalance() throws TimeoutException, GatewayException, IOException, InterruptedException {
        throw new GatewayException("Feature not supported.");
    }

    public boolean queryCoverage(OutboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        throw new GatewayException("Feature not supported.");
    }

    public StatusReportMessage.DeliveryStatuses queryMessage(OutboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        return this.queryMessage(msg.getRefNo());
    }

    public StatusReportMessage.DeliveryStatuses queryMessage(String refNo) throws TimeoutException, GatewayException, IOException, InterruptedException {
        throw new GatewayException("Feature not supported.");
    }

    public int readPhonebook(Phonebook phonebook) throws TimeoutException, GatewayException, IOException, InterruptedException {
        throw new GatewayException("Feature not supported.");
    }

    public int getDeliveryErrorCode() {
        return this.deliveryErrorCode;
    }

    public void setDeliveryErrorCode(int error) {
        this.deliveryErrorCode = error;
    }

    boolean isCapableOf(int att) {
        return (att & this.attributes) == att;
    }

    boolean conformsTo(int attrib, boolean required) {
        return !required || this.isCapableOf(attrib);
    }

    public int getRestartCount() {
        return this.restartCount;
    }

    public abstract int getQueueSchedulingInterval();

    public String sendUSSDCommand(String ussdCommand) throws GatewayException, TimeoutException, IOException, InterruptedException {
        throw new GatewayException("Feature not supported");
    }

    public String sendUSSDCommand(String ussdCommand, boolean interactive) throws GatewayException, TimeoutException, IOException, InterruptedException {
        throw new GatewayException("Feature not supported");
    }

    public boolean sendUSSDRequest(USSDRequest request) throws GatewayException, TimeoutException, IOException, InterruptedException {
        throw new GatewayException("Feature not supported");
    }

    private class QueueManager
    extends AServiceThread {
        public QueueManager(String name, int delay) {
            super(name, delay, 0, true);
        }

        @Override
        public void process() throws Exception {
            block11: {
                OutboundMessage msg = null;
                try {
                    if (AGateway.this.getStatus() != GatewayStatuses.STARTED || (msg = Service.getInstance().getQueueManager().pollPendingMessage(AGateway.this.getGatewayId())) == null) break block11;
                    if (Service.getInstance().getQueueSendingNotification() != null) {
                        Service.getInstance().getQueueSendingNotification().process(AGateway.this.getMyself(), msg);
                    }
                    try {
                        if (!AGateway.this.sendMessage(msg)) {
                            if (msg.getRetryCount() < Service.getInstance().getSettings().QUEUE_RETRIES) {
                                Logger.getInstance().logInfo("Reinserting message to queue.", null, AGateway.this.getGatewayId());
                                msg.incrementRetryCount();
                                Service.getInstance().getQueueManager().queueMessage(msg);
                            } else {
                                Logger.getInstance().logWarn("Maximum number of queue retries exceeded, message lost.", null, AGateway.this.getGatewayId());
                                msg.setFailureCause(OutboundMessage.FailureCauses.UNKNOWN);
                                Service.getInstance().getNotifyQueueManager().getNotifyQueue().add(new OutboundMessageNotification(AGateway.this.getMyself(), msg));
                            }
                        } else {
                            Service.getInstance().getNotifyQueueManager().getNotifyQueue().add(new OutboundMessageNotification(AGateway.this.getMyself(), msg));
                        }
                    }
                    catch (TimeoutException e) {
                        Service.getInstance().getQueueManager().queueMessage(msg);
                        throw e;
                    }
                }
                catch (InterruptedException e) {
                    if (msg != null && msg.getMessageStatus() != OutboundMessage.MessageStatuses.SENT) {
                        Service.getInstance().getQueueManager().queueMessage(msg);
                    }
                    Logger.getInstance().logInfo("QueueManager interrupted.", e, AGateway.this.getGatewayId());
                }
                catch (Exception e) {
                    Logger.getInstance().logWarn("Queue exception, marking gateway for reset.", e, AGateway.this.getGatewayId());
                    AGateway.this.setStatus(GatewayStatuses.RESTART);
                    Service.getInstance().getNotifyQueueManager().getNotifyQueue().add(new OutboundMessageNotification(AGateway.this.getMyself(), msg));
                }
            }
        }
    }

    static class Statistics {
        public int inbound = 0;
        public int outbound = 0;
    }

    public static class GatewayAttributes {
        public static final int SEND = 1;
        public static final int RECEIVE = 2;
        public static final int CUSTOMFROM = 4;
        public static final int BIGMESSAGES = 8;
        public static final int WAPSI = 16;
        public static final int PORTADDRESSING = 32;
        public static final int FLASHSMS = 64;
        public static final int DELIVERYREPORTS = 128;
    }

    public static enum AsyncEvents {
        DELETE,
        NOTHING,
        INBOUNDMESSAGE,
        INBOUNDSTATUSREPORTMESSAGE,
        INBOUNDCALL,
        USSDRESPONSE;

    }

    public static enum GatewayStatuses {
        STOPPED,
        STOPPING,
        STARTING,
        STARTED,
        FAILURE,
        RESTART;

    }

    public static enum Protocols {
        PDU,
        TEXT;

    }
}

