/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl;

import java.util.Date;
import java.util.List;
import java.util.Set;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricProcessInstanceQuery;
import org.activiti.engine.impl.AbstractVariableQueryImpl;
import org.activiti.engine.impl.HistoricProcessInstanceQueryProperty;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.CommandExecutor;

public class HistoricProcessInstanceQueryImpl
extends AbstractVariableQueryImpl<HistoricProcessInstanceQuery, HistoricProcessInstance>
implements HistoricProcessInstanceQuery {
    private static final long serialVersionUID = 1L;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected String businessKey;
    protected boolean finished = false;
    protected boolean unfinished = false;
    protected String startedBy;
    protected String superProcessInstanceId;
    protected boolean excludeSubprocesses;
    protected List<String> processKeyNotIn;
    protected Date startedBefore;
    protected Date startedAfter;
    protected Date finishedBefore;
    protected Date finishedAfter;
    protected String processDefinitionKey;
    protected Set<String> processInstanceIds;
    protected String involvedUser;
    protected boolean includeProcessVariables;
    protected String tenantId;
    protected String tenantIdLike;
    protected boolean withoutTenantId;
    protected String name;
    protected String nameLike;

    public HistoricProcessInstanceQueryImpl() {
    }

    public HistoricProcessInstanceQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public HistoricProcessInstanceQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public HistoricProcessInstanceQueryImpl processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processInstanceIds(Set<String> processInstanceIds) {
        if (processInstanceIds == null) {
            throw new ActivitiIllegalArgumentException("Set of process instance ids is null");
        }
        if (processInstanceIds.isEmpty()) {
            throw new ActivitiIllegalArgumentException("Set of process instance ids is empty");
        }
        this.processInstanceIds = processInstanceIds;
        return this;
    }

    @Override
    public HistoricProcessInstanceQueryImpl processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processInstanceBusinessKey(String businessKey) {
        this.businessKey = businessKey;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery finished() {
        this.finished = true;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery unfinished() {
        this.unfinished = true;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery startedBy(String userId) {
        this.startedBy = userId;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processDefinitionKeyNotIn(List<String> processDefinitionKeys) {
        this.processKeyNotIn = processDefinitionKeys;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery startedAfter(Date date) {
        this.startedAfter = date;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery startedBefore(Date date) {
        this.startedBefore = date;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery finishedAfter(Date date) {
        this.finishedAfter = date;
        this.finished = true;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery finishedBefore(Date date) {
        this.finishedBefore = date;
        this.finished = true;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery superProcessInstanceId(String superProcessInstanceId) {
        this.superProcessInstanceId = superProcessInstanceId;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery excludeSubprocesses(boolean excludeSubprocesses) {
        this.excludeSubprocesses = excludeSubprocesses;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery involvedUser(String userId) {
        this.involvedUser = userId;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery includeProcessVariables() {
        this.includeProcessVariables = true;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processInstanceTenantId(String tenantId) {
        if (tenantId == null) {
            throw new ActivitiIllegalArgumentException("process instance tenant id is null");
        }
        this.tenantId = tenantId;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processInstanceTenantIdLike(String tenantIdLike) {
        if (tenantIdLike == null) {
            throw new ActivitiIllegalArgumentException("process instance tenant id is null");
        }
        this.tenantIdLike = tenantIdLike;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processInstanceWithoutTenantId() {
        this.withoutTenantId = true;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processInstanceName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processInstanceNameLike(String nameLike) {
        this.nameLike = nameLike;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery orderByProcessInstanceBusinessKey() {
        return (HistoricProcessInstanceQuery)this.orderBy(HistoricProcessInstanceQueryProperty.BUSINESS_KEY);
    }

    @Override
    public HistoricProcessInstanceQuery orderByProcessInstanceDuration() {
        return (HistoricProcessInstanceQuery)this.orderBy(HistoricProcessInstanceQueryProperty.DURATION);
    }

    @Override
    public HistoricProcessInstanceQuery orderByProcessInstanceStartTime() {
        return (HistoricProcessInstanceQuery)this.orderBy(HistoricProcessInstanceQueryProperty.START_TIME);
    }

    @Override
    public HistoricProcessInstanceQuery orderByProcessInstanceEndTime() {
        return (HistoricProcessInstanceQuery)this.orderBy(HistoricProcessInstanceQueryProperty.END_TIME);
    }

    @Override
    public HistoricProcessInstanceQuery orderByProcessDefinitionId() {
        return (HistoricProcessInstanceQuery)this.orderBy(HistoricProcessInstanceQueryProperty.PROCESS_DEFINITION_ID);
    }

    @Override
    public HistoricProcessInstanceQuery orderByProcessInstanceId() {
        return (HistoricProcessInstanceQuery)this.orderBy(HistoricProcessInstanceQueryProperty.PROCESS_INSTANCE_ID_);
    }

    @Override
    public HistoricProcessInstanceQuery orderByTenantId() {
        return (HistoricProcessInstanceQuery)this.orderBy(HistoricProcessInstanceQueryProperty.TENANT_ID);
    }

    public String getMssqlOrDB2OrderBy() {
        String specialOrderBy = super.getOrderBy();
        if (specialOrderBy != null && specialOrderBy.length() > 0) {
            specialOrderBy = specialOrderBy.replace("RES.", "TEMPRES_");
            specialOrderBy = specialOrderBy.replace("VAR.", "TEMPVAR_");
        }
        return specialOrderBy;
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        this.ensureVariablesInitialized();
        return commandContext.getHistoricProcessInstanceEntityManager().findHistoricProcessInstanceCountByQueryCriteria(this);
    }

    @Override
    public List<HistoricProcessInstance> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        this.ensureVariablesInitialized();
        if (this.includeProcessVariables) {
            return commandContext.getHistoricProcessInstanceEntityManager().findHistoricProcessInstancesAndVariablesByQueryCriteria(this);
        }
        return commandContext.getHistoricProcessInstanceEntityManager().findHistoricProcessInstancesByQueryCriteria(this);
    }

    @Override
    protected void checkQueryOk() {
        super.checkQueryOk();
        if (this.includeProcessVariables) {
            ((HistoricProcessInstanceQuery)this.orderBy(HistoricProcessInstanceQueryProperty.INCLUDED_VARIABLE_TIME)).asc();
        }
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public boolean isOpen() {
        return this.unfinished;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public String getProcessDefinitionIdLike() {
        return this.processDefinitionKey + ":%:%";
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public Set<String> getProcessInstanceIds() {
        return this.processInstanceIds;
    }

    public String getStartedBy() {
        return this.startedBy;
    }

    public String getSuperProcessInstanceId() {
        return this.superProcessInstanceId;
    }

    public boolean isExcludeSubprocesses() {
        return this.excludeSubprocesses;
    }

    public List<String> getProcessKeyNotIn() {
        return this.processKeyNotIn;
    }

    public Date getStartedAfter() {
        return this.startedAfter;
    }

    public Date getStartedBefore() {
        return this.startedBefore;
    }

    public Date getFinishedAfter() {
        return this.finishedAfter;
    }

    public Date getFinishedBefore() {
        return this.finishedBefore;
    }

    public String getInvolvedUser() {
        return this.involvedUser;
    }

    public String getName() {
        return this.name;
    }

    public String getNameLike() {
        return this.nameLike;
    }
}

