/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query;

import java.lang.reflect.Method;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.core.EntityMetadata;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.DefaultParameters;
import org.springframework.data.repository.query.Parameters;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class QueryMethod {
    private final RepositoryMetadata metadata;
    private final Method method;
    private final Parameters<?, ?> parameters;
    private Class<?> domainClass;

    public QueryMethod(Method method, RepositoryMetadata metadata) {
        Assert.notNull((Object)method, (String)"Method must not be null!");
        Assert.notNull((Object)metadata, (String)"Repository metadata must not be null!");
        for (Class<?> type : Parameters.TYPES) {
            if (org.springframework.data.repository.util.ClassUtils.getNumberOfOccurences(method, type) <= 1) continue;
            throw new IllegalStateException(String.format("Method must only one argument of type %s! Offending method: %s", type.getSimpleName(), method.toString()));
        }
        if (org.springframework.data.repository.util.ClassUtils.hasParameterOfType(method, Pageable.class)) {
            org.springframework.data.repository.util.ClassUtils.assertReturnTypeAssignable(method, Slice.class, Page.class, List.class);
            if (org.springframework.data.repository.util.ClassUtils.hasParameterOfType(method, Sort.class)) {
                throw new IllegalStateException(String.format("Method must not have Pageable *and* Sort parameter. Use sorting capabilities on Pageble instead! Offending method: %s", method.toString()));
            }
        }
        this.method = method;
        this.parameters = this.createParameters(method);
        this.metadata = metadata;
        Assert.notNull(this.parameters);
        if (this.isPageQuery()) {
            Assert.isTrue((boolean)this.parameters.hasPageableParameter(), (String)String.format("Paging query needs to have a Pageable parameter! Offending method %s", method.toString()));
        }
    }

    protected Parameters<?, ?> createParameters(Method method) {
        return new DefaultParameters(method);
    }

    public String getName() {
        return this.method.getName();
    }

    public EntityMetadata<?> getEntityInformation() {
        return new EntityMetadata(){

            public Class<?> getJavaType() {
                return QueryMethod.this.getDomainClass();
            }
        };
    }

    public String getNamedQueryName() {
        Class<?> domainClass = this.getDomainClass();
        return String.format("%s.%s", domainClass.getSimpleName(), this.method.getName());
    }

    protected Class<?> getDomainClass() {
        if (this.domainClass == null) {
            Class<?> repositoryDomainClass = this.metadata.getDomainType();
            Class<?> methodDomainClass = this.metadata.getReturnedDomainClass(this.method);
            this.domainClass = repositoryDomainClass == null || repositoryDomainClass.isAssignableFrom(methodDomainClass) ? methodDomainClass : repositoryDomainClass;
        }
        return this.domainClass;
    }

    public Class<?> getReturnedObjectType() {
        return this.metadata.getReturnedDomainClass(this.method);
    }

    public boolean isCollectionQuery() {
        Class<?> returnType = this.method.getReturnType();
        return !this.isPageQuery() && !this.isSliceQuery() && ClassUtils.isAssignable(Iterable.class, returnType) || returnType.isArray();
    }

    public boolean isSliceQuery() {
        Class<?> returnType = this.method.getReturnType();
        return !this.isPageQuery() && ClassUtils.isAssignable(Slice.class, returnType);
    }

    public boolean isPageQuery() {
        Class<?> returnType = this.method.getReturnType();
        return ClassUtils.isAssignable(Page.class, returnType);
    }

    public boolean isModifyingQuery() {
        return false;
    }

    public boolean isQueryForEntity() {
        return this.getDomainClass().isAssignableFrom(this.getReturnedObjectType());
    }

    public Parameters<?, ?> getParameters() {
        return this.parameters;
    }

    public String toString() {
        return this.method.toString();
    }
}

