/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.configuration.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import net.sf.oval.AbstractCheck;
import net.sf.oval.configuration.annotation.AnnotationCheck;
import net.sf.oval.internal.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnnotationCheck<ConstraintAnnotation extends Annotation>
extends AbstractCheck
implements AnnotationCheck<ConstraintAnnotation> {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = Log.getLog(AbstractAnnotationCheck.class);

    @Override
    public void configure(ConstraintAnnotation constraintAnnotation) {
        Class<?> constraintClazz = constraintAnnotation.getClass();
        try {
            Method getMessage = constraintClazz.getDeclaredMethod("message", null);
            this.message = (String)getMessage.invoke(constraintAnnotation, null);
        }
        catch (Exception e) {
            LOG.debug("Cannot determine constraint error message based on annotation {1}", (Object)constraintClazz.getName(), e);
            this.message = String.valueOf(constraintClazz.getName()) + ".violated";
        }
        try {
            Method getErrorCode = constraintClazz.getDeclaredMethod("errorCode", null);
            this.errorCode = (String)getErrorCode.invoke(constraintAnnotation, null);
        }
        catch (Exception e) {
            LOG.debug("Cannot determine constraint error code based on annotation {1}", (Object)constraintClazz.getName(), e);
            this.errorCode = constraintClazz.getName();
        }
        try {
            Method getSeverity = constraintClazz.getDeclaredMethod("severity", null);
            this.severity = ((Number)getSeverity.invoke(constraintAnnotation, null)).intValue();
        }
        catch (Exception e) {
            LOG.debug("Cannot determine constraint severity based on annotation {1}", (Object)constraintClazz.getName(), e);
        }
        try {
            Method getProfiles = constraintClazz.getDeclaredMethod("profiles", null);
            this.profiles = (String[])getProfiles.invoke(constraintAnnotation, null);
        }
        catch (Exception e) {
            LOG.debug("Cannot determine constraint profiles based on annotation {1}", (Object)constraintClazz.getName(), e);
        }
    }
}

