/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal.schemagen;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import javax.persistence.PersistenceException;
import org.hibernate.jpa.internal.schemagen.ScriptSourceInput;
import org.hibernate.jpa.internal.schemagen.ScriptSourceInputFromFile;
import org.hibernate.jpa.internal.schemagen.ScriptSourceInputFromReader;
import org.jboss.logging.Logger;

public class ScriptSourceInputFromUrl
extends ScriptSourceInputFromReader
implements ScriptSourceInput {
    private static final Logger log = Logger.getLogger(ScriptSourceInputFromFile.class);

    public ScriptSourceInputFromUrl(URL url) {
        super(ScriptSourceInputFromUrl.toReader(url));
    }

    @Override
    public void release() {
        try {
            this.reader().close();
        }
        catch (IOException e) {
            log.warn((Object)"Unable to close file reader for generation script source");
        }
    }

    private static Reader toReader(URL url) {
        try {
            return new InputStreamReader(url.openStream());
        }
        catch (IOException e) {
            throw new PersistenceException("Unable to open specified script source url [" + url + "] for reading");
        }
    }
}

