/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.modem;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import org.smslib.GatewayException;
import org.smslib.Service;
import org.smslib.helper.CommPortIdentifier;
import org.smslib.helper.Logger;
import org.smslib.helper.SerialPort;
import org.smslib.helper.SerialPortEvent;
import org.smslib.helper.SerialPortEventListener;
import org.smslib.modem.AModemDriver;
import org.smslib.modem.ModemGateway;
import org.smslib.threading.AServiceThread;

class SerialModemDriver
extends AModemDriver
implements SerialPortEventListener {
    private String comPort;
    private int baudRate;
    private CommPortIdentifier portId;
    private SerialPort serialPort;
    private InputStream in;
    private OutputStream out;
    private PortReader portReader;

    protected SerialModemDriver(ModemGateway myGateway, String deviceParms) {
        super(myGateway, deviceParms);
        StringTokenizer tokens = new StringTokenizer(deviceParms, ":");
        this.setComPort(tokens.nextToken());
        this.setBaudRate(Integer.parseInt(tokens.nextToken()));
        this.setSerialPort(null);
    }

    @Override
    protected void connectPort() throws GatewayException, IOException, InterruptedException {
        if (Service.getInstance().getSettings().SERIAL_NOFLUSH) {
            Logger.getInstance().logInfo("Comm port flushing is disabled.", null, this.getGateway().getGatewayId());
        }
        if (Service.getInstance().getSettings().SERIAL_POLLING) {
            Logger.getInstance().logInfo("Using polled serial port mode.", null, this.getGateway().getGatewayId());
        }
        try {
            Logger.getInstance().logInfo("Opening: " + this.getComPort() + " @" + this.getBaudRate(), null, this.getGateway().getGatewayId());
            CommPortIdentifier.getPortIdentifiers();
            this.setPortId(CommPortIdentifier.getPortIdentifier(this.getComPort()));
            this.setSerialPort(this.getPortId().open("org.smslib", 1971));
            this.setIn(this.getSerialPort().getInputStream());
            this.setOut(this.getSerialPort().getOutputStream());
            if (!Service.getInstance().getSettings().SERIAL_POLLING) {
                this.getSerialPort().notifyOnDataAvailable(true);
                this.getSerialPort().notifyOnOutputEmpty(true);
            }
            if (!Service.getInstance().getSettings().SERIAL_NOEVENTS) {
                this.getSerialPort().notifyOnBreakInterrupt(true);
                this.getSerialPort().notifyOnFramingError(true);
                this.getSerialPort().notifyOnOverrunError(true);
                this.getSerialPort().notifyOnParityError(true);
            } else {
                Logger.getInstance().logInfo("Skipping registration of serial port events!", null, null);
            }
            if (Service.getInstance().getSettings().SERIAL_RTSCTS_OUT) {
                this.getSerialPort().setFlowControlMode(SerialPort.FLOWCONTROL_RTSCTS_IN | SerialPort.FLOWCONTROL_RTSCTS_OUT);
            } else {
                this.getSerialPort().setFlowControlMode(SerialPort.FLOWCONTROL_RTSCTS_IN);
            }
            this.getSerialPort().addEventListener(this);
            this.getSerialPort().setSerialPortParams(this.getBaudRate(), SerialPort.DATABITS_8, SerialPort.STOPBITS_1, SerialPort.PARITY_NONE);
            this.getSerialPort().setInputBufferSize(Service.getInstance().getSettings().SERIAL_BUFFER_SIZE);
            this.getSerialPort().setOutputBufferSize(Service.getInstance().getSettings().SERIAL_BUFFER_SIZE);
            this.getSerialPort().enableReceiveThreshold(1);
            this.getSerialPort().enableReceiveTimeout(Service.getInstance().getSettings().SERIAL_TIMEOUT);
            if (Service.getInstance().getSettings().SERIAL_POLLING) {
                this.setPortReader(new PortReader("PortReader() [" + this.getComPort() + "]", Service.getInstance().getSettings().SERIAL_POLLING_INTERVAL));
            }
        }
        catch (Exception e) {
            throw new GatewayException("Comm library exception: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void disconnectPort() throws IOException, InterruptedException {
        Object object = this.getSYNCReader();
        synchronized (object) {
            if (Service.getInstance().getSettings().SERIAL_POLLING && this.getPortReader() != null) {
                this.getPortReader().cancel();
                this.setPortReader(null);
            }
            if (this.getSerialPort() != null) {
                this.getSerialPort().close();
            }
            Logger.getInstance().logInfo("Closing: " + this.getComPort() + " @" + this.getBaudRate(), null, this.getGateway().getGatewayId());
        }
    }

    @Override
    protected void clear() throws IOException {
        while (this.portHasData()) {
            this.read();
        }
    }

    @Override
    protected boolean portHasData() throws IOException {
        return this.getIn().available() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialEvent(SerialPortEvent event) {
        int eventType = event.getEventType();
        if (eventType == SerialPortEvent.OE) {
            Logger.getInstance().logError("Overrun Error!", null, this.getGateway().getGatewayId());
        } else if (eventType == SerialPortEvent.FE) {
            Logger.getInstance().logError("Framing Error!", null, this.getGateway().getGatewayId());
        } else if (eventType == SerialPortEvent.PE) {
            Logger.getInstance().logError("Parity Error!", null, this.getGateway().getGatewayId());
        } else if (eventType == SerialPortEvent.DATA_AVAILABLE && !Service.getInstance().getSettings().SERIAL_POLLING) {
            Object object = this.getSYNCReader();
            synchronized (object) {
                this.setDataReceived(true);
                this.getSYNCReader().notifyAll();
            }
        }
    }

    @Override
    public void write(char c) throws IOException {
        this.getOut().write(c);
        if (!Service.getInstance().getSettings().SERIAL_NOFLUSH) {
            this.getOut().flush();
        }
    }

    @Override
    public void write(byte[] s) throws IOException {
        if (Service.getInstance().getSettings().SERIAL_BUFFER_CHUNK == 0) {
            this.getOut().write(s);
        } else {
            int offset = 0;
            int left = s.length;
            while (left > 0) {
                int i = left > Service.getInstance().getSettings().SERIAL_BUFFER_CHUNK ? Service.getInstance().getSettings().SERIAL_BUFFER_CHUNK : left;
                this.getOut().write(s, offset, i);
                offset += i;
                left -= i;
                try {
                    Thread.sleep(Service.getInstance().getSettings().SERIAL_BUFFER_CHUNK_DELAY);
                }
                catch (InterruptedException e) {}
            }
        }
        if (!Service.getInstance().getSettings().SERIAL_NOFLUSH) {
            this.getOut().flush();
        }
    }

    @Override
    protected int read() throws IOException {
        return this.getIn().read();
    }

    PortReader getPortReader() {
        return this.portReader;
    }

    void setPortReader(PortReader myPortReader) {
        this.portReader = myPortReader;
    }

    String getComPort() {
        return this.comPort;
    }

    void setComPort(String myComPort) {
        this.comPort = myComPort;
    }

    int getBaudRate() {
        return this.baudRate;
    }

    void setBaudRate(int myBaudRate) {
        this.baudRate = myBaudRate;
    }

    CommPortIdentifier getPortId() {
        return this.portId;
    }

    void setPortId(CommPortIdentifier myPortId) {
        this.portId = myPortId;
    }

    SerialPort getSerialPort() {
        return this.serialPort;
    }

    void setSerialPort(SerialPort mySerialPort) {
        this.serialPort = mySerialPort;
    }

    InputStream getIn() {
        return this.in;
    }

    void setIn(InputStream myIn) {
        this.in = myIn;
    }

    OutputStream getOut() {
        return this.out;
    }

    void setOut(OutputStream myOut) {
        this.out = myOut;
    }

    private class PortReader
    extends AServiceThread {
        public PortReader(String name, int delay) {
            super(name, delay, 0, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process() throws Exception {
            if (SerialModemDriver.this.portHasData()) {
                Object object = SerialModemDriver.this.getSYNCReader();
                synchronized (object) {
                    SerialModemDriver.this.setDataReceived(true);
                    SerialModemDriver.this.getSYNCReader().notifyAll();
                }
            }
        }
    }
}

