/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.helper;

import java.io.File;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;

public class Logger {
    private static Logger logger = new Logger();
    org.apache.log4j.Logger log4jLogger;
    private static final String FQCN = Logger.class.getName();

    protected Logger() {
        if (System.getProperties().getProperty("java.vm.name").equalsIgnoreCase("ikvm.net")) {
            File f = new File("log4j.properties");
            if (!f.exists()) {
                this.log4jLogger = null;
            } else {
                this.log4jLogger = org.apache.log4j.Logger.getLogger((String)"smslib");
                PropertyConfigurator.configure((String)"log4j.properties");
            }
        } else {
            this.log4jLogger = org.apache.log4j.Logger.getLogger((String)"smslib");
        }
    }

    public static Logger getInstance() {
        if (logger == null) {
            logger = new Logger();
        }
        return logger;
    }

    public static void setInstance(Logger logger) {
        Logger.logger = logger;
    }

    public void logInfo(String message, Exception e, String gatewayId) {
        if (this.log4jLogger == null) {
            return;
        }
        this.log4jLogger.log(FQCN, (Priority)Level.INFO, (Object)this.formatMessage(message, gatewayId), (Throwable)e);
    }

    public void logWarn(String message, Exception e, String gatewayId) {
        if (this.log4jLogger == null) {
            return;
        }
        this.log4jLogger.log(FQCN, (Priority)Level.WARN, (Object)this.formatMessage(message, gatewayId), (Throwable)e);
    }

    public void logDebug(String message, Exception e, String gatewayId) {
        if (this.log4jLogger == null) {
            return;
        }
        this.log4jLogger.log(FQCN, (Priority)Level.DEBUG, (Object)this.formatMessage(message, gatewayId), (Throwable)e);
    }

    public void logError(String message, Exception e, String gatewayId) {
        if (this.log4jLogger == null) {
            return;
        }
        this.log4jLogger.log(FQCN, (Priority)Level.ERROR, (Object)this.formatMessage(message, gatewayId), (Throwable)e);
    }

    private String formatMessage(String message, String gatewayId) {
        return gatewayId == null ? message : "GTW: " + gatewayId + ": " + message;
    }
}

