/*
 * Decompiled with CFR 0.152.
 */
package org.smslib;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.ajwcc.pduUtils.gsm3040.SmsDeliveryPdu;
import org.smslib.InboundBinaryMessage;
import org.smslib.SMSLibException;
import org.smslib.crypto.AKey;
import org.smslib.crypto.KeyManager;

public class InboundEncryptedMessage
extends InboundBinaryMessage {
    private static final long serialVersionUID = 2L;

    public InboundEncryptedMessage(SmsDeliveryPdu pdu, int memIndex, String memLocation) {
        super(pdu, memIndex, memLocation);
    }

    public String getDecryptedText() throws SMSLibException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchPaddingException, NoSuchAlgorithmException {
        KeyManager km = KeyManager.getInstance();
        if (km.getKey(this.getOriginator()) == null) {
            throw new SMSLibException("Message is not encrypted, have you defined the key in KeyManager?");
        }
        this.setDataBytes(km.decrypt(this.getOriginator(), this.getDataBytes()));
        return AKey.asString(this.getDataBytes());
    }
}

