/*
 * Decompiled with CFR 0.152.
 */
package org.json.tests;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class TestJSONTokener
extends TestCase {
    JSONTokener jsontokener;
    JSONObject jsonobject = new JSONObject();

    public void testConstructor_InputStream() {
        String string = "{\"abc\":\"123\"}";
        byte[] buf = string.getBytes();
        ByteArrayInputStream is = new ByteArrayInputStream(buf);
        try {
            this.jsontokener = new JSONTokener(is);
            TestJSONTokener.assertEquals((char)'{', (char)this.jsontokener.next());
            TestJSONTokener.assertEquals((Object)"abc", (Object)this.jsontokener.nextValue());
            TestJSONTokener.assertEquals((char)':', (char)this.jsontokener.next());
            TestJSONTokener.assertEquals((Object)"123", (Object)this.jsontokener.nextValue());
            TestJSONTokener.assertEquals((char)'}', (char)this.jsontokener.next());
        }
        catch (JSONException e) {
            TestJSONTokener.fail((String)e.toString());
        }
    }

    public void testBack() {
        String string = "{\"abc\":\"123\"}";
        byte[] buf = string.getBytes();
        ByteArrayInputStream is = new ByteArrayInputStream(buf);
        try {
            this.jsontokener = new JSONTokener(is);
            TestJSONTokener.assertEquals((char)'{', (char)this.jsontokener.next());
            TestJSONTokener.assertEquals((Object)"abc", (Object)this.jsontokener.nextValue());
            TestJSONTokener.assertEquals((char)':', (char)this.jsontokener.next());
            this.jsontokener.back();
            TestJSONTokener.assertEquals((char)':', (char)this.jsontokener.next());
            TestJSONTokener.assertEquals((Object)"123", (Object)this.jsontokener.nextValue());
            TestJSONTokener.assertEquals((char)'}', (char)this.jsontokener.next());
        }
        catch (JSONException e) {
            TestJSONTokener.fail((String)e.toString());
        }
    }

    public void testBack_FailsIfUsedTwice() {
        String string = "{\"abc\":\"123\"}";
        byte[] buf = string.getBytes();
        ByteArrayInputStream is = new ByteArrayInputStream(buf);
        try {
            this.jsontokener = new JSONTokener(is);
            TestJSONTokener.assertEquals((char)'{', (char)this.jsontokener.next());
            TestJSONTokener.assertEquals((Object)"abc", (Object)this.jsontokener.nextValue());
            TestJSONTokener.assertEquals((char)':', (char)this.jsontokener.next());
            this.jsontokener.back();
            this.jsontokener.back();
        }
        catch (JSONException e) {
            TestJSONTokener.assertEquals((String)"Stepping back two steps is not supported", (String)e.getMessage());
        }
    }

    public void testNext_FakeInputStreamToTestIoexception() {
        try {
            this.jsontokener = new JSONTokener(new MockInputStreamThrowsExceptionOnFourthRead());
            TestJSONTokener.assertEquals((char)'a', (char)this.jsontokener.next());
            TestJSONTokener.assertEquals((char)'a', (char)this.jsontokener.next());
            TestJSONTokener.assertEquals((char)'a', (char)this.jsontokener.next());
            TestJSONTokener.assertEquals((char)'a', (char)this.jsontokener.next());
            TestJSONTokener.assertEquals((char)'a', (char)this.jsontokener.next());
            TestJSONTokener.fail((String)"Should have thrown exception");
        }
        catch (JSONException e) {
            TestJSONTokener.assertEquals((String)"Mock IOException thrown from read", (String)e.getMessage());
        }
    }

    public void testNext_EmptyStream() {
        String string = "";
        byte[] buf = string.getBytes();
        ByteArrayInputStream is = new ByteArrayInputStream(buf);
        try {
            this.jsontokener = new JSONTokener(is);
            TestJSONTokener.assertEquals((int)0, (int)this.jsontokener.next());
        }
        catch (JSONException e) {
            TestJSONTokener.fail((String)e.toString());
        }
    }

    public void testNext_LineIncrementsOnNewLine() {
        this.jsontokener = new JSONTokener("abc\n123");
        try {
            this.jsontokener.next();
            this.jsontokener.next();
            this.jsontokener.next();
            TestJSONTokener.assertEquals((String)" at 3 [character 4 line 1]", (String)this.jsontokener.toString());
            this.jsontokener.next();
            TestJSONTokener.assertEquals((String)" at 4 [character 0 line 2]", (String)this.jsontokener.toString());
        }
        catch (JSONException e) {
            TestJSONTokener.fail((String)e.toString());
        }
    }

    public void testNext_LineIncrementsOnCarriageReturn() {
        this.jsontokener = new JSONTokener("abc\r123");
        try {
            this.jsontokener.next();
            this.jsontokener.next();
            this.jsontokener.next();
            TestJSONTokener.assertEquals((String)" at 3 [character 4 line 1]", (String)this.jsontokener.toString());
            this.jsontokener.next();
            this.jsontokener.next();
            TestJSONTokener.assertEquals((String)" at 5 [character 1 line 2]", (String)this.jsontokener.toString());
        }
        catch (JSONException e) {
            TestJSONTokener.fail((String)e.toString());
        }
    }

    public void testNext_LineIncrementsOnCarriageReturnAndNewLine() {
        this.jsontokener = new JSONTokener("abc\r\n123");
        try {
            this.jsontokener.next();
            this.jsontokener.next();
            this.jsontokener.next();
            TestJSONTokener.assertEquals((String)" at 3 [character 4 line 1]", (String)this.jsontokener.toString());
            this.jsontokener.next();
            this.jsontokener.next();
            TestJSONTokener.assertEquals((String)" at 5 [character 0 line 2]", (String)this.jsontokener.toString());
        }
        catch (JSONException e) {
            TestJSONTokener.fail((String)e.toString());
        }
    }

    public void testSkipTo() {
        String string = "{\"abc\":\"123\",\"wer\":\"rty\"}";
        byte[] buf = string.getBytes();
        ByteArrayInputStream is = new ByteArrayInputStream(buf);
        try {
            this.jsontokener = new JSONTokener(is);
            TestJSONTokener.assertEquals((char)'{', (char)this.jsontokener.next());
            TestJSONTokener.assertEquals((Object)"abc", (Object)this.jsontokener.nextValue());
            TestJSONTokener.assertEquals((char)':', (char)this.jsontokener.next());
            TestJSONTokener.assertEquals((Object)"123", (Object)this.jsontokener.nextValue());
            TestJSONTokener.assertEquals((char)',', (char)this.jsontokener.next());
            TestJSONTokener.assertEquals((int)0, (int)this.jsontokener.skipTo('g'));
            TestJSONTokener.assertEquals((char)'\"', (char)this.jsontokener.next());
            TestJSONTokener.assertEquals((char)'t', (char)this.jsontokener.skipTo('t'));
            TestJSONTokener.assertEquals((char)'t', (char)this.jsontokener.next());
            TestJSONTokener.assertEquals((char)'y', (char)this.jsontokener.next());
        }
        catch (JSONException e) {
            TestJSONTokener.fail((String)e.toString());
        }
    }

    public void testSkipTo_FakeInputStreamToTestIoexception() {
        this.jsontokener = new JSONTokener(new MockInputStreamThrowsExceptionOnReset(new StringReader("123")));
        try {
            this.jsontokener.skipTo('l');
            TestJSONTokener.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestJSONTokener.assertEquals((String)"Mock IOException thrown from reset", (String)e.getMessage());
        }
    }

    public void testEnd() {
        this.jsontokener = new JSONTokener("a");
        try {
            TestJSONTokener.assertFalse((boolean)this.jsontokener.end());
            this.jsontokener.next();
            this.jsontokener.next();
            TestJSONTokener.assertTrue((boolean)this.jsontokener.end());
            this.jsontokener.back();
            TestJSONTokener.assertFalse((boolean)this.jsontokener.end());
            this.jsontokener.next();
            this.jsontokener.next();
            TestJSONTokener.assertTrue((boolean)this.jsontokener.end());
        }
        catch (JSONException e) {
            TestJSONTokener.fail((String)e.toString());
        }
    }

    public void testMore() {
        this.jsontokener = new JSONTokener("a");
        try {
            TestJSONTokener.assertTrue((boolean)this.jsontokener.more());
            this.jsontokener.next();
            TestJSONTokener.assertFalse((boolean)this.jsontokener.more());
            this.jsontokener.back();
            TestJSONTokener.assertTrue((boolean)this.jsontokener.more());
            this.jsontokener.next();
            TestJSONTokener.assertFalse((boolean)this.jsontokener.more());
        }
        catch (JSONException e) {
            TestJSONTokener.fail((String)e.toString());
        }
    }

    public void testNextValue_NiceString() {
        this.jsontokener = new JSONTokener("abc");
        try {
            TestJSONTokener.assertEquals((Object)"abc", (Object)this.jsontokener.nextValue());
        }
        catch (JSONException e) {
            TestJSONTokener.fail((String)e.toString());
        }
    }

    public void testNextValue_StringWithNewLine() {
        this.jsontokener = new JSONTokener("abc\n123");
        try {
            TestJSONTokener.assertEquals((Object)"abc", (Object)this.jsontokener.nextValue());
            TestJSONTokener.assertEquals((Object)123, (Object)this.jsontokener.nextValue());
        }
        catch (JSONException e) {
            TestJSONTokener.fail((String)e.toString());
        }
    }

    public void testNextValue_JsonObjectString() {
        JSONObject jo = new JSONObject();
        try {
            jo.put("abc", "123");
            this.jsontokener = new JSONTokener(jo.toString());
            TestJSONTokener.assertEquals((String)jo.toString(), (String)this.jsontokener.nextValue().toString());
        }
        catch (JSONException e) {
            TestJSONTokener.fail((String)e.toString());
        }
    }

    public void testNextValue_IndentedJsonObjectString() {
        JSONObject jo = new JSONObject();
        try {
            jo.put("abc", "123");
            this.jsontokener = new JSONTokener(jo.toString(4));
            TestJSONTokener.assertEquals((String)jo.toString(), (String)this.jsontokener.nextValue().toString());
        }
        catch (JSONException e) {
            TestJSONTokener.fail((String)e.toString());
        }
    }

    public void testNextValue_JsonArrayString() {
        JSONArray ja = new JSONArray();
        try {
            ja.put("abc");
            ja.put("123");
            this.jsontokener = new JSONTokener(ja.toString());
            TestJSONTokener.assertEquals((String)ja.toString(), (String)this.jsontokener.nextValue().toString());
        }
        catch (JSONException e) {
            TestJSONTokener.fail((String)e.toString());
        }
    }

    public void testNextValue_IndentedJsonArrayString() {
        JSONArray ja = new JSONArray();
        try {
            ja.put("abc");
            ja.put("123");
            this.jsontokener = new JSONTokener(ja.toString(4));
            TestJSONTokener.assertEquals((String)ja.toString(), (String)this.jsontokener.nextValue().toString());
        }
        catch (JSONException e) {
            TestJSONTokener.fail((String)e.toString());
        }
    }

    public void testNextValue_EmptyString() {
        this.jsontokener = new JSONTokener("");
        try {
            this.jsontokener.nextValue();
            TestJSONTokener.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestJSONTokener.assertEquals((String)"Missing value at 0 [character 1 line 1]", (String)e.getMessage());
        }
    }

    public void testNext_ExpectedChar() {
        this.jsontokener = new JSONTokener("abc");
        char expectedA = '\u0000';
        try {
            expectedA = this.jsontokener.next('a');
            this.jsontokener.next('c');
            TestJSONTokener.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestJSONTokener.assertEquals((char)'a', (char)expectedA);
            TestJSONTokener.assertEquals((String)"Expected 'c' and instead saw 'b' at 2 [character 3 line 1]", (String)e.getMessage());
        }
    }

    public void testNext_ExpectedNumberOfCharacters() {
        this.jsontokener = new JSONTokener("abc123");
        String expectedAbc = "";
        String expectedBlank = "";
        try {
            expectedAbc = this.jsontokener.next(3);
            expectedBlank = this.jsontokener.next(0);
            this.jsontokener.next(7);
            TestJSONTokener.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestJSONTokener.assertEquals((String)"abc", (String)expectedAbc);
            TestJSONTokener.assertEquals((String)"", (String)expectedBlank);
            TestJSONTokener.assertEquals((String)"Substring bounds error at 7 [character 8 line 1]", (String)e.getMessage());
        }
    }

    public void testNextTo_Character() {
        this.jsontokener = new JSONTokener("abc123,test\ntestString1\rsecondString\r\nthird String");
        try {
            TestJSONTokener.assertEquals((String)"abc123", (String)this.jsontokener.nextTo(','));
            this.jsontokener.next(',');
            TestJSONTokener.assertEquals((String)"test", (String)this.jsontokener.nextTo(','));
            this.jsontokener.next('\n');
            TestJSONTokener.assertEquals((String)"testString1", (String)this.jsontokener.nextTo(','));
            this.jsontokener.next('\r');
            TestJSONTokener.assertEquals((String)"secondString", (String)this.jsontokener.nextTo(','));
            this.jsontokener.next('\r');
            this.jsontokener.next('\n');
            TestJSONTokener.assertEquals((String)"third String", (String)this.jsontokener.nextTo(','));
        }
        catch (JSONException e) {
            TestJSONTokener.fail((String)e.toString());
        }
    }

    public void testNextTo_String() {
        this.jsontokener = new JSONTokener("abc123,test\ntestString1\rsecondString\r\nthird String");
        try {
            TestJSONTokener.assertEquals((String)"abc", (String)this.jsontokener.nextTo("1,"));
            TestJSONTokener.assertEquals((String)"123", (String)this.jsontokener.nextTo("abc,"));
            this.jsontokener.next(',');
            TestJSONTokener.assertEquals((String)"te", (String)this.jsontokener.nextTo("sabc"));
            TestJSONTokener.assertEquals((String)"st", (String)this.jsontokener.nextTo("ring"));
            this.jsontokener.next('\n');
            TestJSONTokener.assertEquals((String)"testSt", (String)this.jsontokener.nextTo("r"));
            TestJSONTokener.assertEquals((String)"ring1", (String)this.jsontokener.nextTo("qw"));
            this.jsontokener.next('\r');
            TestJSONTokener.assertEquals((String)"second", (String)this.jsontokener.nextTo("bhS"));
            TestJSONTokener.assertEquals((String)"String", (String)this.jsontokener.nextTo("dbh"));
            this.jsontokener.next('\r');
            this.jsontokener.next('\n');
            TestJSONTokener.assertEquals((String)"third", (String)this.jsontokener.nextTo(" ng"));
            TestJSONTokener.assertEquals((String)"String", (String)this.jsontokener.nextTo("qwhdab"));
        }
        catch (JSONException e) {
            TestJSONTokener.fail((String)e.toString());
        }
    }

    public void testNextString() {
        this.jsontokener = new JSONTokener("'abc'\"1\\\"2\\\"3\"'a\\u1111b\\fc\\trhd\\bdd\\r\\ngghhj'\"hghghgjfjf\"");
        try {
            this.jsontokener.next('\'');
            TestJSONTokener.assertEquals((String)"abc", (String)this.jsontokener.nextString('\''));
            this.jsontokener.next('\"');
            TestJSONTokener.assertEquals((String)"1\"2\"3", (String)this.jsontokener.nextString('\"'));
            this.jsontokener.next('\'');
            TestJSONTokener.assertEquals((String)"a\u1111b\fc\trhd\bdd\r\ngghhj", (String)this.jsontokener.nextString('\''));
            this.jsontokener.next('\"');
            TestJSONTokener.assertEquals((String)"hghghgjfjf", (String)this.jsontokener.nextString('\"'));
        }
        catch (JSONException e) {
            TestJSONTokener.fail((String)e.toString());
        }
    }

    public void testNextString_IllegalEscape() {
        this.jsontokener = new JSONTokener("'ab\\\tc'");
        try {
            this.jsontokener.next('\'');
            this.jsontokener.nextString('\'');
            TestJSONTokener.fail((String)"Should have thrown exception");
        }
        catch (JSONException e) {
            TestJSONTokener.assertEquals((String)"Illegal escape. at 5 [character 6 line 1]", (String)e.getMessage());
        }
    }

    public void testNextString_UnterminatedString() {
        this.jsontokener = new JSONTokener("'abc");
        try {
            this.jsontokener.next('\'');
            this.jsontokener.nextString('\'');
            TestJSONTokener.fail((String)"Should have thrown exception");
        }
        catch (JSONException e) {
            TestJSONTokener.assertEquals((String)"Unterminated string at 5 [character 6 line 1]", (String)e.getMessage());
        }
    }

    public static void testDehexChar() {
        char i = '0';
        int j = 0;
        while (i <= '9') {
            TestJSONTokener.assertEquals((int)j, (int)JSONTokener.dehexchar(i));
            i = (char)(i + '\u0001');
            ++j;
        }
        i = 'A';
        while (i <= 'F') {
            TestJSONTokener.assertEquals((int)j, (int)JSONTokener.dehexchar(i));
            i = (char)(i + 1);
            ++j;
        }
        j = 10;
        i = 'a';
        while (i <= 'f') {
            TestJSONTokener.assertEquals((int)j, (int)JSONTokener.dehexchar(i));
            i = (char)(i + '\u0001');
            ++j;
        }
        TestJSONTokener.assertEquals((int)-1, (int)JSONTokener.dehexchar('$'));
        TestJSONTokener.assertEquals((int)-1, (int)JSONTokener.dehexchar('g'));
        TestJSONTokener.assertEquals((int)-1, (int)JSONTokener.dehexchar('G'));
        TestJSONTokener.assertEquals((int)-1, (int)JSONTokener.dehexchar('z'));
        TestJSONTokener.assertEquals((int)-1, (int)JSONTokener.dehexchar('Z'));
    }

    public void testMultipleThings() {
        try {
            this.jsontokener = new JSONTokener("{op:'test', to:'session', pre:1}{op:'test', to:'session', pre:2}");
            this.jsonobject = new JSONObject(this.jsontokener);
            TestJSONTokener.assertEquals((String)"{\"to\":\"session\",\"op\":\"test\",\"pre\":1}", (String)this.jsonobject.toString());
            TestJSONTokener.assertEquals((int)1, (int)this.jsonobject.optInt("pre"));
            char i = this.jsontokener.skipTo('{');
            TestJSONTokener.assertEquals((int)123, (int)i);
            this.jsonobject = new JSONObject(this.jsontokener);
            TestJSONTokener.assertEquals((String)"{\"to\":\"session\",\"op\":\"test\",\"pre\":2}", (String)this.jsonobject.toString());
        }
        catch (JSONException e) {
            TestJSONTokener.fail((String)e.getMessage());
        }
    }

    class MockInputStreamThrowsExceptionOnFourthRead
    extends InputStream {
        int position = 0;

        MockInputStreamThrowsExceptionOnFourthRead() {
        }

        public int read() throws IOException {
            if (this.position < 3) {
                ++this.position;
            } else {
                throw new IOException("Mock IOException thrown from read");
            }
            return 97;
        }
    }

    class MockInputStreamThrowsExceptionOnReset
    extends BufferedReader {
        public MockInputStreamThrowsExceptionOnReset(Reader in) {
            super(in);
        }

        public int read() throws IOException {
            return 0;
        }

        public void reset() throws IOException {
            throw new IOException("Mock IOException thrown from reset");
        }
    }
}

