/*
 * Decompiled with CFR 0.152.
 */
package org.json.tests;

import junit.framework.TestCase;
import org.json.CDL;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Before;

public class TestCDL
extends TestCase {
    private String string;
    private JSONArray jsonarray;

    @Before
    public void setUp() {
        this.string = "abc,test,123\ngg,hh,jj\naa,bb,cc\n";
        try {
            this.jsonarray = new JSONArray();
            JSONObject jo = new JSONObject();
            JSONObject jo2 = new JSONObject();
            jo.put("abc", "gg");
            jo.put("test", "hh");
            jo.put("123", "jj");
            jo2.put("abc", "aa");
            jo2.put("test", "bb");
            jo2.put("123", "cc");
            this.jsonarray.put(jo);
            this.jsonarray.put(jo2);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void testToJsonArray() {
        try {
            TestCDL.assertEquals((String)this.jsonarray.toString(), (String)CDL.toJSONArray(this.string).toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public static void testToJsonArray_NoNames() {
        try {
            TestCDL.assertEquals(null, (Object)CDL.toJSONArray(new JSONArray(), "abc,123"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public static void testToJsonArray_NullNames() {
        try {
            TestCDL.assertEquals(null, (Object)CDL.toJSONArray(null, "abc,123"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public static void testToJsonArray_NoData() {
        try {
            TestCDL.assertEquals(null, (Object)CDL.toJSONArray("abc,123\n"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void testToJsonArray_WeirdData() {
        this.string = "abc,test,123\rgg,hh,\"jj\"\raa,\tbb,cc";
        try {
            TestCDL.assertEquals((String)this.jsonarray.toString(), (String)CDL.toJSONArray(this.string).toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void testToJsonArray_NoClosingQuote() {
        this.string = "abc,test,123\rgg,hh,jj \raa,\"bb ,cc ";
        try {
            TestCDL.assertEquals((String)this.jsonarray.toString(), (String)CDL.toJSONArray(this.string).toString());
            TestCDL.fail((String)"Should have thrown Exception");
        }
        catch (JSONException e) {
            TestCDL.assertEquals((String)"Missing close quote '\"'. at 35 [character 12 line 5]", (String)e.getMessage());
        }
        this.string = "abc,test,123\rgg,hh,jj \raa,\"bb ,cc \n";
        try {
            TestCDL.assertEquals((String)this.jsonarray.toString(), (String)CDL.toJSONArray(this.string).toString());
            TestCDL.fail((String)"Should have thrown Exception");
        }
        catch (JSONException e) {
            TestCDL.assertEquals((String)"Missing close quote '\"'. at 35 [character 0 line 6]", (String)e.getMessage());
        }
        this.string = "abc,test,123\rgg,hh,jj \raa,\"bb ,cc \r";
        try {
            TestCDL.assertEquals((String)this.jsonarray.toString(), (String)CDL.toJSONArray(this.string).toString());
            TestCDL.fail((String)"Should have thrown Exception");
        }
        catch (JSONException e) {
            TestCDL.assertEquals((String)"Missing close quote '\"'. at 35 [character 12 line 5]", (String)e.getMessage());
        }
    }

    public void testToJsonArray_SpaceAfterString() {
        this.string = "abc,test,123\rgg,hh,jj \raa,\"bb\" ,cc\r";
        try {
            TestCDL.assertEquals((String)this.jsonarray.toString(), (String)CDL.toJSONArray(this.string).toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void testToJsonArray_BadCharacter() {
        this.string = "abc,test,123\rgg,hh,jj \raa,\"bb \"?,cc \r";
        try {
            TestCDL.assertEquals((String)this.jsonarray.toString(), (String)CDL.toJSONArray(this.string).toString());
            TestCDL.fail((String)"Should have thrown Exception");
        }
        catch (JSONException e) {
            TestCDL.assertEquals((String)"Bad character '?' (63). at 32 [character 9 line 5]", (String)e.getMessage());
        }
    }

    public void testToString() {
        try {
            TestCDL.assertEquals((String)this.string, (String)CDL.toString(this.jsonarray));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void testToString_BadJsonArray() {
        try {
            this.jsonarray = new JSONArray();
            TestCDL.assertEquals(null, (String)CDL.toString(this.jsonarray));
            this.jsonarray.put("abc");
            TestCDL.assertEquals((String)"", (String)CDL.toString(this.jsonarray, this.jsonarray));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void testToString_NoNames() {
        try {
            this.jsonarray = new JSONArray();
            JSONObject jo = new JSONObject();
            this.jsonarray.put(jo);
            TestCDL.assertEquals(null, (String)CDL.toString(this.jsonarray));
            TestCDL.assertEquals(null, (String)CDL.toString(new JSONArray(), this.jsonarray));
            JSONArray names = new JSONArray();
            names.put("");
            TestCDL.assertEquals((String)"\n", (String)CDL.toString(names, this.jsonarray));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void testToString_NullNames() {
        try {
            this.jsonarray = new JSONArray();
            JSONObject jo = new JSONObject();
            this.jsonarray.put(jo);
            TestCDL.assertEquals(null, (String)CDL.toString(null, this.jsonarray));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void testToString_Quotes() {
        try {
            this.jsonarray = CDL.toJSONArray("Comma delimited list test, '\"Strip\"Quotes', 'quote, comma', No quotes, 'Single Quotes', \"Double Quotes\"\n1,'2',\"3\"\n,'It is \"good,\"', \"It works.\"\n\n");
            this.string = CDL.toString(this.jsonarray);
            TestCDL.assertEquals((String)"\"quote, comma\",\"StripQuotes\",Comma delimited list test\n3,2,1\nIt works.,\"It is good,\",\n", (String)this.string);
            TestCDL.assertEquals((String)"[\n {\n  \"quote, comma\": \"3\",\n  \"\\\"Strip\\\"Quotes\": \"2\",\n  \"Comma delimited list test\": \"1\"\n },\n {\n  \"quote, comma\": \"It works.\",\n  \"\\\"Strip\\\"Quotes\": \"It is \\\"good,\\\"\",\n  \"Comma delimited list test\": \"\"\n }\n]", (String)this.jsonarray.toString(1));
            this.jsonarray = CDL.toJSONArray(this.string);
            TestCDL.assertEquals((String)"[\n {\n  \"quote, comma\": \"3\",\n  \"StripQuotes\": \"2\",\n  \"Comma delimited list test\": \"1\"\n },\n {\n  \"quote, comma\": \"It works.\",\n  \"StripQuotes\": \"It is good,\",\n  \"Comma delimited list test\": \"\"\n }\n]", (String)this.jsonarray.toString(1));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public static void testConstructor() {
        CDL cdl = new CDL();
        TestCDL.assertEquals((String)"CDL", (String)cdl.getClass().getSimpleName());
    }
}

