// Copyright (c) 1998 by W3C
//
// DOM is a trademark of W3C
// The DOM level 1 specification, from which this
// source is derived, is copyright by W3C.
// See: http://www.w3.org/TR/REC-DOM-Level-1/
//

package org.w3c.dom.html;

import org.w3c.dom.*;

/**

  <P>Create a frame. See the 
    <A  href="http://www.w3.org/TR/REC-html40/present/frames.html#edef-FRAME">FRAME element definition</A>
 in HTML 4.0.
  
</P>

<HR>

<!-- ======== PROPERTY SUMMARY ======== -->

<A NAME="property_summary"><!-- --></A>
<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>
<TR BGCOLOR=#CCCCFF ID=TableHeadingColor>
<TD COLSPAN=3><FONT SIZE=+2><B>Property Summary</B>
</FONT></TD></TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-frameBorder><CODE>&nbsp;frameBorder</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getFrameBorder()'>getFrameBorder</a>
<a href='#setFrameBorder(java.lang.String)'>setFrameBorder</a>
</TD>
<TD>
  <P>Request frame borders. See the 
    <A  href="http://www.w3.org/TR/REC-html40/present/frames.html#adef-frameborder">frameborder attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-longDesc><CODE>&nbsp;longDesc</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getLongDesc()'>getLongDesc</a>
<a href='#setLongDesc(java.lang.String)'>setLongDesc</a>
</TD>
<TD>
  <P>URI designating a long description of this image or frame. See the 
    <A  href="http://www.w3.org/TR/REC-html40/present/frames.html#adef-longdesc-FRAME">longdesc attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-marginHeight><CODE>&nbsp;marginHeight</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getMarginHeight()'>getMarginHeight</a>
<a href='#setMarginHeight(java.lang.String)'>setMarginHeight</a>
</TD>
<TD>
  <P>Frame margin height, in pixels. See the 
    <A  href="http://www.w3.org/TR/REC-html40/present/frames.html#adef-marginheight">marginheight attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-marginWidth><CODE>&nbsp;marginWidth</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getMarginWidth()'>getMarginWidth</a>
<a href='#setMarginWidth(java.lang.String)'>setMarginWidth</a>
</TD>
<TD>
  <P>Frame margin width, in pixels. See the 
    <A  href="http://www.w3.org/TR/REC-html40/present/frames.html#adef-marginwidth">marginwidth attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-name><CODE>&nbsp;name</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getName()'>getName</a>
<a href='#setName(java.lang.String)'>setName</a>
</TD>
<TD>
  <P>The frame name (object of the 
    <code>target</code> attribute). See the 
    <A  href="http://www.w3.org/TR/REC-html40/present/frames.html#adef-name-FRAME">name attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-noResize><CODE>&nbsp;noResize</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getNoResize()'>getNoResize</a>
<a href='#setNoResize(java.lang.String)'>setNoResize</a>
</TD>
<TD>
  <P>When true, forbid user from resizing frame. See the 
    <A  href="http://www.w3.org/TR/REC-html40/present/frames.html#adef-noresize">noresize attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-scrolling><CODE>&nbsp;scrolling</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getScrolling()'>getScrolling</a>
<a href='#setScrolling(java.lang.String)'>setScrolling</a>
</TD>
<TD>
  <P>Specify whether or not the frame should have scrollbars. See the 
    <A  href="http://www.w3.org/TR/REC-html40/present/frames.html#adef-scrolling">scrolling attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-src><CODE>&nbsp;src</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getSrc()'>getSrc</a>
<a href='#setSrc(java.lang.String)'>setSrc</a>
</TD>
<TD>
  <P>A URI designating the initial frame contents. See the 
    <A  href="http://www.w3.org/TR/REC-html40/present/frames.html#adef-src-FRAME">src attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
</TABLE>
&nbsp;
*/
public interface HTMLFrameElement
extends HTMLElement
{
	/** Assigns the value of the <code><a href=#att-frameBorder>frameBorder</a></code> property.
	 */
	void setFrameBorder (String frameBorder);

	/**
	 * Returns the value of the <code><a href=#att-frameBorder>frameBorder</a></code> property.
	*/
	String getFrameBorder ();


	/** Assigns the value of the <code><a href=#att-longDesc>longDesc</a></code> property.
	 */
	void setLongDesc (String longDesc);

	/**
	 * Returns the value of the <code><a href=#att-longDesc>longDesc</a></code> property.
	*/
	String getLongDesc ();


	/** Assigns the value of the <code><a href=#att-marginHeight>marginHeight</a></code> property.
	 */
	void setMarginHeight (String marginHeight);

	/**
	 * Returns the value of the <code><a href=#att-marginHeight>marginHeight</a></code> property.
	*/
	String getMarginHeight ();


	/** Assigns the value of the <code><a href=#att-marginWidth>marginWidth</a></code> property.
	 */
	void setMarginWidth (String marginWidth);

	/**
	 * Returns the value of the <code><a href=#att-marginWidth>marginWidth</a></code> property.
	*/
	String getMarginWidth ();


	/** Assigns the value of the <code><a href=#att-name>name</a></code> property.
	 */
	void setName (String name);

	/**
	 * Returns the value of the <code><a href=#att-name>name</a></code> property.
	*/
	String getName ();


	/** Assigns the value of the <code><a href=#att-noResize>noResize</a></code> property.
	 */
	void setNoResize (boolean noResize);

	/**
	 * Returns the value of the <code><a href=#att-noResize>noResize</a></code> property.
	*/
	boolean getNoResize ();


	/** Assigns the value of the <code><a href=#att-scrolling>scrolling</a></code> property.
	 */
	void setScrolling (String scrolling);

	/**
	 * Returns the value of the <code><a href=#att-scrolling>scrolling</a></code> property.
	*/
	String getScrolling ();


	/** Assigns the value of the <code><a href=#att-src>src</a></code> property.
	 */
	void setSrc (String src);

	/**
	 * Returns the value of the <code><a href=#att-src>src</a></code> property.
	*/
	String getSrc ();


}
