/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.io.UnsupportedEncodingException;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.HtmlFont;
import net.sf.jasperreports.engine.export.HtmlResourceHandler;
import net.sf.jasperreports.repo.RepositoryUtil;

public class HtmlFontUtil {
    private final RepositoryUtil repositoryUtil;

    private HtmlFontUtil(JasperReportsContext jasperReportsContext) {
        this.repositoryUtil = RepositoryUtil.getInstance(jasperReportsContext);
    }

    public static HtmlFontUtil getInstance(JasperReportsContext jasperReportsContext) {
        return new HtmlFontUtil(jasperReportsContext);
    }

    public static void handleFont(HtmlResourceHandler resourceHandler, HtmlFont htmlFont) {
        HtmlFontUtil.getInstance(DefaultJasperReportsContext.getInstance()).handleHtmlFont(resourceHandler, htmlFont);
    }

    public void handleHtmlFont(HtmlResourceHandler resourceHandler, HtmlFont htmlFont) {
        StringBuffer sbuffer = new StringBuffer();
        try {
            sbuffer.append("@charset \"UTF-8\";\n");
            sbuffer.append("@font-face {\n");
            sbuffer.append("\tfont-family: '" + htmlFont.getId() + "';\n");
            if (htmlFont.getEot() != null) {
                String eotId = htmlFont.getId() + ".eot";
                String eotFileName = resourceHandler.getResourcePath(eotId);
                sbuffer.append("\tsrc: url('" + eotFileName + "');\n");
                sbuffer.append("\tsrc: url('" + eotFileName + "?#iefix') format('embedded-opentype');\n");
                resourceHandler.handleResource(eotId, this.repositoryUtil.getBytesFromLocation(htmlFont.getEot()));
            }
            if (htmlFont.getTtf() != null || htmlFont.getSvg() != null || htmlFont.getWoff() != null) {
                sbuffer.append("\tsrc: local('\u00e2\u0098\u00ba')");
                if (htmlFont.getWoff() != null) {
                    String woffId = htmlFont.getId() + ".woff";
                    String woffFileName = resourceHandler.getResourcePath(woffId);
                    sbuffer.append(",\n\t\turl('" + woffFileName + "') format('woff')");
                    resourceHandler.handleResource(woffId, this.repositoryUtil.getBytesFromLocation(htmlFont.getWoff()));
                }
                if (htmlFont.getTtf() != null) {
                    String ttfId = htmlFont.getId() + ".ttf";
                    String ttfFileName = resourceHandler.getResourcePath(ttfId);
                    sbuffer.append(",\n\t\turl('" + ttfFileName + "') format('truetype')");
                    resourceHandler.handleResource(ttfId, this.repositoryUtil.getBytesFromLocation(htmlFont.getTtf()));
                }
                if (htmlFont.getSvg() != null) {
                    String svgId = htmlFont.getId() + ".svg";
                    String svgFileName = resourceHandler.getResourcePath(svgId);
                    sbuffer.append(",\n\t\turl('" + svgFileName + "') format('svg')");
                    resourceHandler.handleResource(svgId, this.repositoryUtil.getBytesFromLocation(htmlFont.getSvg()));
                }
                sbuffer.append(";\n");
            }
            sbuffer.append("\tfont-weight: normal;\n");
            sbuffer.append("\tfont-style: normal;\n");
            sbuffer.append("}");
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
        if (resourceHandler != null) {
            try {
                resourceHandler.handleResource(htmlFont.getId(), sbuffer.toString().getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new JRRuntimeException(e);
            }
        }
    }
}

