/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging;

import flex.management.MBeanLifecycleManager;
import flex.management.MBeanServerLocatorFactory;
import flex.messaging.FlexContext;
import flex.messaging.HttpFlexSession;
import flex.messaging.HttpFlexSessionProvider;
import flex.messaging.MessageBroker;
import flex.messaging.MessageException;
import flex.messaging.VersionInfo;
import flex.messaging.config.ConfigurationManager;
import flex.messaging.config.FlexConfigurationManager;
import flex.messaging.config.MessagingConfiguration;
import flex.messaging.endpoints.Endpoint;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.TypeMarshallingContext;
import flex.messaging.log.HTTPRequestLog;
import flex.messaging.log.Log;
import flex.messaging.log.Logger;
import flex.messaging.log.LoggingHttpServletRequestWrapper;
import flex.messaging.log.ServletLogTarget;
import flex.messaging.services.AuthenticationService;
import flex.messaging.util.ClassUtil;
import flex.messaging.util.ExceptionUtil;
import flex.messaging.util.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MessageBrokerServlet
extends HttpServlet {
    static final long serialVersionUID = -5293855229461612246L;
    public static final String LOG_CATEGORY_STARTUP_BROKER = "Startup.MessageBroker";
    private static final String STRING_UNDEFINED_APPLICATION = "undefined";
    private MessageBroker broker;
    private HttpFlexSessionProvider httpFlexSessionProvider;
    private static String FLEXDIR = "/WEB-INF/flex/";
    private boolean log_errors = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        MessageBrokerServlet.createThreadLocals();
        FlexContext.setThreadLocalObjects(null, null, null, null, null, servletConfig);
        ServletLogTarget.setServletContext(servletConfig.getServletContext());
        ClassLoader loader = this.getClassLoader();
        if ("true".equals(servletConfig.getInitParameter("useContextClassLoader"))) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        this.log_errors = HTTPRequestLog.init(this.getServletContext());
        try {
            ConfigurationManager configManager = MessageBrokerServlet.loadMessagingConfiguration(servletConfig);
            MessagingConfiguration config = configManager.getMessagingConfiguration(servletConfig);
            config.createLogAndTargets();
            this.broker = config.createBroker(servletConfig.getInitParameter("messageBrokerId"), loader);
            FlexContext.setThreadLocalObjects(null, null, this.broker, null, null, servletConfig);
            this.setupInternalPathResolver();
            this.broker.setServletContext(servletConfig.getServletContext());
            Logger logger = Log.getLogger((String)"Configuration");
            if (Log.isInfo()) {
                logger.info(VersionInfo.buildMessage());
            }
            config.configureBroker(this.broker);
            long timeBeforeStartup = 0L;
            if (Log.isDebug()) {
                timeBeforeStartup = System.currentTimeMillis();
                Log.getLogger((String)LOG_CATEGORY_STARTUP_BROKER).debug("MessageBroker with id '{0}' is starting.", new Object[]{this.broker.getId()});
            }
            Object object = HttpFlexSession.mapLock;
            synchronized (object) {
                if (servletConfig.getServletContext().getAttribute("LCDS_HTTP_TO_FLEX_SESSION_MAP") == null) {
                    servletConfig.getServletContext().setAttribute("LCDS_HTTP_TO_FLEX_SESSION_MAP", new ConcurrentHashMap());
                }
            }
            this.broker.start();
            if (Log.isDebug()) {
                long timeAfterStartup = System.currentTimeMillis();
                Long diffMillis = timeAfterStartup - timeBeforeStartup;
                Log.getLogger((String)LOG_CATEGORY_STARTUP_BROKER).debug("MessageBroker with id '{0}' is ready (startup time: '{1}' ms)", new Object[]{this.broker.getId(), diffMillis});
            }
            configManager.reportTokens();
            config.reportUnusedProperties();
            this.httpFlexSessionProvider = new HttpFlexSessionProvider();
            this.broker.getFlexSessionManager().registerFlexSessionProvider(HttpFlexSession.class, this.httpFlexSessionProvider);
            FlexContext.clearThreadLocalObjects();
        }
        catch (Throwable t) {
            String applicationName = servletConfig.getServletContext().getServletContextName();
            if (applicationName == null) {
                applicationName = STRING_UNDEFINED_APPLICATION;
            }
            System.err.println("**** MessageBrokerServlet in application '" + applicationName + "' failed to initialize due to runtime exception: " + ExceptionUtil.exceptionFollowedByRootCausesToString((Throwable)t));
            this.destroy();
            throw new ServletException(t);
        }
    }

    private void setupInternalPathResolver() {
        this.broker.setInternalPathResolver(new MessageBroker.InternalPathResolver(){

            public InputStream resolve(String filename) {
                return MessageBrokerServlet.this.getServletContext().getResourceAsStream(FLEXDIR + filename);
            }
        });
    }

    private static ConfigurationManager loadMessagingConfiguration(ServletConfig servletConfig) {
        ConfigurationManager manager;
        block4: {
            String p;
            manager = null;
            if (servletConfig != null && (p = servletConfig.getInitParameter("services.configuration.manager")) != null) {
                String className = p.trim();
                try {
                    Class managerClass = ClassUtil.createClass(className);
                    manager = (ConfigurationManager)managerClass.newInstance();
                }
                catch (Throwable t) {
                    if (!Trace.config) break block4;
                    Trace.trace("Could not load configuration manager as: " + className);
                }
            }
        }
        if (manager == null) {
            manager = new FlexConfigurationManager();
        }
        return manager;
    }

    public void destroy() {
        if (this.broker != null) {
            this.broker.stop();
            if (this.broker.isManaged()) {
                MBeanLifecycleManager.unregisterRuntimeMBeans(this.broker);
            }
            MessageBrokerServlet.destroyThreadLocals();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void service(HttpServletRequest req, HttpServletResponse res) {
        block32: {
            if (this.log_errors) {
                LoggingHttpServletRequestWrapper wrapper = new LoggingHttpServletRequestWrapper((HttpServletRequest)req);
                req = wrapper;
                try {
                    wrapper.doReadBody();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
            try {
                try {
                    block31: {
                        Endpoint endpoint;
                        block30: {
                            String encoded;
                            this.broker.initThreadLocals();
                            FlexContext.setThreadLocalObjects(null, null, this.broker, req, res, this.getServletConfig());
                            HttpFlexSession fs = this.httpFlexSessionProvider.getOrCreateSession((HttpServletRequest)req);
                            Principal principal = FlexContext.isPerClientAuthentication() ? FlexContext.getUserPrincipal() : fs.getUserPrincipal();
                            if (principal == null && req.getHeader("Authorization") != null && (encoded = req.getHeader("Authorization")).indexOf("Basic") > -1) {
                                encoded = encoded.substring(6);
                                try {
                                    ((AuthenticationService)this.broker.getService("authentication-service")).decodeAndLogin(encoded, this.broker.getLoginManager());
                                }
                                catch (Exception e) {
                                    if (!Log.isDebug()) break block30;
                                    Log.getLogger((String)"Security").info("Authentication service could not decode and login: " + e.getMessage());
                                }
                            }
                        }
                        String contextPath = req.getContextPath();
                        String pathInfo = req.getPathInfo();
                        String endpointPath = req.getServletPath();
                        if (pathInfo != null) {
                            endpointPath = endpointPath + pathInfo;
                        }
                        try {
                            endpoint = this.broker.getEndpoint(endpointPath, contextPath);
                        }
                        catch (MessageException me) {
                            String info222;
                            if (Log.isInfo()) {
                                Log.getLogger((String)"Endpoint.General").info("Received invalid request for endpoint path '{0}'.", new Object[]{endpointPath});
                            }
                            if (!res.isCommitted()) {
                                try {
                                    res.sendError(404);
                                }
                                catch (IOException ignore) {
                                }
                            }
                            Object var12_17 = null;
                            if (this.log_errors && (info222 = (String)req.getAttribute("com.adobe.internal._exception_info")) != null) {
                                System.out.println("Exception occurred while processing HTTP request: " + info222 + ", request details logged in " + HTTPRequestLog.getFileName());
                                HTTPRequestLog.outputRequest(info222, req);
                            }
                            FlexContext.clearThreadLocalObjects();
                            return;
                        }
                        try {
                            if (Log.isInfo()) {
                                Log.getLogger((String)"Endpoint.General").info("Channel endpoint {0} received request.", new Object[]{endpoint.getId()});
                            }
                            endpoint.service((HttpServletRequest)req, res);
                        }
                        catch (UnsupportedOperationException ue) {
                            if (Log.isInfo()) {
                                Log.getLogger((String)"Endpoint.General").info("Channel endpoint {0} received request for an unsupported operation.", new Object[]{endpoint.getId()}, (Throwable)ue);
                            }
                            if (res.isCommitted()) break block31;
                            try {
                                res.sendError(405);
                            }
                            catch (IOException ignore) {
                            }
                        }
                    }
                    Object var12_18 = null;
                    if (!this.log_errors) break block32;
                }
                catch (Throwable t) {
                    String info222;
                    try {
                        Log.getLogger((String)"Endpoint.General").error("Unexpected error encountered in Message Broker servlet", t);
                        res.sendError(500);
                    }
                    catch (IOException ignore) {
                    }
                    Object var12_19 = null;
                    if (this.log_errors && (info222 = (String)req.getAttribute("com.adobe.internal._exception_info")) != null) {
                        System.out.println("Exception occurred while processing HTTP request: " + info222 + ", request details logged in " + HTTPRequestLog.getFileName());
                        HTTPRequestLog.outputRequest(info222, req);
                    }
                    FlexContext.clearThreadLocalObjects();
                    return;
                }
            }
            catch (Throwable throwable) {
                String info222;
                Object var12_20 = null;
                if (this.log_errors && (info222 = (String)req.getAttribute("com.adobe.internal._exception_info")) != null) {
                    System.out.println("Exception occurred while processing HTTP request: " + info222 + ", request details logged in " + HTTPRequestLog.getFileName());
                    HTTPRequestLog.outputRequest(info222, req);
                }
                FlexContext.clearThreadLocalObjects();
                throw throwable;
            }
            String info222 = (String)req.getAttribute("com.adobe.internal._exception_info");
            if (info222 != null) {
                System.out.println("Exception occurred while processing HTTP request: " + info222 + ", request details logged in " + HTTPRequestLog.getFileName());
                HTTPRequestLog.outputRequest(info222, req);
            }
        }
        FlexContext.clearThreadLocalObjects();
    }

    protected ClassLoader getClassLoader() {
        return ((Object)((Object)this)).getClass().getClassLoader();
    }

    public static void createThreadLocals() {
        MessageBroker.createThreadLocalObjects();
        FlexContext.createThreadLocalObjects();
        SerializationContext.createThreadLocalObjects();
        TypeMarshallingContext.createThreadLocalObjects();
    }

    protected static void destroyThreadLocals() {
        Log.clear();
        MBeanServerLocatorFactory.clear();
        MessageBroker.releaseThreadLocalObjects();
        FlexContext.releaseThreadLocalObjects();
        SerializationContext.releaseThreadLocalObjects();
        TypeMarshallingContext.releaseThreadLocalObjects();
    }
}

