/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.transport.handler;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.sockjs.SockJsException;
import org.springframework.web.socket.sockjs.frame.SockJsFrame;
import org.springframework.web.socket.sockjs.frame.SockJsFrameFormat;
import org.springframework.web.socket.sockjs.transport.SockJsSession;
import org.springframework.web.socket.sockjs.transport.SockJsSessionFactory;
import org.springframework.web.socket.sockjs.transport.handler.AbstractTransportHandler;
import org.springframework.web.socket.sockjs.transport.session.AbstractHttpSockJsSession;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;

public abstract class AbstractHttpSendingTransportHandler
extends AbstractTransportHandler
implements SockJsSessionFactory {
    @Override
    public final void handleRequest(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, SockJsSession wsSession) throws SockJsException {
        AbstractHttpSockJsSession sockJsSession = (AbstractHttpSockJsSession)wsSession;
        String protocol = null;
        sockJsSession.setAcceptedProtocol(protocol);
        response.getHeaders().setContentType(this.getContentType());
        this.handleRequestInternal(request, response, sockJsSession);
    }

    protected void handleRequestInternal(ServerHttpRequest request, ServerHttpResponse response, AbstractHttpSockJsSession sockJsSession) throws SockJsException {
        if (sockJsSession.isNew()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(request.getMethod() + " " + request.getURI()));
            }
            sockJsSession.handleInitialRequest(request, response, this.getFrameFormat(request));
        } else {
            if (sockJsSession.isClosed()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Connection already closed (but not removed yet) for " + sockJsSession));
                }
                SockJsFrame frame = SockJsFrame.closeFrameGoAway();
                try {
                    response.getBody().write(frame.getContentBytes());
                }
                catch (IOException ex) {
                    throw new SockJsException("Failed to send " + frame, sockJsSession.getId(), ex);
                }
            }
            if (!sockJsSession.isActive()) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Starting " + (Object)((Object)this.getTransportType()) + " async request."));
                }
                sockJsSession.handleSuccessiveRequest(request, response, this.getFrameFormat(request));
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Another " + (Object)((Object)this.getTransportType()) + " connection still open for " + sockJsSession));
                }
                String formattedFrame = this.getFrameFormat(request).format(SockJsFrame.closeFrameAnotherConnectionOpen());
                try {
                    response.getBody().write(formattedFrame.getBytes(SockJsFrame.CHARSET));
                }
                catch (IOException ex) {
                    throw new SockJsException("Failed to send " + formattedFrame, sockJsSession.getId(), ex);
                }
            }
        }
    }

    protected abstract MediaType getContentType();

    protected abstract SockJsFrameFormat getFrameFormat(ServerHttpRequest var1);

    protected final String getCallbackParam(ServerHttpRequest request) {
        String query = request.getURI().getQuery();
        MultiValueMap params = UriComponentsBuilder.newInstance().query(query).build().getQueryParams();
        String value = (String)params.getFirst((Object)"c");
        try {
            return !StringUtils.isEmpty((Object)value) ? UriUtils.decode((String)value, (String)"UTF-8") : null;
        }
        catch (UnsupportedEncodingException ex) {
            throw new SockJsException("Unable to decode callback query parameter", null, ex);
        }
    }
}

