/*
 * Decompiled with CFR 0.152.
 */
package org.ajwcc.pduUtils.test;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.ajwcc.pduUtils.gsm3040.Pdu;
import org.ajwcc.pduUtils.gsm3040.PduParser;
import org.ajwcc.pduUtils.gsm3040.PduUtils;
import org.ajwcc.pduUtils.test.TestFileReader;
import org.smslib.Message;
import org.smslib.OutboundBinaryMessage;
import org.smslib.OutboundMessage;

public class MessageGeneratorTester {
    public static void main(String[] args) throws Exception {
        String currentLine;
        String smscNo = "";
        int testCount = 0;
        int passCount = 0;
        TestFileReader tfr = new TestFileReader();
        tfr.setSkipBlanksAndComment(false);
        tfr.init("java/org/ajwcc/pduUtils/testData/testMessages.txt");
        Message message = null;
        ArrayList<String> expectedPdus = new ArrayList<String>();
        block2: while ((currentLine = tfr.next()) != null) {
            if (currentLine.trim().equals("")) {
                System.out.println(currentLine);
                continue;
            }
            if (currentLine.trim().startsWith("#")) {
                System.out.println(currentLine);
                continue;
            }
            String[] data = new String[2];
            int colon = currentLine.indexOf(58);
            data[0] = currentLine.substring(0, colon);
            data[1] = currentLine.substring(colon + 1);
            if (data[0].equals("messageType")) {
                message = (Message)Class.forName(data[1]).newInstance();
                ++testCount;
                continue;
            }
            if (data[0].equals("messageEnd")) {
                if (message != null) {
                    List<String> pdus = ((OutboundMessage)message).getPdus(smscNo, 123);
                    StringBuffer sb = new StringBuffer();
                    for (String pduString : pdus) {
                        Pdu pdu = new PduParser().parsePdu(pduString);
                        System.out.println(pdu);
                        if (message instanceof OutboundBinaryMessage) {
                            sb.append(PduUtils.bytesToPdu(pdu.getUserDataAsBytes()));
                            continue;
                        }
                        if (!(message instanceof OutboundMessage)) continue;
                        sb.append(pdu.getDecodedText());
                    }
                    System.out.println("EXPECTED PDUs   : " + expectedPdus.size());
                    System.out.println("GENERATED PDUs  : " + pdus.size());
                    if (message instanceof OutboundBinaryMessage) {
                        OutboundBinaryMessage bin = (OutboundBinaryMessage)message;
                        System.out.println("EXPECTED BYTES : " + PduUtils.bytesToPdu(bin.getDataBytes()));
                        System.out.println("GENERATED BYTES: " + sb.toString());
                        boolean match = sb.toString().equals(PduUtils.bytesToPdu(bin.getDataBytes()));
                        System.out.println("MATCH: " + match);
                        if (match) {
                            ++passCount;
                        }
                    } else if (message instanceof OutboundMessage) {
                        System.out.println("EXPECTED TEXT : " + message.getText());
                        System.out.println("GENERATED TEXT: " + sb.toString());
                        boolean match = sb.toString().equals(message.getText());
                        System.out.println("MATCH: " + match);
                        if (match) {
                            ++passCount;
                        }
                    }
                }
                System.out.println();
                expectedPdus.clear();
                message = null;
                smscNo = "";
                continue;
            }
            if (data[0].equals("encoding")) {
                if (data[1].equals("7")) {
                    ((OutboundMessage)message).setEncoding(Message.MessageEncodings.ENC7BIT);
                    continue;
                }
                if (data[1].equals("8")) {
                    ((OutboundMessage)message).setEncoding(Message.MessageEncodings.ENC8BIT);
                    continue;
                }
                if (!data[1].equals("ucs2")) continue;
                ((OutboundMessage)message).setEncoding(Message.MessageEncodings.ENCUCS2);
                continue;
            }
            if (data[0].equals("expectedPdu")) {
                expectedPdus.add(data[1]);
                continue;
            }
            if (data[0].equals("smscNumber")) {
                smscNo = data[1];
                continue;
            }
            if (data[0].equals("dataBytes")) {
                ((OutboundBinaryMessage)message).setDataBytes(PduUtils.pduToBytes(data[1]));
                continue;
            }
            for (Class<?> currentClass = message.getClass(); currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
                try {
                    Method getter = message.getClass().getMethod("get" + Character.toUpperCase(data[0].charAt(0)) + data[0].substring(1), new Class[0]);
                    Class<?> returnType = getter.getReturnType();
                    Method setter = currentClass.getDeclaredMethod("set" + Character.toUpperCase(data[0].charAt(0)) + data[0].substring(1), returnType);
                    setter.setAccessible(true);
                    setter.invoke((Object)message, MessageGeneratorTester.convertStringToArgument(returnType, data[1]));
                    continue block2;
                }
                catch (Exception e) {
                    continue;
                }
            }
        }
        tfr.close();
        System.out.println();
        System.out.println("Total Tests: " + testCount);
        System.out.println("Passed: " + passCount);
    }

    public static Object convertStringToArgument(Class<?> c, String data) {
        if (c == Boolean.class || c == Boolean.TYPE) {
            return Boolean.valueOf(data);
        }
        if (c == Integer.class || c == Integer.TYPE) {
            return Integer.valueOf(data);
        }
        if (c == Long.class || c == Long.TYPE) {
            return Long.valueOf(data);
        }
        if (c == Integer.class || c == Integer.TYPE) {
            return Integer.valueOf(data);
        }
        if (c == Short.class || c == Short.TYPE) {
            return Short.valueOf(data);
        }
        if (c == String.class) {
            return data;
        }
        return null;
    }
}

