/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.ui;

import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.Datasource;
import com.supermap.data.Datasources;
import com.supermap.data.EngineType;
import com.supermap.data.Layouts;
import com.supermap.data.Maps;
import com.supermap.data.Resources;
import com.supermap.data.Scenes;
import com.supermap.data.SymbolFillLibrary;
import com.supermap.data.SymbolLineLibrary;
import com.supermap.data.SymbolMarkerLibrary;
import com.supermap.data.Workspace;
import com.supermap.ui.InternalImageIconFactory;
import com.supermap.ui.InternalResource;
import com.supermap.ui.NodeDataType;
import com.supermap.ui.TreeNodeData;
import com.supermap.ui.WorkspaceTreeCellRenderer;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;

class WorkspaceTreeCellEditor
extends DefaultTreeCellEditor {
    private String _$2 = null;
    private Workspace _$1 = null;

    public WorkspaceTreeCellEditor(JTree jTree, WorkspaceTreeCellRenderer workspaceTreeCellRenderer, Workspace workspace) {
        super(jTree, workspaceTreeCellRenderer);
        this._$1 = workspace;
    }

    protected void determineOffset(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        this.offset = this.editingIcon != null ? this.renderer.getIconTextGap() + this.editingIcon.getIconWidth() : this.renderer.getIconTextGap();
        this._$1(object);
    }

    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        this.setTree(jTree);
        this.lastRow = n;
        this.determineOffset(jTree, object, bl, bl2, bl3, n);
        if (null != this.editingComponent) {
            this.editingContainer.remove(this.editingComponent);
        }
        this.editingComponent = this.realEditor.getTreeCellEditorComponent(jTree, this._$2, bl, bl2, bl3, n);
        TreePath treePath = jTree.getPathForRow(n);
        this.canEdit = this.lastPath != null && treePath != null && this.lastPath.equals(treePath);
        Font font = this._$1(jTree);
        this.editingContainer.setFont(font);
        this.prepareForEditing();
        return this.editingContainer;
    }

    private Font _$1(JTree jTree) {
        Font font = this.getFont();
        if (null == font) {
            if (null != this.renderer) {
                font = this.renderer.getFont();
            }
            if (null == font) {
                font = jTree.getFont();
            }
        }
        return font;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopCellEditing() {
        TreePath treePath = this.tree.getSelectionPath();
        Object object = treePath.getLastPathComponent();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        TreeNodeData treeNodeData = (TreeNodeData)defaultMutableTreeNode.getUserObject();
        try {
            Object object2 = treeNodeData.getData();
            if (object2 instanceof Datasource) {
                Datasource datasource = (Datasource)object2;
                this._$1.getDatasources().modifyAlias(datasource.getAlias(), this._$2);
            } else if (object2 instanceof Dataset) {
                Dataset dataset = (Dataset)object2;
                if (!dataset.getDatasource().getDatasets().rename(dataset.getName(), this._$2)) {
                    this._$2 = dataset.getName();
                    this.cancelCellEditing();
                }
            } else {
                NodeDataType nodeDataType = treeNodeData.getType();
                if (nodeDataType.equals((Object)NodeDataType.LAYOUTNAME)) {
                    String string = (String)object2;
                    this._$1.getLayouts().rename(string, this._$2);
                } else if (nodeDataType.equals((Object)NodeDataType.MAPNAME)) {
                    String string = (String)object2;
                    this._$1.getMaps().rename(string, this._$2);
                } else if (nodeDataType.equals((Object)NodeDataType.SCENENAME)) {
                    String string = (String)object2;
                    this._$1.getScenes().rename(string, this._$2);
                } else {
                    this.cancelCellEditing();
                }
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
        finally {
            this.cancelCellEditing();
        }
        if (this.realEditor.stopCellEditing()) {
            this._$2();
            return true;
        }
        return false;
    }

    public void cancelCellEditing() {
        this.realEditor.cancelCellEditing();
        this._$2();
    }

    public Object getCellEditorValue() {
        return this.realEditor.getCellEditorValue();
    }

    protected TreeCellEditor createTreeCellEditor() {
        Border border = UIManager.getBorder("Tree.editorBorder");
        DefaultTreeCellEditor.DefaultTextField defaultTextField = new DefaultTreeCellEditor.DefaultTextField(this, border);
        defaultTextField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                if (c == '\n') {
                    Object object = WorkspaceTreeCellEditor.this.realEditor.getCellEditorValue();
                    WorkspaceTreeCellEditor.this._$2 = object.toString();
                    WorkspaceTreeCellEditor.this._$1();
                    WorkspaceTreeCellEditor.this.tree.updateUI();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(defaultTextField){

            public boolean shouldSelectCell(EventObject eventObject) {
                boolean bl = super.shouldSelectCell(eventObject);
                return bl;
            }
        };
        defaultCellEditor.setClickCountToStart(1);
        return defaultCellEditor;
    }

    private void _$2() {
        if (this.editingComponent != null) {
            this.editingContainer.remove(this.editingComponent);
        }
        this.editingComponent = null;
    }

    private void _$1() {
        this.stopCellEditing();
    }

    private void _$1(Object object) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        TreeNodeData treeNodeData = (TreeNodeData)defaultMutableTreeNode.getUserObject();
        Object object2 = treeNodeData.getData();
        if (object2 instanceof Workspace) {
            this.editingIcon = InternalImageIconFactory.WORKSPACE;
            this._$2 = this._$1.getCaption().equals("UntitledWorkspace") ? InternalResource.loadString("", "WorkspaceNodeDefaultName", "ui_resources") : this._$1.getCaption();
        } else if (object2 instanceof Datasources) {
            this.editingIcon = InternalImageIconFactory.DATASOURCES;
            this._$2 = InternalResource.loadString("", "DatasourcesNodeName", "ui_resources");
        } else if (object2 instanceof Datasource) {
            Datasource datasource = (Datasource)treeNodeData.getData();
            EngineType engineType = datasource.getEngineType();
            if (engineType.equals((Object)EngineType.SQLPLUS)) {
                this.editingIcon = InternalImageIconFactory.DATASOURCE_SQL;
            } else if (engineType.equals((Object)EngineType.IMAGEPLUGINS)) {
                this.editingIcon = InternalImageIconFactory.DATASOURCE_IMAGEPLUGINS;
            } else if (engineType.equals((Object)EngineType.OGC)) {
                this.editingIcon = InternalImageIconFactory.DATASOURCE_OGC;
            } else if (engineType.equals((Object)EngineType.ORACLEPLUS)) {
                this.editingIcon = InternalImageIconFactory.DATASOURCE_ORACLE;
            } else if (engineType.equals((Object)EngineType.UDB)) {
                this.editingIcon = InternalImageIconFactory.DATASOURCE_UDB;
            }
            this._$2 = datasource.getAlias();
        } else if (object2 instanceof Dataset) {
            Dataset dataset = (Dataset)treeNodeData.getData();
            DatasetType datasetType = dataset.getType();
            if (datasetType.equals((Object)DatasetType.POINT)) {
                this.editingIcon = InternalImageIconFactory.DT_POINT;
                this._$2 = dataset.getName();
            } else if (datasetType.equals((Object)DatasetType.LINE)) {
                this.editingIcon = InternalImageIconFactory.DT_LINE;
                this._$2 = dataset.getName();
            } else if (datasetType.equals((Object)DatasetType.LINEM)) {
                this.editingIcon = InternalImageIconFactory.DT_LINEM;
                this._$2 = dataset.getName();
            } else if (datasetType.equals((Object)DatasetType.REGION)) {
                this.editingIcon = InternalImageIconFactory.DT_REGION;
                this._$2 = dataset.getName();
            } else if (datasetType.equals((Object)DatasetType.CAD)) {
                this.editingIcon = InternalImageIconFactory.DT_CAD;
                this._$2 = dataset.getName();
            } else if (datasetType.equals((Object)DatasetType.GRID)) {
                this.editingIcon = InternalImageIconFactory.DT_GRID;
                this._$2 = dataset.getName();
            } else if (datasetType.equals((Object)DatasetType.IMAGE)) {
                this.editingIcon = InternalImageIconFactory.DT_IMAGE;
                this._$2 = dataset.getName();
            } else if (datasetType.equals((Object)DatasetType.LINKTABLE)) {
                this.editingIcon = InternalImageIconFactory.DT_LINKTABLE;
                this._$2 = dataset.getName();
            } else if (datasetType.equals((Object)DatasetType.NETWORK)) {
                this.editingIcon = InternalImageIconFactory.DT_NETWORK;
                this._$2 = dataset.getName();
            } else if (datasetType.equals((Object)DatasetType.TABULAR)) {
                this.editingIcon = InternalImageIconFactory.DT_TABULAR;
                this._$2 = dataset.getName();
            } else if (datasetType.equals((Object)DatasetType.TEXT)) {
                this.editingIcon = InternalImageIconFactory.DT_TEXT;
                this._$2 = dataset.getName();
            } else if (datasetType.equals((Object)DatasetType.TOPOLOGY)) {
                this.editingIcon = InternalImageIconFactory.DT_TOPOLOGY;
                this._$2 = dataset.getName();
            } else if (datasetType.equals((Object)DatasetType.WCS)) {
                this.editingIcon = InternalImageIconFactory.DT_WCS;
                this._$2 = dataset.getName();
            } else if (datasetType.equals((Object)DatasetType.WMS)) {
                this.editingIcon = InternalImageIconFactory.DT_WMS;
                this._$2 = dataset.getName();
            }
        } else if (object2 instanceof Maps) {
            this.editingIcon = InternalImageIconFactory.MAPS;
            this._$2 = InternalResource.loadString("", "MapsNodeName", "ui_resources");
        } else if (treeNodeData.getType().equals((Object)NodeDataType.MAPNAME)) {
            this.editingIcon = InternalImageIconFactory.MAP;
            this._$2 = treeNodeData.getData().toString().trim();
        } else if (object2 instanceof Scenes) {
            this.editingIcon = InternalImageIconFactory.SCENES;
            this._$2 = InternalResource.loadString("", "ScenesNodeName", "ui_resources");
        } else if (treeNodeData.getType().equals((Object)NodeDataType.SCENENAME)) {
            this.editingIcon = InternalImageIconFactory.SCENE;
            this._$2 = treeNodeData.getData().toString().trim();
        } else if (object2 instanceof Layouts) {
            this.editingIcon = InternalImageIconFactory.LAYOUTS;
            this._$2 = InternalResource.loadString("", "LayoutsNodeName", "ui_resources");
        } else if (treeNodeData.getType().equals((Object)NodeDataType.LAYOUTNAME)) {
            this.editingIcon = InternalImageIconFactory.LAYOUT;
            this._$2 = treeNodeData.getData().toString().trim();
        } else if (object2 instanceof Resources) {
            this.editingIcon = InternalImageIconFactory.RESOURCES;
            this._$2 = InternalResource.loadString("", "ResourcesNodeName", "ui_resources");
        } else if (object2 instanceof SymbolMarkerLibrary) {
            this.editingIcon = InternalImageIconFactory.SYMBOLMARKERLIB;
            this._$2 = InternalResource.loadString("", "SymbolMarkerLibNodeName", "ui_resources");
        } else if (object2 instanceof SymbolLineLibrary) {
            this.editingIcon = InternalImageIconFactory.SYMBOLLINELIB;
            this._$2 = InternalResource.loadString("", "SymbolLineLibNodeName", "ui_resources");
        } else if (object2 instanceof SymbolFillLibrary) {
            this.editingIcon = InternalImageIconFactory.SYMBOLFillLIB;
            this._$2 = InternalResource.loadString("", "SymbolFillLibNodeName", "ui_resources");
        }
    }
}

