/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.ui;

import com.supermap.data.Dataset;
import com.supermap.data.DatasetTopology;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoPoint;
import com.supermap.data.GeoRegion;
import com.supermap.data.GeoStyle;
import com.supermap.data.Geometry;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.Resources;
import com.supermap.data.Size2D;
import com.supermap.data.Symbol;
import com.supermap.data.SymbolMarker;
import com.supermap.data.SymbolMarkerLibrary;
import com.supermap.data.Toolkit;
import com.supermap.mapping.Layer;
import com.supermap.mapping.LayerSettingVector;
import com.supermap.ui.InternalImageIconFactory;
import com.supermap.ui.InternalToolkitControl;
import com.supermap.ui.NodeDataType;
import com.supermap.ui.TreeNodeData;
import com.supermap.ui.TreeNodeDecorator;
import com.supermap.ui.UIEnvironment;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

class LayerNodeDecorator
implements TreeNodeDecorator {
    LayerNodeDecorator() {
    }

    public void decorate(JLabel jLabel, TreeNodeData treeNodeData) {
        if (treeNodeData.getType().equals((Object)NodeDataType.LAYER)) {
            Layer layer = (Layer)treeNodeData.getData();
            jLabel.setText(layer.getCaption());
            Dataset dataset = layer.getDataset();
            if (dataset == null) {
                ImageIcon imageIcon = (ImageIcon)jLabel.getIcon();
                BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
                Graphics graphics = bufferedImage.getGraphics();
                graphics.drawImage(InternalImageIconFactory.DT_UNKNOWN.getImage(), 0, 0, jLabel);
                imageIcon.setImage(bufferedImage);
            } else {
                Object object;
                Object object2;
                Object object3;
                Resources resources = dataset.getDatasource().getWorkspace().getResources();
                if (dataset instanceof DatasetVector) {
                    SymbolMarkerLibrary symbolMarkerLibrary;
                    GeoStyle geoStyle;
                    GeoStyle geoStyle2;
                    LayerSettingVector layerSettingVector;
                    object3 = (DatasetVector)dataset;
                    object2 = (ImageIcon)jLabel.getIcon();
                    object = new BufferedImage(16, 16, 2);
                    Graphics graphics = ((BufferedImage)object).getGraphics();
                    DatasetType datasetType = object3.getType();
                    if (datasetType.equals((Object)DatasetType.POINT)) {
                        layerSettingVector = (LayerSettingVector)layer.getAdditionalSetting();
                        if (layerSettingVector == null) {
                            layerSettingVector = new LayerSettingVector();
                        }
                        geoStyle2 = layerSettingVector.getStyle();
                        geoStyle = geoStyle2.clone();
                        symbolMarkerLibrary = resources.getMarkerLibrary();
                        int n = geoStyle.getMarkerSymbolID();
                        if (n < 1) {
                            graphics.setColor(geoStyle.getLineColor());
                            graphics.fillOval(6, 6, 4, 4);
                        } else {
                            GeoPoint geoPoint = (GeoPoint)this._$1(DatasetType.POINT);
                            geoStyle.setMarkerSize(new Size2D(2.0, 2.0));
                            geoPoint.setStyle(geoStyle);
                            Symbol symbol = symbolMarkerLibrary.findSymbol(geoStyle.getMarkerSymbolID());
                            SymbolMarker symbolMarker = (SymbolMarker)symbol;
                            if (symbolMarker != null) {
                                Point point = symbolMarker.getOrigin();
                                int n2 = point.x * 16 / UIEnvironment.g_symbolPointMax;
                                int n3 = point.y * 16 / UIEnvironment.g_symbolPointMax;
                                geoPoint.setX((double)n2);
                                geoPoint.setY((double)n3);
                            }
                            InternalToolkitControl.internalDraw((Geometry)geoPoint, resources, graphics);
                        }
                        ((ImageIcon)object2).setImage((Image)object);
                    }
                    if (datasetType.equals((Object)DatasetType.LINE)) {
                        layerSettingVector = (LayerSettingVector)layer.getAdditionalSetting();
                        if (layerSettingVector == null) {
                            layerSettingVector = new LayerSettingVector();
                        }
                        if ((geoStyle = (geoStyle2 = layerSettingVector.getStyle()).clone()).getLineWidth() > 0.2) {
                            geoStyle.setLineWidth(0.2);
                        }
                        symbolMarkerLibrary = this._$1(DatasetType.LINE);
                        symbolMarkerLibrary.setStyle(geoStyle);
                        Toolkit.draw((Geometry)symbolMarkerLibrary, (Resources)resources, (Graphics)graphics);
                        ((ImageIcon)object2).setImage((Image)object);
                    }
                    if (datasetType.equals((Object)DatasetType.REGION)) {
                        layerSettingVector = (LayerSettingVector)layer.getAdditionalSetting();
                        if (layerSettingVector == null) {
                            layerSettingVector = new LayerSettingVector();
                        }
                        if ((geoStyle = (geoStyle2 = layerSettingVector.getStyle()).clone()).getLineWidth() > 0.2) {
                            geoStyle.setLineWidth(0.2);
                        }
                        symbolMarkerLibrary = this._$1(DatasetType.REGION);
                        symbolMarkerLibrary.setStyle(geoStyle);
                        Toolkit.draw((Geometry)symbolMarkerLibrary, (Resources)resources, (Graphics)graphics);
                        ((ImageIcon)object2).setImage((Image)object);
                    } else if (datasetType.equals((Object)DatasetType.CAD)) {
                        graphics.drawImage(InternalImageIconFactory.DT_CAD.getImage(), 0, 0, jLabel);
                    } else if (datasetType.equals((Object)DatasetType.LINEM)) {
                        graphics.drawImage(InternalImageIconFactory.DT_LINEM.getImage(), 0, 0, jLabel);
                    } else if (datasetType.equals((Object)DatasetType.LINKTABLE)) {
                        graphics.drawImage(InternalImageIconFactory.DT_LINKTABLE.getImage(), 0, 0, jLabel);
                    } else if (datasetType.equals((Object)DatasetType.NETWORK)) {
                        graphics.drawImage(InternalImageIconFactory.DT_NETWORK.getImage(), 0, 0, jLabel);
                    } else if (datasetType.equals((Object)DatasetType.TABULAR)) {
                        graphics.drawImage(InternalImageIconFactory.DT_TABULAR.getImage(), 0, 0, jLabel);
                    } else if (datasetType.equals((Object)DatasetType.TEXT)) {
                        graphics.drawImage(InternalImageIconFactory.DT_TEXT.getImage(), 0, 0, jLabel);
                    } else if (datasetType.equals((Object)DatasetType.PARAMETRICLINE)) {
                        graphics.drawImage(InternalImageIconFactory.DT_PARAMETRICLINE.getImage(), 0, 0, jLabel);
                    } else if (datasetType.equals((Object)DatasetType.PARAMETRICREGION)) {
                        graphics.drawImage(InternalImageIconFactory.DT_PARAMETRICREGION.getImage(), 0, 0, jLabel);
                    }
                    ((ImageIcon)object2).setImage((Image)object);
                }
                if (dataset instanceof DatasetTopology) {
                    object3 = (ImageIcon)jLabel.getIcon();
                    object2 = new BufferedImage(16, 16, 2);
                    object = ((BufferedImage)object2).getGraphics();
                    ((Graphics)object).drawImage(InternalImageIconFactory.DT_TOPOLOGY.getImage(), 0, 0, jLabel);
                    ((ImageIcon)object3).setImage((Image)object2);
                }
            }
        }
    }

    private Geometry _$1(DatasetType datasetType) {
        if (datasetType.equals((Object)DatasetType.POINT)) {
            GeoPoint geoPoint = new GeoPoint();
            return geoPoint;
        }
        if (datasetType.equals((Object)DatasetType.LINE)) {
            Point2D[] point2DArray = new Point2D[]{new Point2D(0.0, 16.0), new Point2D(4.0, 0.0), new Point2D(12.0, 16.0), new Point2D(16.0, 0.0)};
            Point2Ds point2Ds = new Point2Ds(point2DArray);
            GeoLine geoLine = new GeoLine(point2Ds);
            return geoLine;
        }
        if (datasetType.equals((Object)DatasetType.REGION)) {
            Point2D[] point2DArray = new Point2D[]{new Point2D(1.0, 15.0), new Point2D(1.0, 5.0), new Point2D(10.0, 1.0), new Point2D(15.0, 5.0), new Point2D(15.0, 15.0), new Point2D(1.0, 15.0)};
            Point2Ds point2Ds = new Point2Ds(point2DArray);
            GeoRegion geoRegion = new GeoRegion(point2Ds);
            return geoRegion;
        }
        return null;
    }
}

