/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.ui;

import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.ui.InternalImageIconFactory;
import com.supermap.ui.NodeDataType;
import com.supermap.ui.TreeNodeData;
import com.supermap.ui.TreeNodeDecorator;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

class DatasetVectorNodeDecorator
implements TreeNodeDecorator {
    DatasetVectorNodeDecorator() {
    }

    public void decorate(JLabel jLabel, TreeNodeData treeNodeData) {
        if (treeNodeData.getType().equals((Object)NodeDataType.DATASETVECTOR)) {
            DatasetVector datasetVector = (DatasetVector)treeNodeData.getData();
            jLabel.setText(datasetVector.getName());
            ImageIcon imageIcon = (ImageIcon)jLabel.getIcon();
            BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
            Graphics graphics = bufferedImage.getGraphics();
            DatasetType datasetType = datasetVector.getType();
            if (datasetType.equals((Object)DatasetType.POINT)) {
                graphics.drawImage(InternalImageIconFactory.DT_POINT.getImage(), 0, 0, jLabel);
            } else if (datasetType.equals((Object)DatasetType.CAD)) {
                graphics.drawImage(InternalImageIconFactory.DT_CAD.getImage(), 0, 0, jLabel);
            } else if (datasetType.equals((Object)DatasetType.LINE)) {
                graphics.drawImage(InternalImageIconFactory.DT_LINE.getImage(), 0, 0, jLabel);
            } else if (datasetType.equals((Object)DatasetType.LINEM)) {
                graphics.drawImage(InternalImageIconFactory.DT_LINEM.getImage(), 0, 0, jLabel);
            } else if (datasetType.equals((Object)DatasetType.LINKTABLE)) {
                graphics.drawImage(InternalImageIconFactory.DT_LINKTABLE.getImage(), 0, 0, jLabel);
            } else if (datasetType.equals((Object)DatasetType.NETWORK)) {
                graphics.drawImage(InternalImageIconFactory.DT_NETWORK.getImage(), 0, 0, jLabel);
            } else if (datasetType.equals((Object)DatasetType.REGION)) {
                graphics.drawImage(InternalImageIconFactory.DT_REGION.getImage(), 0, 0, jLabel);
            } else if (datasetType.equals((Object)DatasetType.TABULAR)) {
                graphics.drawImage(InternalImageIconFactory.DT_TABULAR.getImage(), 0, 0, jLabel);
            } else if (datasetType.equals((Object)DatasetType.TEXT)) {
                graphics.drawImage(InternalImageIconFactory.DT_TEXT.getImage(), 0, 0, jLabel);
            } else if (datasetType.equals((Object)DatasetType.TABULAR)) {
                graphics.drawImage(InternalImageIconFactory.DT_TABULAR.getImage(), 0, 0, jLabel);
            } else if (datasetType.equals((Object)DatasetType.POINT3D)) {
                graphics.drawImage(InternalImageIconFactory.DT_POINT3D.getImage(), 0, 0, jLabel);
            } else if (datasetType.equals((Object)DatasetType.LINE3D)) {
                graphics.drawImage(InternalImageIconFactory.DT_LINE3D.getImage(), 0, 0, jLabel);
            } else if (datasetType.equals((Object)DatasetType.REGION3D)) {
                graphics.drawImage(InternalImageIconFactory.DT_REGION3D.getImage(), 0, 0, jLabel);
            } else if (datasetType.equals((Object)DatasetType.PARAMETRICLINE)) {
                graphics.drawImage(InternalImageIconFactory.DT_PARAMETRICLINE.getImage(), 0, 0, jLabel);
            } else if (datasetType.equals((Object)DatasetType.PARAMETRICREGION)) {
                graphics.drawImage(InternalImageIconFactory.DT_PARAMETRICREGION.getImage(), 0, 0, jLabel);
            } else {
                graphics.drawImage(InternalImageIconFactory.DT_UNKNOWN.getImage(), 0, 0, jLabel);
            }
            imageIcon.setImage(bufferedImage);
        }
    }
}

