/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.ColorSpaceType;
import com.supermap.data.Colors;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetImage;
import com.supermap.mapping.ImageDisplayMode;
import com.supermap.mapping.ImageStretchOption;
import com.supermap.mapping.InternalColors;
import com.supermap.mapping.InternalEnum;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.Layer;
import com.supermap.mapping.LayerNative;
import com.supermap.mapping.LayerSetting;
import com.supermap.mapping.LayerSettingType;
import com.supermap.mapping.Layers;
import java.awt.Color;

public class LayerSettingImage
extends LayerSetting {
    private Layer _$15 = null;
    private Layers _$14 = null;
    private boolean _$13 = false;
    private int _$12 = 100;
    private int _$11 = 0;
    private int _$10 = 0;
    private boolean _$9 = false;
    private Color _$8 = Color.black;
    private int[] _$7;
    private ColorSpaceType _$6 = ColorSpaceType.RGB;
    private String[] _$5 = null;
    private int _$4;
    private ImageStretchOption _$3 = null;
    private ImageDisplayMode _$2 = ImageDisplayMode.STRETCHED;
    private Colors _$1 = null;

    public LayerSettingImage() {
        Colors colors = new Colors();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)colors, false);
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)colors);
        this._$1 = InternalColors.createInstance(l, false);
        this._$13 = false;
    }

    public LayerSettingImage(LayerSettingImage layerSettingImage) {
        long l;
        if (layerSettingImage == null) {
            String string = InternalResource.loadString("layerSettingImage", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (layerSettingImage._$13 && (l = InternalHandle.getHandle(layerSettingImage._$15)) == 0L) {
            String string = InternalResource.loadString("layerSettingImage.Layer", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this._$10 = layerSettingImage.getBrightness();
        this._$11 = layerSettingImage.getContrast();
        this._$12 = layerSettingImage.getOpaqueRate();
        this._$6 = layerSettingImage.getDisplayColorSpace();
        this._$7 = (int[])layerSettingImage.getDisplayBandIndexes().clone();
        this._$4 = layerSettingImage.getTransparentColorTolerance();
        this._$3 = layerSettingImage.getImageStretchOption();
        this._$2 = layerSettingImage.getDisplayMode();
        Colors colors = new Colors(layerSettingImage.getColorTable());
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)colors, false);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)colors);
        this._$1 = InternalColors.createInstance(l2, false);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)colors);
        this._$13 = false;
    }

    LayerSettingImage(Layer layer, Layers layers) {
        this._$15 = layer;
        this._$14 = layers;
        this._$13 = true;
    }

    public Colors getColorTable() {
        if (this._$13) {
            long l;
            if (this._$15 == null) {
                String string = InternalResource.loadString("getColorTable()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l2 = InternalHandle.getHandle(this._$15);
            if (l2 == 0L) {
                String string = InternalResource.loadString("getColorTable()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (this._$1 == null && (l = LayerNative.jni_GetColorTable(l2)) != 0L) {
                this._$1 = InternalColors.createInstance(l, false);
            }
        }
        return this._$1;
    }

    public void setColorTable(Colors colors) {
        long l = 0L;
        if (this._$13) {
            if (this._$15 == null) {
                String string = InternalResource.loadString("setColorTable(Colors colorTable)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle(this._$15);
            if (l == 0L) {
                String string = InternalResource.loadString("setColorTable(Colors colorTable)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        }
        if (colors == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)colors) == 0L) {
            String string = InternalResource.loadString("colorTable", "LayerSettingGrid_InvalidColors", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        Colors colors2 = new Colors(colors);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)colors2);
        if (this._$13) {
            LayerNative.jni_GetColorTable(l);
            LayerNative.jni_SetColorTable(l, l2);
        } else if (this._$1 == null) {
            this._$1 = InternalColors.createInstance(l2, false);
        } else {
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)colors2, false);
            InternalColors.changeHandle(this._$1, l2);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)colors2);
    }

    public int getOpaqueRate() {
        if (this._$13) {
            long l = InternalHandle.getHandle(this._$15);
            if (l == 0L) {
                String string = InternalResource.loadString("getRasterOpaqueRate()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            return LayerNative.jni_GetRasterOpaqueRate(l);
        }
        return this._$12;
    }

    public void setOpaqueRate(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > 100) {
            n = 100;
        }
        if (this._$13) {
            long l = InternalHandle.getHandle(this._$15);
            if (l == 0L) {
                String string = InternalResource.loadString("setRasterOpaqueRate(byte value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetRasterOpaqueRate(l, n);
        }
        this._$12 = n;
    }

    public int getContrast() {
        if (this._$13) {
            long l = InternalHandle.getHandle(this._$15);
            if (l == 0L) {
                String string = InternalResource.loadString("getContrast()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            return LayerNative.jni_GetRasterContrast(l);
        }
        return this._$11;
    }

    public void setContrast(int n) {
        if (n < -100 || n > 100) {
            String string = InternalResource.loadString("value", "LayerSettingImage_ContrastMustBeIn(-100~100)", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this._$13) {
            long l = InternalHandle.getHandle(this._$15);
            if (l == 0L) {
                String string = InternalResource.loadString("setContrast(byte value))", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetRasterContrast(l, n);
        }
        this._$11 = n;
    }

    public int getBrightness() {
        if (this._$13) {
            long l = InternalHandle.getHandle(this._$15);
            if (l == 0L) {
                String string = InternalResource.loadString("getBrightness()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            return LayerNative.jni_GetRasterBrightness(l);
        }
        return this._$10;
    }

    public void setBrightness(int n) {
        if (n < -100 || n > 100) {
            String string = InternalResource.loadString("value", "LayerSettingImage_BrightnessMustBeIn(-100~100)", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this._$13) {
            long l = InternalHandle.getHandle(this._$15);
            if (l == 0L) {
                String string = InternalResource.loadString("setBrightness(byte value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetRasterBrightness(l, n);
        }
        this._$10 = n;
    }

    public boolean isTransparent() {
        if (this._$13) {
            long l = InternalHandle.getHandle(this._$15);
            if (l == 0L) {
                String string = InternalResource.loadString("isTransparent()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            return LayerNative.jni_GetRasterIsBackTransparent(l);
        }
        return this._$9;
    }

    public void setTransparent(boolean bl) {
        if (this._$13) {
            long l = InternalHandle.getHandle(this._$15);
            if (l == 0L) {
                String string = InternalResource.loadString("setTransparent(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetRasterBackTransparent(l, bl);
        }
        this._$9 = bl;
    }

    public Color getTransparentColor() {
        if (this._$13) {
            long l = InternalHandle.getHandle(this._$15);
            if (l == 0L) {
                String string = InternalResource.loadString("getTransparentColor()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            int n = LayerNative.jni_GetRasterBackTransparentColor(l);
            return new Color(n);
        }
        return this._$8;
    }

    public void setTransparentColor(Color color) {
        if (this._$13) {
            long l = InternalHandle.getHandle(this._$15);
            if (l == 0L) {
                String string = InternalResource.loadString("setTransparentColor(Color value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetRasterBackTransparentColor(l, color.getRGB());
        }
        this._$8 = new Color(color.getRGB());
    }

    public int[] getDisplayBandIndexes() {
        if (this._$13) {
            long l = InternalHandle.getHandle(this._$15);
            if (l == 0L) {
                String string = InternalResource.loadString("getDisplayBandIndexes()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            return LayerNative.jni_GetDisplayBandIndexes(l);
        }
        return this._$7;
    }

    public void setDisplayBandIndexes(int[] nArray) {
        if (this._$13) {
            long l = InternalHandle.getHandle(this._$15);
            if (l == 0L) {
                String string = InternalResource.loadString("setDisplayBandIndexes(int[] bandIndexes)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (nArray == null) {
                String string = InternalResource.loadString("", "Global_ArgumentNull", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            int n = nArray.length;
            if (!(this._$15.getDataset() instanceof DatasetImage) || ((DatasetImage)this._$15.getDataset()).getBandCount() <= 1) {
                String string = InternalResource.loadString("setDisplayBandIndexes(int[] bandIndexes)", "LayerSettingImage_ThisOperationIsAvailableForMultibandsDataOnly", "mapping_resources");
                throw new IllegalStateException(string);
            }
            int n2 = 0;
            ColorSpaceType colorSpaceType = this.getDisplayColorSpace();
            int n3 = colorSpaceType.value();
            switch (n3) {
                case 2: 
                case 4: {
                    n2 = 4;
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 3;
                    break;
                }
            }
            if (nArray.length != n2) {
                String string = InternalResource.loadString("indexes", "GlobalArgument_OutOfBounds", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            int n4 = ((DatasetImage)this._$15.getDataset()).getBandCount();
            for (int i = 0; i < n; ++i) {
                if (0 <= nArray[i] && n4 > nArray[i]) continue;
                String string = InternalResource.loadString("indexes", "Global_IndexOutOfBounds", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            LayerNative.jni_SetDisplayBandIndexes(l, nArray);
        } else {
            this._$7 = (int[])nArray.clone();
        }
    }

    public ColorSpaceType getDisplayColorSpace() {
        if (this._$13) {
            long l = InternalHandle.getHandle(this._$15);
            if (l == 0L) {
                String string = InternalResource.loadString("getDisplayColorSpace()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            int n = LayerNative.jni_GetDispalayColorSpaceType(l);
            return (ColorSpaceType)InternalEnum.parseUGCValue(ColorSpaceType.class, n);
        }
        return this._$6;
    }

    public void setDisplayColorSpace(ColorSpaceType colorSpaceType) {
        if (this._$13) {
            long l = InternalHandle.getHandle(this._$15);
            if (l == 0L) {
                String string = InternalResource.loadString("setDisplayColorSpace(ColorSpaceType colorSpace)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (!(this._$15.getDataset() instanceof DatasetImage) || ((DatasetImage)this._$15.getDataset()).getBandCount() <= 1) {
                String string = InternalResource.loadString("setDisplayColorSpace(ColorSpaceType colorSpace)", "LayerSettingImage_ThisOperationIsAvailableForMultibandsDataOnly", "mapping_resources");
                throw new IllegalStateException(string);
            }
            int n = 0;
            int n2 = colorSpaceType.value();
            switch (n2) {
                case 2: 
                case 4: {
                    n = 4;
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: {
                    n = 3;
                    break;
                }
            }
            int n3 = colorSpaceType.value();
            LayerNative.jni_SetDispalayColorSpaceType(l, n3);
            if (this.getDisplayBandIndexes() != null) {
                int[] nArray = this.getDisplayBandIndexes();
                if (nArray.length > n) {
                    int[] nArray2 = new int[n];
                    for (int i = 0; i < n; ++i) {
                        nArray2[i] = nArray[i];
                    }
                    this.setDisplayBandIndexes(nArray2);
                } else if (nArray.length < n) {
                    int[] nArray3 = new int[n];
                    for (int i = 0; i < n; ++i) {
                        nArray3[i] = i < nArray.length ? nArray[i] : (nArray.length > 1 ? nArray[nArray.length - 1] : 0);
                    }
                    this.setDisplayBandIndexes(nArray3);
                }
            }
        }
        this._$6 = colorSpaceType;
    }

    public ImageDisplayMode getDisplayMode() {
        if (this._$13) {
            long l = InternalHandle.getHandle(this._$15);
            if (l == 0L) {
                String string = InternalResource.loadString("getDisplayColorSpace()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            int n = LayerNative.jni_GetImageDisplayMode(l);
            return (ImageDisplayMode)InternalEnum.parseUGCValue(ImageDisplayMode.class, n);
        }
        return this._$2;
    }

    public void setDisplayMode(ImageDisplayMode imageDisplayMode) {
        if (this._$13) {
            long l = InternalHandle.getHandle(this._$15);
            if (l == 0L) {
                String string = InternalResource.loadString("setDisplayMode(ImageDisplayMode displayMode)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (!(this._$15.getDataset() instanceof DatasetImage)) {
                String string = InternalResource.loadString("setDisplayMode(ImageDisplayMode displayMode)", "LayerSettingImage_ThisOperationIsAvailableForMultibandsDataOnly", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (((DatasetImage)this._$15.getDataset()).getBandCount() < 2 && imageDisplayMode == ImageDisplayMode.COMPOSITE) {
                String string = InternalResource.loadString("setDisplayMode(ImageDisplayMode displayMode)", "LayerSettingImage_ThisOperationIsAvailableForMultibandsDataOnly", "mapping_resources");
                throw new IllegalStateException(string);
            }
            int n = imageDisplayMode.value();
            LayerNative.jni_SetImageDisplayMode(l, n);
        }
        this._$2 = imageDisplayMode;
    }

    public String[] getAllSubLayers() {
        String[] stringArray = null;
        if (this._$13) {
            long l = InternalHandle.getHandle(this._$15);
            if (l == 0L) {
                String string = InternalResource.loadString("setTransparent(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            String string = "";
            string = LayerNative.jni_getAllSubLayers(l);
            stringArray = string.split(",");
        }
        return stringArray;
    }

    public String[] getVisibleSubLayers() {
        if (this._$13) {
            long l = InternalHandle.getHandle(this._$15);
            if (l == 0L) {
                String string = InternalResource.loadString("setTransparent(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            String string = "";
            string = LayerNative.jni_getVisibleSubLayers(l);
            this._$5 = string.split(",");
        }
        return this._$5;
    }

    public void setVisibleSubLayers(String[] stringArray) {
        if (this._$13) {
            long l = InternalHandle.getHandle(this._$15);
            if (l == 0L) {
                String string = InternalResource.loadString("setTransparent(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            String string = "";
            for (int i = 0; i < stringArray.length; ++i) {
                string = string + stringArray[i];
                string = string + ",";
            }
            LayerNative.jni_setVisibleSubLayers(l, string);
        }
        this._$5 = stringArray;
    }

    public LayerSettingType getType() {
        long l;
        if (this._$13 && (l = InternalHandle.getHandle(this._$15)) == 0L) {
            String string = InternalResource.loadString("getType()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerSettingType.IMAGE;
    }

    public int getTransparentColorTolerance() {
        if (this._$13) {
            long l = InternalHandle.getHandle(this._$15);
            if (l == 0L) {
                String string = InternalResource.loadString("getTransparentColor()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            return LayerNative.jni_GetTransparentColorTolerance(l);
        }
        return this._$4;
    }

    public void setTransparentColorTolerance(int n) {
        if (n < 0 || n > 255) {
            String string = InternalResource.loadString("setTransparentColorTolerance(int value)", "LayerSettingImage_TransparentColorToleranceShouldBetween0And255", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this._$13) {
            long l = InternalHandle.getHandle(this._$15);
            if (l == 0L) {
                String string = InternalResource.loadString("setRasterOpaqueRate(byte value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetTransparentColorTolerance(l, n);
        }
        this._$4 = n;
    }

    public ImageStretchOption getImageStretchOption() {
        if (this._$13) {
            Class<?> clazz;
            Dataset dataset;
            if (this._$3 == null && this._$15 != null && this._$14 != null && (dataset = this._$15.getDataset()) != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset) != 0L && (clazz = dataset.getClass()).equals(DatasetImage.class)) {
                this._$3 = new ImageStretchOption(this._$15, this._$14);
            }
            return this._$3;
        }
        if (this._$3 == null) {
            String string = InternalResource.loadString("getImageStretchOption", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return this._$3;
    }

    public void setImageStretchOption(ImageStretchOption imageStretchOption) {
        if (this._$15 == null || this._$14 == null) {
            String string = InternalResource.loadString("setImageStretchOption(ImageStretchOption imageStretchOption)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.getImageStretchOption() == null) {
            String string = InternalResource.loadString("setImageStretchOption(ImageStretchOption imageStretchOption)", "Layer_UnsupportedOperationOfSetAdditionalSetting", "mapping_resources");
            throw new UnsupportedOperationException(string);
        }
        if (imageStretchOption == null) {
            String string = InternalResource.loadString("imageStretchOption", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this._$3.setStretchType(imageStretchOption.getStretchType());
        this._$3.setStandardDeviationStretchFactor(imageStretchOption.getStandardDeviationStretchFactor());
        this._$3.setGaussianStretchRatioFactor(imageStretchOption.getGaussianStretchRatioFactor());
        this._$3.setGaussianStretchMiddleFactor(imageStretchOption.isGaussianStretchMiddleFactor());
        this._$3.setStandardHistograms(imageStretchOption.getStandardHistograms());
    }

    void clearHandle() {
        this._$15 = null;
        this._$14 = null;
    }
}

