/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoText;
import com.supermap.data.GeoTextNative;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.TextPartNative;

public class TextPart
extends InternalHandleDisposable {
    private Point2D _$4 = null;
    private GeoText _$3 = null;

    public TextPart() {
        long l = TextPartNative.jni_New();
        this.setHandle(l, true);
        this.reset();
    }

    public TextPart(TextPart textPart) {
        if (textPart.getHandle() == 0L) {
            String string = InternalResource.loadString("part", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (textPart._$3 != null) {
            int n = textPart._$3.getTextPartsList().indexOf(textPart);
            if (n == -1) {
                String string = InternalResource.loadString("TextPart(TextPart part)", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            l = GeoTextNative.jni_GetSubHandle(textPart._$3.getHandle(), n);
        } else {
            l = textPart.getHandle();
        }
        long l2 = TextPartNative.jni_Clone(l);
        this.setHandle(l2, true);
        this.setAnchorPoint(textPart.getAnchorPoint());
        textPart.makeSureNativeObjectLive();
    }

    public TextPart(String string, Point2D point2D) {
        long l = TextPartNative.jni_New();
        this.setHandle(l, true);
        this.reset(point2D, 0.0, string);
    }

    public TextPart(String string, Point2D point2D, double d) {
        long l = TextPartNative.jni_New();
        this.setHandle(l, true);
        this.reset(point2D, d, string);
    }

    public TextPart(String string, double d, double d2, double d3) {
        long l = TextPartNative.jni_New();
        this.setHandle(l, true);
        Point2D point2D = new Point2D(d, d2);
        this.reset(point2D, d3, string);
    }

    TextPart(GeoText geoText, int n) {
        if (geoText.getHandle() == 0L) {
            String string = InternalResource.loadString("geoText", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoTextNative.jni_GetSubHandle(geoText.getHandle(), n);
        this.setHandle(l, false);
        this._$3 = geoText;
        geoText.makeSureNativeObjectLive();
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            TextPartNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
        }
    }

    public double getRotation() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRotation()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$3 != null) {
            int n = this._$3.getTextPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getRotation()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            return GeoTextNative.jni_GetSubRotation(this._$3.getHandle(), n);
        }
        return TextPartNative.jni_GetRotation(this.getHandle());
    }

    public void setRotation(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRotation(double rotation)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$3 != null) {
            int n = this._$3.getTextPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setRotation()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            GeoTextNative.jni_SetSubRotation(this._$3.getHandle(), d, n);
        } else {
            TextPartNative.jni_SetRotation(this.getHandle(), d);
        }
    }

    public String getText() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getText()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$3 != null) {
            int n = this._$3.getTextPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getText()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            return GeoTextNative.jni_GetSubText(this._$3.getHandle(), n);
        }
        return TextPartNative.jni_GetText(this.getHandle());
    }

    public void setText(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setText(String text)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            string = "";
        }
        if (this._$3 != null) {
            int n = this._$3.getTextPartsList().indexOf(this);
            if (n == -1) {
                String string3 = InternalResource.loadString("setText()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string3);
            }
            GeoTextNative.jni_SetSubText(this._$3.getHandle(), string, n);
        } else {
            TextPartNative.jni_SetText(this.getHandle(), string);
        }
    }

    public Point2D getAnchorPoint() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAnchorPoint()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$3 != null) {
            int n = this._$3.getTextPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getAnchorPoint()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = new double[2];
            TextPartNative.jni_GetSubAnchor(this._$3.getHandle(), dArray, n);
            return new Point2D(dArray[0], dArray[1]);
        }
        return this._$4;
    }

    public void setAnchorPoint(Point2D point2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAnchorPoint(Point2D anchorPoint)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$3 != null) {
            int n = this._$3.getTextPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getAnchorPoint()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            TextPartNative.jni_SetSubAnchor(this._$3.getHandle(), point2D.getX(), point2D.getY(), n);
        } else {
            this._$4 = point2D.clone();
        }
    }

    public double getX() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getX()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$3 != null) {
            int n = this._$3.getTextPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getAnchorPoint()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = new double[2];
            TextPartNative.jni_GetSubAnchor(this._$3.getHandle(), dArray, n);
            return dArray[0];
        }
        return this._$4.getX();
    }

    public double getY() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getY()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$3 != null) {
            int n = this._$3.getTextPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getAnchorPoint()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = new double[2];
            TextPartNative.jni_GetSubAnchor(this._$3.getHandle(), dArray, n);
            return dArray[1];
        }
        return this._$4.getY();
    }

    public void setX(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setX(double x)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$3 != null) {
            int n = this._$3.getTextPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getAnchorPoint()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            TextPartNative.jni_SetSubAnchor(this._$3.getHandle(), d, this.getY(), n);
        } else {
            this._$4.setX(d);
        }
    }

    public void setY(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setY(double y)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$3 != null) {
            int n = this._$3.getTextPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getAnchorPoint()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            TextPartNative.jni_SetSubAnchor(this._$3.getHandle(), this.getX(), d, n);
        } else {
            this._$4.setY(d);
        }
    }

    public void offset(double d, double d2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("offset(double dx, double dy)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double d3 = this.getX() + d;
        double d4 = this.getY() + d2;
        if (this._$3 != null) {
            int n = this._$3.getTextPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getAnchorPoint()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            TextPartNative.jni_SetSubAnchor(this._$3.getHandle(), d3, d4, n);
        } else {
            this._$4.setX(d3);
            this._$4.setY(d4);
        }
    }

    public TextPart clone() {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$3 != null && (n = this._$3.getTextPartsList().indexOf(this)) == -1) {
            String string = InternalResource.loadString("getAnchorPoint()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new TextPart(this);
    }

    void reset() {
        this.reset(new Point2D(0.0, 0.0), 0.0, "");
    }

    void reset(Point2D point2D, double d, String string) {
        this.setAnchorPoint(point2D);
        this.setRotation(d);
        this.setText(string);
    }
}

