/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.MaterialNative;
import java.awt.Color;

public class Material
extends InternalHandleDisposable {
    public Material() {
        long l = MaterialNative.jni_New();
        this.setHandle(l, true);
    }

    public Material(Material material) {
        this(material, true);
    }

    protected Material(Material material, boolean bl) {
        if (material == null) {
            String string = InternalResource.loadString("Material", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (material.getHandle() == 0L) {
            String string = InternalResource.loadString("Material", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = MaterialNative.jni_Clone(material.getHandle());
        this.setHandle(l, bl);
    }

    public boolean toStreamFile(String string) {
        return MaterialNative.jni_ToStreamFile(this.getHandle(), string);
    }

    protected Material(long l) {
        this.setHandle(l, false);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            MaterialNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public Color getAmbient() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAmbient", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Color color = new Color(MaterialNative.jni_GetAmbient(this.getHandle()), true);
        return color;
    }

    public void setAmbient(Color color) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAmbient", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (color == null) {
            String string = InternalResource.loadString("setAmbient", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        MaterialNative.jni_SetAmbient(this.getHandle(), color.getRGB());
    }

    public Color getDiffuse() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDiffuse", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Color color = new Color(MaterialNative.jni_GetDiffuse(this.getHandle()), true);
        return color;
    }

    public void setDiffuse(Color color) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDiffuse", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (color == null) {
            String string = InternalResource.loadString("setDiffuse", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        MaterialNative.jni_SetDiffuse(this.getHandle(), color.getRGB());
    }

    public Color getSpecular() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSpecular", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Color color = new Color(MaterialNative.jni_GetSpecular(this.getHandle()), true);
        return color;
    }

    public void setSpecular(Color color) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSpecular", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (color == null) {
            String string = InternalResource.loadString("setSpecular", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        MaterialNative.jni_SetSpecular(this.getHandle(), color.getRGB());
    }

    public Color getEmission() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getEmission", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Color color = new Color(MaterialNative.jni_GetEmission(this.getHandle()), true);
        return color;
    }

    public void setEmission(Color color) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEmission", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (color == null) {
            String string = InternalResource.loadString("setEmission", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        MaterialNative.jni_SetEmission(this.getHandle(), color.getRGB());
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getName()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return MaterialNative.jni_GetName(this.getHandle());
    }

    public void setName(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setName(String value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            String string3 = InternalResource.loadString("setName", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        MaterialNative.jni_SetName(this.getHandle(), string);
    }

    public double getShininess() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCameraDistanceZ()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return MaterialNative.jni_GetShininess(this.getHandle());
    }

    public void setShininess(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCameraDistanceZ(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        MaterialNative.jni_SetShininess(this.getHandle(), d);
    }

    public String getTextureFile() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTgetTextureFile()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return MaterialNative.jni_GetTextureFile(this.getHandle());
    }

    public void setTextureFile(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setTgetTextureFile(String value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            String string3 = InternalResource.loadString("setTgetTextureFile", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        MaterialNative.jni_SetTextureFile(this.getHandle(), string);
    }
}

