/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoLine;
import com.supermap.data.GeoRectangleNative;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.Rectangle2D;

public class GeoRectangle
extends Geometry {
    public GeoRectangle() {
        long l = GeoRectangleNative.jni_New();
        this.setHandle(l, true);
    }

    public GeoRectangle(GeoRectangle geoRectangle) {
        if (geoRectangle == null) {
            String string = InternalResource.loadString("geoRectangle", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geoRectangle);
        if (l == 0L) {
            String string = InternalResource.loadString("GeoRectangle geoRectangle", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l2 = GeoRectangleNative.jni_Clone(l);
        this.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoRectangle);
    }

    public GeoRectangle(Point2D point2D, double d, double d2, double d3) {
        if (d <= 0.0) {
            String string = InternalResource.loadString("width", "GeoRectangleWidthShouldPositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d2 <= 0.0) {
            String string = InternalResource.loadString("height", "GeoRectangleHeightShouldPositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoRectangleNative.jni_New1(point2D.getX(), point2D.getY(), d, d2, d3);
        this.setHandle(l, true);
    }

    public GeoRectangle(Rectangle2D rectangle2D, double d) {
        if (rectangle2D.getWidth() <= 0.0) {
            String string = InternalResource.loadString("rectangle width", "GeoRectangleWidthShouldPositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (rectangle2D.getHeight() <= 0.0) {
            String string = InternalResource.loadString("rectangle height", "GeoRectangleWidthShouldPositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoRectangleNative.jni_New2(rectangle2D.getLeft(), rectangle2D.getRight(), rectangle2D.getTop(), rectangle2D.getBottom(), d);
        this.setHandle(l, true);
    }

    GeoRectangle(long l) {
        this.setHandle(l, false);
    }

    public GeoLine convertToLine() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertToLine()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoRectangleNative.jni_ConvertToLine(this.getHandle());
        GeoLine geoLine = null;
        if (l != 0L) {
            geoLine = new GeoLine(l);
            geoLine.setIsDisposable(true);
        }
        return geoLine;
    }

    public GeoRegion convertToRegion() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertToRegion()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoRectangleNative.jni_ConvertToRegion(this.getHandle());
        GeoRegion geoRegion = null;
        if (l != 0L) {
            geoRegion = new GeoRegion(l);
            geoRegion.setIsDisposable(true);
        }
        return geoRegion;
    }

    public Point2D getCenter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCenter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        GeoRectangleNative.jni_GetCenter(this.getHandle(), dArray);
        return new Point2D(dArray[0], dArray[1]);
    }

    public void setCenter(Point2D point2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCenter(Point2D value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoRectangleNative.jni_SetCenter(this.getHandle(), point2D.getX(), point2D.getY());
    }

    public double getWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getWidth()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRectangleNative.jni_GetWidth(this.getHandle());
    }

    public void setWidth(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setWidth(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("value", "GeoRectangleWidthShouldPositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoRectangleNative.jni_SetWidth(this.getHandle(), d);
    }

    public double getHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHeight()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRectangleNative.jni_GetHeight(this.getHandle());
    }

    public void setHeight(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setHeight(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("value", "GeoRectangleHeightShouldPositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoRectangleNative.jni_SetHeight(this.getHandle(), d);
    }

    public double getRotation() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRotation()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRectangleNative.jni_GetAngle(this.getHandle());
    }

    public void setRotation(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRotation(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoRectangleNative.jni_SetAngle(this.getHandle(), d);
    }

    public double getArea() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getArea()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRectangleNative.jni_getArea(this.getHandle());
    }

    public double getPerimeter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPerimeter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRectangleNative.jni_getPerimeter(this.getHandle());
    }

    public GeoRectangle clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoRectangle(this);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoRectangleNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    protected void clearHandle() {
        super.clearHandle();
    }
}

