/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoMapBorder;
import com.supermap.data.GeoMapGrid;
import com.supermap.data.GeoMapNative;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;

public class GeoMap
extends Geometry {
    private Geometry _$7;
    private GeoMapBorder _$6;
    private GeoMapGrid _$5;

    public GeoMap() {
        long l = GeoMapNative.jni_New();
        this.setHandle(l, true);
    }

    public GeoMap(GeoMap geoMap) {
        if (geoMap == null) {
            String string = InternalResource.loadString("geoMap", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(geoMap);
        if (l == 0L) {
            String string = InternalResource.loadString("geoMap", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoMapNative.jni_Clone(l);
        this.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoMap);
    }

    public GeoMap(String string, Geometry geometry) {
        if (geometry == null) {
            String string2 = InternalResource.loadString("shape", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string2);
        }
        int n = geometry.getType().value();
        boolean bl = false;
        switch (n) {
            case 5: 
            case 12: 
            case 13: 
            case 15: 
            case 20: 
            case 21: {
                bl = true;
                break;
            }
        }
        if (!bl) {
            String string3 = InternalResource.loadString("shape", "GeoMap_UnsupprotGeometryType", "data_resources");
            throw new UnsupportedOperationException(string3);
        }
        long l = GeoMapNative.jni_New();
        this.setHandle(l, true);
        this.setMapName(string);
        this.setShape(geometry);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
    }

    public GeoMap(String string) {
        long l = GeoMapNative.jni_New();
        this.setHandle(l, true);
        this.setMapXML(string);
    }

    GeoMap(long l) {
        this.setHandle(l, false);
    }

    public Geometry getShape() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getShape()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$7 == null) {
            long l = GeoMapNative.jni_GetShape(this.getHandle());
            if (l != 0L) {
                this._$7 = Geometry.createInstance(l);
                InternalHandleDisposable.setIsDisposable(this._$7, false);
            }
        } else {
            long l = GeoMapNative.jni_GetShape(this.getHandle());
            this._$7.clearHandle();
            this._$7.refreshHandle(l);
        }
        return this._$7;
    }

    public void setShape(Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setShape(Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = geometry.getType().value();
        boolean bl = false;
        switch (n) {
            case 5: 
            case 12: 
            case 13: 
            case 15: 
            case 20: 
            case 21: {
                bl = true;
                break;
            }
        }
        if (!bl) {
            String string = InternalResource.loadString("geometry", "GeoMap_UnsupprotGeometryType", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        long l = InternalHandleDisposable.getHandle(geometry);
        GeoMapNative.jni_SetShape(this.getHandle(), l);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
    }

    public String getMapName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMapName()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapNative.jni_GetMapName(this.getHandle());
    }

    public void setMapName(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setMapName(String mapName)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        GeoMapNative.jni_SetMapName(this.getHandle(), string);
    }

    public GeoMapBorder getMapBorder() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMapBorder()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$6 == null && (l = GeoMapNative.jni_GetMapBorder(this.getHandle())) != 0L) {
            this._$6 = new GeoMapBorder(l);
        }
        return this._$6;
    }

    public void setMapBorder(GeoMapBorder geoMapBorder) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMapBorder(GeoMapBorder geoMapBorder)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geoMapBorder == null) {
            String string = InternalResource.loadString("geoMapBorder", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (geoMapBorder.getHandle() == 0L) {
            String string = InternalResource.loadString("geoMapBorder", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapNative.jni_SetMapBorder(this.getHandle(), geoMapBorder.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geoMapBorder);
    }

    public boolean isBorderVisible() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isBorderVisible()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapNative.jni_IsBorderVisible(this.getHandle());
    }

    public void setBorderVisible(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBorderVisible()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapNative.jni_SetBorderVisible(this.getHandle(), bl);
    }

    public boolean isGridVisible() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isMarginVisible()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapNative.jni_IsGridVisible(this.getHandle());
    }

    public void setGridVisible(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMarginVisible()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapNative.jni_SetGridVisible(this.getHandle(), bl);
    }

    public GeoMapGrid getMapGrid() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMapGrid()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$5 == null && (l = GeoMapNative.jni_GetMapGrid(this.getHandle())) != 0L) {
            this._$5 = new GeoMapGrid(l);
        }
        return this._$5;
    }

    public void setMapGrid(GeoMapGrid geoMapGrid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMapMargin(GeoMapMargin geoMapMargin)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geoMapGrid == null) {
            String string = InternalResource.loadString("geoMapMargin", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (geoMapGrid.getHandle() == 0L) {
            String string = InternalResource.loadString("geoMapMargin", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapNative.jni_SetMapGrid(this.getHandle(), geoMapGrid.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geoMapGrid);
    }

    public GeoMap clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoMap(this);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoMapNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public double getMapScale() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMapScale()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapNative.jni_GetMapScale(this.getHandle());
    }

    public void setMapScale(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMapScale(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("value", "ValueShouldNotBeNeagtive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapNative.jni_SetMapScale(this.getHandle(), d);
    }

    public double getMapAngle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMapAngle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapNative.jni_GetMapAngle(this.getHandle());
    }

    public void setMapAngle(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMapAngle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapNative.jni_SetMapAngle(this.getHandle(), d);
    }

    public Point2D getMapCenter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCenter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        GeoMapNative.jni_GetMapCenter(this.getHandle(), dArray);
        return new Point2D(dArray[0], dArray[1]);
    }

    public void setMapCenter(Point2D point2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCenter(Point2D value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapNative.jni_SetMapCenter(this.getHandle(), point2D.getX(), point2D.getY());
    }

    public String getMapXML() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMapXML()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapNative.jni_GetMapXML(this.getHandle());
    }

    public void setMapXML(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setMapXML(String mapXML)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        GeoMapNative.jni_SetMapXML(this.getHandle(), string);
    }

    protected static void clearHandle(GeoMap geoMap) {
        geoMap.clearHandle();
    }

    protected void clearHandle() {
        if (this._$7 != null) {
            this._$7.clearHandle();
            this._$7 = null;
        }
        if (this._$6 != null) {
            this._$6.clearHandle();
            this._$6 = null;
        }
        if (this._$5 != null) {
            this._$5.clearHandle();
            this._$5 = null;
        }
        this.setHandle(0L);
    }
}

