/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.CursorType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.Domain;
import com.supermap.data.DomainManagerNative;
import com.supermap.data.DomainNative;
import com.supermap.data.DomainType;
import com.supermap.data.Enum;
import com.supermap.data.FieldInfo;
import com.supermap.data.FieldInfos;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalResource;
import com.supermap.data.Recordset;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainManager
extends InternalHandle {
    private Datasource _$3;
    private ArrayList<Domain> _$2;

    protected DomainManager(long l, Datasource datasource) {
        this.setHandle(l);
        this._$3 = datasource;
        this._$2 = new ArrayList();
        long[] lArray = DomainManagerNative.jni_GetAllDomain(this.getHandle());
        for (int i = 0; i < lArray.length; ++i) {
            int n = DomainNative.jni_GetType(lArray[i]);
            DomainType domainType = (DomainType)Enum.parseUGCValue(DomainType.class, n);
            Domain domain = Domain.CreateInstance(lArray[i], domainType);
            if (null == domain) continue;
            this._$2.add(domain);
        }
    }

    public Domain getDomain(DatasetVector datasetVector, String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string.isEmpty()) {
            String string3 = InternalResource.loadString(string, "Recordset_FieldIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        if (null == datasetVector) {
            String string4 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string4);
        }
        long l = DomainManagerNative.jni_GetDomain(this.getHandle(), datasetVector.getHandle(), string);
        if (l == 0L) {
            return null;
        }
        int n = DomainNative.jni_GetType(l);
        DomainType domainType = (DomainType)Enum.parseUGCValue(DomainType.class, n);
        Domain domain = Domain.CreateInstance(l, domainType);
        return domain;
    }

    public boolean setDomain(DatasetVector datasetVector, String string, Domain domain) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string.isEmpty()) {
            String string3 = InternalResource.loadString(string, "Recordset_FieldIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        if (null == datasetVector) {
            String string4 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string4);
        }
        long l = 0L;
        if (domain != null) {
            l = domain.getHandle();
        }
        return DomainManagerNative.jni_SetDomain(this.getHandle(), datasetVector.getHandle(), string, l);
    }

    public ArrayList<Integer> checkFieldValues(DatasetVector datasetVector, String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Domain domain = this.getDomain(datasetVector, string);
        if (domain != null) {
            Recordset recordset = datasetVector.getRecordset(false, CursorType.STATIC);
            recordset.moveFirst();
            FieldInfos fieldInfos = datasetVector.getFieldInfos();
            FieldInfo fieldInfo = fieldInfos.get(string);
            while (!recordset.isEOF()) {
                Object object = recordset.getFieldValue(string);
                if (object == null && !fieldInfo.isRequired()) {
                    recordset.moveNext();
                    continue;
                }
                if (!domain.check(object)) {
                    arrayList.add(recordset.getID());
                }
                recordset.moveNext();
            }
            recordset.dispose();
        }
        return arrayList;
    }

    @Override
    protected void clearHandle() {
        this.setHandle(0L);
        this._$3 = null;
        if (null != this._$2) {
            int n = this._$2.size();
            for (int i = 0; i < n; ++i) {
                this._$2.get(i).clearHandle();
            }
            this._$2.clear();
            this._$2 = null;
        }
    }
}

