/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.EncodeType;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.Workspace;
import com.supermap.data.WorkspaceConnectionInfo;
import com.supermap.data.conversion.DataType;
import com.supermap.data.conversion.ImportDataInfos;
import com.supermap.data.conversion.ImportSetting;
import com.supermap.data.conversion.ImportSettingWORNative;
import com.supermap.data.conversion.InternalResource;
import com.supermap.data.conversion.InternalWorkspaceConnectionInfo;

public class ImportSettingWOR
extends ImportSetting {
    WorkspaceConnectionInfo m_info;
    Workspace m_workspace;

    public ImportSettingWOR() {
        this.setHandle(ImportSettingWORNative.jni_New(), true);
        super.setDataType(DataType.WOR);
    }

    public ImportSettingWOR(ImportSettingWOR importSettingWOR) {
        this();
        super.setSourceFilePath(importSettingWOR.getSourceFilePath());
        this.setTargetWorkspaceConnectionInfo(importSettingWOR.getTargetWorkspaceConnectionInfo());
        super.setTargetDatasourceConnectionInfo(importSettingWOR.getTargetDatasourceConnectionInfo());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)importSettingWOR));
    }

    public ImportSettingWOR(String string, DatasourceConnectionInfo datasourceConnectionInfo, WorkspaceConnectionInfo workspaceConnectionInfo) {
        this();
        super.setSourceFilePath(string);
        this.setTargetWorkspaceConnectionInfo(workspaceConnectionInfo);
        super.setTargetDatasourceConnectionInfo(datasourceConnectionInfo);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)datasourceConnectionInfo);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)workspaceConnectionInfo);
    }

    public ImportSettingWOR(String string, Datasource datasource, Workspace workspace) {
        this();
        super.setSourceFilePath(string);
        this.setTargetWorkspace(workspace);
        super.setTargetDatasource(datasource);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)workspace);
    }

    public WorkspaceConnectionInfo getTargetWorkspaceConnectionInfo() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTargetWorkspaceConnectionInfo()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return this.m_info;
    }

    public void setTargetWorkspaceConnectionInfo(WorkspaceConnectionInfo workspaceConnectionInfo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTargetWorkspaceConnectionInfo(WorkspaceConnectionInfo info)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (workspaceConnectionInfo == null) {
            if (this.m_info != null) {
                InternalWorkspaceConnectionInfo.clearHandle(this.m_info);
                this.m_info = null;
            }
        } else {
            this.setTargetWorkspace(null);
            this.m_info = this.cloneWorkspaceConnectionInfo(workspaceConnectionInfo);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)workspaceConnectionInfo);
    }

    public Workspace getTargetWorkspace() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTargetWorkspace()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return this.m_workspace;
    }

    public void setTargetWorkspace(Workspace workspace) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTargetWorkspace(Workspace workspace)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        this.m_workspace = workspace;
        if (this.m_workspace != null) {
            this.setTargetWorkspaceConnectionInfo(null);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)workspace);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "conversion_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ImportSettingWORNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public ImportDataInfos getTargetDataInfos(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("getSourceDataInfos()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string2);
        }
        if (this.m_dataInfos == null) {
            this.m_dataInfos = new ImportDataInfos(this.getHandle(), this.getSourceFileType(), DataType.WOR, this.getSourceFilePath(), "");
        }
        return this.m_dataInfos;
    }

    public ImportDataInfos getTargetDataInfos(String string, EncodeType encodeType, PrjCoordSys prjCoordSys) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("getSourceDataInfos()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string2);
        }
        if (this.m_dataInfos == null) {
            this.m_dataInfos = new ImportDataInfos(this.getHandle(), this.getSourceFileType(), DataType.WOR, this.getSourceFilePath(), "");
        }
        return this.m_dataInfos;
    }

    public void setTargetDataInfos(ImportDataInfos importDataInfos) {
        this.m_dataInfos = importDataInfos;
    }

    @Deprecated
    public PrjCoordSys getTargetPrjCoordSys() {
        return null;
    }

    @Deprecated
    public void setTargetPrjCoordSys(PrjCoordSys prjCoordSys) {
    }

    @Deprecated
    public EncodeType getEncodeType() {
        return null;
    }

    @Deprecated
    public void setEncodeType(EncodeType encodeType) {
    }

    WorkspaceConnectionInfo cloneWorkspaceConnectionInfo(WorkspaceConnectionInfo workspaceConnectionInfo) {
        long l = InternalHandle.getHandle((InternalHandle)workspaceConnectionInfo);
        long l2 = ImportSettingWORNative.jni_CloneWorkspaceConnectionInfo(l);
        WorkspaceConnectionInfo workspaceConnectionInfo2 = InternalWorkspaceConnectionInfo.createInstance(l2);
        InternalHandleDisposable.setIsDisposable((InternalHandleDisposable)workspaceConnectionInfo2, (boolean)true);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)workspaceConnectionInfo);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)workspaceConnectionInfo2);
        return workspaceConnectionInfo2;
    }

    public void setImportEmptyDataset(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportEmptyDataset()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingWORNative.jni_SetImportEmptyDT(this.getHandle(), bl);
    }

    public boolean isImportEmptyDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImportEmptyDataset()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingWORNative.jni_IsImportEmptyDT(this.getHandle());
    }
}

