/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.SimpleWebApplicationServiceImpl;
import org.jasig.cas.services.UnauthorizedServiceException;
import org.jasig.cas.ticket.TicketException;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public final class ProxyController
extends AbstractController {
    private static final String CONST_PROXY_FAILURE = "casProxyFailureView";
    private static final String CONST_PROXY_SUCCESS = "casProxySuccessView";
    private static final String MODEL_SERVICE_TICKET = "ticket";
    @NotNull
    private CentralAuthenticationService centralAuthenticationService;

    public ProxyController() {
        this.setCacheSeconds(0);
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String ticket = request.getParameter("pgt");
        Service targetService = this.getTargetService(request);
        if (!StringUtils.hasText((String)ticket) || targetService == null) {
            return this.generateErrorView("INVALID_REQUEST", "INVALID_REQUEST_PROXY", null);
        }
        try {
            return new ModelAndView(CONST_PROXY_SUCCESS, MODEL_SERVICE_TICKET, (Object)this.centralAuthenticationService.grantServiceTicket(ticket, targetService));
        }
        catch (TicketException e) {
            return this.generateErrorView(e.getCode(), e.getCode(), new Object[]{ticket});
        }
        catch (UnauthorizedServiceException unauthorizedServiceException) {
            return this.generateErrorView("UNAUTHORIZED_SERVICE", "UNAUTHORIZED_SERVICE_PROXY", new Object[]{targetService});
        }
    }

    private Service getTargetService(HttpServletRequest request) {
        return SimpleWebApplicationServiceImpl.createServiceFrom(request);
    }

    private ModelAndView generateErrorView(String code, String description, Object[] args) {
        ModelAndView modelAndView = new ModelAndView(CONST_PROXY_FAILURE);
        modelAndView.addObject("code", (Object)code);
        modelAndView.addObject("description", (Object)this.getMessageSourceAccessor().getMessage(description, args, description));
        return modelAndView;
    }

    public void setCentralAuthenticationService(CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }
}

