/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.support;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.aspect.LogAspect;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.TicketState;
import org.slf4j.Logger;
import org.springframework.util.Assert;

public final class MultiTimeUseOrTimeoutExpirationPolicy
implements ExpirationPolicy {
    private static final long serialVersionUID = 3257844372614558261L;
    private final long timeToKillInMilliSeconds;
    private final int numberOfUses;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public MultiTimeUseOrTimeoutExpirationPolicy(int numberOfUses, long timeToKillInMilliSeconds) {
        this.timeToKillInMilliSeconds = timeToKillInMilliSeconds;
        this.numberOfUses = numberOfUses;
        Assert.isTrue((this.numberOfUses > 0 ? 1 : 0) != 0, (String)"numberOfUsers must be greater than 0.");
        Assert.isTrue((this.timeToKillInMilliSeconds > 0L ? 1 : 0) != 0, (String)"timeToKillInMilliseconds must be greater than 0.");
    }

    public MultiTimeUseOrTimeoutExpirationPolicy(int numberOfUses, long timeToKill, TimeUnit timeUnit) {
        this(numberOfUses, timeUnit.toMillis(timeToKill));
    }

    @Override
    public boolean isExpired(TicketState ticketState) {
        TicketState ticketState2 = ticketState;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ticketState2);
        return Conversions.booleanValue((Object)MultiTimeUseOrTimeoutExpirationPolicy.isExpired_aroundBody1$advice(this, ticketState2, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint));
    }

    static {
        MultiTimeUseOrTimeoutExpirationPolicy.ajc$preClinit();
    }

    private static final /* synthetic */ boolean isExpired_aroundBody0(MultiTimeUseOrTimeoutExpirationPolicy ajc$this, TicketState ticketState, JoinPoint joinPoint) {
        return ticketState == null || ticketState.getCountOfUses() >= ajc$this.numberOfUses || System.currentTimeMillis() - ticketState.getLastTimeUsed() >= ajc$this.timeToKillInMilliSeconds;
    }

    private static final /* synthetic */ Object isExpired_aroundBody1$advice(MultiTimeUseOrTimeoutExpirationPolicy ajc$this, TicketState ticketState, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            object = returnVal = Conversions.booleanObject((boolean)MultiTimeUseOrTimeoutExpirationPolicy.isExpired_aroundBody0(ajc$this, ticketState, (JoinPoint)proceedingJoinPoint2));
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return object;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MultiTimeUseOrTimeoutExpirationPolicy.java", MultiTimeUseOrTimeoutExpirationPolicy.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isExpired", "org.jasig.cas.ticket.support.MultiTimeUseOrTimeoutExpirationPolicy", "org.jasig.cas.ticket.TicketState", "ticketState", "", "boolean"), 60);
    }
}

