/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.data.Dataset;
import com.supermap.data.TextStyle;
import com.supermap.realspace.GraduatedMode3D;
import com.supermap.realspace.InternalEnum;
import com.supermap.realspace.InternalHandle;
import com.supermap.realspace.InternalHandleDisposable;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.InternalTextStyle;
import com.supermap.realspace.Layer3DDataset;
import com.supermap.realspace.Theme3D;
import com.supermap.realspace.Theme3DGraphItem;
import com.supermap.realspace.Theme3DGraphNative;
import com.supermap.realspace.Theme3DGraphTextFormat;
import com.supermap.realspace.Theme3DGraphType;
import java.util.ArrayList;

public class Theme3DGraph
extends Theme3D {
    private ArrayList _$2;
    private TextStyle _$1 = null;

    public Theme3DGraph() {
        long l = Theme3DGraphNative.jni_new();
        this.setHandle(l, true);
        this._$2 = new ArrayList();
    }

    public Theme3DGraph(Theme3DGraph theme3DGraph) {
        if (theme3DGraph == null) {
            String string = InternalResource.loadString("theme3DGraph", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (theme3DGraph.getHandle() == 0L) {
            String string = InternalResource.loadString("theme3DGraph", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = Theme3DGraphNative.jni_clone(theme3DGraph.getHandle());
        this.setHandle(l, true);
        this._$2 = new ArrayList();
        int n = theme3DGraph.getGraphItemsList().size();
        long[] lArray = new long[n];
        Theme3DGraphNative.jni_getItemHandles(this.getHandle(), lArray);
        for (int i = 0; i < n; ++i) {
            long l2 = lArray[i];
            Theme3DGraphItem theme3DGraphItem = new Theme3DGraphItem(l2, this);
            this._$2.add(theme3DGraphItem);
        }
    }

    Theme3DGraph(long l, Layer3DDataset layer3DDataset, boolean bl) {
        this.setHandle(l, bl);
        this._$2 = new ArrayList();
        int n = this.getCount();
        long[] lArray = new long[n];
        Theme3DGraphNative.jni_getItemHandles(this.getHandle(), lArray);
        for (int i = 0; i < n; ++i) {
            long l2 = lArray[i];
            Theme3DGraphItem theme3DGraphItem = new Theme3DGraphItem(l2, this);
            this._$2.add(theme3DGraphItem);
        }
        this.m_layer3DDataset = layer3DDataset;
    }

    public Theme3DGraphItem getItem(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n2 = this.getCount();
        if (n < 0 || n >= n2) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        return (Theme3DGraphItem)((Object)this._$2.get(n));
    }

    public void setItem(int n, Theme3DGraphItem theme3DGraphItem) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n2 = Theme3DGraphNative.jni_getCount(this.getHandle());
        if (n < 0 || n >= n2) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        Theme3DGraphItem theme3DGraphItem2 = new Theme3DGraphItem(theme3DGraphItem);
        long l = com.supermap.data.InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)theme3DGraphItem2);
        Theme3DGraphNative.jni_setItem(this.getHandle(), n, l);
        long l2 = Theme3DGraphNative.jni_getItem(this.getHandle(), n);
        Theme3DGraphItem theme3DGraphItem3 = new Theme3DGraphItem(l2, this);
        this._$2.set(n, theme3DGraphItem3);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)theme3DGraphItem));
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = Theme3DGraphNative.jni_getCount(this.getHandle());
        return n;
    }

    public Theme3DGraphType getGraph3DType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getType()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = Theme3DGraphNative.jni_getGraphType(this.getHandle());
        return (Theme3DGraphType)InternalEnum.parseUGCValue(Theme3DGraphType.class, n);
    }

    public void setGraph3DType(Theme3DGraphType theme3DGraphType) {
        if (theme3DGraphType == null) {
            String string = InternalResource.loadString("theme3DGraphType", "Theme3DGraphType_ShouldNotBeNull", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setType()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(theme3DGraphType);
        Theme3DGraphNative.jni_setGraphType(this.getHandle(), n);
    }

    public double getBarWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBarWidth()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Theme3DGraphNative.jni_getBarWidth(this.getHandle());
    }

    public void setBarWidth(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBarWidth(int value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("value", "Argument_ShouldBePositive", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        Theme3DGraphNative.jni_setBarWidth(this.getHandle(), d);
    }

    public double getStartAngle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStartAngle()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Theme3DGraphNative.jni_getStartAngle(this.getHandle());
    }

    public void setStartAngle(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStartAngle(int value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Theme3DGraphNative.jni_setStartAngle(this.getHandle(), d);
    }

    public TextStyle getGraph3DTextStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGraphTextStyle()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this._$1 == null && (l = Theme3DGraphNative.jni_getGraphTextStyle(this.getHandle())) != 0L) {
            this._$1 = InternalTextStyle.createInstance(l);
        }
        return this._$1;
    }

    public void setGraph3DTextStyle(TextStyle textStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGraphTextStyle(TextStyle textStyle)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (textStyle == null) {
            String string = InternalResource.loadString("textStyle", "Handle_UndisposableObject", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)textStyle);
        if (l == 0L) {
            String string = InternalResource.loadString("textStyle", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        TextStyle textStyle2 = textStyle.clone();
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)textStyle2);
        Theme3DGraphNative.jni_setGraphTextStyle(this.getHandle(), l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)textStyle);
    }

    public Theme3DGraphTextFormat getGraph3DTextFormat() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGraphTextFormat()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = Theme3DGraphNative.jni_getGraphTextFormat(this.getHandle());
        return (Theme3DGraphTextFormat)InternalEnum.parseUGCValue(Theme3DGraphTextFormat.class, n);
    }

    public void setGraph3DTextFormat(Theme3DGraphTextFormat theme3DGraphTextFormat) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGraphTextFormat()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(theme3DGraphTextFormat);
        Theme3DGraphNative.jni_setGraphTextFormat(this.getHandle(), n);
    }

    public boolean isGraph3DTextDisplayed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isGraphTextDisplayed()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Theme3DGraphNative.jni_isGraphTextDisplayed(this.getHandle());
    }

    public void setGraph3DTextDisplayed(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGraphTextDisplayed()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Theme3DGraphNative.jni_setGraphTextDisplayed(this.getHandle(), bl);
    }

    public double getMinGraphSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMinGraphSize()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Theme3DGraphNative.jni_getMinGraphSize(this.getHandle());
    }

    public void setMinGraphSize(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMinGraphSize()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("value", "Argument_ShouldBePositive", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        Theme3DGraphNative.jni_setMinGraphSize(this.getHandle(), d);
    }

    public double getMaxGraphSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMaxGraphSize()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Theme3DGraphNative.jni_getMaxGraphSize(this.getHandle());
    }

    public void setMaxGraphSize(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMaxGraphSize()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Theme3DGraphNative.jni_setMaxGraphSize(this.getHandle(), d);
    }

    public GraduatedMode3D getGraduatedMode3D() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGraphTextFormat()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = Theme3DGraphNative.jni_getGraduatedMode(this.getHandle());
        return (GraduatedMode3D)InternalEnum.parse(GraduatedMode3D.class, (int)n);
    }

    public void setGraduatedMode3D(GraduatedMode3D graduatedMode3D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGraduatedMode", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (graduatedMode3D == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        int n = InternalEnum.getUGCValue(graduatedMode3D);
        Theme3DGraphNative.jni_setGraduatedMode(this.getHandle(), n);
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Theme3DGraphNative.jni_clear(this.getHandle());
        if (this._$2 != null) {
            this._$2();
        }
        this._$1();
    }

    public int add(Theme3DGraphItem theme3DGraphItem) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (theme3DGraphItem == null) {
            String string = InternalResource.loadString("item", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        int n = theme3DGraphItem.getMemoryDoubleValues().length;
        if (n > 0 && n != this.getMemoryKeys().length) {
            String string = InternalResource.loadString("item", "Theme3DGraph_TheLengthOfMemoryDoubleValuesShouldBeEqualsWithTheLengthOfMemoryKeys", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        Theme3DGraphItem theme3DGraphItem2 = new Theme3DGraphItem(theme3DGraphItem);
        long l = com.supermap.data.InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)theme3DGraphItem2);
        int n2 = Theme3DGraphNative.jni_add(this.getHandle(), l);
        if (n2 != -1) {
            long l2 = Theme3DGraphNative.jni_getItem(this.getHandle(), n2);
            Theme3DGraphItem theme3DGraphItem3 = new Theme3DGraphItem(l2, this);
            this._$2.add(theme3DGraphItem3);
            this._$3();
            this._$1();
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)theme3DGraphItem));
        return n2;
    }

    public boolean insert(int n, Theme3DGraphItem theme3DGraphItem) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n2 = this.getCount();
        if (n < 0 || n > n2) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (theme3DGraphItem == null) {
            String string = InternalResource.loadString("item", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (theme3DGraphItem.getMemoryDoubleValues().length != this.getMemoryKeys().length) {
            String string = InternalResource.loadString("item", "Theme3DGraph_TheLengthOfMemoryDoubleValuesShouldBeEqualsWithTheLengthOfMemoryKeys", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        Theme3DGraphItem theme3DGraphItem2 = new Theme3DGraphItem(theme3DGraphItem);
        long l = com.supermap.data.InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)theme3DGraphItem2);
        boolean bl = false;
        if (n == n2) {
            int n3 = Theme3DGraphNative.jni_add(this.getHandle(), l);
            if (n3 == n2) {
                bl = true;
                long l2 = Theme3DGraphNative.jni_getItem(this.getHandle(), n);
                Theme3DGraphItem theme3DGraphItem3 = new Theme3DGraphItem(l2, this);
                this._$2.add(theme3DGraphItem3);
                this._$3();
                this._$1();
            }
        } else {
            bl = Theme3DGraphNative.jni_insert(this.getHandle(), n, l);
            long l3 = Theme3DGraphNative.jni_getItem(this.getHandle(), n);
            Theme3DGraphItem theme3DGraphItem4 = new Theme3DGraphItem(l3, this);
            this._$2.add(n, theme3DGraphItem4);
            this._$3();
            this._$1();
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)theme3DGraphItem));
        return bl;
    }

    public boolean exchangeItem(int n, int n2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n3 = this.getCount();
        if (n < 0 || n >= n3) {
            String string = InternalResource.loadString("index1", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (n2 < 0 || n2 >= n3) {
            String string = InternalResource.loadString("index2", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = Theme3DGraphNative.jni_exchangeItem(this.getHandle(), n, n2);
        if (bl) {
            Theme3DGraphItem theme3DGraphItem = (Theme3DGraphItem)((Object)this._$2.get(n));
            Theme3DGraphItem theme3DGraphItem2 = (Theme3DGraphItem)((Object)this._$2.get(n2));
            long l = Theme3DGraphNative.jni_getItem(this.getHandle(), n);
            Theme3DGraphItem theme3DGraphItem3 = new Theme3DGraphItem(l, this);
            this._$2.set(n, theme3DGraphItem3);
            long l2 = Theme3DGraphNative.jni_getItem(this.getHandle(), n2);
            Theme3DGraphItem theme3DGraphItem4 = new Theme3DGraphItem(l2, this);
            this._$2.set(n2, theme3DGraphItem4);
            theme3DGraphItem.clearHandle();
            theme3DGraphItem2.clearHandle();
            this._$1();
        }
        return bl;
    }

    public int indexOf(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        int n = -1;
        if (string != null && string.trim().length() != 0) {
            n = Theme3DGraphNative.jni_indexOf(this.getHandle(), string);
        }
        return n;
    }

    public boolean remove(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = Theme3DGraphNative.jni_removeAt(this.getHandle(), n);
        if (bl) {
            Theme3DGraphItem theme3DGraphItem = (Theme3DGraphItem)((Object)this._$2.get(n));
            theme3DGraphItem.clearHandle();
            this._$2.remove(n);
            this._$3();
            this._$1();
        }
        return bl;
    }

    public int[] getMemoryKeys() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMemoryKeys()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Theme3DGraphNative.jni_getMemoryKeys(this.getHandle());
    }

    public void setMemoryKeys(int[] nArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMemoryKeys(int[] values)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Theme3DGraphNative.jni_setMemoryKeys(this.getHandle(), nArray);
    }

    public String toString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{BarWidth = ");
        stringBuffer.append(this.getBarWidth());
        stringBuffer.append(",Count = ");
        stringBuffer.append(this.getCount());
        stringBuffer.append(",GraduatedMode = ");
        stringBuffer.append((Object)this.getGraduatedMode3D());
        stringBuffer.append(",GraphTextFormat = ");
        stringBuffer.append(this.getGraph3DTextFormat().name());
        stringBuffer.append(",GraphType = ");
        stringBuffer.append((Object)this.getGraph3DType());
        stringBuffer.append(",IsGraphTextDisplayed = ");
        stringBuffer.append(this.isGraph3DTextDisplayed());
        stringBuffer.append(",MaxGraphSize = ");
        stringBuffer.append(this.getMaxGraphSize());
        stringBuffer.append(",MinGraphSize = ");
        stringBuffer.append(this.getMinGraphSize());
        stringBuffer.append(",StartAngle = ");
        stringBuffer.append(this.getStartAngle());
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "realspace_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            Theme3DGraphNative.jni_delete(this.getHandle());
            this.clearHandle();
        }
    }

    protected void clearHandle() {
        if (this._$2 != null) {
            this._$2();
            this._$2 = null;
        }
        if (this._$1 != null) {
            InternalTextStyle.clearHandle(this._$1);
        }
        this.setHandle(0L);
    }

    ArrayList getGraphItemsList() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGraphItemsList()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return this._$2;
    }

    private void _$3() {
        int n = this.getCount();
        long[] lArray = new long[n];
        long[] lArray2 = new long[n];
        Theme3DGraphNative.jni_getItemAndStyleHandles(this.getHandle(), lArray, lArray2);
        for (int i = 0; i < n; ++i) {
            Theme3DGraphItem theme3DGraphItem = this.getItem(i);
            theme3DGraphItem.refreshItemAndStyle(lArray[i], lArray2[i]);
        }
    }

    private void _$2() {
        int n = this._$2.size();
        for (int i = 0; i < n; ++i) {
            Theme3DGraphItem theme3DGraphItem = (Theme3DGraphItem)((Object)this._$2.get(i));
            theme3DGraphItem.clearHandle();
        }
        this._$2.clear();
    }

    private void _$1() {
        if (this.m_layer3DDataset != null) {
            this.calculateExtremum(this.m_layer3DDataset.getDataset());
        }
    }

    void calculateExtremum(Dataset dataset) {
        long l;
        if (dataset != null && (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset)) != 0L) {
            Theme3DGraphNative.jni_calculateExtremum(this.getHandle(), l);
        }
    }

    public boolean fromXML(String string) {
        boolean bl = super.fromXML(string);
        if (bl) {
            if (this._$1 != null) {
                InternalTextStyle.clearHandle(this._$1);
            }
            this._$3();
        }
        return bl;
    }
}

