/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.terrainanalyst;

import com.supermap.analyst.terrainanalyst.HydrologyAnalystNative;
import com.supermap.analyst.terrainanalyst.InternalDatasetGrid;
import com.supermap.analyst.terrainanalyst.InternalDatasetVector;
import com.supermap.analyst.terrainanalyst.InternalDatasets;
import com.supermap.analyst.terrainanalyst.InternalGeometry;
import com.supermap.analyst.terrainanalyst.InternalHandle;
import com.supermap.analyst.terrainanalyst.InternalResource;
import com.supermap.analyst.terrainanalyst.InternalToolkitTerrainAnalyst;
import com.supermap.analyst.terrainanalyst.QuadMeshParameter;
import com.supermap.analyst.terrainanalyst.StreamOrderType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.GeoRegion;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.License;
import com.supermap.data.Point2Ds;
import com.supermap.data.ProductType;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import java.util.ArrayList;
import java.util.Vector;

public class HydrologyAnalyst {
    private static License _$2;
    private static transient Vector _$1;

    private HydrologyAnalyst() {
    }

    public static GeoRegion[] buildQuadMesh(QuadMeshParameter quadMeshParameter) {
        HydrologyAnalyst._$1(quadMeshParameter);
        long l = 0L;
        l = InternalHandle.getHandle((com.supermap.data.InternalHandle)quadMeshParameter.getQuadMeshRegion());
        long[] lArray = HydrologyAnalystNative.jni_BuildQuadMeshRegions(l, quadMeshParameter.getRowCount(), quadMeshParameter.getColCount(), quadMeshParameter.getLeftBottomPoint().getX(), quadMeshParameter.getLeftBottomPoint().getY(), quadMeshParameter.getRightBottomPoint().getX(), quadMeshParameter.getRightBottomPoint().getY(), quadMeshParameter.getRightTopPoint().getX(), quadMeshParameter.getRightTopPoint().getY(), quadMeshParameter.getLeftTopPoint().getX(), quadMeshParameter.getLeftTopPoint().getY());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)quadMeshParameter);
        GeoRegion[] geoRegionArray = null;
        if (lArray == null) {
            geoRegionArray = new GeoRegion[]{};
        } else {
            int n = lArray.length;
            geoRegionArray = new GeoRegion[n];
            for (int i = 0; i < n; ++i) {
                geoRegionArray[i] = (GeoRegion)InternalGeometry.createInstance(lArray[i]);
            }
        }
        return geoRegionArray;
    }

    public static DatasetVector buildQuadMesh(QuadMeshParameter quadMeshParameter, Datasource datasource, String string) {
        HydrologyAnalyst._$1(quadMeshParameter);
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string2 = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string3 = InternalResource.loadString("resultGridName", "Global_DatasetNameInvalid", "terrainanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        long l = 0L;
        l = InternalHandle.getHandle((com.supermap.data.InternalHandle)quadMeshParameter.getQuadMeshRegion());
        long l2 = 0L;
        l2 = HydrologyAnalystNative.jni_BuildQuadMeshDataset(l, quadMeshParameter.getRowCount(), quadMeshParameter.getColCount(), quadMeshParameter.getLeftBottomPoint().getX(), quadMeshParameter.getLeftBottomPoint().getY(), quadMeshParameter.getRightBottomPoint().getX(), quadMeshParameter.getRightBottomPoint().getY(), quadMeshParameter.getRightTopPoint().getX(), quadMeshParameter.getRightTopPoint().getY(), quadMeshParameter.getLeftTopPoint().getX(), quadMeshParameter.getLeftTopPoint().getY(), quadMeshParameter.getRowField(), quadMeshParameter.getColField(), InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource), string);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)quadMeshParameter);
        DatasetVector datasetVector = null;
        if (l2 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l2, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    private static void _$1(QuadMeshParameter quadMeshParameter) {
        if (quadMeshParameter == null) {
            String string = InternalResource.loadString("quadMeshParameter", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (quadMeshParameter.getQuadMeshRegion() == null) {
            String string = InternalResource.loadString("quadMeshRegion", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (quadMeshParameter.getRowCount() < 2) {
            String string = InternalResource.loadString("rowCount", "QuadMeshParameter_ArgumentShouldEqualsOrGreaterThanTwo", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (quadMeshParameter.getColCount() < 2) {
            String string = InternalResource.loadString("colCount", "QuadMeshParameter_ArgumentShouldEqualsOrGreaterThanTwo", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (quadMeshParameter.getLeftBottomPoint().isEmpty()) {
            String string = InternalResource.loadString("leftBottomPoint", "QuadMeshParameter_ArgumentPointIsEmpty", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (quadMeshParameter.getRightBottomPoint().isEmpty()) {
            String string = InternalResource.loadString("rightBottomPoint", "QuadMeshParameter_ArgumentPointIsEmpty", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (quadMeshParameter.getRightTopPoint().isEmpty()) {
            String string = InternalResource.loadString("rightTopPoint", "QuadMeshParameter_ArgumentPointIsEmpty", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (quadMeshParameter.getLeftTopPoint().isEmpty()) {
            String string = InternalResource.loadString("leftTopPoint", "QuadMeshParameter_ArgumentPointIsEmpty", "terrainanalyst_resources");
            throw new IllegalArgumentException(string);
        }
    }

    public static DatasetGrid fillSink(DatasetGrid datasetGrid, Datasource datasource, String string) {
        long l;
        if (null == datasetGrid) {
            String string2 = InternalResource.loadString("surfaceGrid", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        if (0L == l2) {
            String string3 = InternalResource.loadString("surfaceGrid", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        if (null == datasource) {
            datasource = datasetGrid.getDatasource();
        }
        if (0L == (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource))) {
            String string4 = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("resultGridName", "Global_DatasetNameInvalid", "terrainanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        long l3 = HydrologyAnalystNative.jni_FillSink(l2, l, string, 0L);
        DatasetGrid datasetGrid2 = null;
        if (l3 != 0L) {
            datasetGrid2 = InternalDatasetGrid.createInstance(l3, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid2);
        }
        return datasetGrid2;
    }

    public static DatasetGrid fillSink(DatasetGrid datasetGrid, Datasource datasource, String string, DatasetVector datasetVector) {
        long l;
        if (null == datasetGrid) {
            String string2 = InternalResource.loadString("surfaceGrid", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        if (0L == l2) {
            String string3 = InternalResource.loadString("surfaceGrid", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        if (null == datasource) {
            datasource = datasetGrid.getDatasource();
        }
        if (0L == (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource))) {
            String string4 = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("resultGridName", "Global_DatasetNameInvalid", "terrainanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        long l3 = 0L;
        if (datasetVector != null) {
            if (datasetVector.getType() != DatasetType.POINT && datasetVector.getType() != DatasetType.REGION) {
                String string6 = InternalResource.loadString("realSinkVector", "UnSupportedDatasetType", "terrainanalyst_resources");
                throw new IllegalArgumentException(string6);
            }
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        }
        long l4 = HydrologyAnalystNative.jni_FillSink(l2, l, string, l3);
        DatasetGrid datasetGrid2 = null;
        if (l4 != 0L) {
            datasetGrid2 = InternalDatasetGrid.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid2);
        }
        return datasetGrid2;
    }

    public static DatasetGrid flowDirection(DatasetGrid datasetGrid, boolean bl, Datasource datasource, String string, String string2) {
        long l;
        long l2;
        if (null == datasetGrid) {
            String string3 = InternalResource.loadString("surfaceGrid", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        if (0L == l3) {
            String string4 = InternalResource.loadString("surfaceGrid", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (null == datasource) {
            datasource = datasetGrid.getDatasource();
        }
        if (0L == (l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource))) {
            String string5 = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string6 = InternalResource.loadString("resultGridName", "Global_DatasetNameInvalid", "terrainanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string2)) {
            String string7 = InternalResource.loadString("dropGridName", "Global_DatasetNameInvalid", "terrainanalyst_resources");
            throw new IllegalArgumentException(string7);
        }
        long[] lArray = HydrologyAnalystNative.jni_FlowDirection(l3, true, bl, l2, string2, string);
        long l4 = lArray[0];
        DatasetGrid datasetGrid2 = null;
        if (l4 != 0L) {
            datasetGrid2 = InternalDatasetGrid.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid2);
        }
        if ((l = lArray[1]) != 0L) {
            DatasetGrid datasetGrid3 = InternalDatasetGrid.createInstance(l, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid3);
        }
        return datasetGrid2;
    }

    public static DatasetGrid flowDirection(DatasetGrid datasetGrid, boolean bl, Datasource datasource, String string) {
        long l;
        long l2;
        if (null == datasetGrid) {
            String string2 = InternalResource.loadString("surfaceGrid", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        if (0L == l3) {
            String string3 = InternalResource.loadString("surfaceGrid", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        if (null == datasource) {
            datasource = datasetGrid.getDatasource();
        }
        if (0L == (l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource))) {
            String string4 = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("resultGridName", "Global_DatasetNameInvalid", "terrainanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        long[] lArray = HydrologyAnalystNative.jni_FlowDirection(l3, false, bl, l2, null, string);
        long l4 = lArray[0];
        DatasetGrid datasetGrid2 = null;
        if (l4 != 0L) {
            datasetGrid2 = InternalDatasetGrid.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid2);
        }
        if ((l = lArray[1]) != 0L) {
            DatasetGrid datasetGrid3 = InternalDatasetGrid.createInstance(l, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid3);
        }
        return datasetGrid2;
    }

    public static DatasetGrid flowAccumulation(DatasetGrid datasetGrid, DatasetGrid datasetGrid2, Datasource datasource, String string) {
        long l;
        if (null == datasetGrid) {
            String string2 = InternalResource.loadString("directionGrid", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        if (0L == l2) {
            String string3 = InternalResource.loadString("directionGrid", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        long l3 = 0L;
        if (null != datasetGrid2) {
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid2);
        }
        if (null == datasource) {
            datasource = datasetGrid.getDatasource();
        }
        if (0L == (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource))) {
            String string4 = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("resultGridName", "Global_DatasetNameInvalid", "terrainanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        long l4 = HydrologyAnalystNative.jni_FlowAccumulation(l2, l3, l, string);
        DatasetGrid datasetGrid3 = null;
        if (l4 != 0L) {
            datasetGrid3 = InternalDatasetGrid.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid3);
        }
        return datasetGrid3;
    }

    public static DatasetGrid flowLength(DatasetGrid datasetGrid, DatasetGrid datasetGrid2, boolean bl, Datasource datasource, String string) {
        long l;
        if (null == datasetGrid) {
            String string2 = InternalResource.loadString("directionGrid", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        if (0L == l2) {
            String string3 = InternalResource.loadString("directionGrid", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        long l3 = 0L;
        if (null != datasetGrid2) {
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid2);
        }
        if (null == datasource) {
            datasource = datasetGrid.getDatasource();
        }
        if (0L == (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource))) {
            String string4 = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("resultGridName", "Global_DatasetNameInvalid", "terrainanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        long l4 = HydrologyAnalystNative.jni_FlowLength(l2, l3, bl, l, string);
        DatasetGrid datasetGrid3 = null;
        if (l4 != 0L) {
            datasetGrid3 = InternalDatasetGrid.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid3);
        }
        return datasetGrid3;
    }

    public static DatasetGrid basin(DatasetGrid datasetGrid, Datasource datasource, String string) {
        long l;
        if (null == datasetGrid) {
            String string2 = InternalResource.loadString("directionGrid", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        if (0L == l2) {
            String string3 = InternalResource.loadString("directionGrid", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        if (null == datasource) {
            datasource = datasetGrid.getDatasource();
        }
        if (0L == (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource))) {
            String string4 = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("resultGridName", "Global_DatasetNameInvalid", "terrainanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        long l3 = HydrologyAnalystNative.jni_Basin(l2, l, string);
        DatasetGrid datasetGrid2 = null;
        if (l3 != 0L) {
            datasetGrid2 = InternalDatasetGrid.createInstance(l3, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid2);
        }
        return datasetGrid2;
    }

    public static DatasetGrid pourPoints(DatasetGrid datasetGrid, DatasetGrid datasetGrid2, int n, Datasource datasource, String string) {
        long l;
        if (null == datasetGrid) {
            String string2 = InternalResource.loadString("directionGrid", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        if (0L == l2) {
            String string3 = InternalResource.loadString("directionGrid", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        if (null == datasetGrid2) {
            String string4 = InternalResource.loadString("accumulationGrid", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid2);
        if (0L == l3) {
            String string5 = InternalResource.loadString("accumulationGrid", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (null == datasource) {
            datasource = datasetGrid.getDatasource();
        }
        if (0L == (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource))) {
            String string6 = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string7 = InternalResource.loadString("resultGridName", "Global_DatasetNameInvalid", "terrainanalyst_resources");
            throw new IllegalArgumentException(string7);
        }
        long l4 = HydrologyAnalystNative.jni_SnapPourPoints(l2, l3, n, l, string);
        DatasetGrid datasetGrid3 = null;
        if (l4 != 0L) {
            datasetGrid3 = InternalDatasetGrid.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid3);
        }
        return datasetGrid3;
    }

    public static DatasetGrid watershed(DatasetGrid datasetGrid, Point2Ds point2Ds, Datasource datasource, String string) {
        long l;
        if (null == datasetGrid) {
            String string2 = InternalResource.loadString("directionGrid", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        if (0L == l2) {
            String string3 = InternalResource.loadString("directionGrid", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        int n = point2Ds.getCount();
        if (n <= 0) {
            String string4 = InternalResource.loadString("pourPoints", "PointsCount <= 0", "terrainanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (null == datasource) {
            datasource = datasetGrid.getDatasource();
        }
        if (0L == (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource))) {
            String string5 = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string6 = InternalResource.loadString("resultGridName", "Global_DatasetNameInvalid", "terrainanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = point2Ds.getItem(i).getX();
            dArray2[i] = point2Ds.getItem(i).getY();
        }
        long l3 = HydrologyAnalystNative.jni_WatershedPoint2Ds(l2, dArray, dArray2, l, string);
        DatasetGrid datasetGrid2 = null;
        if (l3 != 0L) {
            datasetGrid2 = InternalDatasetGrid.createInstance(l3, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid2);
        }
        return datasetGrid2;
    }

    public static DatasetGrid watershed(DatasetGrid datasetGrid, DatasetGrid datasetGrid2, Datasource datasource, String string) {
        long l;
        if (null == datasetGrid) {
            String string2 = InternalResource.loadString("directionGrid", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        if (0L == l2) {
            String string3 = InternalResource.loadString("directionGrid", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        if (null == datasetGrid2) {
            String string4 = InternalResource.loadString("pourPointsGrid", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid2);
        if (0L == l3) {
            String string5 = InternalResource.loadString("pourPointsGrid", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (null == datasource) {
            datasource = datasetGrid.getDatasource();
        }
        if (0L == (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource))) {
            String string6 = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string7 = InternalResource.loadString("resultGridName", "Global_DatasetNameInvalid", "terrainanalyst_resources");
            throw new IllegalArgumentException(string7);
        }
        long l4 = HydrologyAnalystNative.jni_WatershedDatasetGrid(l2, l3, l, string);
        DatasetGrid datasetGrid3 = null;
        if (l4 != 0L) {
            datasetGrid3 = InternalDatasetGrid.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid3);
        }
        return datasetGrid3;
    }

    public static DatasetVector streamToLine(DatasetGrid datasetGrid, DatasetGrid datasetGrid2, Datasource datasource, String string, StreamOrderType streamOrderType) {
        long l;
        if (null == datasetGrid) {
            String string2 = InternalResource.loadString("streamGrid", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        if (0L == l2) {
            String string3 = InternalResource.loadString("streamGrid", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        if (null == datasetGrid2) {
            String string4 = InternalResource.loadString("directionGrid", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid2);
        if (0L == l3) {
            String string5 = InternalResource.loadString("directionGrid", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (null == datasource) {
            datasource = datasetGrid2.getDatasource();
        }
        if (0L == (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource))) {
            String string6 = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string7 = InternalResource.loadString("resultGridName", "Global_DatasetNameInvalid", "terrainanalyst_resources");
            throw new IllegalArgumentException(string7);
        }
        long l4 = HydrologyAnalystNative.jni_StreamToLine(l2, l3, l, string, streamOrderType.value());
        DatasetVector datasetVector = null;
        if (l4 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static DatasetGrid streamLink(DatasetGrid datasetGrid, DatasetGrid datasetGrid2, Datasource datasource, String string) {
        long l;
        if (null == datasetGrid) {
            String string2 = InternalResource.loadString("streamGrid", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        if (0L == l2) {
            String string3 = InternalResource.loadString("streamGrid", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        if (null == datasetGrid2) {
            String string4 = InternalResource.loadString("directionGrid", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid2);
        if (0L == l3) {
            String string5 = InternalResource.loadString("directionGrid", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (null == datasource) {
            datasource = datasetGrid2.getDatasource();
        }
        if (0L == (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource))) {
            String string6 = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string7 = InternalResource.loadString("resultGridName", "Global_DatasetNameInvalid", "terrainanalyst_resources");
            throw new IllegalArgumentException(string7);
        }
        long l4 = HydrologyAnalystNative.jni_StreamLink(l2, l3, l, string);
        DatasetGrid datasetGrid3 = null;
        if (l4 != 0L) {
            datasetGrid3 = InternalDatasetGrid.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid3);
        }
        return datasetGrid3;
    }

    public static DatasetGrid streamOrder(DatasetGrid datasetGrid, DatasetGrid datasetGrid2, StreamOrderType streamOrderType, Datasource datasource, String string) {
        long l;
        if (null == datasetGrid) {
            String string2 = InternalResource.loadString("streamGrid", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        if (0L == l2) {
            String string3 = InternalResource.loadString("streamGrid", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        if (null == datasetGrid2) {
            String string4 = InternalResource.loadString("directionGrid", "Global_ArgumentNull", "terrainanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid2);
        if (0L == l3) {
            String string5 = InternalResource.loadString("directionGrid", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (null == datasource) {
            datasource = datasetGrid2.getDatasource();
        }
        if (0L == (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource))) {
            String string6 = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "terrainanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string7 = InternalResource.loadString("resultGridName", "Global_DatasetNameInvalid", "terrainanalyst_resources");
            throw new IllegalArgumentException(string7);
        }
        long l4 = HydrologyAnalystNative.jni_StreamOrder(l2, l3, streamOrderType.value(), l, string);
        DatasetGrid datasetGrid3 = null;
        if (l4 != 0L) {
            datasetGrid3 = InternalDatasetGrid.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid3);
        }
        return datasetGrid3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _$1() {
        int n = -1;
        Object object = _$2;
        synchronized (object) {
            n = _$2.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener steppedListener) {
        if (_$1 == null) {
            _$1 = new Vector();
        }
        if (!_$1.contains(steppedListener)) {
            _$1.add(steppedListener);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener steppedListener) {
        if (_$1 != null && _$1.contains(steppedListener)) {
            _$1.remove(steppedListener);
        }
    }

    protected static void fireStepped(SteppedEvent steppedEvent) {
        if (_$1 != null) {
            Vector vector = _$1;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(steppedEvent);
            }
        }
    }

    static void steppedCallBack(int n, long l, String string, String string2, long l2) {
        String string3 = "HydrologyAnalyst";
        boolean bl = InternalToolkitTerrainAnalyst.getHandleBooleanValue(l2);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, n, l, string, string2, string3);
        HydrologyAnalyst.fireStepped(steppedEvent);
        InternalToolkitTerrainAnalyst.setHandleBooleanValue(l2, steppedEvent.getCancel());
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitTerrainAnalyst.managerProducts(InternalToolkitTerrainAnalyst.getSpatialAnalystProducts());
        _$2 = InternalToolkitTerrainAnalyst.verifyLicense(arrayList);
    }
}

