/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.List;
import javax.persistence.Query;
import org.springframework.data.jpa.repository.query.ExpressionAwareParameterBinder;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.StringQuery;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.Parameter;
import org.springframework.util.Assert;

public class StringQueryParameterBinder
extends ExpressionAwareParameterBinder {
    private final StringQuery query;

    public StringQueryParameterBinder(JpaParameters parameters, Object[] values, StringQuery query, EvaluationContextProvider evaluationContextProvider) {
        super(parameters, values, evaluationContextProvider);
        Assert.notNull((Object)query, (String)"StringQuery must not be null!");
        this.query = query;
    }

    @Override
    protected void bind(Query jpaQuery, JpaParameters.JpaParameter methodParameter, Object value, int position) {
        StringQuery.ParameterBinding binding = this.getBindingFor(jpaQuery, position, methodParameter);
        super.bind(jpaQuery, methodParameter, binding.prepare(value), position);
    }

    @Override
    protected boolean canBindParameter(JpaParameters.JpaParameter parameter) {
        List<StringQuery.ParameterBinding> parameterBindings = this.query.getParameterBindings();
        if (parameterBindings.isEmpty()) {
            return super.canBindParameter(parameter);
        }
        int expressionParameterCount = 0;
        for (StringQuery.ParameterBinding binding : parameterBindings) {
            if (!binding.isExpression()) continue;
            ++expressionParameterCount;
        }
        boolean allParametersAreUsedInExpressions = parameterBindings.size() - expressionParameterCount == 0;
        return !allParametersAreUsedInExpressions && super.canBindParameter(parameter);
    }

    private StringQuery.ParameterBinding getBindingFor(Query jpaQuery, int position, Parameter methodParameter) {
        try {
            jpaQuery.getParameter(position);
            return this.query.getBindingFor(position);
        }
        catch (IllegalArgumentException o_O) {
            if (this.hasNamedParameter(jpaQuery)) {
                return this.query.getBindingFor(methodParameter.getName());
            }
            return new StringQuery.ParameterBinding(position);
        }
    }
}

