/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter.parser;

import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.constants.BpmnXMLConstants;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.Message;
import org.apache.commons.lang3.StringUtils;

public class MessageParser
implements BpmnXMLConstants {
    public void parse(XMLStreamReader xtr, BpmnModel model) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeValue(null, "id"))) {
            String messageId = model.getTargetNamespace() + ":" + xtr.getAttributeValue(null, "id");
            String messageName = xtr.getAttributeValue(null, "name");
            String itemRef = this.parseItemRef(xtr.getAttributeValue(null, "itemRef"), model);
            Message message = new Message(messageId, messageName, itemRef);
            BpmnXMLUtil.addXMLLocation((BaseElement)message, xtr);
            BpmnXMLUtil.parseChildElements("message", (BaseElement)message, xtr, model);
            model.addMessage(message);
        }
    }

    protected String parseItemRef(String itemRef, BpmnModel model) {
        String result = null;
        if (StringUtils.isNotEmpty((CharSequence)itemRef)) {
            int indexOfP = itemRef.indexOf(58);
            if (indexOfP != -1) {
                String prefix = itemRef.substring(0, indexOfP);
                String resolvedNamespace = model.getNamespace(prefix);
                result = resolvedNamespace + ":" + itemRef.substring(indexOfP + 1);
            } else {
                result = model.getTargetNamespace() + ":" + itemRef;
            }
        }
        return result;
    }
}

