/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.executor.resultset;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.ExecutorException;
import org.apache.ibatis.executor.loader.ResultLoader;
import org.apache.ibatis.executor.loader.ResultLoaderMap;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.result.DefaultResultContext;
import org.apache.ibatis.executor.result.DefaultResultHandler;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.executor.resultset.ResultSetWrapper;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.Discriminator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.reflection.MetaClass;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.session.AutoMappingBehavior;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultContext;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;

public class DefaultResultSetHandler
implements ResultSetHandler {
    private static final Object NO_VALUE = new Object();
    private final Executor executor;
    private final Configuration configuration;
    private final MappedStatement mappedStatement;
    private final RowBounds rowBounds;
    private final ParameterHandler parameterHandler;
    private final ResultHandler resultHandler;
    private final BoundSql boundSql;
    private final TypeHandlerRegistry typeHandlerRegistry;
    private final ObjectFactory objectFactory;
    private final Map<CacheKey, Object> nestedResultObjects = new HashMap<CacheKey, Object>();
    private final Map<CacheKey, Object> ancestorObjects = new HashMap<CacheKey, Object>();
    private final Map<String, String> ancestorColumnPrefix = new HashMap<String, String>();
    private final Map<String, ResultMapping> nextResultMaps = new HashMap<String, ResultMapping>();
    private final Map<CacheKey, List<PendingRelation>> pendingRelations = new HashMap<CacheKey, List<PendingRelation>>();

    public DefaultResultSetHandler(Executor executor, MappedStatement mappedStatement, ParameterHandler parameterHandler, ResultHandler resultHandler, BoundSql boundSql, RowBounds rowBounds) {
        this.executor = executor;
        this.configuration = mappedStatement.getConfiguration();
        this.mappedStatement = mappedStatement;
        this.rowBounds = rowBounds;
        this.parameterHandler = parameterHandler;
        this.boundSql = boundSql;
        this.typeHandlerRegistry = this.configuration.getTypeHandlerRegistry();
        this.objectFactory = this.configuration.getObjectFactory();
        this.resultHandler = resultHandler;
    }

    @Override
    public void handleOutputParameters(CallableStatement cs) throws SQLException {
        Object parameterObject = this.parameterHandler.getParameterObject();
        MetaObject metaParam = this.configuration.newMetaObject(parameterObject);
        List<ParameterMapping> parameterMappings = this.boundSql.getParameterMappings();
        for (int i = 0; i < parameterMappings.size(); ++i) {
            ParameterMapping parameterMapping = parameterMappings.get(i);
            if (parameterMapping.getMode() != ParameterMode.OUT && parameterMapping.getMode() != ParameterMode.INOUT) continue;
            if (ResultSet.class.equals(parameterMapping.getJavaType())) {
                this.handleRefCursorOutputParameter((ResultSet)cs.getObject(i + 1), parameterMapping, metaParam);
                continue;
            }
            TypeHandler<?> typeHandler = parameterMapping.getTypeHandler();
            metaParam.setValue(parameterMapping.getProperty(), typeHandler.getResult(cs, i + 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRefCursorOutputParameter(ResultSet rs, ParameterMapping parameterMapping, MetaObject metaParam) throws SQLException {
        try {
            String resultMapId = parameterMapping.getResultMapId();
            ResultMap resultMap = this.configuration.getResultMap(resultMapId);
            DefaultResultHandler resultHandler = new DefaultResultHandler(this.objectFactory);
            ResultSetWrapper rsw = new ResultSetWrapper(rs, this.configuration);
            this.handleRowValues(rsw, resultMap, resultHandler, new RowBounds(), null);
            metaParam.setValue(parameterMapping.getProperty(), resultHandler.getResultList());
        }
        finally {
            this.closeResultSet(rs);
        }
    }

    public List<Object> handleResultSets(Statement stmt) throws SQLException {
        int resultSetCount;
        ErrorContext.instance().activity("handling results").object(this.mappedStatement.getId());
        ArrayList<Object> multipleResults = new ArrayList<Object>();
        ResultSetWrapper rsw = this.getFirstResultSet(stmt);
        List<ResultMap> resultMaps = this.mappedStatement.getResultMaps();
        int resultMapCount = resultMaps.size();
        this.validateResultMapsCount(rsw, resultMapCount);
        for (resultSetCount = 0; rsw != null && resultMapCount > resultSetCount; ++resultSetCount) {
            ResultMap resultMap = resultMaps.get(resultSetCount);
            this.handleResultSet(rsw, resultMap, multipleResults, null);
            rsw = this.getNextResultSet(stmt);
            this.cleanUpAfterHandlingResultSet();
        }
        String[] resultSets = this.mappedStatement.getResulSets();
        if (resultSets != null) {
            while (rsw != null && resultSetCount < resultSets.length) {
                ResultMapping parentMapping = this.nextResultMaps.get(resultSets[resultSetCount]);
                if (parentMapping != null) {
                    String nestedResultMapId = parentMapping.getNestedResultMapId();
                    ResultMap resultMap = this.configuration.getResultMap(nestedResultMapId);
                    this.handleResultSet(rsw, resultMap, null, parentMapping);
                }
                rsw = this.getNextResultSet(stmt);
                this.cleanUpAfterHandlingResultSet();
                ++resultSetCount;
            }
        }
        return this.collapseSingleResultList(multipleResults);
    }

    private ResultSetWrapper getFirstResultSet(Statement stmt) throws SQLException {
        ResultSet rs = stmt.getResultSet();
        while (rs == null) {
            if (stmt.getMoreResults()) {
                rs = stmt.getResultSet();
                continue;
            }
            if (stmt.getUpdateCount() != -1) continue;
        }
        return rs != null ? new ResultSetWrapper(rs, this.configuration) : null;
    }

    private ResultSetWrapper getNextResultSet(Statement stmt) throws SQLException {
        try {
            if (stmt.getConnection().getMetaData().supportsMultipleResultSets() && (stmt.getMoreResults() || stmt.getUpdateCount() != -1)) {
                ResultSet rs = stmt.getResultSet();
                return rs != null ? new ResultSetWrapper(rs, this.configuration) : null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void closeResultSet(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void cleanUpAfterHandlingResultSet() {
        this.nestedResultObjects.clear();
        this.ancestorColumnPrefix.clear();
    }

    private void validateResultMapsCount(ResultSetWrapper rsw, int resultMapCount) {
        if (rsw != null && resultMapCount < 1) {
            throw new ExecutorException("A query was run and no Result Maps were found for the Mapped Statement '" + this.mappedStatement.getId() + "'.  It's likely that neither a Result Type nor a Result Map was specified.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResultSet(ResultSetWrapper rsw, ResultMap resultMap, List<Object> multipleResults, ResultMapping parentMapping) throws SQLException {
        try {
            if (parentMapping != null) {
                this.handleRowValues(rsw, resultMap, null, RowBounds.DEFAULT, parentMapping);
            } else if (this.resultHandler == null) {
                DefaultResultHandler defaultResultHandler = new DefaultResultHandler(this.objectFactory);
                this.handleRowValues(rsw, resultMap, defaultResultHandler, this.rowBounds, null);
                multipleResults.add(defaultResultHandler.getResultList());
            } else {
                this.handleRowValues(rsw, resultMap, this.resultHandler, this.rowBounds, null);
            }
        }
        finally {
            this.closeResultSet(rsw.getResultSet());
        }
    }

    private List<Object> collapseSingleResultList(List<Object> multipleResults) {
        if (multipleResults.size() == 1) {
            List returned = (List)multipleResults.get(0);
            return returned;
        }
        return multipleResults;
    }

    private void handleRowValues(ResultSetWrapper rsw, ResultMap resultMap, ResultHandler resultHandler, RowBounds rowBounds, ResultMapping parentMapping) throws SQLException {
        if (resultMap.hasNestedResultMaps()) {
            this.ensureNoRowBounds();
            this.checkResultHandler();
            this.handleRowValuesForNestedResultMap(rsw, resultMap, resultHandler, rowBounds, parentMapping);
        } else {
            this.handleRowValuesForSimpleResultMap(rsw, resultMap, resultHandler, rowBounds, parentMapping);
        }
    }

    private void ensureNoRowBounds() {
        if (this.configuration.isSafeRowBoundsEnabled() && this.rowBounds != null && (this.rowBounds.getLimit() < Integer.MAX_VALUE || this.rowBounds.getOffset() > 0)) {
            throw new ExecutorException("Mapped Statements with nested result mappings cannot be safely constrained by RowBounds. Use safeRowBoundsEnabled=false setting to bypass this check.");
        }
    }

    protected void checkResultHandler() {
        if (this.resultHandler != null && this.configuration.isSafeResultHandlerEnabled() && !this.mappedStatement.isResultOrdered()) {
            throw new ExecutorException("Mapped Statements with nested result mappings cannot be safely used with a custom ResultHandler. Use safeResultHandlerEnabled=false setting to bypass this check or ensure your statement returns ordered data and set resultOrdered=true on it.");
        }
    }

    private void handleRowValuesForSimpleResultMap(ResultSetWrapper rsw, ResultMap resultMap, ResultHandler resultHandler, RowBounds rowBounds, ResultMapping parentMapping) throws SQLException {
        DefaultResultContext resultContext = new DefaultResultContext();
        this.skipRows(rsw.getResultSet(), rowBounds);
        while (this.shouldProcessMoreRows(resultContext, rowBounds) && rsw.getResultSet().next()) {
            ResultMap discriminatedResultMap = this.resolveDiscriminatedResultMap(rsw.getResultSet(), resultMap, null);
            Object rowValue = this.getRowValue(rsw, discriminatedResultMap);
            this.storeObject(resultHandler, resultContext, rowValue, parentMapping, rsw.getResultSet());
        }
    }

    private void storeObject(ResultHandler resultHandler, DefaultResultContext resultContext, Object rowValue, ResultMapping parentMapping, ResultSet rs) throws SQLException {
        if (parentMapping != null) {
            this.linkToParents(rs, parentMapping, rowValue);
        } else {
            this.callResultHandler(resultHandler, resultContext, rowValue);
        }
    }

    private void callResultHandler(ResultHandler resultHandler, DefaultResultContext resultContext, Object rowValue) {
        resultContext.nextResultObject(rowValue);
        resultHandler.handleResult(resultContext);
    }

    private boolean shouldProcessMoreRows(ResultContext context, RowBounds rowBounds) throws SQLException {
        return !context.isStopped() && context.getResultCount() < rowBounds.getLimit();
    }

    private void skipRows(ResultSet rs, RowBounds rowBounds) throws SQLException {
        if (rs.getType() != 1003) {
            if (rowBounds.getOffset() != 0) {
                rs.absolute(rowBounds.getOffset());
            }
        } else {
            for (int i = 0; i < rowBounds.getOffset(); ++i) {
                rs.next();
            }
        }
    }

    private Object getRowValue(ResultSetWrapper rsw, ResultMap resultMap) throws SQLException {
        ResultLoaderMap lazyLoader = new ResultLoaderMap();
        Object resultObject = this.createResultObject(rsw, resultMap, lazyLoader, null);
        if (resultObject != null && !this.typeHandlerRegistry.hasTypeHandler(resultMap.getType())) {
            MetaObject metaObject = this.configuration.newMetaObject(resultObject);
            boolean foundValues = resultMap.getConstructorResultMappings().size() > 0;
            if (this.shouldApplyAutomaticMappings(resultMap, !AutoMappingBehavior.NONE.equals((Object)this.configuration.getAutoMappingBehavior()))) {
                foundValues = this.applyAutomaticMappings(rsw, resultMap, metaObject, null) || foundValues;
            }
            foundValues = this.applyPropertyMappings(rsw, resultMap, metaObject, lazyLoader, null) || foundValues;
            foundValues = lazyLoader.size() > 0 || foundValues;
            resultObject = foundValues ? resultObject : null;
            return resultObject;
        }
        return resultObject;
    }

    private boolean shouldApplyAutomaticMappings(ResultMap resultMap, boolean def) {
        return resultMap.getAutoMapping() != null ? resultMap.getAutoMapping() : def;
    }

    private boolean applyPropertyMappings(ResultSetWrapper rsw, ResultMap resultMap, MetaObject metaObject, ResultLoaderMap lazyLoader, String columnPrefix) throws SQLException {
        List<String> mappedColumnNames = rsw.getMappedColumnNames(resultMap, columnPrefix);
        boolean foundValues = false;
        List<ResultMapping> propertyMappings = resultMap.getPropertyResultMappings();
        for (ResultMapping propertyMapping : propertyMappings) {
            String column = this.prependPrefix(propertyMapping.getColumn(), columnPrefix);
            if (!propertyMapping.isCompositeResult() && (column == null || !mappedColumnNames.contains(column.toUpperCase(Locale.ENGLISH))) && propertyMapping.getResultSet() == null) continue;
            Object value = this.getPropertyMappingValue(rsw.getResultSet(), metaObject, propertyMapping, lazyLoader, columnPrefix);
            String property = propertyMapping.getProperty();
            if (value == NO_VALUE || property == null || value == null && !this.configuration.isCallSettersOnNulls()) continue;
            if (value != null || !metaObject.getSetterType(property).isPrimitive()) {
                metaObject.setValue(property, value);
            }
            foundValues = true;
        }
        return foundValues;
    }

    private Object getPropertyMappingValue(ResultSet rs, MetaObject metaResultObject, ResultMapping propertyMapping, ResultLoaderMap lazyLoader, String columnPrefix) throws SQLException {
        if (propertyMapping.getNestedQueryId() != null) {
            return this.getNestedQueryMappingValue(rs, metaResultObject, propertyMapping, lazyLoader, columnPrefix);
        }
        if (propertyMapping.getResultSet() != null) {
            this.addPendingChildRelation(rs, metaResultObject, propertyMapping);
            return NO_VALUE;
        }
        if (propertyMapping.getNestedResultMapId() != null) {
            return NO_VALUE;
        }
        TypeHandler<?> typeHandler = propertyMapping.getTypeHandler();
        String column = this.prependPrefix(propertyMapping.getColumn(), columnPrefix);
        return typeHandler.getResult(rs, column);
    }

    private boolean applyAutomaticMappings(ResultSetWrapper rsw, ResultMap resultMap, MetaObject metaObject, String columnPrefix) throws SQLException {
        List<String> unmappedColumnNames = rsw.getUnmappedColumnNames(resultMap, columnPrefix);
        boolean foundValues = false;
        Iterator<String> i$ = unmappedColumnNames.iterator();
        while (i$.hasNext()) {
            TypeHandler<?> typeHandler;
            Object value;
            Class<?> propertyType;
            String property;
            String columnName;
            String propertyName = columnName = i$.next();
            if (columnPrefix != null && columnPrefix.length() > 0) {
                if (!columnName.toUpperCase(Locale.ENGLISH).startsWith(columnPrefix)) continue;
                propertyName = columnName.substring(columnPrefix.length());
            }
            if ((property = metaObject.findProperty(propertyName, this.configuration.isMapUnderscoreToCamelCase())) == null || !metaObject.hasSetter(property) || !this.typeHandlerRegistry.hasTypeHandler(propertyType = metaObject.getSetterType(property)) || (value = (typeHandler = rsw.getTypeHandler(propertyType, columnName)).getResult(rsw.getResultSet(), columnName)) == null && !this.configuration.isCallSettersOnNulls()) continue;
            if (value != null || !propertyType.isPrimitive()) {
                metaObject.setValue(property, value);
            }
            foundValues = true;
        }
        return foundValues;
    }

    private void linkToParents(ResultSet rs, ResultMapping parentMapping, Object rowValue) throws SQLException {
        CacheKey parentKey = this.createKeyForMultipleResults(rs, parentMapping, parentMapping.getColumn(), parentMapping.getForeignColumn());
        List<PendingRelation> parents = this.pendingRelations.get(parentKey);
        for (PendingRelation parent : parents) {
            if (parent == null) continue;
            Object collectionProperty = this.instantiateCollectionPropertyIfAppropriate(parent.propertyMapping, parent.metaObject);
            if (rowValue == null) continue;
            if (collectionProperty != null) {
                MetaObject targetMetaObject = this.configuration.newMetaObject(collectionProperty);
                targetMetaObject.add(rowValue);
                continue;
            }
            parent.metaObject.setValue(parent.propertyMapping.getProperty(), rowValue);
        }
    }

    private Object instantiateCollectionPropertyIfAppropriate(ResultMapping resultMapping, MetaObject metaObject) {
        block6: {
            String propertyName = resultMapping.getProperty();
            Object propertyValue = metaObject.getValue(propertyName);
            if (propertyValue == null) {
                Class<?> type = resultMapping.getJavaType();
                if (type == null) {
                    type = metaObject.getSetterType(propertyName);
                }
                try {
                    if (this.objectFactory.isCollection(type)) {
                        propertyValue = this.objectFactory.create(type);
                        metaObject.setValue(propertyName, propertyValue);
                        return propertyValue;
                    }
                    break block6;
                }
                catch (Exception e) {
                    throw new ExecutorException("Error instantiating collection property for result '" + resultMapping.getProperty() + "'.  Cause: " + e, e);
                }
            }
            if (this.objectFactory.isCollection(propertyValue.getClass())) {
                return propertyValue;
            }
        }
        return null;
    }

    private void addPendingChildRelation(ResultSet rs, MetaObject metaResultObject, ResultMapping parentMapping) throws SQLException {
        CacheKey cacheKey = this.createKeyForMultipleResults(rs, parentMapping, parentMapping.getColumn(), parentMapping.getColumn());
        PendingRelation deferLoad = new PendingRelation();
        deferLoad.metaObject = metaResultObject;
        deferLoad.propertyMapping = parentMapping;
        List<PendingRelation> relations = this.pendingRelations.get(cacheKey);
        if (relations == null) {
            relations = new ArrayList<PendingRelation>();
            this.pendingRelations.put(cacheKey, relations);
        }
        relations.add(deferLoad);
        ResultMapping previous = this.nextResultMaps.get(parentMapping.getResultSet());
        if (previous == null) {
            this.nextResultMaps.put(parentMapping.getResultSet(), parentMapping);
        } else if (!previous.equals(parentMapping)) {
            throw new ExecutorException("Two different properties are mapped to the same resultSet");
        }
    }

    private CacheKey createKeyForMultipleResults(ResultSet rs, ResultMapping resultMapping, String names, String columns) throws SQLException {
        CacheKey cacheKey = new CacheKey();
        cacheKey.update(resultMapping);
        if (columns != null && names != null) {
            String[] columnsArray = columns.split(",");
            String[] namesArray = names.split(",");
            for (int i = 0; i < columnsArray.length; ++i) {
                String value = rs.getString(columnsArray[i]);
                if (value == null) continue;
                cacheKey.update(namesArray[i]);
                cacheKey.update(value);
            }
        }
        return cacheKey;
    }

    private Object createResultObject(ResultSetWrapper rsw, ResultMap resultMap, ResultLoaderMap lazyLoader, String columnPrefix) throws SQLException {
        ArrayList constructorArgTypes = new ArrayList();
        ArrayList<Object> constructorArgs = new ArrayList<Object>();
        Object resultObject = this.createResultObject(rsw, resultMap, constructorArgTypes, constructorArgs, columnPrefix);
        if (resultObject != null && !this.typeHandlerRegistry.hasTypeHandler(resultMap.getType())) {
            List<ResultMapping> propertyMappings = resultMap.getPropertyResultMappings();
            for (ResultMapping propertyMapping : propertyMappings) {
                if (propertyMapping.getNestedQueryId() == null || !propertyMapping.isLazy()) continue;
                return this.configuration.getProxyFactory().createProxy(resultObject, lazyLoader, this.configuration, this.objectFactory, constructorArgTypes, constructorArgs);
            }
        }
        return resultObject;
    }

    private Object createResultObject(ResultSetWrapper rsw, ResultMap resultMap, List<Class<?>> constructorArgTypes, List<Object> constructorArgs, String columnPrefix) throws SQLException {
        Class<?> resultType = resultMap.getType();
        List<ResultMapping> constructorMappings = resultMap.getConstructorResultMappings();
        if (this.typeHandlerRegistry.hasTypeHandler(resultType)) {
            return this.createPrimitiveResultObject(rsw, resultMap, columnPrefix);
        }
        if (constructorMappings.size() > 0) {
            return this.createParameterizedResultObject(rsw, resultType, constructorMappings, constructorArgTypes, constructorArgs, columnPrefix);
        }
        return this.objectFactory.create(resultType);
    }

    private Object createParameterizedResultObject(ResultSetWrapper rsw, Class<?> resultType, List<ResultMapping> constructorMappings, List<Class<?>> constructorArgTypes, List<Object> constructorArgs, String columnPrefix) throws SQLException {
        boolean foundValues = false;
        for (ResultMapping constructorMapping : constructorMappings) {
            Object value;
            Class<?> parameterType = constructorMapping.getJavaType();
            String column = constructorMapping.getColumn();
            if (constructorMapping.getNestedQueryId() != null) {
                value = this.getNestedQueryConstructorValue(rsw.getResultSet(), constructorMapping, columnPrefix);
            } else if (constructorMapping.getNestedResultMapId() != null) {
                ResultMap resultMap = this.configuration.getResultMap(constructorMapping.getNestedResultMapId());
                value = this.getRowValue(rsw, resultMap);
            } else {
                TypeHandler<?> typeHandler = constructorMapping.getTypeHandler();
                value = typeHandler.getResult(rsw.getResultSet(), this.prependPrefix(column, columnPrefix));
            }
            constructorArgTypes.add(parameterType);
            constructorArgs.add(value);
            foundValues = value != null || foundValues;
        }
        return foundValues ? this.objectFactory.create(resultType, constructorArgTypes, constructorArgs) : null;
    }

    private Object createPrimitiveResultObject(ResultSetWrapper rsw, ResultMap resultMap, String columnPrefix) throws SQLException {
        String columnName;
        Class<?> resultType = resultMap.getType();
        if (resultMap.getResultMappings().size() > 0) {
            List<ResultMapping> resultMappingList = resultMap.getResultMappings();
            ResultMapping mapping = resultMappingList.get(0);
            columnName = this.prependPrefix(mapping.getColumn(), columnPrefix);
        } else {
            columnName = rsw.getColumnNames().get(0);
        }
        TypeHandler<?> typeHandler = rsw.getTypeHandler(resultType, columnName);
        return typeHandler.getResult(rsw.getResultSet(), columnName);
    }

    private Object getNestedQueryConstructorValue(ResultSet rs, ResultMapping constructorMapping, String columnPrefix) throws SQLException {
        String nestedQueryId = constructorMapping.getNestedQueryId();
        MappedStatement nestedQuery = this.configuration.getMappedStatement(nestedQueryId);
        Class<?> nestedQueryParameterType = nestedQuery.getParameterMap().getType();
        Object nestedQueryParameterObject = this.prepareParameterForNestedQuery(rs, constructorMapping, nestedQueryParameterType, columnPrefix);
        Object value = null;
        if (nestedQueryParameterObject != null) {
            BoundSql nestedBoundSql = nestedQuery.getBoundSql(nestedQueryParameterObject);
            CacheKey key = this.executor.createCacheKey(nestedQuery, nestedQueryParameterObject, RowBounds.DEFAULT, nestedBoundSql);
            Class<?> targetType = constructorMapping.getJavaType();
            ResultLoader resultLoader = new ResultLoader(this.configuration, this.executor, nestedQuery, nestedQueryParameterObject, targetType, key, nestedBoundSql);
            value = resultLoader.loadResult();
        }
        return value;
    }

    private Object getNestedQueryMappingValue(ResultSet rs, MetaObject metaResultObject, ResultMapping propertyMapping, ResultLoaderMap lazyLoader, String columnPrefix) throws SQLException {
        String nestedQueryId = propertyMapping.getNestedQueryId();
        String property = propertyMapping.getProperty();
        MappedStatement nestedQuery = this.configuration.getMappedStatement(nestedQueryId);
        Class<?> nestedQueryParameterType = nestedQuery.getParameterMap().getType();
        Object nestedQueryParameterObject = this.prepareParameterForNestedQuery(rs, propertyMapping, nestedQueryParameterType, columnPrefix);
        Object value = NO_VALUE;
        if (nestedQueryParameterObject != null) {
            BoundSql nestedBoundSql = nestedQuery.getBoundSql(nestedQueryParameterObject);
            CacheKey key = this.executor.createCacheKey(nestedQuery, nestedQueryParameterObject, RowBounds.DEFAULT, nestedBoundSql);
            Class<?> targetType = propertyMapping.getJavaType();
            if (this.executor.isCached(nestedQuery, key)) {
                this.executor.deferLoad(nestedQuery, metaResultObject, property, key, targetType);
            } else {
                ResultLoader resultLoader = new ResultLoader(this.configuration, this.executor, nestedQuery, nestedQueryParameterObject, targetType, key, nestedBoundSql);
                if (propertyMapping.isLazy()) {
                    lazyLoader.addLoader(property, metaResultObject, resultLoader);
                } else {
                    value = resultLoader.loadResult();
                }
            }
        }
        return value;
    }

    private Object prepareParameterForNestedQuery(ResultSet rs, ResultMapping resultMapping, Class<?> parameterType, String columnPrefix) throws SQLException {
        if (resultMapping.isCompositeResult()) {
            return this.prepareCompositeKeyParameter(rs, resultMapping, parameterType, columnPrefix);
        }
        return this.prepareSimpleKeyParameter(rs, resultMapping, parameterType, columnPrefix);
    }

    private Object prepareSimpleKeyParameter(ResultSet rs, ResultMapping resultMapping, Class<?> parameterType, String columnPrefix) throws SQLException {
        TypeHandler<Object> typeHandler = this.typeHandlerRegistry.hasTypeHandler(parameterType) ? this.typeHandlerRegistry.getTypeHandler(parameterType) : this.typeHandlerRegistry.getUnknownTypeHandler();
        return typeHandler.getResult(rs, this.prependPrefix(resultMapping.getColumn(), columnPrefix));
    }

    private Object prepareCompositeKeyParameter(ResultSet rs, ResultMapping resultMapping, Class<?> parameterType, String columnPrefix) throws SQLException {
        Object parameterObject = this.instantiateParameterObject(parameterType);
        MetaObject metaObject = this.configuration.newMetaObject(parameterObject);
        boolean foundValues = false;
        for (ResultMapping innerResultMapping : resultMapping.getComposites()) {
            Class<?> propType = metaObject.getSetterType(innerResultMapping.getProperty());
            TypeHandler<?> typeHandler = this.typeHandlerRegistry.getTypeHandler(propType);
            Object propValue = typeHandler.getResult(rs, this.prependPrefix(innerResultMapping.getColumn(), columnPrefix));
            if (propValue == null) continue;
            metaObject.setValue(innerResultMapping.getProperty(), propValue);
            foundValues = true;
        }
        return foundValues ? parameterObject : null;
    }

    private Object instantiateParameterObject(Class<?> parameterType) {
        if (parameterType == null) {
            return new HashMap();
        }
        return this.objectFactory.create(parameterType);
    }

    public ResultMap resolveDiscriminatedResultMap(ResultSet rs, ResultMap resultMap, String columnPrefix) throws SQLException {
        Object value;
        String discriminatedMapId;
        HashSet<String> pastDiscriminators = new HashSet<String>();
        Discriminator discriminator = resultMap.getDiscriminator();
        while (discriminator != null && this.configuration.hasResultMap(discriminatedMapId = discriminator.getMapIdFor(String.valueOf(value = this.getDiscriminatorValue(rs, discriminator, columnPrefix))))) {
            resultMap = this.configuration.getResultMap(discriminatedMapId);
            Discriminator lastDiscriminator = discriminator;
            discriminator = resultMap.getDiscriminator();
            if (discriminator != lastDiscriminator && pastDiscriminators.add(discriminatedMapId)) continue;
            break;
        }
        return resultMap;
    }

    private Object getDiscriminatorValue(ResultSet rs, Discriminator discriminator, String columnPrefix) throws SQLException {
        ResultMapping resultMapping = discriminator.getResultMapping();
        TypeHandler<?> typeHandler = resultMapping.getTypeHandler();
        return typeHandler.getResult(rs, this.prependPrefix(resultMapping.getColumn(), columnPrefix));
    }

    private String prependPrefix(String columnName, String prefix) {
        if (columnName == null || columnName.length() == 0 || prefix == null || prefix.length() == 0) {
            return columnName;
        }
        return prefix + columnName;
    }

    private void handleRowValuesForNestedResultMap(ResultSetWrapper rsw, ResultMap resultMap, ResultHandler resultHandler, RowBounds rowBounds, ResultMapping parentMapping) throws SQLException {
        DefaultResultContext resultContext = new DefaultResultContext();
        this.skipRows(rsw.getResultSet(), rowBounds);
        Object rowValue = null;
        while (this.shouldProcessMoreRows(resultContext, rowBounds) && rsw.getResultSet().next()) {
            ResultMap discriminatedResultMap = this.resolveDiscriminatedResultMap(rsw.getResultSet(), resultMap, null);
            CacheKey rowKey = this.createRowKey(discriminatedResultMap, rsw, null);
            Object partialObject = this.nestedResultObjects.get(rowKey);
            if (this.mappedStatement.isResultOrdered()) {
                if (partialObject == null && rowValue != null) {
                    this.nestedResultObjects.clear();
                    this.storeObject(resultHandler, resultContext, rowValue, parentMapping, rsw.getResultSet());
                }
                rowValue = this.getRowValue(rsw, discriminatedResultMap, rowKey, rowKey, null, partialObject);
                continue;
            }
            rowValue = this.getRowValue(rsw, discriminatedResultMap, rowKey, rowKey, null, partialObject);
            if (partialObject != null) continue;
            this.storeObject(resultHandler, resultContext, rowValue, parentMapping, rsw.getResultSet());
        }
        if (rowValue != null && this.mappedStatement.isResultOrdered() && this.shouldProcessMoreRows(resultContext, rowBounds)) {
            this.storeObject(resultHandler, resultContext, rowValue, parentMapping, rsw.getResultSet());
        }
    }

    private Object getRowValue(ResultSetWrapper rsw, ResultMap resultMap, CacheKey combinedKey, CacheKey absoluteKey, String columnPrefix, Object partialObject) throws SQLException {
        String resultMapId = resultMap.getId();
        Object resultObject = partialObject;
        if (resultObject != null) {
            MetaObject metaObject = this.configuration.newMetaObject(resultObject);
            this.putAncestor(absoluteKey, resultObject, resultMapId, columnPrefix);
            this.applyNestedResultMappings(rsw, resultMap, metaObject, columnPrefix, combinedKey, false);
            this.ancestorObjects.remove(absoluteKey);
        } else {
            ResultLoaderMap lazyLoader = new ResultLoaderMap();
            resultObject = this.createResultObject(rsw, resultMap, lazyLoader, columnPrefix);
            if (resultObject != null && !this.typeHandlerRegistry.hasTypeHandler(resultMap.getType())) {
                boolean foundValues;
                MetaObject metaObject = this.configuration.newMetaObject(resultObject);
                boolean bl = foundValues = resultMap.getConstructorResultMappings().size() > 0;
                if (this.shouldApplyAutomaticMappings(resultMap, AutoMappingBehavior.FULL.equals((Object)this.configuration.getAutoMappingBehavior()))) {
                    foundValues = this.applyAutomaticMappings(rsw, resultMap, metaObject, columnPrefix) || foundValues;
                }
                foundValues = this.applyPropertyMappings(rsw, resultMap, metaObject, lazyLoader, columnPrefix) || foundValues;
                this.putAncestor(absoluteKey, resultObject, resultMapId, columnPrefix);
                foundValues = this.applyNestedResultMappings(rsw, resultMap, metaObject, columnPrefix, combinedKey, true) || foundValues;
                this.ancestorObjects.remove(absoluteKey);
                foundValues = lazyLoader.size() > 0 || foundValues;
                Object object = resultObject = foundValues ? resultObject : null;
            }
            if (combinedKey != CacheKey.NULL_CACHE_KEY) {
                this.nestedResultObjects.put(combinedKey, resultObject);
            }
        }
        return resultObject;
    }

    private void putAncestor(CacheKey rowKey, Object resultObject, String resultMapId, String columnPrefix) {
        if (!this.ancestorColumnPrefix.containsKey(resultMapId)) {
            this.ancestorColumnPrefix.put(resultMapId, columnPrefix);
        }
        this.ancestorObjects.put(rowKey, resultObject);
    }

    private boolean applyNestedResultMappings(ResultSetWrapper rsw, ResultMap resultMap, MetaObject metaObject, String parentPrefix, CacheKey parentRowKey, boolean newObject) {
        boolean foundValues = false;
        for (ResultMapping resultMapping : resultMap.getPropertyResultMappings()) {
            String nestedResultMapId = resultMapping.getNestedResultMapId();
            if (nestedResultMapId == null || resultMapping.getResultSet() != null) continue;
            try {
                String columnPrefix = this.getColumnPrefix(parentPrefix, resultMapping);
                ResultMap nestedResultMap = this.getNestedResultMap(rsw.getResultSet(), nestedResultMapId, columnPrefix);
                CacheKey rowKey = null;
                Object ancestorObject = null;
                if (this.ancestorColumnPrefix.containsKey(nestedResultMapId)) {
                    rowKey = this.createRowKey(nestedResultMap, rsw, this.ancestorColumnPrefix.get(nestedResultMapId));
                    ancestorObject = this.ancestorObjects.get(rowKey);
                }
                if (ancestorObject != null) {
                    if (!newObject) continue;
                    metaObject.setValue(resultMapping.getProperty(), ancestorObject);
                    continue;
                }
                rowKey = this.createRowKey(nestedResultMap, rsw, columnPrefix);
                CacheKey combinedKey = this.combineKeys(rowKey, parentRowKey);
                Object rowValue = this.nestedResultObjects.get(combinedKey);
                boolean knownValue = rowValue != null;
                Object collectionProperty = this.instantiateCollectionPropertyIfAppropriate(resultMapping, metaObject);
                if (!this.anyNotNullColumnHasValue(resultMapping, columnPrefix, rsw.getResultSet()) || (rowValue = this.getRowValue(rsw, nestedResultMap, combinedKey, rowKey, columnPrefix, rowValue)) == null || knownValue) continue;
                if (collectionProperty != null) {
                    MetaObject targetMetaObject = this.configuration.newMetaObject(collectionProperty);
                    targetMetaObject.add(rowValue);
                } else {
                    metaObject.setValue(resultMapping.getProperty(), rowValue);
                }
                foundValues = true;
            }
            catch (SQLException e) {
                throw new ExecutorException("Error getting nested result map values for '" + resultMapping.getProperty() + "'.  Cause: " + e, e);
            }
        }
        return foundValues;
    }

    private String getColumnPrefix(String parentPrefix, ResultMapping resultMapping) {
        StringBuilder columnPrefixBuilder = new StringBuilder();
        if (parentPrefix != null) {
            columnPrefixBuilder.append(parentPrefix);
        }
        if (resultMapping.getColumnPrefix() != null) {
            columnPrefixBuilder.append(resultMapping.getColumnPrefix());
        }
        String columnPrefix = columnPrefixBuilder.length() == 0 ? null : columnPrefixBuilder.toString().toUpperCase(Locale.ENGLISH);
        return columnPrefix;
    }

    private boolean anyNotNullColumnHasValue(ResultMapping resultMapping, String columnPrefix, ResultSet rs) throws SQLException {
        Set<String> notNullColumns = resultMapping.getNotNullColumns();
        boolean anyNotNullColumnHasValue = true;
        if (notNullColumns != null && !notNullColumns.isEmpty()) {
            anyNotNullColumnHasValue = false;
            for (String column : notNullColumns) {
                rs.getObject(this.prependPrefix(column, columnPrefix));
                if (rs.wasNull()) continue;
                anyNotNullColumnHasValue = true;
                break;
            }
        }
        return anyNotNullColumnHasValue;
    }

    private ResultMap getNestedResultMap(ResultSet rs, String nestedResultMapId, String columnPrefix) throws SQLException {
        ResultMap nestedResultMap = this.configuration.getResultMap(nestedResultMapId);
        nestedResultMap = this.resolveDiscriminatedResultMap(rs, nestedResultMap, columnPrefix);
        return nestedResultMap;
    }

    private CacheKey createRowKey(ResultMap resultMap, ResultSetWrapper rsw, String columnPrefix) throws SQLException {
        CacheKey cacheKey = new CacheKey();
        cacheKey.update(resultMap.getId());
        List<ResultMapping> resultMappings = this.getResultMappingsForRowKey(resultMap);
        if (resultMappings.size() == 0) {
            if (Map.class.isAssignableFrom(resultMap.getType())) {
                this.createRowKeyForMap(rsw, cacheKey);
            } else {
                this.createRowKeyForUnmappedProperties(resultMap, rsw, cacheKey, columnPrefix);
            }
        } else {
            this.createRowKeyForMappedProperties(resultMap, rsw, cacheKey, resultMappings, columnPrefix);
        }
        return cacheKey;
    }

    private CacheKey combineKeys(CacheKey rowKey, CacheKey parentRowKey) {
        if (rowKey.getUpdateCount() > 1 && parentRowKey.getUpdateCount() > 1) {
            CacheKey combinedKey;
            try {
                combinedKey = rowKey.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new ExecutorException("Error cloning cache key.  Cause: " + e, e);
            }
            combinedKey.update(parentRowKey);
            return combinedKey;
        }
        return CacheKey.NULL_CACHE_KEY;
    }

    private List<ResultMapping> getResultMappingsForRowKey(ResultMap resultMap) {
        List<ResultMapping> resultMappings = resultMap.getIdResultMappings();
        if (resultMappings.size() == 0) {
            resultMappings = resultMap.getPropertyResultMappings();
        }
        return resultMappings;
    }

    private void createRowKeyForMappedProperties(ResultMap resultMap, ResultSetWrapper rsw, CacheKey cacheKey, List<ResultMapping> resultMappings, String columnPrefix) throws SQLException {
        for (ResultMapping resultMapping : resultMappings) {
            Object value;
            if (resultMapping.getNestedResultMapId() != null && resultMapping.getResultSet() == null) {
                ResultMap nestedResultMap = this.configuration.getResultMap(resultMapping.getNestedResultMapId());
                this.createRowKeyForMappedProperties(nestedResultMap, rsw, cacheKey, nestedResultMap.getConstructorResultMappings(), this.prependPrefix(resultMapping.getColumnPrefix(), columnPrefix));
                continue;
            }
            if (resultMapping.getNestedQueryId() != null) continue;
            String column = this.prependPrefix(resultMapping.getColumn(), columnPrefix);
            TypeHandler<?> th = resultMapping.getTypeHandler();
            List<String> mappedColumnNames = rsw.getMappedColumnNames(resultMap, columnPrefix);
            if (column == null || !mappedColumnNames.contains(column.toUpperCase(Locale.ENGLISH)) || (value = th.getResult(rsw.getResultSet(), column)) == null) continue;
            cacheKey.update(column);
            cacheKey.update(value);
        }
    }

    private void createRowKeyForUnmappedProperties(ResultMap resultMap, ResultSetWrapper rsw, CacheKey cacheKey, String columnPrefix) throws SQLException {
        MetaClass metaType = MetaClass.forClass(resultMap.getType());
        List<String> unmappedColumnNames = rsw.getUnmappedColumnNames(resultMap, columnPrefix);
        Iterator<String> i$ = unmappedColumnNames.iterator();
        while (i$.hasNext()) {
            String value;
            String column;
            String property = column = i$.next();
            if (columnPrefix != null && columnPrefix.length() > 0) {
                if (!column.toUpperCase(Locale.ENGLISH).startsWith(columnPrefix)) continue;
                property = column.substring(columnPrefix.length());
            }
            if (metaType.findProperty(property, this.configuration.isMapUnderscoreToCamelCase()) == null || (value = rsw.getResultSet().getString(column)) == null) continue;
            cacheKey.update(column);
            cacheKey.update(value);
        }
    }

    private void createRowKeyForMap(ResultSetWrapper rsw, CacheKey cacheKey) throws SQLException {
        List<String> columnNames = rsw.getColumnNames();
        for (String columnName : columnNames) {
            String value = rsw.getResultSet().getString(columnName);
            if (value == null) continue;
            cacheKey.update(columnName);
            cacheKey.update(value);
        }
    }

    private static class PendingRelation {
        public MetaObject metaObject;
        public ResultMapping propertyMapping;

        private PendingRelation() {
        }
    }
}

