/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.geoprocessor.common;

import com.supermap.geoprocessor.common.LogProvider;
import com.supermap.geoprocessor.common.SqlProvider;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlSequence {
    private static final Log log = LogProvider.getLog(SqlSequence.class);
    private static LinkedBlockingQueue<Map<String, String>> sequence = new LinkedBlockingQueue();
    private static Map<String, String> sql = null;

    public static synchronized boolean execute() {
        try {
            sql = sequence.poll();
            while (sql != null) {
                for (Map.Entry<String, String> entry : sql.entrySet()) {
                    if (entry.getKey().equalsIgnoreCase("insert") || entry.getKey().equalsIgnoreCase("delete")) {
                        SqlProvider.addOrDeleteRecord(entry.getValue());
                        continue;
                    }
                    if (!entry.getKey().equalsIgnoreCase("update")) continue;
                    SqlProvider.updateRecord(entry.getValue());
                }
                sql = sequence.poll();
            }
            log.debug((Object)"Sequence executed.");
            return true;
        }
        catch (Exception exception) {
            if (exception.getMessage().trim().equalsIgnoreCase("database locked")) {
                sequence.add(sql);
                log.debug((Object)"Circle backed to sequence.");
                return SqlSequence.execute();
            }
            log.error((Object)exception);
            return false;
        }
    }

    public static void push(Map<String, String> map) {
        sequence.add(map);
    }
}

