/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.smsserver.interfaces;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.Collection;
import java.util.Properties;
import org.smslib.InboundMessage;
import org.smslib.smsserver.SMSServer;
import org.smslib.smsserver.interfaces.Interface;

public class SimpleInboundFileLogger
extends Interface<Void> {
    private BufferedWriter out;

    public SimpleInboundFileLogger(String myInterfaceId, Properties myProps, SMSServer myServer, Interface.InterfaceTypes myType) {
        super(myInterfaceId, myProps, myServer, myType);
        this.setDescription("Simple file logger for inbound messages.");
    }

    @Override
    public void start() throws Exception {
        this.out = new BufferedWriter(new FileWriter(this.getProperty("filename", ""), true));
        super.start();
    }

    @Override
    public void stop() throws Exception {
        if (this.out != null) {
            this.out.close();
        }
        super.stop();
    }

    @Override
    public void messagesReceived(Collection<InboundMessage> msgList) throws Exception {
        for (InboundMessage msg : msgList) {
            this.out.write(msg.getDate() + "|" + msg.getOriginator() + "|" + msg.getText());
            this.out.flush();
        }
    }
}

