/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comm;

import com.sun.comm.Win32SerialPort;
import java.io.IOException;

class NotificationThread
extends Thread {
    Win32SerialPort port;
    private static int EV_RXCHAR = 1;
    private static int EV_RXFLAG = 2;
    private static int EV_TXEMPTY = 4;
    private static int EV_CTS = 8;
    private static int EV_DSR = 16;
    private static int EV_RLSD = 32;
    private static int EV_BREAK = 64;
    private static int EV_ERR = 128;
    private static int EV_RING = 256;
    private static int CE_OVERRUN = 2;
    private static int CE_RXPARITY = 4;
    private static int CE_FRAME = 8;
    private static int CE_BREAK = 16;

    NotificationThread(String string, Win32SerialPort win32SerialPort) {
        super(string);
        this.port = win32SerialPort;
    }

    public void run() {
        while (true) {
            if (this.port.closed || this.port.eventListener == null) {
                this.port.notificationThread = null;
                return;
            }
            int n = this.port.waitForEvent();
            if (this.port.closed || this.port.eventListener == null) {
                this.port.notificationThread = null;
                return;
            }
            if ((n & EV_CTS) == EV_CTS) {
                this.port.sendCTSevent();
            }
            if ((n & EV_DSR) == EV_DSR) {
                this.port.sendDSRevent();
            }
            if ((n & EV_RLSD) == EV_RLSD) {
                this.port.sendCDevent();
            }
            if ((n & EV_RING) == EV_RING) {
                this.port.sendRIevent();
            }
            if ((n & EV_BREAK) == EV_BREAK) {
                this.port.sendBIevent();
            }
            if ((n & EV_ERR) == EV_ERR) {
                int n2 = n >> 16;
                if ((n2 & CE_OVERRUN) == CE_OVERRUN) {
                    this.port.sendOEevent();
                }
                if ((n2 & CE_RXPARITY) == CE_RXPARITY) {
                    this.port.sendPEevent();
                }
                if ((n2 & CE_FRAME) == CE_FRAME) {
                    this.port.sendFEevent();
                }
            }
            if ((n & EV_TXEMPTY) == EV_TXEMPTY) {
                this.port.sendOutputEmptyEvent();
            }
            if ((n & EV_RXCHAR) == EV_RXCHAR) {
                Object object = this.port.readSignal;
                synchronized (object) {
                    this.port.readSignal.notifyAll();
                }
                try {
                    if (this.port.available() > 0) {
                        this.port.sendDataAvailEvent();
                    }
                }
                catch (IOException iOException) {}
            }
            if ((n & EV_RXFLAG) != EV_RXFLAG) continue;
            this.port.framingByteReceived = true;
            Object object = this.port.readSignal;
            synchronized (object) {
                this.port.readSignal.notifyAll();
            }
        }
    }
}

