/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.json.writer.jsonlib;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import net.sf.json.JSON;
import net.sf.json.JSONSerializer;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonValueProcessor;
import net.sf.json.processors.JsonValueProcessorMatcher;
import net.sf.json.util.JsonEventListener;
import net.sf.json.util.PropertyFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.validation.BindingResult;
import org.springframework.web.servlet.view.json.JsonStringWriter;
import org.springframework.web.servlet.view.json.JsonWriterConfiguratorTemplateRegistry;
import org.springframework.web.servlet.view.json.writer.jsonlib.AllwaysMatchingValueProcessorMatcher;
import org.springframework.web.servlet.view.json.writer.jsonlib.JsonlibJsonWriterConfiguratorTemplate;
import org.springframework.web.servlet.view.json.writer.jsonlib.NullPropertyFilter;
import org.springframework.web.servlet.view.json.writer.jsonlib.PropertyEditorRegistryValueProcessor;

public class JsonlibJsonStringWriter
implements JsonStringWriter {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private boolean enableJsonConfigSupport;
    private boolean convertAllMapValues;
    private boolean keepNullProperties;

    public void convertAndWrite(Map model, JsonWriterConfiguratorTemplateRegistry configuratorTemplateRegistry, Writer writer, BindingResult br) throws IOException {
        JsonConfig jsonConfig = null;
        JsonlibJsonWriterConfiguratorTemplate configuratorTemplate = (JsonlibJsonWriterConfiguratorTemplate)configuratorTemplateRegistry.findConfiguratorTemplate(JsonlibJsonWriterConfiguratorTemplate.class.getName());
        if (this.enableJsonConfigSupport && configuratorTemplate != null) {
            jsonConfig = (JsonConfig)configuratorTemplate.getConfigurator();
        }
        if (jsonConfig == null) {
            jsonConfig = new JsonConfig();
        }
        if (jsonConfig.getJsonPropertyFilter() == null && !this.keepNullProperties) {
            jsonConfig.setJsonPropertyFilter((PropertyFilter)new NullPropertyFilter());
        }
        if (jsonConfig.getJsonValueProcessorMatcher().getClass().equals(JsonValueProcessorMatcher.DEFAULT.getClass())) {
            PropertyEditorRegistry per = null;
            String objektName = null;
            if (br != null) {
                per = br.getPropertyEditorRegistry();
                objektName = br.getObjectName();
            }
            PropertyEditorRegistryValueProcessor valueProzessor = new PropertyEditorRegistryValueProcessor(per);
            valueProzessor.setConvertAllMapValues(this.convertAllMapValues);
            valueProzessor.setObjektName(objektName);
            jsonConfig.registerJsonValueProcessor(AllwaysMatchingValueProcessorMatcher.class, (JsonValueProcessor)valueProzessor);
            jsonConfig.setJsonValueProcessorMatcher((JsonValueProcessorMatcher)new AllwaysMatchingValueProcessorMatcher());
            jsonConfig.addJsonEventListener((JsonEventListener)valueProzessor);
            jsonConfig.enableEventTriggering();
        }
        JSON json = JSONSerializer.toJSON((Object)model, (JsonConfig)jsonConfig);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)json.toString());
        }
        json.write(writer);
        writer.flush();
    }

    public boolean isEnableJsonConfigSupport() {
        return this.enableJsonConfigSupport;
    }

    public void setEnableJsonConfigSupport(boolean enableJsonConfigSupport) {
        this.enableJsonConfigSupport = enableJsonConfigSupport;
    }

    public boolean isConvertAllMapValues() {
        return this.convertAllMapValues;
    }

    public void setConvertAllMapValues(boolean convertAllMapValues) {
        this.convertAllMapValues = convertAllMapValues;
    }

    public boolean isKeepNullProperties() {
        return this.keepNullProperties;
    }

    public void setKeepNullProperties(boolean keepNullProperties) {
        this.keepNullProperties = keepNullProperties;
    }
}

