/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.json;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.validation.BindingResult;
import org.springframework.web.servlet.support.RequestContext;
import org.springframework.web.servlet.view.AbstractView;
import org.springframework.web.servlet.view.json.JsonErrorHandler;
import org.springframework.web.servlet.view.json.JsonStringWriter;
import org.springframework.web.servlet.view.json.JsonViewCallback;
import org.springframework.web.servlet.view.json.JsonViewFilter;
import org.springframework.web.servlet.view.json.JsonWriterConfiguratorTemplateRegistry;
import org.springframework.web.servlet.view.json.error.StandartErrorConverter;
import org.springframework.web.servlet.view.json.filter.SimplePropertyFilter;
import org.springframework.web.servlet.view.json.writer.sojo.SojoJsonStringWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonView
extends AbstractView {
    private static final String DEFAULT_ENCODING = "UTF-8";
    public static final String DEFAULT_JSON_CONTENT_TYPE = "application/json";
    private static final String REQUEST_CONTEXT_ATTRIBUTE = RequestContext.class.toString();
    public static final String DEFAULT_HIJACKSAVE_PREFIX_POSTFIX = "JSON";
    private JsonViewFilter jsonViewFilter = new SimplePropertyFilter();
    private JsonViewCallback jsonViewCallback = new StandartErrorConverter();
    private List<JsonErrorHandler> jsonErrors = new ArrayList<JsonErrorHandler>();
    private JsonStringWriter jsonWriter = new SojoJsonStringWriter();
    private String encoding;
    private String hijackSafePrefixPostFix = "JSON";
    private boolean hijackSafe = false;

    public JsonView() {
        this.setRequestContextAttribute(REQUEST_CONTEXT_ATTRIBUTE);
        this.setContentType(DEFAULT_JSON_CONTENT_TYPE);
        this.setEncoding(DEFAULT_ENCODING);
    }

    public void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType(this.getContentType());
        response.setCharacterEncoding(this.encoding);
        RequestContext rc = this.getRequestContext(model);
        BindingResult br = this.getBindingResult(model);
        String commandName = this.getCommandName(br);
        JsonWriterConfiguratorTemplateRegistry configuratorTemplateRegistry = this.getConfiguratorTemplateRegistry(request);
        this.jsonViewFilter.filterBeforePopulate(model, commandName);
        if (this.hasErrors(rc, br)) {
            this.jsonViewFilter.filterBeforePopulateErrors(model, commandName);
            this.jsonViewCallback.onPopulateErrors(model, rc, br);
            this.triggerJsonErrors(model, rc, br, request, response);
        } else {
            this.jsonViewFilter.filterBeforePopulateSuccess(model, commandName);
            this.jsonViewCallback.onPopulateSuccess(model, rc, br);
        }
        if (this.hijackSafe) {
            response.getWriter().print("/*" + this.hijackSafePrefixPostFix);
        }
        this.jsonWriter.convertAndWrite(model, configuratorTemplateRegistry, response.getWriter(), br);
        if (this.hijackSafe) {
            response.getWriter().print(this.hijackSafePrefixPostFix + "*/");
        }
    }

    protected boolean hasErrors(RequestContext rc, BindingResult br) {
        if (br == null) {
            return false;
        }
        return br.hasErrors();
    }

    protected void triggerJsonErrors(Map model, RequestContext rc, BindingResult br, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.jsonErrors == null || this.jsonErrors.size() == 0) {
            return;
        }
        for (JsonErrorHandler error : this.jsonErrors) {
            error.triggerError(model, rc, br, request, response);
        }
    }

    protected BindingResult getBindingResult(Map model) {
        for (Object key : model.keySet()) {
            if (!((String)key).startsWith(BindingResult.MODEL_KEY_PREFIX)) continue;
            return (BindingResult)model.remove(key);
        }
        return null;
    }

    protected String getCommandName(BindingResult br) {
        if (br == null) {
            return null;
        }
        return br.getObjectName();
    }

    protected RequestContext getRequestContext(Map model) {
        return (RequestContext)model.remove(this.getRequestContextAttribute());
    }

    protected JsonWriterConfiguratorTemplateRegistry getConfiguratorTemplateRegistry(HttpServletRequest request) {
        return JsonWriterConfiguratorTemplateRegistry.load(request);
    }

    public List<JsonErrorHandler> getJsonErrors() {
        return this.jsonErrors;
    }

    public void setJsonErrors(List<JsonErrorHandler> jsonErrors) {
        this.jsonErrors = jsonErrors;
    }

    public JsonViewCallback getJsonViewCallback() {
        return this.jsonViewCallback;
    }

    public void setJsonViewCallback(JsonViewCallback jsonViewCallback) {
        this.jsonViewCallback = jsonViewCallback;
    }

    public JsonStringWriter getJsonWriter() {
        return this.jsonWriter;
    }

    public void setJsonWriter(JsonStringWriter jsonWriter) {
        this.jsonWriter = jsonWriter;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean getHijackSafe() {
        return this.hijackSafe;
    }

    public void setHijackSafe(boolean hijackSafe) {
        this.hijackSafe = hijackSafe;
    }

    public String getHijackSafePrefixPostFix() {
        return this.hijackSafePrefixPostFix;
    }

    public void setHijackSafePrefixPostFix(String hijackSafePrefixPostFix) {
        this.hijackSafePrefixPostFix = hijackSafePrefixPostFix;
    }

    public JsonViewFilter getJsonViewFilter() {
        return this.jsonViewFilter;
    }

    public void setJsonViewFilter(JsonViewFilter jsonViewFilter) {
        this.jsonViewFilter = jsonViewFilter;
    }
}

