/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.concurrent.LockType;
import net.sf.ehcache.concurrent.ReadWriteLockSync;
import net.sf.ehcache.concurrent.StripedReadWriteLockSync;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.store.AbstractStore;
import net.sf.ehcache.store.Policy;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.writer.CacheWriterManager;

public class LegacyStoreWrapper
extends AbstractStore {
    private static final int SYNC_STRIPES = 64;
    private final Store memory;
    private final Store disk;
    private final RegisteredEventListeners eventListeners;
    private final CacheConfiguration config;
    private final StripedReadWriteLockSync sync = new StripedReadWriteLockSync(64);

    public LegacyStoreWrapper(Store memory, Store disk, RegisteredEventListeners eventListeners, CacheConfiguration config) {
        this.memory = memory;
        this.disk = disk;
        this.eventListeners = eventListeners;
        this.config = config;
    }

    public boolean bufferFull() {
        if (this.disk == null) {
            return false;
        }
        return this.disk.bufferFull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        ReadWriteLockSync s = this.sync.getSyncForKey(key);
        s.lock(LockType.READ);
        try {
            if (key instanceof Serializable && this.disk != null) {
                boolean bl = this.disk.containsKey(key) || this.memory.containsKey(key);
                return bl;
            }
            boolean bl = this.memory.containsKey(key);
            return bl;
        }
        finally {
            s.unlock(LockType.READ);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKeyInMemory(Object key) {
        ReadWriteLockSync s = this.sync.getSyncForKey(key);
        s.lock(LockType.READ);
        try {
            boolean bl = this.memory.containsKey(key);
            return bl;
        }
        finally {
            s.unlock(LockType.READ);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKeyOnDisk(Object key) {
        ReadWriteLockSync s = this.sync.getSyncForKey(key);
        s.lock(LockType.READ);
        try {
            if (this.disk != null) {
                boolean bl = this.disk.containsKey(key);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            s.unlock(LockType.READ);
        }
    }

    public void dispose() {
        this.memory.dispose();
        if (this.disk != null) {
            this.disk.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireElements() {
        Object[] keys;
        for (Object key : keys = this.memory.getKeyArray()) {
            ReadWriteLockSync s = this.sync.getSyncForKey(key);
            s.lock(LockType.WRITE);
            try {
                Element e;
                Element element = this.memory.getQuiet(key);
                if (element == null || !element.isExpired(this.config) || (e = this.remove(key)) == null) continue;
                this.eventListeners.notifyElementExpiry(e, false);
            }
            finally {
                s.unlock(LockType.WRITE);
            }
        }
        if (this.disk != null) {
            this.disk.expireElements();
        }
    }

    public void flush() throws IOException {
        this.memory.flush();
        if (this.disk != null) {
            this.disk.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element get(Object key) {
        ReadWriteLockSync s = this.sync.getSyncForKey(key);
        s.lock(LockType.READ);
        try {
            Element e = this.memory.get(key);
            if (e == null && this.disk != null && (e = this.disk.get(key)) != null) {
                this.memory.put(e);
            }
            Element element = e;
            return element;
        }
        finally {
            s.unlock(LockType.READ);
        }
    }

    public Policy getInMemoryEvictionPolicy() {
        return this.memory.getInMemoryEvictionPolicy();
    }

    public int getInMemorySize() {
        return this.memory.getSize();
    }

    public long getInMemorySizeInBytes() {
        return this.memory.getInMemorySizeInBytes();
    }

    public Object getInternalContext() {
        return this.sync;
    }

    public Object[] getKeyArray() {
        if (this.disk == null) {
            return this.memory.getKeyArray();
        }
        HashSet<Object> keys = new HashSet<Object>();
        keys.addAll(Arrays.asList(this.memory.getKeyArray()));
        keys.addAll(Arrays.asList(this.disk.getKeyArray()));
        return keys.toArray();
    }

    public int getOnDiskSize() {
        if (this.disk != null) {
            return this.disk.getSize();
        }
        return 0;
    }

    public long getOnDiskSizeInBytes() {
        if (this.disk != null) {
            return this.disk.getOnDiskSizeInBytes();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getQuiet(Object key) {
        ReadWriteLockSync s = this.sync.getSyncForKey(key);
        s.lock(LockType.READ);
        try {
            Element e = this.memory.getQuiet(key);
            if (e == null && this.disk != null && (e = this.disk.getQuiet(key)) != null) {
                this.memory.put(e);
            }
            Element element = e;
            return element;
        }
        finally {
            s.unlock(LockType.READ);
        }
    }

    public int getSize() {
        if (this.disk != null) {
            HashSet<Object> keys = new HashSet<Object>();
            keys.addAll(Arrays.asList(this.memory.getKeyArray()));
            keys.addAll(Arrays.asList(this.disk.getKeyArray()));
            return keys.size();
        }
        return this.memory.getSize();
    }

    public Status getStatus() {
        return this.memory.getStatus();
    }

    public int getTerracottaClusteredSize() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(Element element) throws CacheException {
        if (element == null) {
            return false;
        }
        ReadWriteLockSync s = this.sync.getSyncForKey(element.getObjectKey());
        s.lock(LockType.WRITE);
        try {
            boolean notOnDisk = !this.containsKeyOnDisk(element.getObjectKey());
            boolean bl = this.memory.put(element) && notOnDisk;
            return bl;
        }
        finally {
            s.unlock(LockType.WRITE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putWithWriter(Element element, CacheWriterManager writerManager) throws CacheException {
        if (element == null) {
            return false;
        }
        ReadWriteLockSync s = this.sync.getSyncForKey(element.getObjectKey());
        s.lock(LockType.WRITE);
        try {
            boolean notOnDisk = !this.containsKey(element.getObjectKey());
            boolean bl = this.memory.putWithWriter(element, writerManager) && notOnDisk;
            return bl;
        }
        finally {
            s.unlock(LockType.WRITE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element remove(Object key) {
        ReadWriteLockSync s = this.sync.getSyncForKey(key);
        s.lock(LockType.WRITE);
        try {
            Element m = this.memory.remove(key);
            if (this.disk != null && key instanceof Serializable) {
                Element d = this.disk.remove(key);
                if (m == null) {
                    Element element = d;
                    return element;
                }
            }
            Element element = m;
            return element;
        }
        finally {
            s.unlock(LockType.WRITE);
        }
    }

    public void removeAll() throws CacheException {
        this.memory.removeAll();
        if (this.disk != null) {
            this.disk.removeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element removeWithWriter(Object key, CacheWriterManager writerManager) throws CacheException {
        ReadWriteLockSync s = this.sync.getSyncForKey(key);
        s.lock(LockType.WRITE);
        try {
            Element m = this.memory.removeWithWriter(key, writerManager);
            if (this.disk != null && key instanceof Serializable) {
                Element d = this.disk.removeWithWriter(key, writerManager);
                if (m == null) {
                    Element element = d;
                    return element;
                }
            }
            Element element = m;
            return element;
        }
        finally {
            s.unlock(LockType.WRITE);
        }
    }

    public void setInMemoryEvictionPolicy(Policy policy) {
        this.memory.setInMemoryEvictionPolicy(policy);
    }

    public Store getDiskStore() {
        return this.disk;
    }

    public Store getMemoryStore() {
        return this.memory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element putIfAbsent(Element element) throws NullPointerException {
        ReadWriteLockSync lock = this.sync.getSyncForKey(element.getObjectKey());
        lock.lock(LockType.WRITE);
        try {
            Element e = this.getQuiet(element.getObjectKey());
            if (e == null) {
                this.put(element);
            }
            Element element2 = e;
            return element2;
        }
        finally {
            lock.unlock(LockType.WRITE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element removeElement(Element element) throws NullPointerException {
        ReadWriteLockSync lock = this.sync.getSyncForKey(element.getObjectKey());
        lock.lock(LockType.WRITE);
        try {
            Element current = this.getQuiet(element.getObjectKey());
            if (LegacyStoreWrapper.fullElementEquals(element, current)) {
                Element element2 = this.remove(current.getObjectKey());
                return element2;
            }
            Element element3 = null;
            return element3;
        }
        finally {
            lock.unlock(LockType.WRITE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replace(Element old, Element element) throws NullPointerException, IllegalArgumentException {
        ReadWriteLockSync lock = this.sync.getSyncForKey(old.getObjectKey());
        lock.lock(LockType.WRITE);
        try {
            Element current = this.getQuiet(old.getObjectKey());
            if (LegacyStoreWrapper.fullElementEquals(old, current)) {
                this.put(element);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock(LockType.WRITE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element replace(Element element) throws NullPointerException {
        ReadWriteLockSync lock = this.sync.getSyncForKey(element.getObjectKey());
        lock.lock(LockType.WRITE);
        try {
            Element current = this.getQuiet(element.getObjectKey());
            if (current != null) {
                this.put(element);
            }
            Element element2 = current;
            return element2;
        }
        finally {
            lock.unlock(LockType.WRITE);
        }
    }

    private static boolean fullElementEquals(Element e1, Element e2) {
        if (e1.equals(e2)) {
            if (e1.getObjectValue() == null) {
                return e2.getObjectValue() == null;
            }
            return e1.getObjectValue().equals(e2.getObjectValue());
        }
        return false;
    }
}

