/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing;

import com.supermap.data.Colors;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetImage;
import com.supermap.data.GeoRegion;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.PrjCoordSysType;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.processing.CacheBuilderSCI3DNative;
import com.supermap.data.processing.CacheImageType;
import com.supermap.data.processing.InternalColors;
import com.supermap.data.processing.InternalEnum;
import com.supermap.data.processing.InternalGeoRegion;
import com.supermap.data.processing.InternalGeometry;
import com.supermap.data.processing.InternalHandle;
import com.supermap.data.processing.InternalResource;
import com.supermap.data.processing.InternalToolkitProcessing;
import com.supermap.data.processing.StorageType;
import com.supermap.data.processing.Tile;
import com.supermap.data.processing.Tiles;
import java.awt.Color;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageCacheBuilder
extends com.supermap.data.processing.InternalHandleDisposable {
    private Dataset _$9 = null;
    private boolean _$8 = true;
    private GeoRegion _$7 = null;
    private long _$6;
    transient Vector m_steppedListeners;
    private static String _$5;
    private String _$4;
    private String _$3;
    private Colors _$2 = null;
    private double[] _$1 = null;

    public ImageCacheBuilder() {
        long l = CacheBuilderSCI3DNative.jni_New();
        this.setHandle(l, true);
        Colors colors = new Colors();
        com.supermap.data.processing.InternalHandleDisposable.setIsDisposable((InternalHandleDisposable)colors, false);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)colors);
        this._$2 = InternalColors.createInstance(l2, false);
        this._$6 = CacheBuilderSCI3DNative.jni_NewSelfEventHandle(this);
    }

    public ImageCacheBuilder(DatasetImage datasetImage, String string) {
        this();
        this.setDataset(datasetImage);
        this.setOutputFolder(string);
        this.computeLevel();
    }

    public ImageCacheBuilder(DatasetImage datasetImage, String string, String string2) {
        this();
        this.setDataset(datasetImage);
        this.setOutputFolder(string);
        this.setCacheName(string2);
        this.computeLevel();
    }

    public DatasetImage getDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDataset()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        DatasetImage datasetImage = null;
        if (this._$9 instanceof DatasetImage) {
            datasetImage = (DatasetImage)this._$9;
        }
        return datasetImage;
    }

    public void setDataset(DatasetImage datasetImage) {
        if (datasetImage == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetImage);
        if (l == 0L) {
            String string = InternalResource.loadString("dataset", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDataset()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        this._$9 = datasetImage;
        this._$8 = true;
        CacheBuilderSCI3DNative.jni_SetDataset(this.getHandle(), l);
    }

    public DatasetGrid getDatasetGrid() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDatasetGrid()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        DatasetGrid datasetGrid = null;
        if (this._$9 instanceof DatasetGrid) {
            datasetGrid = (DatasetGrid)this._$9;
        }
        return datasetGrid;
    }

    public void setDatasetGrid(DatasetGrid datasetGrid) {
        if (datasetGrid == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        if (l == 0L) {
            String string = InternalResource.loadString("dataset", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDataset()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        this._$9 = datasetGrid;
        this._$8 = true;
        CacheBuilderSCI3DNative.jni_SetDataset(this.getHandle(), l);
    }

    public String getOutputFolder() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutputFolder()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderSCI3DNative.jni_GetOutputFolder(this.getHandle());
    }

    public void setOutputFolder(String string) {
        File file = new File(string);
        if (!file.exists()) {
            String string2 = InternalResource.loadString("outputFolder", InternalResource.CacheBuilderSCI3DOutputFolderNotExists, "processing_resources");
            throw new IllegalStateException(string2);
        }
        if (this.getHandle() == 0L) {
            String string3 = InternalResource.loadString("setOutputFolder()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string3);
        }
        CacheBuilderSCI3DNative.jni_SetOutputFolder(this.getHandle(), string);
    }

    public String getCacheName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCacheName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderSCI3DNative.jni_GetCacheName(this.getHandle());
    }

    public void setCacheName(String string) {
        if (string == null || string.trim().length() == 0) {
            String string2 = InternalResource.loadString("setCacheName()", "Global_StringIsNullOrEmpty", "processing_resources");
            throw new IllegalArgumentException(string2);
        }
        if (this.getHandle() == 0L) {
            String string3 = InternalResource.loadString("setCacheName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string3);
        }
        CacheBuilderSCI3DNative.jni_SetCacheName(this.getHandle(), string);
    }

    public GeoRegion getClipRegion() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getClipRegion()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this._$7 == null) {
            long l = CacheBuilderSCI3DNative.jni_GetClipRegion(this.getHandle());
            if (l != 0L) {
                this._$7 = (GeoRegion)InternalGeometry.createInstance(l);
                com.supermap.data.processing.InternalHandleDisposable.setIsDisposable((InternalHandleDisposable)this._$7, false);
                if (this._$7.isEmpty()) {
                    this._$7 = null;
                }
            }
        } else {
            long l = CacheBuilderSCI3DNative.jni_GetClipRegion(this.getHandle());
            InternalGeoRegion.clearHandle(this._$7);
            InternalGeoRegion.refreshHandle(this._$7, l);
        }
        return this._$7;
    }

    public void setClipRegion(GeoRegion geoRegion) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setClipRegion(GeoRegion geoRegion)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (geoRegion == null) {
            CacheBuilderSCI3DNative.jni_SetClipRegion(this.getHandle(), 0L);
            this._$7 = null;
        } else {
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion);
            if (l == 0L) {
                String string = InternalResource.loadString("geoRegion", "Global_ArgumentObjectHasBeenDisposed", "processing_resources");
                throw new IllegalArgumentException(string);
            }
            CacheBuilderSCI3DNative.jni_SetClipRegion(this.getHandle(), l);
        }
        com.supermap.data.processing.InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion);
    }

    public boolean computeOutputScales() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("computeOutputScales()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = CacheBuilderSCI3DNative.jni_ComputeOutputScales(this.getHandle());
        return bl;
    }

    public double[] getDefaultOutputScales() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDefultOutputScales()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderSCI3DNative.jni_GetDefaultOutputScales(this.getHandle());
    }

    public HashMap<Double, String> getOutputScaleCaptions() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutputScaleCaptions()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = CacheBuilderSCI3DNative.jni_GetOutputScalesCount(this.getHandle());
        double[] dArray = new double[n];
        String[] stringArray = new String[n];
        HashMap<Double, String> hashMap = new HashMap<Double, String>();
        CacheBuilderSCI3DNative.jni_GetOutputScaleCaptions(this.getHandle(), dArray, stringArray);
        for (int i = 0; i < n; ++i) {
            hashMap.put(dArray[i], stringArray[i]);
        }
        return hashMap;
    }

    public void setOutputScaleCaptions(HashMap<Double, String> hashMap) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOutputScaleCaptions()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (hashMap == null) {
            String string = InternalResource.loadString("setOutputScaleCaptions()", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = hashMap.size();
        double[] dArray = new double[n];
        String[] stringArray = new String[n];
        Set<Map.Entry<Double, String>> set = hashMap.entrySet();
        Iterator<Map.Entry<Double, String>> iterator = set.iterator();
        Map.Entry<Double, String> entry = null;
        for (int i = 0; i < n; ++i) {
            entry = iterator.next();
            dArray[i] = entry.getKey();
            stringArray[i] = entry.getValue();
        }
        CacheBuilderSCI3DNative.jni_SetOutputScaleCaptions(this.getHandle(), dArray, stringArray);
    }

    public double[] getOutputScales() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutputScales()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderSCI3DNative.jni_GetOutputScales(this.getHandle());
    }

    public void setOutputScales(double[] dArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOutputScales()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (!CacheBuilderSCI3DNative.jni_SetOutputScales(this.getHandle(), dArray)) {
            String string = InternalResource.loadString("setOutputScales()", "CacheBuilder_IllegalScales", "processing_resources");
            throw new IllegalArgumentException(string);
        }
    }

    @Deprecated
    public int getBeginLevel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBeginLevel()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderSCI3DNative.jni_GetBeginLevel(this.getHandle());
    }

    @Deprecated
    public void setBeginLevel(int n) {
        if (n < 0) {
            String string = InternalResource.loadString("beginLevel", "CacheBuilderSCI3D_BeginLevelShouldNotBeNegative", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBeginLevel()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0) {
            // empty if block
        }
        CacheBuilderSCI3DNative.jni_SetBeginLevel(this.getHandle(), n);
    }

    public String getImageFileName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImageFileName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this._$4;
    }

    public void setImageFileName(String string) {
        if (string == null || string.trim().length() == 0) {
            String string2 = InternalResource.loadString("imageFileName", "CacheBuilderSCI3D_ImageFileNameShouldNotBeNull", "processing_resources");
            throw new IllegalStateException(string2);
        }
        if (this.getHandle() == 0L) {
            String string3 = InternalResource.loadString("setImageFileName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string3);
        }
        this._$4 = string;
        this._$8 = false;
        CacheBuilderSCI3DNative.jni_SetImageFileName(this.getHandle(), string);
    }

    public CacheImageType getImageType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImageType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = CacheBuilderSCI3DNative.jni_GetImageType(this.getHandle());
        return (CacheImageType)InternalEnum.parseUGCValue(CacheImageType.class, n);
    }

    public void setImageType(CacheImageType cacheImageType) {
        if (cacheImageType == null) {
            String string = InternalResource.loadString("imageType", "CacheBuilderSCI3D_CacheImageTypeShouldNotBeNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImageType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderSCI3DNative.jni_SetImageType(this.getHandle(), cacheImageType.value());
    }

    public StorageType getStorageType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStorageType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = CacheBuilderSCI3DNative.jni_GetStorageType(this.getHandle());
        return (StorageType)InternalEnum.parseUGCValue(StorageType.class, n);
    }

    public void setStorageType(StorageType storageType) {
        if (storageType == null) {
            String string = InternalResource.loadString("storageType", "CacheBuilderS_StorageTypeShouldNotBeNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStorageType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderSCI3DNative.jni_SetStorageType(this.getHandle(), storageType.value());
    }

    @Deprecated
    public int getEndLevel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getEndLevel()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderSCI3DNative.jni_GetEndLevel(this.getHandle());
    }

    @Deprecated
    public void setEndLevel(int n) {
        if (n < 0) {
            String string = InternalResource.loadString("endLevel", InternalResource.CacheBuilderSCI3DEndLevelShouldNotBeNegative, "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEndLevel()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderSCI3DNative.jni_SetEndLevel(this.getHandle(), n);
    }

    @Deprecated
    public int getDefaultBeginLevel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDefaultBeginLevel()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderSCI3DNative.jni_GetDefaultBeginLevel(this.getHandle());
    }

    @Deprecated
    public int getDefaultEndLevel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDefaultEndLevel", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderSCI3DNative.jni_GetDefaultEndLevel(this.getHandle());
    }

    public int getSampleSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSampleSize()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderSCI3DNative.jni_GetSampleSize(this.getHandle());
    }

    public void setSampleSize(int n) {
        if (n < 0) {
            String string = InternalResource.loadString("sampleSize", InternalResource.CacheBuilderSCI3DSampleSizeShouldNotBeNegative, "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSampleSize()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderSCI3DNative.jni_SetSampleSize(this.getHandle(), n);
    }

    public String getPassword() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPassword()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this._$3;
    }

    public void setPassword(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setPassword()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string2);
        }
        this._$3 = string;
    }

    public Colors getColorTable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getColorTable()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        long l = CacheBuilderSCI3DNative.jni_GetColorTable(this.getHandle());
        if (this._$2 != null && l != 0L && InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$2) != l) {
            InternalColors.changeHandle(this._$2, l);
        }
        return this._$2;
    }

    public void setColorTable(Colors colors) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setColorTable(Colors colorTable)()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        Colors colors2 = new Colors(colors);
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)colors2);
        CacheBuilderSCI3DNative.jni_SetColorTable(this.getHandle(), l);
        com.supermap.data.processing.InternalHandleDisposable.makeSureNativeObjectLive((Object)colors2);
    }

    public double[] getGridValueTable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGridValueTable()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this._$1;
    }

    public void setGridValueTable(double[] dArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGridValueTable(double[] value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (dArray == null) {
            String string = InternalResource.loadString("", "Global_ArgumentNull", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray2 = (double[])dArray.clone();
        CacheBuilderSCI3DNative.jni_SetGridValueTable(this.getHandle(), dArray2);
        this._$1 = dArray;
    }

    public Color getSpecialValueColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getColorTable()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = CacheBuilderSCI3DNative.jni_GetGridSpecialValueColor(this.getHandle());
        return new Color(n);
    }

    public void setSpecialValueColor(Color color) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSpecialValueColor(Color value)()", "Handle_ObjectHasBeenDisposed", "processing_resources");
        }
        int n = color.getRGB();
        CacheBuilderSCI3DNative.jni_SetGridSpecialValueColor(this.getHandle(), n);
    }

    public double getSpecialValue() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSpecialValue()", "Handle_ObjectHasBeenDisposed", "processing_resources");
        }
        return CacheBuilderSCI3DNative.jni_GetGridSpecialValue(this.getHandle());
    }

    public void setSpecialValue(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSpecialValue(double value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
        }
        CacheBuilderSCI3DNative.jni_SetGridSpecialValue(this.getHandle(), d);
    }

    public boolean isSpecialValueTransparent() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isSpecialValueColorTransparent()", "Handle_ObjectHasBeenDisposed", "processing_resources");
        }
        return CacheBuilderSCI3DNative.jni_IsSpecialValueTransparent(this.getHandle());
    }

    public void setSpecialValueTransparent(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSpecialValueColorTransparent(boolean transparent)", "Handle_ObjectHasBeenDisposed", "processing_resources");
        }
        CacheBuilderSCI3DNative.jni_SetSpecialValueTransparent(this.getHandle(), bl);
    }

    public PrjCoordSysType getDynamicPrjCoordSysType() {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isDynamicProjection()", "Handle_ObjectHasBeenDisposed", "processing_resources");
        }
        PrjCoordSysType prjCoordSysType = (n = CacheBuilderSCI3DNative.jni_GetDynamicPrjCoordSysType(this.getHandle())) == 1 ? PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE : PrjCoordSysType.PCS_NON_EARTH;
        return prjCoordSysType;
    }

    public void setDynamicPrjCoordSysType(PrjCoordSysType prjCoordSysType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDynamicProjection(boolean dynamicProjection)", "Handle_ObjectHasBeenDisposed", "processing_resources");
        }
        int n = prjCoordSysType == PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE ? 1 : 0;
        CacheBuilderSCI3DNative.jni_SetDynamicPrjCoordSysType(this.getHandle(), n);
    }

    public boolean build() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("build()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this._$8) {
            if (this._$9 == null) {
                String string = InternalResource.loadString("dataset", "Handle_ObjectHasBeenDisposed", "processing_resources");
                throw new IllegalStateException(string);
            }
            if (this._$9 != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$9) == 0L) {
                String string = InternalResource.loadString("dataset", "Handle_ObjectHasBeenDisposed", "processing_resources");
                throw new IllegalStateException(string);
            }
        }
        if (this.getOutputFolder() == null || this.getOutputFolder().trim().length() == 0) {
            String string = InternalResource.loadString("ouputFolder", "Global_StringIsNullOrEmpty", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getBeginLevel() > this.getEndLevel()) {
            String string = InternalResource.loadString("build()", InternalResource.CacheBuilderSCI3DEndLevelShouldNotLessThanBeginLevel, "processing_resources");
            throw new IllegalArgumentException(string);
        }
        if (this._$3 == null || this._$3.trim().length() == 0) {
            return CacheBuilderSCI3DNative.jni_Build(this.getHandle(), this._$6);
        }
        return CacheBuilderSCI3DNative.jni_BuildWithPassword(this.getHandle(), this._$6, this._$3);
    }

    public boolean buildWithoutConfigFile() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("build(String password)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this._$8) {
            if (this._$9 == null) {
                String string = InternalResource.loadString("dataset", "Handle_ObjectHasBeenDisposed", "processing_resources");
                throw new IllegalStateException(string);
            }
            if (this._$9 != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$9) == 0L) {
                String string = InternalResource.loadString("dataset", "Handle_ObjectHasBeenDisposed", "processing_resources");
                throw new IllegalStateException(string);
            }
        }
        if (this.getOutputFolder() == null || this.getOutputFolder().trim().length() == 0) {
            String string = InternalResource.loadString("ouputFolder", "Global_StringIsNullOrEmpty", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getBeginLevel() > this.getEndLevel()) {
            String string = InternalResource.loadString("build(String password)", InternalResource.CacheBuilderSCI3DEndLevelShouldNotLessThanBeginLevel, "processing_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        bl = this._$3 == null || this._$3.trim().length() == 0 ? CacheBuilderSCI3DNative.jni_BuildWithoutConfigFile(this.getHandle(), this._$6) : CacheBuilderSCI3DNative.jni_BuildWithoutConfigFile(this.getHandle(), this._$6, this._$3);
        ((Object)((Object)this)).hashCode();
        return bl;
    }

    @Deprecated
    public boolean computeLevel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("computeLevel()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this._$8 && (this._$9 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$9) == 0L)) {
            String string = InternalResource.loadString("dataset", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderSCI3DNative.jni_ComputeLevel(this.getHandle());
    }

    @Deprecated
    public String[] computeImageFileName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ComputeImageFileName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this._$8 && (this._$9 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$9) == 0L)) {
            String string = InternalResource.loadString("dataset", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = CacheBuilderSCI3DNative.jni_ComputeImageFileName(this.getHandle());
        return InternalToolkitProcessing.splitString(string, ";");
    }

    @Deprecated
    public String[] computeImageFileName(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ComputeImageFileName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this._$8 && (this._$9 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$9) == 0L)) {
            String string = InternalResource.loadString("dataset", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = CacheBuilderSCI3DNative.jni_ComputeImageFileName(this.getHandle(), n);
        return InternalToolkitProcessing.splitString(string, ";");
    }

    public boolean toConfigFile(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("ToFile(String path)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string2);
        }
        return CacheBuilderSCI3DNative.jni_ToFile(this.getHandle(), string);
    }

    public boolean fromConfigFile(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("FromFile(String path)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string2);
        }
        return CacheBuilderSCI3DNative.jni_FromFile(this.getHandle(), string);
    }

    public Tile[] getTiles(Rectangle2D rectangle2D, double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTiles()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        Tiles tiles = null;
        long l = CacheBuilderSCI3DNative.jni_GetTiles(this.getHandle(), rectangle2D.getLeft(), rectangle2D.getTop(), rectangle2D.getRight(), rectangle2D.getBottom(), d);
        tiles = new Tiles(l);
        Tile[] tileArray = new Tile[tiles.getCount()];
        for (int i = 0; i < tiles.getCount(); ++i) {
            tileArray[i] = tiles.get(i);
        }
        return tileArray;
    }

    protected void fireStepped(SteppedEvent steppedEvent) {
        if (this.m_steppedListeners != null) {
            Vector vector = this.m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(steppedEvent);
            }
        }
    }

    static void steppedCallBack(ImageCacheBuilder imageCacheBuilder, int n, long l, String string, String string2, long l2) {
        if (imageCacheBuilder != null) {
            _$5 = "build";
            boolean bl = InternalToolkitProcessing.getHandleBooleanValue(l2);
            SteppedEvent steppedEvent = new SteppedEvent((Object)imageCacheBuilder, n, l, string, string2, _$5, bl);
            imageCacheBuilder.fireStepped(steppedEvent);
            InternalToolkitProcessing.setHandleBooleanValue(l2, steppedEvent.getCancel());
        }
    }

    public synchronized void addSteppedListener(SteppedListener steppedListener) {
        if (this.m_steppedListeners == null) {
            this.m_steppedListeners = new Vector();
        }
        if (!this.m_steppedListeners.contains(steppedListener)) {
            this.m_steppedListeners.add(steppedListener);
        }
    }

    public synchronized void removeSteppedListener(SteppedListener steppedListener) {
        if (this.m_steppedListeners != null && this.m_steppedListeners.contains(steppedListener)) {
            this.m_steppedListeners.remove(steppedListener);
        }
    }

    private void _$1() {
        if (this._$6 != 0L) {
            CacheBuilderSCI3DNative.jni_DeleteSelfEventHandle(this._$6);
            this._$6 = 0L;
        }
    }

    protected void clearHandle() {
        if (this._$9 != null) {
            this._$9 = null;
        }
        if (this._$7 != null) {
            InternalGeoRegion.clearHandle(this._$7);
            this._$7 = null;
        }
        this.setHandle(0L);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            CacheBuilderSCI3DNative.jni_Delete(this.getHandle());
            this.clearHandle();
            this._$1();
        }
    }
}

