/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.Charset;
import com.supermap.data.DatasetType;
import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.EncodeType;
import com.supermap.data.FieldType;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.License;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.conversion.DataType;
import com.supermap.data.conversion.FileType;
import com.supermap.data.conversion.ImportDataInfo;
import com.supermap.data.conversion.ImportDataInfoCSV;
import com.supermap.data.conversion.ImportDataInfoNative;
import com.supermap.data.conversion.ImportDataInfos;
import com.supermap.data.conversion.ImportMode;
import com.supermap.data.conversion.ImportSettingCSVNative;
import com.supermap.data.conversion.ImportSettingNative;
import com.supermap.data.conversion.InternalDatasourceConnectionInfo;
import com.supermap.data.conversion.InternalEnum;
import com.supermap.data.conversion.InternalPrjCoordSys;
import com.supermap.data.conversion.InternalResource;
import com.supermap.data.conversion.InternalToolkiConversion;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ImportSetting
extends InternalHandleDisposable {
    private DatasourceConnectionInfo _$9;
    private PrjCoordSys _$8;
    private DataType _$7;
    private ArrayList<Boolean> _$6;
    private Datasource _$5;
    ImportDataInfos m_dataInfos;
    private static int _$4 = -1;
    private static int _$3 = -1;
    private static int _$2 = -1;
    private static int _$1 = -1;

    public String getSourceFilePath() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSourceFilePath()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return ImportSettingNative.jni_GetSourceFilePath(this.getHandle());
    }

    public void setSourceFilePath(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setSourceFilePath(String path)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("path", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string3);
        }
        File file = new File(string);
        if (!file.exists()) {
            String string4 = InternalResource.loadString(file.getAbsolutePath(), "Global_PathIsNotValid", "conversion_resources");
            throw new IllegalArgumentException(string4);
        }
        ImportSettingNative.jni_SetSourceFilePath(this.getHandle(), file.getPath());
    }

    public String getTargetDatasetName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSourceFilePath()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return ImportSettingNative.jni_GetTargetDatasetName(this.getHandle());
    }

    public void setTargetDatasetName(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setSourceFilePath(String path)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("path", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string3);
        }
        ImportSettingNative.jni_SetTargetDatasetName(this.getHandle(), string);
    }

    public FileType getSourceFileType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSourceFileType()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ImportSettingNative.jni_GetSourceFileType(this.getHandle());
        return (FileType)InternalEnum.parseUGCValue(FileType.class, n);
    }

    public DatasourceConnectionInfo getTargetDatasourceConnectionInfo() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTargetDatasourceConnectionInfo()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return this._$9;
    }

    public void setTargetDatasourceConnectionInfo(DatasourceConnectionInfo datasourceConnectionInfo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTargetDatasourceConnectionInfo()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (datasourceConnectionInfo == null) {
            if (this._$9 != null) {
                InternalDatasourceConnectionInfo.clearHandle(this._$9);
                this._$9 = null;
            }
        } else {
            long l = InternalHandle.getHandle((InternalHandle)datasourceConnectionInfo);
            if (l == 0L) {
                String string = InternalResource.loadString("setTargetDatasourceConnectionInfo(DatasourceConnectionInfo connectionInfo)", "Datasources_ConnectionInfoIsInvalid", "conversion_resources");
                throw new IllegalStateException(string);
            }
            this._$9 = this.cloneDatasourceConnectionInfo(datasourceConnectionInfo);
            this.setTargetDatasource(null);
        }
    }

    public Datasource getTargetDatasource() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTargetDatasource()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return this._$5;
    }

    public void setTargetDatasource(Datasource datasource) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTargetDatasource(Datasource datasource)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        this._$5 = datasource;
        if (this._$5 != null) {
            this.setTargetDatasourceConnectionInfo(null);
        }
    }

    public EncodeType getTargetEncodeType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getEncodeType()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ImportSettingNative.jni_GetEncodeType(this.getHandle());
        return (EncodeType)InternalEnum.parseUGCValue(EncodeType.class, n);
    }

    @Deprecated
    public EncodeType getEncodeType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getEncodeType()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ImportSettingNative.jni_GetEncodeType(this.getHandle());
        return (EncodeType)InternalEnum.parseUGCValue(EncodeType.class, n);
    }

    @Deprecated
    public void setEncodeType(EncodeType encodeType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEncodeType(EncodeType type)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        ImportSettingNative.jni_SetEncodeType(this.getHandle(), encodeType.value());
    }

    public Charset getSourceFileCharset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getEncodeType()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ImportSettingNative.jni_GetFileCharset(this.getHandle());
        return (Charset)InternalEnum.parseUGCValue(Charset.class, n);
    }

    public void setSourceFileCharset(Charset charset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEncodeType(EncodeType type)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        ImportSettingNative.jni_SetFileCharset(this.getHandle(), charset.value());
    }

    public void setTargetEncodeType(EncodeType encodeType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEncodeType(EncodeType type)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        ImportSettingNative.jni_SetEncodeType(this.getHandle(), encodeType.value());
    }

    public PrjCoordSys getTargetPrjCoordSys() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTargetPrjCoordSys()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return this._$8;
    }

    public void setTargetPrjCoordSys(PrjCoordSys prjCoordSys) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTargetPrjCoordSys(PrjCoordSys prjCoordSys)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (prjCoordSys == null) {
            if (this._$8 != null) {
                InternalPrjCoordSys.clearHandle(this._$8);
                this._$8 = null;
            }
        } else {
            this._$8 = prjCoordSys.clone();
            long l = InternalHandle.getHandle((InternalHandle)this._$8);
            if (l == 0L) {
                String string = InternalResource.loadString("prjCoordSys", "Global_InvalidConstructorArgument", "conversion_resources");
                throw new IllegalArgumentException(string);
            }
            ImportSettingNative.jni_SetTargetPrjCoordSys(this.getHandle(), l);
            InternalHandleDisposable.makeSureNativeObjectLive((Object)prjCoordSys);
        }
    }

    public ImportMode getImportMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImportMode()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ImportSettingNative.jni_GetImportMode(this.getHandle());
        return (ImportMode)InternalEnum.parseUGCValue(ImportMode.class, n);
    }

    public void setImportMode(ImportMode importMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportMode(ImportMode importMode)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = importMode.value();
        ImportSettingNative.jni_SetImportMode(this.getHandle(), n);
    }

    @Deprecated
    public String toXML() {
        return "";
    }

    @Deprecated
    public boolean fromXML(String string) {
        return false;
    }

    public ImportDataInfos getTargetDataInfos(String string) {
        this.CheakFMELicense();
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("getTargetDataInfos(String targetNamePrefix)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string2);
        }
        ImportDataInfos importDataInfos = null;
        long l = ImportSettingNative.jni_GetTargetDataInfos(this.getHandle(), string);
        if (l != 0L) {
            if (this._$7 == DataType.VECTOR) {
                importDataInfos = new ImportDataInfos(l, this.getSourceFileType(), DataType.VECTOR, this.getSourceFilePath(), "");
                if (this.getStates() == null) {
                    this.setStates((ArrayList)importDataInfos.getStates().clone());
                } else {
                    importDataInfos.setStates(this.getStates());
                }
            } else if (this._$7 == DataType.RASTER) {
                importDataInfos = new ImportDataInfos(l, this.getSourceFileType(), DataType.RASTER, this.getSourceFilePath(), "");
                if (this.getStates() == null) {
                    this.setStates((ArrayList)importDataInfos.getStates().clone());
                } else {
                    importDataInfos.setStates(this.getStates());
                }
            } else {
                importDataInfos = this.m_dataInfos = new ImportDataInfos(this.getHandle(), this.getSourceFileType(), DataType.WOR, this.getSourceFilePath(), "");
            }
        }
        return importDataInfos;
    }

    public ImportDataInfos getTargetDataInfos(String string, EncodeType encodeType, PrjCoordSys prjCoordSys) {
        this.CheakFMELicense();
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("getTargetDataInfos(String targetNamePrefix,EncodeType targetEncodeType, PrjCoordSys targetPrjCoordSy)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string2);
        }
        if (encodeType == null) {
            String string3 = InternalResource.loadString("targetEncodeType", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string3);
        }
        if (prjCoordSys == null) {
            String string4 = InternalResource.loadString("targetPrjCoordSy", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string4);
        }
        long l = InternalHandle.getHandle((InternalHandle)prjCoordSys);
        if (l == 0L) {
            String string5 = InternalResource.loadString("targetPrjCoordSy", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string5);
        }
        ImportDataInfos importDataInfos = null;
        int n = encodeType.value();
        long l2 = ImportSettingNative.jni_GetTargetDataInfos2(this.getHandle(), string, n, l);
        if (l2 != 0L) {
            if (this._$7 == DataType.VECTOR) {
                importDataInfos = new ImportDataInfos(l2, this.getSourceFileType(), DataType.VECTOR, this.getSourceFilePath(), "");
                if (this.getStates() == null) {
                    this.setStates((ArrayList)importDataInfos.getStates().clone());
                } else {
                    importDataInfos.setStates((ArrayList)importDataInfos.getStates().clone());
                }
            } else if (this._$7 == DataType.RASTER) {
                importDataInfos = new ImportDataInfos(l2, this.getSourceFileType(), DataType.RASTER, this.getSourceFilePath(), "");
                if (this.getStates() == null) {
                    this.setStates((ArrayList)importDataInfos.getStates().clone());
                } else {
                    importDataInfos.setStates((ArrayList)importDataInfos.getStates().clone());
                }
            } else {
                importDataInfos = this.m_dataInfos = new ImportDataInfos(this.getHandle(), this.getSourceFileType(), DataType.WOR, this.getSourceFilePath(), "");
            }
        }
        return importDataInfos;
    }

    /*
     * WARNING - void declaration
     */
    public void setTargetDataInfos(ImportDataInfos importDataInfos) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTargetDataInfos(ImportDataInfos targetDataInfos)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (importDataInfos == null) {
            String string = InternalResource.loadString("targetDataInfos", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((InternalHandle)importDataInfos);
        if (l == 0L) {
            String string = InternalResource.loadString("targetDataInfos", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        if (this._$7 == DataType.VECTOR) {
            for (int i = 0; i < importDataInfos.getCount(); ++i) {
                Object object;
                void var8_13;
                ArrayList<Integer> arrayList;
                Object object2;
                ImportDataInfo importDataInfo = importDataInfos.get(i);
                if (this.getSourceFileType() == FileType.CSV) {
                    object2 = (ImportDataInfoCSV)importDataInfo;
                    boolean n = ((ImportDataInfoCSV)((Object)object2)).GetTargetFieldInfosByUse();
                    ImportSettingCSVNative.jni_SetIsTargetFieldInfosByUse(this.getHandle(), n);
                    arrayList = importDataInfo.getFieldState();
                    if (DatasetType.POINT == ((ImportDataInfoCSV)((Object)object2)).getDatasetType() && !n) {
                        arrayList.add(0);
                        arrayList.add(1);
                    }
                } else {
                    arrayList = importDataInfo.getFieldState();
                }
                object2 = new int[arrayList.size()];
                boolean bl = false;
                while (var8_13 < ((ImportDataInfoCSV)object2).length) {
                    object2[var8_13] = arrayList.get((int)var8_13);
                    ++var8_13;
                }
                HashMap<Integer, String> hashMap = importDataInfo.getChangeName();
                Object[] objectArray = hashMap.keySet().toArray();
                int n = hashMap.size();
                int[] nArray = new int[n];
                String[] stringArray = new String[n];
                for (int j = 0; j < hashMap.size(); ++j) {
                    nArray[j] = (Integer)objectArray[j];
                    stringArray[j] = hashMap.get(nArray[j]);
                }
                HashMap<Integer, FieldType> hashMap2 = importDataInfo.getChangeFieldType();
                objectArray = hashMap2.keySet().toArray();
                n = hashMap2.size();
                int[] nArray2 = new int[n];
                int[] nArray3 = new int[n];
                for (int j = 0; j < n; ++j) {
                    nArray2[j] = (Integer)objectArray[j];
                    object = hashMap2.get(nArray2[j]);
                    nArray3[j] = object.value();
                }
                ArrayList<Integer> arrayList2 = importDataInfo.getSourceIndex();
                object = new int[arrayList2.size()];
                for (int j = 0; j < ((int[])object).length; ++j) {
                    object[j] = arrayList2.get(j);
                }
                ArrayList<Integer> arrayList3 = importDataInfo.getTargetIndex();
                int[] nArray4 = new int[arrayList3.size()];
                for (int j = 0; j < nArray4.length; ++j) {
                    nArray4[j] = arrayList3.get(j);
                }
                ImportDataInfoNative.jni_SetTargetFieldInfos3(InternalHandle.getHandle((InternalHandle)importDataInfo), (int[])object2, nArray, stringArray, nArray2, nArray3, object, nArray4);
            }
            ImportSettingNative.jni_SetTargetDataInfos(this.getHandle(), l);
            this.setStates((ArrayList)importDataInfos.getStates().clone());
        } else if (this._$7 == DataType.RASTER) {
            ImportSettingNative.jni_SetTargetDataInfos(this.getHandle(), l);
            this.setStates((ArrayList)importDataInfos.getStates().clone());
        } else {
            this.m_dataInfos = importDataInfos;
        }
    }

    public PrjCoordSys getSourcePrjCoordSys() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSourcePrjCoordSys()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return null;
    }

    protected void clearHandle() {
        if (this._$8 != null) {
            InternalPrjCoordSys.clearHandle(this._$8);
            this._$8 = null;
        }
        this._$9 = null;
        this.setHandle(0L);
    }

    protected DatasourceConnectionInfo cloneDatasourceConnectionInfo(DatasourceConnectionInfo datasourceConnectionInfo) {
        long l = InternalHandle.getHandle((InternalHandle)datasourceConnectionInfo);
        long l2 = ImportSettingNative.jni_CloneDatasourceConnectionInfo(l);
        DatasourceConnectionInfo datasourceConnectionInfo2 = InternalDatasourceConnectionInfo.createInstance(l2);
        InternalHandleDisposable.setIsDisposable((InternalHandleDisposable)datasourceConnectionInfo2, (boolean)true);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)datasourceConnectionInfo2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)datasourceConnectionInfo);
        return datasourceConnectionInfo2;
    }

    DataType getDataType() {
        return this._$7;
    }

    void setDataType(DataType dataType) {
        this._$7 = dataType;
    }

    ArrayList<Boolean> getStates() {
        return this._$6;
    }

    void setStates(ArrayList<Boolean> arrayList) {
        this._$6 = arrayList;
    }

    public boolean isUseFME() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isUseFME()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return ImportSettingNative.jni_GetIsUseFME(this.getHandle());
    }

    public void setUseFME(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setUseFME()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        ImportSettingNative.jni_SetIsUseFME(this.getHandle(), bl);
    }

    boolean hasFMEVecotrLicense() {
        return _$4 == 0;
    }

    void verifyFMEVecotrLicense() {
        if (_$4 != 0) {
            String string = License.getErrorMessage((int)_$4);
            throw new IllegalStateException(string);
        }
    }

    boolean hasFMEEsriLicense() {
        return _$3 == 0;
    }

    void verifyFMEEsriLicense() {
        if (_$3 != 0) {
            String string = License.getErrorMessage((int)_$3);
            throw new IllegalStateException(string);
        }
    }

    boolean hasFMERasterLicense() {
        return _$2 == 0;
    }

    void verifyFMERasterLicense() {
        if (_$2 != 0) {
            String string = License.getErrorMessage((int)_$2);
            throw new IllegalStateException(string);
        }
    }

    boolean hasFMEOtherLicense() {
        return _$1 == 0;
    }

    void verifyFMEOtherLicense() {
        if (_$1 != 0) {
            String string = License.getErrorMessage((int)_$1);
            throw new IllegalStateException(string);
        }
    }

    boolean hasLicenseBySpecialType(int n) {
        switch (n) {
            case 8: {
                if (!this.hasFMEVecotrLicense() && !this.hasFMEEsriLicense()) break;
                return true;
            }
            case 161: {
                if (!this.hasFMEEsriLicense() && !this.hasFMERasterLicense()) break;
                return true;
            }
        }
        return false;
    }

    boolean hasFMElicense() {
        int n = this.getSourceFileType().value();
        switch (n) {
            case 8: 
            case 161: {
                if (this.hasLicenseBySpecialType(n)) {
                    return true;
                }
                String string = InternalResource.loadString("isUnFMESupported()", "Fme_Lack_FmeLicense", "conversion_resources");
                throw new IllegalStateException(string);
            }
            case 2: 
            case 3: 
            case 11: 
            case 12: 
            case 53: 
            case 54: {
                if (this.hasFMEVecotrLicense()) {
                    return true;
                }
                String string = InternalResource.loadString("isUnFMESupported()", "Fme_Lack_FmeLicense", "conversion_resources");
                throw new IllegalStateException(string);
            }
            case 101: 
            case 103: 
            case 121: 
            case 122: 
            case 123: 
            case 124: {
                if (this.hasFMERasterLicense()) {
                    return true;
                }
                String string = InternalResource.loadString("isUnFMESupported()", "Fme_Lack_FmeLicense", "conversion_resources");
                throw new IllegalStateException(string);
            }
            case 16: 
            case 51: {
                try {
                    this.verifyFMEVecotrLicense();
                    return true;
                }
                catch (IllegalStateException illegalStateException) {
                    String string = InternalResource.loadString("isUnFMESupported()", "Fme_Lack_FmeLicense", "conversion_resources");
                    throw new IllegalStateException(string);
                }
            }
            case 6: 
            case 7: 
            case 68: 
            case 70: {
                try {
                    this.verifyFMEEsriLicense();
                    return true;
                }
                catch (IllegalStateException illegalStateException) {
                    String string = InternalResource.loadString("isUnFMESupported()", "Fme_Lack_FmeLicense", "conversion_resources");
                    throw new IllegalStateException(string);
                }
            }
        }
        String string = InternalResource.loadString("isUnFMESupported()", "Fme_UnSupportedFileType", "conversion_resources");
        throw new IllegalStateException(string);
    }

    void CheakFMELicense() {
        if (this.isUseFME()) {
            this.hasFMElicense();
        } else {
            this.isUnFMESupported();
        }
    }

    boolean isUnFMESupported() {
        int n = this.getSourceFileType().value();
        switch (n) {
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 22: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 53: 
            case 54: 
            case 55: 
            case 61: 
            case 63: 
            case 64: 
            case 70: 
            case 101: 
            case 102: 
            case 103: 
            case 106: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 148: 
            case 149: 
            case 150: 
            case 161: 
            case 204: 
            case 501: 
            case 503: 
            case 505: 
            case 507: 
            case 508: 
            case 509: {
                return true;
            }
        }
        String string = InternalResource.loadString("isUnFMESupported()", "UnFme_UnSupportFileType", "conversion_resources");
        throw new IllegalStateException(string);
    }

    static {
        _$4 = InternalToolkiConversion.GetFMELicenseCode(InternalToolkiConversion.getFMEVectorProducts());
        _$3 = InternalToolkiConversion.GetFMELicenseCode(InternalToolkiConversion.getFMEEsriProducts());
        _$2 = InternalToolkiConversion.GetFMELicenseCode(InternalToolkiConversion.getFMERasterProducts());
        _$1 = InternalToolkiConversion.GetFMELicenseCode(InternalToolkiConversion.getFMEOtherProducts());
    }
}

