/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.AggregationType;
import com.supermap.analyst.spatialanalyst.DissolveParameter;
import com.supermap.analyst.spatialanalyst.EliminateMode;
import com.supermap.analyst.spatialanalyst.GeneralizeAnalystNative;
import com.supermap.analyst.spatialanalyst.GridAnalystSetting;
import com.supermap.analyst.spatialanalyst.InternalDatasetGrid;
import com.supermap.analyst.spatialanalyst.InternalDatasetImage;
import com.supermap.analyst.spatialanalyst.InternalDatasetVector;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalEnum;
import com.supermap.analyst.spatialanalyst.InternalHandle;
import com.supermap.analyst.spatialanalyst.InternalHandleDisposable;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.ReclassMappingTable;
import com.supermap.analyst.spatialanalyst.ReclassPixelFormat;
import com.supermap.analyst.spatialanalyst.ResampleMode;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetImage;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.License;
import com.supermap.data.ProductType;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralizeAnalyst {
    private static License _$3;
    private static transient Vector _$2;
    private static GridAnalystSetting _$1;

    private GeneralizeAnalyst() {
        _$1 = null;
    }

    public static GridAnalystSetting getAnalystSetting() {
        return _$1;
    }

    public static void setAnalystSetting(GridAnalystSetting gridAnalystSetting) {
        if (gridAnalystSetting == null) {
            _$1 = null;
            return;
        }
        if (_$1 == null) {
            _$1 = new GridAnalystSetting();
        }
        _$1.setBounds(gridAnalystSetting.getBounds());
        _$1.setBoundsType(gridAnalystSetting.getBoundsType());
        _$1.setCellSizeType(gridAnalystSetting.getCellSizeType());
        _$1.setCellSize(gridAnalystSetting.getCellSize());
        _$1.setOutputDatasource(gridAnalystSetting.getOutputDatasource());
        _$1.setGridOutputNamePrefix(gridAnalystSetting.getGridOutputNamePrefix());
        _$1.setVectorOutputNamePrefix(gridAnalystSetting.getVectorOutputNamePrefix());
        _$1.setValidRegion(gridAnalystSetting.getValidRegion());
        _$1.setShowProgress(gridAnalystSetting.isShowProgress());
    }

    public static DatasetGrid aggregate(DatasetGrid datasetGrid, int n, AggregationType aggregationType, boolean bl, boolean bl2, Datasource datasource, String string) {
        GeneralizeAnalyst._$1();
        if (datasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid) == 0L) {
            String string2 = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            datasource = _$1 != null && _$1.getOutputDatasource() != null ? _$1.getOutputDatasource() : datasetGrid.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string3 = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        if (null == string) {
            String string4 = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (null != _$1 && null != _$1.getGridOutputNamePrefix()) {
            string = _$1.getGridOutputNamePrefix() + string;
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        int n2 = InternalEnum.getUGCValue(aggregationType);
        long l3 = GeneralizeAnalystNative.jni_New();
        if (null != _$1) {
            GeneralizeAnalystNative.jni_SetShowProgress(l3, _$1.isShowProgress());
            Rectangle2D rectangle2D = _$1.getBounds();
            GeneralizeAnalystNative.jni_SetTargetBounds(l3, _$1.getBoundsType().value(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
        }
        long l4 = GeneralizeAnalystNative.jni_Aggregate(l3, l, n, n2, bl, bl2, l2, string);
        GeneralizeAnalystNative.jni_Delete(l3);
        DatasetGrid datasetGrid2 = null;
        if (l4 != 0L) {
            datasetGrid2 = InternalDatasetGrid.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid2);
        }
        return datasetGrid2;
    }

    public static Dataset resample(Dataset dataset, double d, ResampleMode resampleMode, Datasource datasource, String string) {
        GeneralizeAnalyst._$1();
        if (dataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset) == 0L) {
            String string2 = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            datasource = _$1 != null && _$1.getOutputDatasource() != null ? _$1.getOutputDatasource() : dataset.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string3 = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        if (null == string) {
            String string4 = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (null != _$1 && null != _$1.getGridOutputNamePrefix()) {
            string = _$1.getGridOutputNamePrefix() + string;
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        int n = InternalEnum.getUGCValue(resampleMode);
        long l3 = GeneralizeAnalystNative.jni_New();
        if (null != _$1) {
            GeneralizeAnalystNative.jni_SetShowProgress(l3, _$1.isShowProgress());
            Rectangle2D rectangle2D = _$1.getBounds();
            GeneralizeAnalystNative.jni_SetTargetBounds(l3, _$1.getBoundsType().value(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
        }
        long l4 = GeneralizeAnalystNative.jni_Resample(l3, l, d, n, l2, string);
        GeneralizeAnalystNative.jni_Delete(l3);
        if (l4 != 0L) {
            if (dataset.getType() == DatasetType.IMAGE) {
                DatasetImage datasetImage = InternalDatasetImage.createInstance(l4, datasource);
                InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetImage);
                return datasetImage;
            }
            DatasetGrid datasetGrid = InternalDatasetGrid.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid);
            return datasetGrid;
        }
        return null;
    }

    public static DatasetGrid reclass(DatasetGrid datasetGrid, ReclassMappingTable reclassMappingTable, ReclassPixelFormat reclassPixelFormat, Datasource datasource, String string) {
        GeneralizeAnalyst._$1();
        if (datasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid) == 0L) {
            String string2 = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (reclassMappingTable == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)reclassMappingTable) == 0L) {
            String string3 = InternalResource.loadString("reclassMappingTable", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            datasource = _$1 != null && _$1.getOutputDatasource() != null ? _$1.getOutputDatasource() : datasetGrid.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string4 = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (null == string) {
            String string5 = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (null != _$1 && null != _$1.getGridOutputNamePrefix()) {
            string = _$1.getGridOutputNamePrefix() + string;
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string6 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)reclassMappingTable);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        int n = InternalEnum.getUGCValue(reclassPixelFormat);
        long l4 = GeneralizeAnalystNative.jni_New();
        if (null != _$1) {
            GeneralizeAnalystNative.jni_SetShowProgress(l4, _$1.isShowProgress());
            Rectangle2D rectangle2D = _$1.getBounds();
            GeneralizeAnalystNative.jni_SetTargetBounds(l4, _$1.getBoundsType().value(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
        }
        long l5 = GeneralizeAnalystNative.jni_Reclass(l4, l, l2, n, l3, string);
        GeneralizeAnalystNative.jni_Delete(l4);
        DatasetGrid datasetGrid2 = null;
        if (l5 != 0L) {
            datasetGrid2 = InternalDatasetGrid.createInstance(l5, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid2);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)reclassMappingTable));
        return datasetGrid2;
    }

    public static DatasetGrid replace(DatasetGrid datasetGrid, Map<Double, Double> map, Datasource datasource, String string) {
        GeneralizeAnalyst._$1();
        if (datasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid) == 0L) {
            String string2 = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (map == null || map.size() == 0) {
            String string3 = InternalResource.loadString("replaceTable", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            datasource = _$1 != null && _$1.getOutputDatasource() != null ? _$1.getOutputDatasource() : datasetGrid.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string4 = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (null == string) {
            String string5 = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (null != _$1 && null != _$1.getGridOutputNamePrefix()) {
            string = _$1.getGridOutputNamePrefix() + string;
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string6 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        Object[] objectArray = map.keySet().toArray();
        int n = objectArray.length;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = (Double)objectArray[i];
            dArray2[i] = map.get(dArray[i]);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        long l3 = GeneralizeAnalystNative.jni_New();
        if (null != _$1) {
            GeneralizeAnalystNative.jni_SetShowProgress(l3, _$1.isShowProgress());
        }
        long l4 = GeneralizeAnalystNative.jni_Replace(l3, l, dArray, dArray2, l2, string);
        GeneralizeAnalystNative.jni_Delete(l3);
        DatasetGrid datasetGrid2 = null;
        if (l4 != 0L) {
            datasetGrid2 = InternalDatasetGrid.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid2);
        }
        return datasetGrid2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _$1() {
        int n = -1;
        Object object = _$3;
        synchronized (object) {
            n = _$3.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener steppedListener) {
        if (_$2 == null) {
            _$2 = new Vector();
        }
        if (!_$2.contains(steppedListener)) {
            _$2.add(steppedListener);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener steppedListener) {
        if (_$2 != null && _$2.contains(steppedListener)) {
            _$2.remove(steppedListener);
        }
    }

    protected static void fireStepped(SteppedEvent steppedEvent) {
        if (_$2 != null) {
            Vector vector = _$2;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(steppedEvent);
            }
        }
    }

    static void steppedCallBack(int n, long l, String string, String string2, long l2) {
        String string3 = "GeneralizeAnalyst";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(l2);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, n, l, string, string2, string3);
        GeneralizeAnalyst.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(l2, steppedEvent.getCancel());
    }

    @Deprecated
    public static DatasetVector dissolve(DatasetVector datasetVector, Datasource datasource, String string, DissolveParameter dissolveParameter) {
        GeneralizeAnalyst._$1();
        if (datasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector) == 0L) {
            String string2 = InternalResource.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string3 = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string4 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string5 = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string5);
        }
        if (dissolveParameter == null) {
            String string6 = InternalResource.loadString("dissolveParameter", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)dissolveParameter);
        long l4 = GeneralizeAnalystNative.jni_Dissolve(l, l2, string, l3);
        DatasetVector datasetVector2 = null;
        if (l4 != 0L) {
            datasetVector2 = InternalDatasetVector.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector2);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)dissolveParameter));
        return datasetVector2;
    }

    @Deprecated
    public static boolean eliminate(DatasetVector datasetVector, double d, double d2, EliminateMode eliminateMode, boolean bl) {
        if (datasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector) == 0L) {
            String string = InternalResource.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("sourceDatasetVector", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("regionTolerance", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (d2 < 0.0) {
            String string = InternalResource.loadString("vertexTolerance", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (eliminateMode == null) {
            String string = InternalResource.loadString("eliminateMode", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        boolean bl2 = false;
        bl2 = GeneralizeAnalystNative.jni_Eliminate(l, d, d2, eliminateMode.value(), bl);
        return bl2;
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        _$3 = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

