/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.BoundsType;
import com.supermap.analyst.spatialanalyst.ConversionAnalystNative;
import com.supermap.analyst.spatialanalyst.ConversionAnalystParameter;
import com.supermap.analyst.spatialanalyst.GridAnalystSetting;
import com.supermap.analyst.spatialanalyst.InternalDatasetGrid;
import com.supermap.analyst.spatialanalyst.InternalDatasetImage;
import com.supermap.analyst.spatialanalyst.InternalDatasetVector;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalEnum;
import com.supermap.analyst.spatialanalyst.InternalHandle;
import com.supermap.analyst.spatialanalyst.InternalHandleDisposable;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.Enum;
import com.supermap.data.GeoRegion;
import com.supermap.data.License;
import com.supermap.data.PixelFormat;
import com.supermap.data.ProductType;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import java.util.ArrayList;
import java.util.Vector;

public class ConversionAnalyst {
    private static transient Vector _$3;
    private static License _$2;
    private static GridAnalystSetting _$1;

    private ConversionAnalyst() {
        _$1 = null;
    }

    public static GridAnalystSetting getAnalystSetting() {
        return _$1;
    }

    public static void setAnalystSetting(GridAnalystSetting gridAnalystSetting) {
        if (gridAnalystSetting == null) {
            _$1 = null;
            return;
        }
        if (_$1 == null) {
            _$1 = new GridAnalystSetting();
        }
        _$1.setBounds(gridAnalystSetting.getBounds());
        _$1.setBoundsType(gridAnalystSetting.getBoundsType());
        _$1.setCellSizeType(gridAnalystSetting.getCellSizeType());
        _$1.setCellSize(gridAnalystSetting.getCellSize());
        _$1.setOutputDatasource(gridAnalystSetting.getOutputDatasource());
        _$1.setGridOutputNamePrefix(gridAnalystSetting.getGridOutputNamePrefix());
        _$1.setVectorOutputNamePrefix(gridAnalystSetting.getVectorOutputNamePrefix());
        _$1.setValidRegion(gridAnalystSetting.getValidRegion());
        _$1.setShowProgress(gridAnalystSetting.isShowProgress());
    }

    public static DatasetGrid vectorToRaster(ConversionAnalystParameter conversionAnalystParameter) {
        ConversionAnalyst._$1();
        if (conversionAnalystParameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        Dataset dataset = conversionAnalystParameter.getSourceDataset();
        if (dataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset) == 0L) {
            String string = InternalResource.loadString("srcDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (dataset.getType() != DatasetType.POINT && dataset.getType() != DatasetType.LINE && dataset.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("srcDataset DatasetType", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        Datasource datasource = conversionAnalystParameter.getTargetDatasource();
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            datasource = _$1 != null && _$1.getOutputDatasource() != null ? _$1.getOutputDatasource() : dataset.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String string = conversionAnalystParameter.getTargetDatasetName();
        if (null == string) {
            String string2 = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        if (null != _$1 && null != _$1.getGridOutputNamePrefix()) {
            string = _$1.getGridOutputNamePrefix() + string;
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string3 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        double d = conversionAnalystParameter.getCellSize();
        boolean bl = false;
        Rectangle2D rectangle2D = new Rectangle2D(0.0, 0.0, 0.0, 0.0);
        int n = BoundsType.INTERSECTION.value();
        if (null != _$1) {
            bl = _$1.isShowProgress();
            n = _$1.getBoundsType().value();
            rectangle2D = _$1.getBounds();
            if (d <= 0.0) {
                d = _$1.getCellSize();
            }
        }
        String string4 = conversionAnalystParameter.getValueFieldName();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        long l3 = 0L;
        GeoRegion geoRegion = conversionAnalystParameter.getClipRegion();
        if (geoRegion != null) {
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion);
        } else if (_$1 != null && _$1.getValidRegion() != null) {
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)_$1.getValidRegion());
        }
        PixelFormat pixelFormat = conversionAnalystParameter.getPixelFormat();
        int n2 = InternalEnum.getUGCValue((Enum)pixelFormat);
        long l4 = ConversionAnalystNative.jni_VectorToRaster(l, string4, d, n2, l3, l2, string, bl, n, rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
        DatasetGrid datasetGrid = null;
        if (l4 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)conversionAnalystParameter);
        return datasetGrid;
    }

    public static DatasetVector rasterToVector(ConversionAnalystParameter conversionAnalystParameter) {
        String string;
        ConversionAnalyst._$1();
        if (conversionAnalystParameter == null) {
            String string2 = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (conversionAnalystParameter.getSourceDataset() == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)conversionAnalystParameter.getSourceDataset()) == 0L) {
            String string3 = InternalResource.loadString("getSourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (conversionAnalystParameter.getSourceDataset().getType() != DatasetType.IMAGE && conversionAnalystParameter.getSourceDataset().getType() != DatasetType.GRID) {
            String string4 = InternalResource.loadString("sourceDataset", "Global_ArgumentTypeInvalid", "spatialanalyst_resources");
            throw new NullPointerException(string4);
        }
        Datasource datasource = conversionAnalystParameter.getTargetDatasource();
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            datasource = _$1 != null && _$1.getOutputDatasource() != null ? _$1.getOutputDatasource() : conversionAnalystParameter.getSourceDataset().getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string5 = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        String string6 = conversionAnalystParameter.getTargetDatasetName();
        if (null == string6) {
            String string7 = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string7);
        }
        if (null != _$1 && null != _$1.getVectorOutputNamePrefix()) {
            string6 = _$1.getVectorOutputNamePrefix() + string6;
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string6)) {
            String string8 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string8);
        }
        boolean bl = false;
        if (null != _$1) {
            bl = _$1.isShowProgress();
        }
        if ((string = conversionAnalystParameter.getValueFieldName()) == null || string.length() == 0) {
            String string9 = InternalResource.loadString("valueField", "StringIsNullOrEmpty", "spatialanalyst_resources");
            throw new IllegalArgumentException(string9);
        }
        if (string != null && ConversionAnalyst._$1(string)) {
            String string10 = InternalResource.loadString("valueField", "FieldInfos_Unsupported", "spatialanalyst_resources");
            throw new UnsupportedOperationException(string10);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)conversionAnalystParameter.getSourceDataset());
        long l2 = 0L;
        if (conversionAnalystParameter.getClipRegion() != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)conversionAnalystParameter.getClipRegion());
        } else if (_$1 != null && _$1.getValidRegion() != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)_$1.getValidRegion());
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        int n = InternalEnum.getUGCValue((Enum)conversionAnalystParameter.getTargetDatasetType());
        long l4 = conversionAnalystParameter.getSpecifiedValue();
        double d = conversionAnalystParameter.getSpecifiedValueTolerance();
        long l5 = conversionAnalystParameter.getBackOrNoValue();
        double d2 = conversionAnalystParameter.getBackOrNoValueTolerance();
        int n2 = InternalEnum.getUGCValue(conversionAnalystParameter.getSmoothMethod());
        int n3 = conversionAnalystParameter.getSmoothDegree();
        boolean bl2 = conversionAnalystParameter.isThinRaster();
        long l6 = ConversionAnalystNative.jni_RasterToVector(l, n, string, l4, d, l2, l5, d2, bl2, n2, n3, l3, string6, bl);
        DatasetVector datasetVector = null;
        if (l6 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l6, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)conversionAnalystParameter);
        return datasetVector;
    }

    public static Dataset thinRaster(Dataset dataset, long l, double d, Datasource datasource, String string) {
        ConversionAnalyst._$1();
        if (dataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset) == 0L) {
            String string2 = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (dataset.getType() != DatasetType.IMAGE && dataset.getType() != DatasetType.GRID) {
            String string3 = InternalResource.loadString("sourceDataset", "Global_ArgumentTypeInvalid", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            datasource = _$1 != null && _$1.getOutputDatasource() != null ? _$1.getOutputDatasource() : dataset.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string4 = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (null == string) {
            String string5 = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (null != _$1 && null != _$1.getGridOutputNamePrefix()) {
            string = _$1.getGridOutputNamePrefix() + string;
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string6 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        boolean bl = false;
        if (null != _$1) {
            bl = _$1.isShowProgress();
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
        long l4 = ConversionAnalystNative.jni_ThinRaster(l3, l, d, l2, string, bl);
        DatasetGrid datasetGrid = null;
        if (l4 != 0L) {
            DatasetType datasetType = dataset.getType();
            if (datasetType == DatasetType.GRID) {
                datasetGrid = InternalDatasetGrid.createInstance(l4, datasource);
            } else if (datasetType == DatasetType.IMAGE) {
                datasetGrid = InternalDatasetImage.createInstance(l4, datasource);
            } else {
                return null;
            }
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid);
        }
        return datasetGrid;
    }

    private static boolean _$1(String string) {
        String string2 = string;
        int n = string2.indexOf(".");
        if (n > 0) {
            string2 = string2.substring(n, string2.length() - n - 1);
        }
        if (string2.substring(0, 2).compareToIgnoreCase("Sm") == 0) {
            if (string2.compareToIgnoreCase("SmUserID") == 0) {
                return false;
            }
            if (string2.compareToIgnoreCase("SmID") == 0 || string2.compareToIgnoreCase("SmSdriN") == 0 || string2.compareToIgnoreCase("SmSdriS") == 0 || string2.compareToIgnoreCase("SmSdriW") == 0 || string2.compareToIgnoreCase("SmSdriE") == 0 || string2.compareToIgnoreCase("SmGeometry") == 0 || string2.compareToIgnoreCase("SmX") == 0 || string2.compareToIgnoreCase("SmY") == 0 || string2.compareToIgnoreCase("SmZ") == 0 || string2.compareToIgnoreCase("SmKey") == 0 || string2.compareToIgnoreCase("SmGranule") == 0 || string2.compareToIgnoreCase("SmLength") == 0 || string2.compareToIgnoreCase("SmArea") == 0 || string2.compareToIgnoreCase("SmPerimeter") == 0 || string2.compareToIgnoreCase("SmLibTileID") == 0 || string2.compareToIgnoreCase("SmEdgeID") == 0 || string2.compareToIgnoreCase("SmFNode") == 0 || string2.compareToIgnoreCase("SmTNode") == 0 || string2.compareToIgnoreCase("SmResistanceA") == 0 || string2.compareToIgnoreCase("SmResistanceB") == 0 || string2.compareToIgnoreCase("SmTopoError") == 0 || string2.compareToIgnoreCase("SmNodeID") == 0 || string2.compareToIgnoreCase("SmGeoType") == 0 || string2.compareToIgnoreCase("SmRouteID") == 0 || string2.compareToIgnoreCase("SMMAXMEASURE") == 0 || string2.compareToIgnoreCase("SMMINMEASURE") == 0 || string2.compareToIgnoreCase("SmGeometrySize") == 0 || string2.compareToIgnoreCase("SmVertexSeq") == 0) {
                return true;
            }
        }
        return false;
    }

    public static synchronized void addSteppedListener(SteppedListener steppedListener) {
        if (_$3 == null) {
            _$3 = new Vector();
        }
        if (!_$3.contains(steppedListener)) {
            _$3.add(steppedListener);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener steppedListener) {
        if (_$3 != null && _$3.contains(steppedListener)) {
            _$3.remove(steppedListener);
        }
    }

    protected static void fireStepped(SteppedEvent steppedEvent) {
        if (_$3 != null) {
            Vector vector = _$3;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(steppedEvent);
            }
        }
    }

    static void steppedCallBack(int n, long l, String string, String string2, long l2) {
        String string3 = "ConversionAnalyst";
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, n, l, string, string2, string3);
        ConversionAnalyst.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(l2, steppedEvent.getCancel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _$1() {
        int n = -1;
        Object object = _$2;
        synchronized (object) {
            n = _$2.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        _$2 = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

