/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.CoordSysTransMethod;
import com.supermap.data.CoordSysTransParameter;
import com.supermap.data.CoordSysTransRunnable;
import com.supermap.data.CoordSysTranslatorNative;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetNative;
import com.supermap.data.Datasource;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.PrjCoordSys;

public final class CoordSysTranslator {
    private CoordSysTranslator() {
    }

    public static boolean forward(Point2Ds point2Ds, PrjCoordSys prjCoordSys) {
        int n;
        if (point2Ds == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n2 = point2Ds.getCount();
        if (n2 < 1) {
            String string = InternalResource.loadString("points", "Point2DsIsEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (prjCoordSys == null || prjCoordSys.getHandle() == 0L) {
            String string = InternalResource.loadString("prjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = point2Ds.getItem(n).getX();
            dArray2[n] = point2Ds.getItem(n).getY();
            if (!(dArray[n] > 180.0 || dArray[n] < -180.0 || dArray2[n] > 90.0) && !(dArray2[n] < -90.0)) continue;
            String string = InternalResource.loadString("points", "InvalidLongitudeLatitudeCoord", "data_resources");
            throw new IllegalArgumentException(string);
        }
        n = CoordSysTranslatorNative.jni_Forward(dArray, dArray2, prjCoordSys.getHandle()) ? 1 : 0;
        for (int i = 0; i < n2; ++i) {
            point2Ds.setItem(i, new Point2D(dArray[i], dArray2[i]));
        }
        InternalHandleDisposable.makeSureNativeObjectLive(prjCoordSys);
        return n != 0;
    }

    public static boolean inverse(Point2Ds point2Ds, PrjCoordSys prjCoordSys) {
        int n;
        if (point2Ds == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n2 = point2Ds.getCount();
        if (n2 < 1) {
            String string = InternalResource.loadString("points", "Point2DsIsEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (prjCoordSys == null || prjCoordSys.getHandle() == 0L) {
            String string = InternalResource.loadString("prjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = point2Ds.getItem(n).getX();
            dArray2[n] = point2Ds.getItem(n).getY();
        }
        n = CoordSysTranslatorNative.jni_Inverse(dArray, dArray2, prjCoordSys.getHandle()) ? 1 : 0;
        for (int i = 0; i < n2; ++i) {
            point2Ds.setItem(i, new Point2D(dArray[i], dArray2[i]));
        }
        InternalHandleDisposable.makeSureNativeObjectLive(prjCoordSys);
        return n != 0;
    }

    public static boolean convert(Datasource datasource, PrjCoordSys prjCoordSys, CoordSysTransParameter coordSysTransParameter, CoordSysTransMethod coordSysTransMethod) {
        if (datasource == null || datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("srcDatasource", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (prjCoordSys == null || prjCoordSys.getHandle() == 0L) {
            String string = InternalResource.loadString("desPrjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (coordSysTransParameter == null || coordSysTransParameter.getHandle() == 0L) {
            coordSysTransParameter = new CoordSysTransParameter();
        }
        if (coordSysTransMethod == null) {
            String string = InternalResource.loadString("coordSysTransMethod", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = CoordSysTranslatorNative.jni_ConvertDataSource(datasource.getHandle(), prjCoordSys.getHandle(), coordSysTransParameter.getHandle(), coordSysTransMethod.getUGCValue());
        InternalHandleDisposable.makeSureNativeObjectLive(prjCoordSys);
        InternalHandleDisposable.makeSureNativeObjectLive(coordSysTransParameter);
        return bl;
    }

    public static boolean convert(Datasource datasource, Datasource datasource2, CoordSysTransParameter coordSysTransParameter, CoordSysTransMethod coordSysTransMethod) {
        if (datasource == null || datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("srcDatasource", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasource2 == null || datasource2.getHandle() == 0L) {
            String string = InternalResource.loadString("desDatasource", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (coordSysTransParameter == null || coordSysTransParameter.getHandle() == 0L) {
            coordSysTransParameter = new CoordSysTransParameter();
        }
        if (coordSysTransMethod == null) {
            String string = InternalResource.loadString("coordSysTransMethod", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = CoordSysTranslatorNative.jni_ConvertDataSource2(datasource.getHandle(), datasource2.getHandle(), coordSysTransParameter.getHandle(), coordSysTransMethod.getUGCValue());
        InternalHandleDisposable.makeSureNativeObjectLive(coordSysTransParameter);
        return bl;
    }

    public static boolean convert(Geometry geometry, PrjCoordSys prjCoordSys, PrjCoordSys prjCoordSys2, CoordSysTransParameter coordSysTransParameter, CoordSysTransMethod coordSysTransMethod) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (prjCoordSys == null || prjCoordSys.getHandle() == 0L) {
            String string = InternalResource.loadString("srcPrjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (prjCoordSys2 == null || prjCoordSys2.getHandle() == 0L) {
            String string = InternalResource.loadString("desPrjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (coordSysTransParameter == null || coordSysTransParameter.getHandle() == 0L) {
            coordSysTransParameter = new CoordSysTransParameter();
        }
        if (coordSysTransMethod == null) {
            String string = InternalResource.loadString("coordSysTransMethod", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = CoordSysTranslatorNative.jni_ConvertGeometry(geometry.getHandle(), prjCoordSys.getHandle(), prjCoordSys2.getHandle(), coordSysTransParameter.getHandle(), coordSysTransMethod.getUGCValue());
        if (geometry.getType() == GeometryType.GEOREGION) {
            ((GeoRegion)geometry).refrashPartsList();
        }
        InternalHandleDisposable.makeSureNativeObjectLive(prjCoordSys);
        InternalHandleDisposable.makeSureNativeObjectLive(prjCoordSys2);
        InternalHandleDisposable.makeSureNativeObjectLive(coordSysTransParameter);
        return bl;
    }

    public static boolean convert(Point2Ds point2Ds, PrjCoordSys prjCoordSys, PrjCoordSys prjCoordSys2, CoordSysTransParameter coordSysTransParameter, CoordSysTransMethod coordSysTransMethod) {
        int n;
        if (point2Ds == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n2 = point2Ds.getCount();
        if (n2 < 1) {
            String string = InternalResource.loadString("points", "Point2DsIsEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (prjCoordSys == null || prjCoordSys.getHandle() == 0L) {
            String string = InternalResource.loadString("srcPrjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (prjCoordSys2 == null || prjCoordSys2.getHandle() == 0L) {
            String string = InternalResource.loadString("targetPrjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (coordSysTransParameter == null || coordSysTransParameter.getHandle() == 0L) {
            coordSysTransParameter = new CoordSysTransParameter();
        }
        if (coordSysTransMethod == null) {
            String string = InternalResource.loadString("coordSysTransMethod", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = point2Ds.getItem(n).getX();
            dArray2[n] = point2Ds.getItem(n).getY();
        }
        n = CoordSysTranslatorNative.jni_ConvertPoints(dArray, dArray2, prjCoordSys.getHandle(), prjCoordSys2.getHandle(), coordSysTransParameter.getHandle(), coordSysTransMethod.getUGCValue()) ? 1 : 0;
        for (int i = 0; i < n2; ++i) {
            point2Ds.setItem(i, new Point2D(dArray[i], dArray2[i]));
        }
        InternalHandleDisposable.makeSureNativeObjectLive(prjCoordSys);
        InternalHandleDisposable.makeSureNativeObjectLive(prjCoordSys2);
        InternalHandleDisposable.makeSureNativeObjectLive(coordSysTransParameter);
        return n != 0;
    }

    public static boolean convert(Dataset dataset, PrjCoordSys prjCoordSys, CoordSysTransParameter coordSysTransParameter, CoordSysTransMethod coordSysTransMethod) {
        if (dataset == null || InternalHandle.getHandle(dataset) == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (prjCoordSys == null || prjCoordSys.getHandle() == 0L) {
            String string = InternalResource.loadString("targetPrjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (coordSysTransParameter == null || coordSysTransParameter.getHandle() == 0L) {
            coordSysTransParameter = new CoordSysTransParameter();
        }
        if (coordSysTransMethod == null) {
            String string = InternalResource.loadString("coordSysTransMethod", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        dataset.m_selfEventHandle = DatasetNative.jni_NewSelfEventHandle(dataset);
        boolean bl = CoordSysTranslatorNative.jni_ConvertDataset(dataset.getHandle(), prjCoordSys.getHandle(), coordSysTransParameter.getHandle(), coordSysTransMethod.getUGCValue(), dataset.m_selfEventHandle);
        dataset.clearSelfEventHandle();
        InternalHandleDisposable.makeSureNativeObjectLive(prjCoordSys);
        InternalHandleDisposable.makeSureNativeObjectLive(coordSysTransParameter);
        return bl;
    }

    public static Dataset convert(Dataset dataset, PrjCoordSys prjCoordSys, Datasource datasource, String string, CoordSysTransParameter coordSysTransParameter, CoordSysTransMethod coordSysTransMethod) {
        return CoordSysTranslator.convert(dataset, prjCoordSys, datasource, string, coordSysTransParameter, coordSysTransMethod, null);
    }

    public static Dataset convert(Dataset dataset, PrjCoordSys prjCoordSys, Datasource datasource, String string, CoordSysTransParameter coordSysTransParameter, CoordSysTransMethod coordSysTransMethod, CoordSysTransRunnable coordSysTransRunnable) {
        if (dataset == null || InternalHandle.getHandle(dataset) == 0L) {
            String string2 = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        if (prjCoordSys == null || prjCoordSys.getHandle() == 0L) {
            String string3 = InternalResource.loadString("targetPrjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = InternalResource.loadString("targetDatasetName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("targetDatasetName", "Datasets_NameIsOccupied", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        if (coordSysTransParameter == null || coordSysTransParameter.getHandle() == 0L) {
            coordSysTransParameter = new CoordSysTransParameter();
        }
        if (coordSysTransMethod == null) {
            String string6 = InternalResource.loadString("coordSysTransMethod", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        if (coordSysTransRunnable != null) {
            coordSysTransRunnable.setSourcePrj(dataset.getPrjCoordSys());
            coordSysTransRunnable.setTargetPrj(prjCoordSys);
            coordSysTransRunnable.setTransMethod(coordSysTransMethod);
            coordSysTransRunnable.setTransParameter(coordSysTransParameter);
        }
        Dataset dataset2 = null;
        dataset.m_selfEventHandle = DatasetNative.jni_NewSelfEventHandle(dataset);
        long l = CoordSysTranslatorNative.jni_ConvertDataset2(dataset.getHandle(), prjCoordSys.getHandle(), datasource.getHandle(), string, coordSysTransParameter.getHandle(), coordSysTransMethod.getUGCValue(), dataset.m_selfEventHandle, coordSysTransRunnable);
        dataset.clearSelfEventHandle();
        if (l != 0L) {
            dataset2 = Dataset.createInstance(l, dataset.getType(), datasource);
            datasource.getDatasets().add(dataset2);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(prjCoordSys);
        InternalHandleDisposable.makeSureNativeObjectLive(coordSysTransParameter);
        return dataset2;
    }
}

