/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.InternalHandle;
import com.supermap.data.conversion.DataType;
import com.supermap.data.conversion.IgnoreMode;
import com.supermap.data.conversion.ImportSetting;
import com.supermap.data.conversion.ImportSettingGRDNative;
import com.supermap.data.conversion.InternalEnum;
import com.supermap.data.conversion.InternalHandleDisposable;
import com.supermap.data.conversion.InternalResource;

public class ImportSettingGRD
extends ImportSetting {
    public ImportSettingGRD() {
        long l = ImportSettingGRDNative.jni_New();
        this.setHandle(l, true);
        super.setDataType(DataType.RASTER);
    }

    public ImportSettingGRD(ImportSettingGRD importSettingGRD) {
        if (importSettingGRD == null) {
            String string = InternalResource.loadString("importSettingGRD", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)importSettingGRD);
        if (l == 0L) {
            String string = InternalResource.loadString("importSettingGRD", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = ImportSettingGRDNative.jni_Clone(l);
        this.setHandle(l2, true);
        this.setTargetDatasourceConnectionInfo(importSettingGRD.getTargetDatasourceConnectionInfo());
        this.setTargetDatasource(importSettingGRD.getTargetDatasource());
        this.setTargetPrjCoordSys(importSettingGRD.getTargetPrjCoordSys());
        super.setDataType(DataType.RASTER);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)importSettingGRD));
    }

    public ImportSettingGRD(String string, Datasource datasource) {
        this();
        this.setSourceFilePath(string);
        this.setTargetDatasource(datasource);
    }

    public ImportSettingGRD(String string, DatasourceConnectionInfo datasourceConnectionInfo) {
        this();
        this.setSourceFilePath(string);
        this.setTargetDatasourceConnectionInfo(datasourceConnectionInfo);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)datasourceConnectionInfo);
    }

    public boolean isPyramidBuilt() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isPyramidBuilt()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return ImportSettingGRDNative.jni_IsPyramidBuilt(this.getHandle());
    }

    public void setPyramidBuilt(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPyramidBuilt(boolean value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        ImportSettingGRDNative.jni_SetPyramidBuilt(this.getHandle(), bl);
    }

    public void setIgnoreMode(IgnoreMode ignoreMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIgnoreMode(int ignoreMode)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ignoreMode.value();
        ImportSettingGRDNative.jni_SetIgnorMode(this.getHandle(), n);
    }

    public IgnoreMode getIgnoreMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIgnoreMode()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ImportSettingGRDNative.jni_GetIgnorMode(this.getHandle());
        return (IgnoreMode)InternalEnum.parseUGCValue(IgnoreMode.class, n);
    }

    public double[] getIgnoreValues() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIgnoreValues()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ImportSettingGRDNative.jni_GetIgnoreValueCount(this.getHandle());
        double[] dArray = new double[n];
        ImportSettingGRDNative.jni_GetIgnoreValues(this.getHandle(), dArray);
        return dArray;
    }

    public void setIgnoreValues(double[] dArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIgnoreValues", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (dArray == null) {
            dArray = new double[]{};
        }
        ImportSettingGRDNative.jni_SetIgnoreValues(this.getHandle(), dArray);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "conversion_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ImportSettingGRDNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }
}

